/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wireless.datatypes;

import com.viconics.wireless.datatypes.BIZigbeeHelperParent;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessStatZigbeeHelper
extends BComponent {
    public static final int ZIGBEE_CHANNEL_DEFAULT = 10;
    public static final int ZIGBEE_PANID_DEFAULT = 0;
    public static final Property status = BWirelessStatZigbeeHelper.newProperty((int)3, (BValue)BStatus.down, null);
    public static final Property faultCause = BWirelessStatZigbeeHelper.newProperty((int)67, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property zigbeePanId = BWirelessStatZigbeeHelper.newProperty((int)0, (int)0, (BFacets)BFacets.makeNumeric((BUnit)BUnit.NULL, (BNumber)BInteger.make((int)0), (BNumber)BInteger.make((int)500)));
    public static final Property zigbeeChannel = BWirelessStatZigbeeHelper.newProperty((int)0, (int)10, (BFacets)BFacets.makeNumeric((BUnit)BUnit.NULL, (BNumber)BInteger.make((int)10), (BNumber)BInteger.make((int)26)));
    public static final Type TYPE;
    public static final BWirelessStatZigbeeHelper DEFAULT;
    private static final BIcon icon;
    public static Log log;
    private static final int MIN_CHANNEL = 10;
    private static final int MAX_CHANNEL = 26;
    private static final int MIN_PANID = 0;
    private static final int MAX_PANNID = 500;
    private BIZigbeeHelperParent host;
    private int oldStatus;
    private boolean configFault;
    private boolean communicationFault;
    private boolean commDisabled;
    static /* synthetic */ Class class$com$viconics$wireless$datatypes$BWirelessStatZigbeeHelper;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public int getZigbeePanId() {
        return this.getInt(zigbeePanId);
    }

    public void setZigbeePanId(int n) {
        this.setInt(zigbeePanId, n, null);
    }

    public int getZigbeeChannel() {
        return this.getInt(zigbeeChannel);
    }

    public void setZigbeeChannel(int n) {
        this.setInt(zigbeeChannel, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setWirelessHelperParent(BIZigbeeHelperParent bIZigbeeHelperParent) {
        this.host = bIZigbeeHelperParent;
    }

    public BIZigbeeHelperParent getWirelessHelperParent() {
        if (this.host != null) {
            return this.host;
        }
        return (BIZigbeeHelperParent)this.getParent();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BIZigbeeHelperParent;
    }

    public void changed(Property property, Context context) {
        if (this.getWirelessHelperParent() != null) {
            this.getWirelessHelperParent().changed(property, context);
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)zigbeeChannel)) {
            this.validateSelectedConfig();
        } else if (property.equals((Object)zigbeePanId)) {
            this.validateSelectedConfig();
        } else {
            super.changed(property, context);
        }
        this.getWirelessHelperParent().reopenWirelessPort(context);
    }

    public void validateSelectedConfig() {
        if (this.getZigbeeChannel() == 10) {
            this.commDisabled = true;
            this.setFaultCause("Channel 10 means \"no communication\"");
            return;
        }
        if (this.getZigbeePanId() == 0) {
            this.commDisabled = true;
            this.setFaultCause("Pan ID 0 means \"no communication\"");
            return;
        }
        this.commDisabled = false;
        this.updateStatus();
    }

    public final void communicationFail(String string) {
        this.communicationFault = true;
        this.setFaultCause(string);
        this.updateStatus();
    }

    public final void configFail(String string) {
        this.configFault = true;
        this.setFaultCause(string);
        this.updateStatus();
    }

    public final void updateStatus() {
        int n = this.getStatus().getBits();
        n = this.configFault || this.communicationFault ? (n |= 2) : (n &= 0xFFFFFFFD);
        n = this.commDisabled ? (n |= 4) : (n &= 0xFFFFFFFB);
        if (n == 0) {
            this.setFaultCause("");
        }
        if (n == this.oldStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
    }

    public final void setStatus() {
    }

    public final void configOk() {
        this.configFault = false;
        this.updateStatus();
    }

    public final void communicationOk() {
        this.communicationFault = false;
        this.updateStatus();
    }

    public boolean isChannelValid() {
        boolean bl = false;
        if (this.getZigbeeChannel() >= 10 && this.getZigbeeChannel() <= 26) {
            bl = true;
        }
        return bl;
    }

    public boolean isPanIdValid() {
        boolean bl = false;
        if (this.getZigbeePanId() >= 0 && this.getZigbeePanId() <= 500) {
            bl = true;
        }
        return bl;
    }

    public String toString(Context context) {
        return "Zigbee partameters configuration";
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldStatus = -1;
    }

    public BWirelessStatZigbeeHelper() {
        this.this();
    }

    static {
        Class clazz = class$com$viconics$wireless$datatypes$BWirelessStatZigbeeHelper;
        if (clazz == null) {
            clazz = class$com$viconics$wireless$datatypes$BWirelessStatZigbeeHelper = BWirelessStatZigbeeHelper.class("[Lcom.viconics.wireless.datatypes.BWirelessStatZigbeeHelper;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT = new BWirelessStatZigbeeHelper();
        icon = BIcon.std((String)"commConfig.png");
        log = Log.getLog((String)"WirelessHelper");
    }
}

