/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wireless;

import com.tridium.basicdriver.MessageListener;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BBasicPollScheduler;
import com.tridium.platform.BSystemPlatformService;
import com.viconics.wireless.BWirelessStatDevice;
import com.viconics.wireless.BWirelessStatDeviceFolder;
import com.viconics.wireless.BWirelessStatPointBuilder;
import com.viconics.wireless.WirelessStatMessageListener;
import com.viconics.wireless.comm.BWirelessStatReplyParser;
import com.viconics.wireless.comm.BWirelessStatUnsolicitedReceive;
import com.viconics.wireless.comm.WirelessStatComm;
import com.viconics.wireless.comm.WirelessStatCommReceiver;
import com.viconics.wireless.datatypes.BIZigbeeHelperParent;
import com.viconics.wireless.datatypes.BWirelessStatCoordAddressInfo;
import com.viconics.wireless.datatypes.BWirelessStatCoordModuleInfo;
import com.viconics.wireless.datatypes.BWirelessStatSerialHelper;
import com.viconics.wireless.datatypes.BWirelessStatZigbeeHelper;
import com.viconics.wireless.messages.WirelessStatReceivedMessage;
import com.viconics.wireless.misc.BUtils;
import com.viconics.wireless.point.BWirelessStatProxyExt;
import com.viconics.wireless.point.enums.BCoolingValvesEnum;
import com.viconics.wireless.point.enums.BEffectiveOccupancyEnum;
import com.viconics.wireless.point.enums.BFanModeFcuEnum;
import com.viconics.wireless.point.enums.BHeatingValvesEnum;
import com.viconics.wireless.point.enums.BKeypadLookoutEnum;
import com.viconics.wireless.point.enums.BOccupancyCommandEnum;
import com.viconics.wireless.point.enums.BSequenceOfOperationEnum;
import com.viconics.wireless.point.enums.BSystemModeEnum;
import com.viconics.wireless.ui.BCreateSampleDevice;
import java.util.Hashtable;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nav.BINavNode;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessStatNetwork
extends BSerialNetwork
implements BIZigbeeHelperParent,
MessageListener,
WirelessStatMessageListener {
    public static final Property faultCause = BWirelessStatNetwork.newProperty((int)67, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property monitor = BWirelessStatNetwork.newProperty((int)0, (BValue)new BPingMonitor(), null);
    public static final Property tuningPolicies = BWirelessStatNetwork.newProperty((int)4, (BValue)new BTuningPolicyMap(), null);
    public static final Property pollScheduler = BWirelessStatNetwork.newProperty((int)4, (BValue)new BBasicPollScheduler(), null);
    public static final Property retryCount = BWirelessStatNetwork.newProperty((int)4, (int)3, (BFacets)BFacets.makeNumeric((BUnit)BUnit.NULL, (BNumber)BInteger.make((int)0), (BNumber)BInteger.make((int)5)));
    public static final Property responseTimeout = BWirelessStatNetwork.newProperty((int)4, (BValue)BRelTime.make((long)10000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)20)));
    public static final Property interMessageDelay = BWirelessStatNetwork.newProperty((int)4, (BValue)BRelTime.make((long)10L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property sendMessageDelay = BWirelessStatNetwork.newProperty((int)4, (BValue)BRelTime.make((long)20L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property serialPortConfig = BWirelessStatNetwork.newProperty((int)0, (BValue)new BWirelessStatSerialHelper(), null);
    public static final Property unsolicitedReceiveHandler = BWirelessStatNetwork.newProperty((int)5, (BValue)new BWirelessStatUnsolicitedReceive(), null);
    public static final Property wirelessParametersConfig = BWirelessStatNetwork.newProperty((int)0, (BValue)BWirelessStatZigbeeHelper.DEFAULT, null);
    public static final Property communicationModuleInfo = BWirelessStatNetwork.newProperty((int)0, (BValue)BWirelessStatCoordModuleInfo.DEFAULT, null);
    public static final Property addressInfo = BWirelessStatNetwork.newProperty((int)0, (BValue)BWirelessStatCoordAddressInfo.DEFAULT, null);
    public static final Property discoveredDevices = BWirelessStatNetwork.newProperty((int)0, (BValue)new BWirelessStatDeviceFolder(), null);
    public static final Action resetStatistics = BWirelessStatNetwork.newAction((int)20, null);
    public static final Action upload = BWirelessStatNetwork.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BWirelessStatNetwork.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Action ping = BWirelessStatNetwork.newAction((int)20, null);
    public static final Action startNetwork = BWirelessStatNetwork.newAction((int)20, null);
    public static final Action readNetworkInfo = BWirelessStatNetwork.newAction((int)20, null);
    public static final Action RequestIdentify = BWirelessStatNetwork.newAction((int)20, null);
    public static final Type TYPE;
    private static volatile int transSeq;
    private static Hashtable hash;
    public static BDevice[] devArray;
    private static BWirelessStatNetwork wirelessNetwork;
    public long[] retriesArray;
    static /* synthetic */ Class class$com$viconics$wireless$BWirelessStatNetwork;

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    public void setMonitor(BPingMonitor bPingMonitor) {
        this.set(monitor, (BValue)bPingMonitor, null);
    }

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public BPollScheduler getPollScheduler() {
        return (BPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BPollScheduler bPollScheduler) {
        this.set(pollScheduler, (BValue)bPollScheduler, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int n) {
        this.setInt(retryCount, n, null);
    }

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public BRelTime getSendMessageDelay() {
        return (BRelTime)this.get(sendMessageDelay);
    }

    public void setSendMessageDelay(BRelTime bRelTime) {
        this.set(sendMessageDelay, (BValue)bRelTime, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public BWirelessStatUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BWirelessStatUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    public void setUnsolicitedReceiveHandler(BWirelessStatUnsolicitedReceive bWirelessStatUnsolicitedReceive) {
        this.set(unsolicitedReceiveHandler, (BValue)bWirelessStatUnsolicitedReceive, null);
    }

    public BWirelessStatZigbeeHelper getWirelessParametersConfig() {
        return (BWirelessStatZigbeeHelper)this.get(wirelessParametersConfig);
    }

    public void setWirelessParametersConfig(BWirelessStatZigbeeHelper bWirelessStatZigbeeHelper) {
        this.set(wirelessParametersConfig, (BValue)bWirelessStatZigbeeHelper, null);
    }

    public BWirelessStatCoordModuleInfo getCommunicationModuleInfo() {
        return (BWirelessStatCoordModuleInfo)this.get(communicationModuleInfo);
    }

    public void setCommunicationModuleInfo(BWirelessStatCoordModuleInfo bWirelessStatCoordModuleInfo) {
        this.set(communicationModuleInfo, (BValue)bWirelessStatCoordModuleInfo, null);
    }

    public BWirelessStatCoordAddressInfo getAddressInfo() {
        return (BWirelessStatCoordAddressInfo)this.get(addressInfo);
    }

    public void setAddressInfo(BWirelessStatCoordAddressInfo bWirelessStatCoordAddressInfo) {
        this.set(addressInfo, (BValue)bWirelessStatCoordAddressInfo, null);
    }

    public BWirelessStatDeviceFolder getDiscoveredDevices() {
        return (BWirelessStatDeviceFolder)this.get(discoveredDevices);
    }

    public void setDiscoveredDevices(BWirelessStatDeviceFolder bWirelessStatDeviceFolder) {
        this.set(discoveredDevices, (BValue)bWirelessStatDeviceFolder, null);
    }

    public void resetStatistics() {
        this.invoke(resetStatistics, null, null);
    }

    public void upload(BUploadParameters bUploadParameters) {
        this.invoke(upload, (BValue)bUploadParameters, null);
    }

    public void download(BDownloadParameters bDownloadParameters) {
        this.invoke(download, (BValue)bDownloadParameters, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public void startNetwork() {
        this.invoke(startNetwork, null, null);
    }

    public void readNetworkInfo() {
        this.invoke(readNetworkInfo, null, null);
    }

    public void RequestIdentify() {
        this.invoke(RequestIdentify, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doReadNetworkInfo() {
        if (BWirelessStatReplyParser.dataOutReplyReq(this, "0F01", "00", 0, BWirelessStatNetwork.makeTransString(), "", this) && BWirelessStatReplyParser.dataOutReplyReq(this, "0F03", "00", 0, BWirelessStatNetwork.makeTransString(), "", this)) {
            this.getWirelessParametersConfig().communicationOk();
            return;
        }
    }

    public void setMsgFault() {
        this.getWirelessParametersConfig().communicationFail("Failed to communicate with wireless communication board");
    }

    public void setMsgOk() {
        this.getWirelessParametersConfig().communicationOk();
    }

    public void doResetStatistics() {
        int n = 0;
        while (n < this.retriesArray.length) {
            this.retriesArray[n] = 0L;
            ++n;
        }
    }

    public void doCreateDynamicDevice(BCreateSampleDevice bCreateSampleDevice) {
        BWirelessStatPointBuilder.createDisabledDevice(bCreateSampleDevice.getModelNumber(), bCreateSampleDevice.getCommAddress(), 0, this);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"Wireless Network", 2);
        spyWriter.prop((Object)"Total Messages without retries", (Object)new Long(this.retriesArray[0]));
        spyWriter.prop((Object)"Total Messages with 1 retry", (Object)new Long(this.retriesArray[1]));
        spyWriter.prop((Object)"Total Messages with 2 retry", (Object)new Long(this.retriesArray[2]));
        spyWriter.prop((Object)"Total Messages with 3 retry", (Object)new Long(this.retriesArray[3]));
        spyWriter.prop((Object)"Total Messages with 4 retry", (Object)new Long(this.retriesArray[4]));
        spyWriter.prop((Object)"Total Messages with 5 retry", (Object)new Long(this.retriesArray[5]));
        spyWriter.prop((Object)"Hash Table size", BWirelessStatNetwork.getHashSize());
        spyWriter.endProps();
    }

    public void checkRemove1(Property property, Context context) {
        if (property.getName().equals("discoveredDevices")) {
            throw new LocalizableRuntimeException("wirelessStat", "discoveredDevicesFolder.name");
        }
        super.checkRemove(property, context);
    }

    public void checkRename(Property property, String string, Context context) {
        if (property.getName().equals("discoveredDevices")) {
            throw new LocalizableRuntimeException("wirelessStat", "discoveredDevicesFolder.name");
        }
        super.checkRename(property, string, context);
    }

    public static BWirelessStatNetwork wirelessNetwork() {
        return wirelessNetwork;
    }

    public boolean deviceIsReady(BWirelessStatDevice bWirelessStatDevice) {
        boolean bl = false;
        if (bWirelessStatDevice != null && bWirelessStatDevice.getAdded() && bWirelessStatDevice.isRunning()) {
            bl = true;
        }
        return bl;
    }

    public void doRequestIdentify() {
        BWirelessStatReplyParser.dataOutReplyReq(this, "0F03", "00", 0, BWirelessStatNetwork.makeTransString(), "", this);
    }

    public void doStartNetwork() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BUtils.wordToHex(this.getWirelessParametersConfig().getZigbeePanId()));
        stringBuffer.append(BUtils.byteToHex(this.getWirelessParametersConfig().getZigbeeChannel()));
        if (BWirelessStatReplyParser.dataOutReplyReq(this, "0F01", "02", 0, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), this)) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            BWirelessStatReplyParser.dataOutReplyReq(this, "0F00", "02", 0, BWirelessStatNetwork.makeTransString(), "", this);
        }
    }

    public String getHostId() {
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        if (bSystemPlatformService != null) {
            return bSystemPlatformService.getHostId();
        }
        return "";
    }

    public void doOutputRemoteConfig(BString bString) {
    }

    public Type getDeviceType() {
        return BWirelessStatDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BWirelessStatDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        this.integrityCheck();
        this.checkLicensed();
        this.setSerialPort();
        super.started();
        this.getTuningPolicies().getDefaultPolicy().setWriteOnEnabled(false);
        this.getTuningPolicies().getDefaultPolicy().setWriteOnStart(false);
        this.getTuningPolicies().getDefaultPolicy().setWriteOnUp(false);
        this.getPollScheduler().disable();
    }

    private final void integrityCheck() {
        if (!Sys.getService((Type)TYPE).equals((Object)this)) {
            this.configFail("Duplicate Wireless Network");
            throw new IllegalStateException("Only one Wireless Network allowed per station!");
        }
    }

    private final void setSerialPort() {
        BSerialHelper bSerialHelper = this.getSerialPortConfig();
        bSerialHelper.setBaudRate((BBaudRate)BSerialBaudRate.baud57600);
        bSerialHelper.setDataBits(BSerialDataBits.dataBits8);
        bSerialHelper.setStopBits(BSerialStopBits.stopBit1);
        bSerialHelper.setParity(BSerialParity.none);
        if (this.getHostId().startsWith("Win-")) {
            bSerialHelper.setFlowControlMode(BSerialFlowControlMode.none);
        } else {
            bSerialHelper.setFlowControlMode(BSerialFlowControlMode.rtsCtsOnInput);
            bSerialHelper.setFlowControlMode(BSerialFlowControlMode.rtsCtsOnOutput);
        }
        this.setSerialPortConfig(bSerialHelper);
    }

    public void descendantsStarted() throws Exception {
        this.postAsync((Runnable)new Invocation((BComponent)this, readNetworkInfo, null, null));
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)5), (Action)readNetworkInfo, null);
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    protected Comm makeComm() {
        return new WirelessStatComm(this, new WirelessStatCommReceiver());
    }

    public void setZigbeeInfo(int n, int n2, int n3, int n4, int n5, int n6, String string, String string2, int n7) {
        BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
        bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
        bWirelessStatDevice.setSignalStrength(n2);
        bWirelessStatDevice.setZigbeeModMajorVersion(n5);
        bWirelessStatDevice.setZigbeeModMinorVersion(n6);
        bWirelessStatDevice.setZigbeeAddress(string);
        bWirelessStatDevice.setIEEEAddress(string2);
        bWirelessStatDevice.setHardwareRevision(n7);
        bWirelessStatDevice.setThermostatFirmwareNumber(n4);
        bWirelessStatDevice.setThermostatFirmwareVersion(n3);
    }

    public void setTemps(int n, int n2, float f, float f2, float f3, float f4, float f5, int n3) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("RoomTemp") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("RoomTemp")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f));
                }
                if (bWirelessStatDevice.getPoints().get("OutdoorTemp") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("OutdoorTemp")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f2));
                }
                if (bWirelessStatDevice.getPoints().get("SupplyTemp") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("SupplyTemp")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f3));
                }
                BNumericPoint bNumericPoint = (BNumericPoint)bWirelessStatDevice.getPoints().get("PIHeatingDemand");
                if (f4 > 100.0f) {
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric(0.0));
                } else if (f4 < 0.0f) {
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric(0.0));
                } else {
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f4));
                }
                BNumericPoint bNumericPoint2 = (BNumericPoint)bWirelessStatDevice.getPoints().get("PICoolingDemand");
                if (f5 > 100.0f) {
                    ((BWirelessStatProxyExt)bNumericPoint2.getProxyExt()).readOk((BStatusValue)new BStatusNumeric(0.0));
                } else if (f5 < 0.0f) {
                    ((BWirelessStatProxyExt)bNumericPoint2.getProxyExt()).readOk((BStatusValue)new BStatusNumeric(0.0));
                } else {
                    ((BWirelessStatProxyExt)bNumericPoint2.getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f5));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTemps> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTSetpoints(int n, int n2, float f, float f2, float f3, float f4, float f5, float f6) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("OccCoolSetpoint") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("OccCoolSetpoint")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f));
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("OccCoolSetpoint")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f));
                }
                if (bWirelessStatDevice.getPoints().get("OccHeatSetpoint") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("OccHeatSetpoint")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f2));
                }
                if (bWirelessStatDevice.getPoints().get("UnOccCoolSetpoint") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("UnOccCoolSetpoint")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f3));
                }
                if (bWirelessStatDevice.getPoints().get("UnOccHeatSetpoint") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("UnOccHeatSetpoint")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f4));
                }
                if (bWirelessStatDevice.getPoints().get("StandByCoolSetpoint") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("StandByCoolSetpoint")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f5));
                }
                if (bWirelessStatDevice.getPoints().get("StandByHeatSetpoint") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("StandByHeatSetpoint")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f6));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSetpoints> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTStatValues(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("EffectiveOccupancy") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("EffectiveOccupancy")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n3 + 1), (BEnumRange)BEnumRange.make((Type)BEffectiveOccupancyEnum.TYPE))));
                }
                if (bWirelessStatDevice.getPoints().get("KeypadLockout") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("KeypadLockout")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n4 + 1), (BEnumRange)BEnumRange.make((Type)BKeypadLookoutEnum.TYPE))));
                }
                if (bWirelessStatDevice.getPoints().get("Alarms") != null) {
                    BEnumPoint bEnumPoint = (BEnumPoint)bWirelessStatDevice.getPoints().get("Alarms");
                    if (!bWirelessStatDevice.isVT76Device()) {
                        switch (n5) {
                            case 0: {
                                n5 = 0;
                                break;
                            }
                            case 128: {
                                n5 = 1;
                                break;
                            }
                            case 4: {
                                n5 = 2;
                                break;
                            }
                            case 8: {
                                n5 = 3;
                                break;
                            }
                            case 132: {
                                n5 = 4;
                                break;
                            }
                            case 136: {
                                n5 = 5;
                                break;
                            }
                            case 12: {
                                n5 = 6;
                                break;
                            }
                        }
                    }
                    ((BWirelessStatProxyExt)bEnumPoint.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n5 + 1), (BEnumRange)bEnumPoint.getOut().getEnum().getRange())));
                }
                if (bWirelessStatDevice.getPoints().get("OccupancyCommand") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("OccupancyCommand")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n6 + 1), (BEnumRange)BEnumRange.make((Type)BOccupancyCommandEnum.TYPE))));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTStatValues> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
            exception.printStackTrace();
        }
    }

    public void setCommonThermostatPIRStatus(int n, int n2, int n3) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("PIRMotionStatus") != null) {
                    if (n3 == 0) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("PIRMotionStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("PIRMotionStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setCommonThermostatPIR> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
            exception.printStackTrace();
        }
    }

    public void setTStatHumidity(int n, int n2, float f, int n3, int n4) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("RoomHumidity") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("RoomHumidity")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f));
                }
                if (bWirelessStatDevice.getPoints().get("DehumidStatus") != null) {
                    if (n3 == 0) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DehumidStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DehumidStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("DehumidLockout") != null) {
                    if (n4 == 0) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DehumidLockout")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DehumidLockout")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTStatHumidity> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTStatHumidity(int n, int n2, float f, int n3, int n4, int n5) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("RoomHumidity") != null) {
                    if (bWirelessStatDevice.isVT76Device()) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("RoomHumidity")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)(f / 10.0f)));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("RoomHumidity")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("DehumidStatus") != null) {
                    if (n3 == 0) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DehumidStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DehumidStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("DehumidLockout") != null) {
                    if (n4 == 0) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DehumidLockout")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DehumidLockout")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTStatHumidity> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTStatFanControl(int n, int n2, int n3, int n4, int n5) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                BEnumWritable bEnumWritable;
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("FanMode") != null) {
                    bEnumWritable = (BEnumWritable)bWirelessStatDevice.getPoints().get("FanMode");
                    switch (n3) {
                        case 0: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)3, (BEnumRange)bEnumWritable.getOut().getEnum().getRange())));
                            break;
                        }
                        case 1: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)4, (BEnumRange)bEnumWritable.getOut().getEnum().getRange())));
                            break;
                        }
                        case 2: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)5, (BEnumRange)bEnumWritable.getOut().getEnum().getRange())));
                            break;
                        }
                        case 3: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)1, (BEnumRange)bEnumWritable.getOut().getEnum().getRange())));
                            break;
                        }
                        case 4: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)2, (BEnumRange)bEnumWritable.getOut().getEnum().getRange())));
                            break;
                        }
                    }
                }
                if (bWirelessStatDevice.getPoints().get("FanStatus") != null) {
                    bEnumWritable = (BEnumPoint)bWirelessStatDevice.getPoints().get("FanStatus");
                    switch (n4) {
                        case 0: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)1, (BEnumRange)bEnumWritable.getEnum().getRange())));
                            break;
                        }
                        case 1: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)4, (BEnumRange)bEnumWritable.getEnum().getRange())));
                            break;
                        }
                        case 2: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)3, (BEnumRange)bEnumWritable.getEnum().getRange())));
                            break;
                        }
                        case 4: {
                            ((BWirelessStatProxyExt)bEnumWritable.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)2, (BEnumRange)bEnumWritable.getEnum().getRange())));
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTStatFanControl> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
            exception.printStackTrace();
        }
    }

    public void setTSValveStatus(int n, int n2, int n3, int n4) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("HeatValveStatus") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("HeatValveStatus")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n3 + 1), (BEnumRange)BEnumRange.make((Type)BHeatingValvesEnum.TYPE))));
                }
                if (bWirelessStatDevice.getPoints().get("CoolValveStatus") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("CoolValveStatus")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n4 + 1), (BEnumRange)BEnumRange.make((Type)BCoolingValvesEnum.TYPE))));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSValveStatus> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setRSSI(int n, int n2, int n3) {
        BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
        if (this.deviceIsReady(bWirelessStatDevice)) {
            bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
            bWirelessStatDevice.setSignalStrength(n2);
            bWirelessStatDevice.setRSSI(n3 * -1);
        }
    }

    public void setTSOutputStatus(int n, int n2, int n3, float f, int n4, int n5) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                bWirelessStatDevice.setStatusBit(n3);
                String string = Integer.toBinaryString(n3);
                if (n3 < 8) {
                    string = "00000000".substring(string.length()).concat(string);
                }
                if (bWirelessStatDevice.getPoints().get("BI1Status") != null) {
                    if (string.charAt(string.length() - 1) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("BI1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("BI1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("BI2Status") != null) {
                    if (string.charAt(string.length() - 2) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("BI2Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("BI2Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("AuxStatus") != null) {
                    if (string.charAt(string.length() - 3) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("AuxStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("AuxStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("AuxCommand") != null) {
                    if (string.charAt(string.length() - 4) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("AuxCommand")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("AuxCommand")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("UI3Status") != null) {
                    if (f < 0.0f) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("UI3Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("UI3Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("SystemMode") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("SystemMode")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n4 + 1), (BEnumRange)BEnumRange.make((Type)BSystemModeEnum.TYPE))));
                }
                if (bWirelessStatDevice.getPoints().get("SequenceOfOperation") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("SequenceOfOperation")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n5 + 1), (BEnumRange)BEnumRange.make((Type)BSequenceOfOperationEnum.TYPE))));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSOutputStatus> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTSHPU(int n, int n2, int n3, int n4) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("SystemModeHPU") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("SystemModeHPU")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n3 + 1), (BEnumRange)BEnumRange.make((Type)BSystemModeEnum.TYPE))));
                }
                if (bWirelessStatDevice.getPoints().get("ReversingValveStatus") != null) {
                    BBooleanPoint bBooleanPoint = (BBooleanPoint)bWirelessStatDevice.getPoints().get("ReversingValveStatus");
                    if (n4 == 0) {
                        ((BWirelessStatProxyExt)bBooleanPoint.getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)bBooleanPoint.getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSHPU> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTSOutputStatusVT7600(int n, int n2, int n3, int n4) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                bWirelessStatDevice.setStatusBit(n3);
                String string = Integer.toBinaryString(n3);
                if (string.length() < 8) {
                    string = "00000000".substring(string.length()).concat(string);
                }
                if (bWirelessStatDevice.getPoints().get("DI2Status") != null && bWirelessStatDevice.getPoints().get("DI2Status") != null) {
                    if (string.charAt(string.length() - 1) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DI2Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DI2Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("DI1Status") != null) {
                    if (bWirelessStatDevice.getDeviceInfo().getFirmwareNumber() == 0 || bWirelessStatDevice.getDeviceInfo().getFirmwareNumber() == 17) {
                        if (string.charAt(string.length() - 1) == '1') {
                            ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DI1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                        } else {
                            ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DI1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                        }
                    } else if (string.charAt(string.length() - 2) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DI1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("DI1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("W1Status") != null) {
                    if (string.charAt(string.length() - 3) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("W1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("W1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("Y1Status") != null) {
                    if (string.charAt(string.length() - 4) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("Y1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("Y1Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("GFanStatus") != null) {
                    if (string.charAt(string.length() - 5) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("GFanStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("GFanStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("AuxStatus") != null) {
                    if (string.charAt(string.length() - 6) == '1') {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("AuxStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("AuxStatus")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    }
                }
                if (bWirelessStatDevice.getPoints().get("FanMode") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("FanMode")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n4 + 1), (BEnumRange)BEnumRange.make((Type)BFanModeFcuEnum.TYPE))));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSOutputStatusVT7600> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTSRTU(int n, int n2, int n3) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("SystemModeRTU") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("SystemModeRTU")).getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n3 + 1), (BEnumRange)BEnumRange.make((Type)BSystemModeEnum.TYPE))));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSRTU> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTSEconimizer(int n, int n2, int n3) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("EconomizerOutput") != null) {
                    ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("EconomizerOutput")).getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)n3));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSEconimizer> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTSTwoStageHeating(int n, int n2, int n3) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("W2Status") != null) {
                    if (n3 == 1) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("W2Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("W2Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    }
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSTwoStageHeating> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTSTwoStageCooling(int n, int n2, int n3) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("Y2Status") != null) {
                    if (n3 == 1) {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("Y2Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true));
                    } else {
                        ((BWirelessStatProxyExt)((BControlPoint)bWirelessStatDevice.getPoints().get("Y2Status")).getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false));
                    }
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setTSTwoStageCooling> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setTSSchedule(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    public void setFloatingValve(int n, int n2, int n3, int n4, int n5) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                BFacets bFacets;
                BEnumRange bEnumRange;
                BEnumPoint bEnumPoint;
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("HeatValveStatus") != null) {
                    bEnumPoint = (BEnumPoint)bWirelessStatDevice.getPoints().get("HeatValveStatus");
                    bEnumRange = BEnumRange.make((int[])BWirelessStatNetwork.getHeatingCoolingValveStatusOrd(n3 + 1), (String[])BWirelessStatNetwork.getHeatingCoolingValveStatusNames(n3 + 1));
                    ((BWirelessStatProxyExt)bEnumPoint.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n4 + 1), (BEnumRange)BEnumRange.make((int[])BWirelessStatNetwork.getHeatingCoolingValveStatusOrd(n3 + 1), (String[])BWirelessStatNetwork.getHeatingCoolingValveStatusNames(n3 + 1)))));
                    bFacets = BFacets.makeEnum((BEnumRange)bEnumRange);
                    bEnumPoint.setFacets(bFacets);
                }
                if (bWirelessStatDevice.getPoints().get("CoolValveStatus") != null) {
                    bEnumPoint = (BEnumPoint)bWirelessStatDevice.getPoints().get("CoolValveStatus");
                    bEnumRange = BEnumRange.make((int[])BWirelessStatNetwork.getHeatingCoolingValveStatusOrd(n3 + 1), (String[])BWirelessStatNetwork.getHeatingCoolingValveStatusNames(n3 + 1));
                    ((BWirelessStatProxyExt)bEnumPoint.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n5 + 1), (BEnumRange)BEnumRange.make((Type)BCoolingValvesEnum.TYPE))));
                    bFacets = BFacets.makeEnum((BEnumRange)bEnumRange);
                    bEnumPoint.setFacets(bFacets);
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setFloatingValve> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setFloatingValve(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                BFacets bFacets;
                BEnumRange bEnumRange;
                BEnumPoint bEnumPoint;
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("HeatValveStatus") != null) {
                    bEnumPoint = (BEnumPoint)bWirelessStatDevice.getPoints().get("HeatValveStatus");
                    bEnumRange = BEnumRange.make((int[])BWirelessStatNetwork.getHeatingCoolingValveStatusOrd(n3 + 1), (String[])BWirelessStatNetwork.getHeatingCoolingValveStatusNames(n3 + 1));
                    ((BWirelessStatProxyExt)bEnumPoint.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n4 + 1), (BEnumRange)BEnumRange.make((int[])BWirelessStatNetwork.getHeatingCoolingValveStatusOrd(n3 + 1), (String[])BWirelessStatNetwork.getHeatingCoolingValveStatusNames(n3 + 1)))));
                    bFacets = BFacets.makeEnum((BEnumRange)bEnumRange);
                    bEnumPoint.setFacets(bFacets);
                }
                if (bWirelessStatDevice.getPoints().get("CoolValveStatus") != null) {
                    bEnumPoint = (BEnumPoint)bWirelessStatDevice.getPoints().get("CoolValveStatus");
                    bEnumRange = BEnumRange.make((int[])BWirelessStatNetwork.getHeatingCoolingValveStatusOrd(n3 + 1), (String[])BWirelessStatNetwork.getHeatingCoolingValveStatusNames(n3 + 1));
                    ((BWirelessStatProxyExt)bEnumPoint.getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(n5 + 1), (BEnumRange)BEnumRange.make((Type)BCoolingValvesEnum.TYPE))));
                    bFacets = BFacets.makeEnum((BEnumRange)bEnumRange);
                    bEnumPoint.setFacets(bFacets);
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setFloatingValve> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setVT76RHStatus(int n, int n2, float f, float f2, float f3) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                BNumericPoint bNumericPoint;
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("HumidifierOutput") != null) {
                    bNumericPoint = (BNumericPoint)bWirelessStatDevice.getPoints().get("HumidifierOutput");
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)(f * 10.0f)));
                }
                if (bWirelessStatDevice.getPoints().get("EffectiveHumidificationRHSetpoint") != null) {
                    bNumericPoint = (BNumericPoint)bWirelessStatDevice.getPoints().get("EffectiveHumidificationRHSetpoint");
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f2));
                }
                if (bWirelessStatDevice.getPoints().get("SupplyRH") != null) {
                    bNumericPoint = (BNumericPoint)bWirelessStatDevice.getPoints().get("SupplyRH");
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f3));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setVT76RHStatus> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setVT76RHSetpoints(int n, int n2, float f, float f2, float f3) {
        try {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
            if (this.deviceIsReady(bWirelessStatDevice)) {
                BNumericPoint bNumericPoint;
                bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                bWirelessStatDevice.setSignalStrength(n2);
                if (bWirelessStatDevice.getPoints().get("DehumidRHSetpoint") != null) {
                    bNumericPoint = (BNumericPoint)bWirelessStatDevice.getPoints().get("DehumidRHSetpoint");
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f));
                }
                if (bWirelessStatDevice.getPoints().get("HumidificationRHSetpoint") != null) {
                    bNumericPoint = (BNumericPoint)bWirelessStatDevice.getPoints().get("HumidificationRHSetpoint");
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f2));
                }
                if (bWirelessStatDevice.getPoints().get("HumidificationHighLimitSetpoint") != null) {
                    bNumericPoint = (BNumericPoint)bWirelessStatDevice.getPoints().get("HumidificationHighLimitSetpoint");
                    ((BWirelessStatProxyExt)bNumericPoint.getProxyExt()).readOk((BStatusValue)new BStatusNumeric((double)f3));
                }
            }
        }
        catch (Exception exception) {
            BUtils.error("Error in function <setVT76RHSetpoints> while receiving message from comm address <" + n + "> (" + exception.getMessage() + ')');
        }
    }

    public void setConflict(int n, boolean bl) {
        BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)devArray[n];
        if (bWirelessStatDevice.getAddressInfo().getCommAddress() == n) {
            bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
            bWirelessStatDevice.setDuplicate(bl);
            bWirelessStatDevice.setStatus(BStatus.fault);
            bWirelessStatDevice.configFail("Duplicate device comm address");
        }
    }

    public static int[] getOrd(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2 + 1;
            ++n2;
        }
        return nArray;
    }

    public static String[] getFanModeNames(int n) {
        String[] stringArray;
        switch (n) {
            case 1: {
                stringArray = new String[]{"Low", "Med", "High"};
                break;
            }
            case 2: {
                stringArray = new String[]{"Low", "High"};
                break;
            }
            case 3: {
                stringArray = new String[]{"Low", "Med", "High", "Auto"};
                break;
            }
            case 4: {
                stringArray = new String[]{"Low", "High", "Auto"};
                break;
            }
            case 5: {
                stringArray = new String[]{"Auto", "On"};
                break;
            }
            default: {
                System.out.println("Error: Invalid value passed into method");
                stringArray = new String[]{"ERROR"};
            }
        }
        return stringArray;
    }

    public static int[] getFanModeOrds(int n) {
        int[] nArray;
        switch (n) {
            case 1: {
                nArray = new int[]{1, 2, 3};
                break;
            }
            case 2: {
                nArray = new int[]{1, 2};
                break;
            }
            case 3: {
                nArray = new int[]{1, 2, 3, 4};
                break;
            }
            case 4: {
                nArray = new int[]{1, 3, 4};
                break;
            }
            case 5: {
                nArray = new int[]{1, 2};
                break;
            }
            default: {
                System.out.println("Error: Invalid value passed into method getFanModeNames (" + n + ')');
                nArray = new int[]{0};
            }
        }
        return nArray;
    }

    public static String[] getHeatingCoolingValveStatusNames(int n) {
        String[] stringArray;
        switch (n) {
            case 1: {
                stringArray = new String[]{"Closed", "Open"};
                break;
            }
            case 2: {
                stringArray = new String[]{"Stopped", "Opening", "Closing"};
                break;
            }
            case 3: {
                stringArray = new String[]{"N$2fA"};
                break;
            }
            default: {
                System.out.println("Error: Invalid value passed into method getHeatingCoolingValveStatusNames (" + n + ')');
                stringArray = new String[]{"ERROR"};
            }
        }
        return stringArray;
    }

    public static int[] getHeatingCoolingValveStatusOrd(int n) {
        int[] nArray;
        switch (n) {
            case 1: {
                nArray = new int[]{1, 2};
                break;
            }
            case 2: {
                nArray = new int[]{1, 2, 3};
                break;
            }
            case 3: {
                nArray = new int[]{0};
                break;
            }
            default: {
                System.out.println("Error: Invalid value passed into method getHeatingCoolingValveStatusOrd (" + n + ')');
                nArray = new int[]{0};
            }
        }
        return nArray;
    }

    public int[] minsToTime(int n) {
        int[] nArray = new int[2];
        nArray[1] = n % 60;
        nArray[0] = (n - nArray[1]) / 60;
        return nArray;
    }

    private final void checkLicensed() {
        if (this.getHostId().equals("Win-A252-4203-BAF5-E681")) {
            return;
        }
        if (this.getHostId().equals("Win-1A68-E6BC-ADC8-3D06")) {
            return;
        }
        try {
            Feature[] featureArray = Sys.getLicenseManager().getFeatures();
            int n = 0;
            while (n < featureArray.length) {
                String string = featureArray[n].getFeatureName();
                String string2 = featureArray[n].getVendorName();
                String string3 = featureArray[n].get("brandId");
                if (string2.equals("Lynxspring") && string.equals("lynxWireless")) {
                    return;
                }
                if (string2.equals("Tridium") && string.equals("brand") && (string3.equals("vykon") || string3.equals("FacExp"))) {
                    return;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new FeatureNotLicensedException("wirelessStat is NOT licensed");
        }
        throw new FeatureNotLicensedException("wirelessStat is NOT licensed");
    }

    public void doChangePanId(BInteger bInteger) {
        this.getWirelessParametersConfig().setZigbeePanId(bInteger.getInt());
    }

    public void doChangeZigBeeChan(BInteger bInteger) {
        this.getWirelessParametersConfig().setZigbeeChannel(bInteger.getInt());
    }

    public Hashtable getHash() {
        return hash;
    }

    public static synchronized String makeTransString() {
        ++transSeq;
        return Integer.toHexString(256 + (transSeq %= 255)).substring(1).toUpperCase();
    }

    public void registerDevice(BWirelessStatDevice bWirelessStatDevice) {
        int n = bWirelessStatDevice.getCommAddress();
        BWirelessStatNetwork.devArray[n] = bWirelessStatDevice;
    }

    public void unregisterDevice(BWirelessStatDevice bWirelessStatDevice) {
        int n = bWirelessStatDevice.getCommAddress();
        BWirelessStatNetwork.devArray[n] = null;
    }

    public static int getHashSize() {
        return hash.size();
    }

    public void setzigbeeChannel(int n) {
        this.getWirelessParametersConfig().setZigbeeChannel(n);
    }

    public int getzigbeeChannel() {
        return this.getWirelessParametersConfig().getZigbeeChannel();
    }

    public void setZigbeePanId(int n) {
        this.getWirelessParametersConfig().setZigbeePanId(n);
    }

    public int getZigbeePanId() {
        return this.getWirelessParametersConfig().getZigbeePanId();
    }

    public final void reopenWirelessPort(Context context) {
        if (context instanceof BasicContext) {
            Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)50L), (Action)startNetwork, null);
        }
    }

    public void setZigbeeModMajorVersion(int n) {
        this.getCommunicationModuleInfo().setZigbeeModMajorVersion(n);
    }

    public void setZigbeeModMinorVersion(int n) {
        this.getCommunicationModuleInfo().setZigbeeModMinorVersion(n);
    }

    public void setZigbeeAddress(String string) {
        this.getAddressInfo().setZigbeeAddress(string);
    }

    public void setIEEEAddress(String string) {
        this.getAddressInfo().setIEEEAddress(string);
    }

    public void setHardwareRevision(int n) {
        this.getCommunicationModuleInfo().setHardwareRevision(n);
    }

    public BINavNode[] getNavChildren() {
        BComponent bComponent;
        this.loadSlots();
        BComponent[] bComponentArray = new BComponent[this.getSlotCount()];
        SlotCursor slotCursor = this.getProperties();
        int n = 0;
        while (slotCursor.nextComponent()) {
            bComponent = (BComponent)slotCursor.get();
            if (Flags.isHidden((BComplex)this, (Slot)slotCursor.property()) || !bComponent.isNavChild() || bComponent.getPropertyInParent().isFrozen() && !bComponent.getPropertyInParent().getName().equals("discoveredDevices")) continue;
            bComponentArray[n++] = bComponent;
        }
        bComponent = new BComponent[n];
        System.arraycopy(bComponentArray, 0, bComponent, 0, n);
        return bComponent;
    }

    public void processMessage(Message message) {
        if (message != null) {
            this.setMsgOk();
            this.getUnsolicitedReceiveHandler().processResponse((WirelessStatReceivedMessage)message);
        } else {
            this.setMsgFault();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.retriesArray = new long[7];
    }

    public BWirelessStatNetwork() {
        this.this();
        wirelessNetwork = this;
        this.getTuningPolicies().getDefaultPolicy().setWriteOnEnabled(false);
        this.getTuningPolicies().getDefaultPolicy().setWriteOnStart(false);
        this.getTuningPolicies().getDefaultPolicy().setWriteOnUp(false);
        this.getPollScheduler().disable();
    }

    static {
        Class clazz = class$com$viconics$wireless$BWirelessStatNetwork;
        if (clazz == null) {
            clazz = class$com$viconics$wireless$BWirelessStatNetwork = BWirelessStatNetwork.class("[Lcom.viconics.wireless.BWirelessStatNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        transSeq = 0;
        hash = new Hashtable();
        devArray = new BDevice[255];
        wirelessNetwork = null;
    }
}

