/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wireless;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.basicdriver.MessageListener;
import com.tridium.basicdriver.message.Message;
import com.viconics.wireless.BWirelessStatDeviceFolder;
import com.viconics.wireless.BWirelessStatNetwork;
import com.viconics.wireless.WirelessStatMessageListener;
import com.viconics.wireless.comm.BWirelessStatReplyParser;
import com.viconics.wireless.datatypes.BWirelessStatDeviceAddressInfo;
import com.viconics.wireless.datatypes.BWirelessStatDeviceModelInfo;
import com.viconics.wireless.datatypes.BWirelessStatDeviceModuleInfo;
import com.viconics.wireless.messages.WirelessStatReceivedMessage;
import com.viconics.wireless.misc.BUtils;
import com.viconics.wireless.point.BWirelessStatPointDeviceExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessStatDevice
extends BBasicDevice
implements MessageListener,
WirelessStatMessageListener {
    public static final Property deviceInfo = BWirelessStatDevice.newProperty((int)0, (BValue)BWirelessStatDeviceModelInfo.DEFAULT, null);
    public static final Property addressInfo = BWirelessStatDevice.newProperty((int)0, (BValue)BWirelessStatDeviceAddressInfo.DEFAULT, null);
    public static final Property communicationModuleInfo = BWirelessStatDevice.newProperty((int)0, (BValue)BWirelessStatDeviceModuleInfo.DEFAULT, null);
    public static final Property signalStrength = BWirelessStatDevice.newProperty((int)3, (int)0, null);
    public static final Property RSSI = BWirelessStatDevice.newProperty((int)7, (int)0, null);
    public static final Property duplicate = BWirelessStatDevice.newProperty((int)5, (boolean)false, null);
    public static final Property points = BWirelessStatDevice.newProperty((int)0, (BValue)new BWirelessStatPointDeviceExt(), null);
    public static final Action upload = BWirelessStatDevice.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BWirelessStatDevice.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Action ping = BWirelessStatDevice.newAction((int)20, null);
    public static final Action AddRemoveToNetwork = BWirelessStatDevice.newAction((int)20, null);
    public static final Action SendAddedStatus = BWirelessStatDevice.newAction((int)20, null);
    public static final Action AckDuplcate = BWirelessStatDevice.newAction((int)20, null);
    public static final Type TYPE;
    private long lastHeartbeat;
    private int statusBit;
    static /* synthetic */ Class class$com$viconics$wireless$BWirelessStatDevice;

    public BWirelessStatDeviceModelInfo getDeviceInfo() {
        return (BWirelessStatDeviceModelInfo)this.get(deviceInfo);
    }

    public void setDeviceInfo(BWirelessStatDeviceModelInfo bWirelessStatDeviceModelInfo) {
        this.set(deviceInfo, (BValue)bWirelessStatDeviceModelInfo, null);
    }

    public BWirelessStatDeviceAddressInfo getAddressInfo() {
        return (BWirelessStatDeviceAddressInfo)this.get(addressInfo);
    }

    public void setAddressInfo(BWirelessStatDeviceAddressInfo bWirelessStatDeviceAddressInfo) {
        this.set(addressInfo, (BValue)bWirelessStatDeviceAddressInfo, null);
    }

    public BWirelessStatDeviceModuleInfo getCommunicationModuleInfo() {
        return (BWirelessStatDeviceModuleInfo)this.get(communicationModuleInfo);
    }

    public void setCommunicationModuleInfo(BWirelessStatDeviceModuleInfo bWirelessStatDeviceModuleInfo) {
        this.set(communicationModuleInfo, (BValue)bWirelessStatDeviceModuleInfo, null);
    }

    public int getSignalStrength() {
        return this.getInt(signalStrength);
    }

    public void setSignalStrength(int n) {
        this.setInt(signalStrength, n, null);
    }

    public int getRSSI() {
        return this.getInt(RSSI);
    }

    public void setRSSI(int n) {
        this.setInt(RSSI, n, null);
    }

    public boolean getDuplicate() {
        return this.getBoolean(duplicate);
    }

    public void setDuplicate(boolean bl) {
        this.setBoolean(duplicate, bl, null);
    }

    public BWirelessStatPointDeviceExt getPoints() {
        return (BWirelessStatPointDeviceExt)this.get(points);
    }

    public void setPoints(BWirelessStatPointDeviceExt bWirelessStatPointDeviceExt) {
        this.set(points, (BValue)bWirelessStatPointDeviceExt, null);
    }

    public void upload(BUploadParameters bUploadParameters) {
        this.invoke(upload, (BValue)bUploadParameters, null);
    }

    public void download(BDownloadParameters bDownloadParameters) {
        this.invoke(download, (BValue)bDownloadParameters, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public void AddRemoveToNetwork() {
        this.invoke(AddRemoveToNetwork, null, null);
    }

    public void SendAddedStatus() {
        this.invoke(SendAddedStatus, null, null);
    }

    public void AckDuplcate() {
        this.invoke(AckDuplcate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    void doUpload(BUploadParameters bUploadParameters) {
    }

    void doDownload(BDownloadParameters bDownloadParameters) {
    }

    public void doAckDuplcate() {
        this.setDuplicate(false);
    }

    public void doAddRemoveToNetwork() {
        BFolder bFolder = (BFolder)this.getNetwork().get("discoveredDevices");
        BWirelessStatDevice bWirelessStatDevice = this;
        String string = bWirelessStatDevice.getName();
        BWirelessStatNetwork bWirelessStatNetwork = this.getWirelessNetwork();
        if (this.getParent().getType().is(BWirelessStatNetwork.TYPE)) {
            this.getWirelessNetwork().remove(this.getName());
            bFolder.add(string, (BValue)bWirelessStatDevice);
            bWirelessStatDevice.getPoints().removeAllPoints();
            BWirelessStatNetwork.devArray[bWirelessStatDevice.getAddressInfo().getCommAddress()] = bWirelessStatDevice;
            BWirelessStatReplyParser.dataOutReplyReq(this.getWirelessNetwork(), "0003", "02", bWirelessStatDevice.getAddressInfo().getCommAddress(), BWirelessStatNetwork.makeTransString(), "00", this);
        } else {
            bFolder.remove(this.getName());
            bWirelessStatNetwork.add(string, (BValue)bWirelessStatDevice);
            ((BWirelessStatPointDeviceExt)bWirelessStatDevice.getPoints().getDeviceExt()).addAllPoints();
            BWirelessStatNetwork.devArray[bWirelessStatDevice.getAddressInfo().getCommAddress()] = bWirelessStatDevice;
            BWirelessStatReplyParser.dataOutReplyReq(this.getWirelessNetwork(), "0003", "02", bWirelessStatDevice.getAddressInfo().getCommAddress(), BWirelessStatNetwork.makeTransString(), "01", this);
        }
    }

    public boolean getAdded() {
        return this.getParent().getType().is(BWirelessStatNetwork.TYPE);
    }

    public final BWirelessStatNetwork getWirelessNetwork() {
        return (BWirelessStatNetwork)this.getNetwork();
    }

    public Type getNetworkType() {
        return BWirelessStatNetwork.TYPE;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
    }

    public void doSendAddedStatus() {
        if (this.getAdded()) {
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0003", "02", this.getCommAddress(), BWirelessStatNetwork.makeTransString(), "01", this);
        } else {
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0003", "02", this.getCommAddress(), BWirelessStatNetwork.makeTransString(), "00", this);
        }
    }

    public void setMsgFault() {
        this.setFaultCause("Communication failure");
        this.setStatus(BStatus.down);
    }

    public void setMsgOk() {
        this.setFaultCause("");
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)false));
    }

    public void started() throws Exception {
        this.setLastHeartbeat(System.currentTimeMillis());
        this.checkLicensed();
        super.started();
        this.lease(2);
        int n = this.getCommAddress();
        BDevice bDevice = BWirelessStatNetwork.devArray[n];
        if (bDevice != null && bDevice != this) {
            this.configFail("Duplicate comm address");
            this.setCommAddress(0);
            return;
        }
        BWirelessStatNetwork.wirelessNetwork().registerDevice(this);
    }

    public void descendantsStarted() {
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)60), (Action)SendAddedStatus, null);
    }

    public void stopped() throws Exception {
        super.stopped();
        BWirelessStatNetwork.wirelessNetwork().unregisterDevice(this);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        if (!this.isRunning()) {
            return;
        }
        if (!BWirelessStatNetwork.wirelessNetwork().isRunning()) {
            return;
        }
        if (System.currentTimeMillis() - this.getLastHeartbeat() > (long)this.getWirelessNetwork().getMonitor().getPingFrequency().getSeconds() * 1000L) {
            BWirelessStatReplyParser.dataOutReplyReq(this.getWirelessNetwork(), "0000", "00", this.getCommAddress(), BWirelessStatNetwork.makeTransString(), "01", this);
            if (!this.isDown()) {
                BUtils.error("Ping failed on device " + this.getName());
            }
            this.pingFail("Heartbeat failed");
            this.setFaultCause("Heartbeat failed");
            this.setSignalStrength(0);
        } else {
            if (this.isDown()) {
                BUtils.message("Ping success on device " + this.getName());
            }
            if (this.getDuplicate()) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Duplicate device comm address");
            } else {
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
            }
            this.pingOk();
        }
    }

    public void doRequestRSSI() {
        String string = BWirelessStatNetwork.makeTransString();
        BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0004", "00", this.getAddressInfo().getCommAddress(), string, "", null);
    }

    public void setLastHeartbeat(long l) {
        this.lastHeartbeat = l;
        if (this.isRunning() && !this.isNull()) {
            this.setMsgOk();
            this.doPing();
        }
    }

    public int getStatusBit() {
        return this.statusBit;
    }

    public void setStatusBit(int n) {
        this.statusBit = n;
    }

    private final void checkLicensed() {
        if (this.getWirelessNetwork().getHostId().equals("Win-A252-4203-BAF5-E681")) {
            return;
        }
        if (this.getWirelessNetwork().getHostId().equals("Win-1A68-E6BC-ADC8-3D06")) {
            return;
        }
        try {
            Feature[] featureArray = Sys.getLicenseManager().getFeatures();
            int n = 0;
            while (n < featureArray.length) {
                String string = featureArray[n].getFeatureName();
                String string2 = featureArray[n].getVendorName();
                String string3 = featureArray[n].get("brandId");
                if (string2.equals("Lynxspring") && string.equals("lynxWireless")) {
                    return;
                }
                if (string2.equals("Tridium") && string.equals("brand") && (string3.equals("vykon") || string3.equals("FacExp"))) {
                    return;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new FeatureNotLicensedException("wirelessStat is NOT licensed");
        }
        throw new FeatureNotLicensedException("wirelessStat is NOT licensed");
    }

    public boolean isVT76Device() {
        boolean bl = false;
        if (this.getDeviceInfo().getFirmwareNumber() < 20) {
            bl = true;
        }
        return bl;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setZigbeeAddress(String string) {
        this.getAddressInfo().setZigbeeAddress(string);
    }

    public void setIEEEAddress(String string) {
        this.getAddressInfo().setIEEEAddress(string);
    }

    public void setHardwareRevision(int n) {
        this.getCommunicationModuleInfo().setHardwareRevision(n);
    }

    public int getCommAddress() {
        return this.getAddressInfo().getCommAddress();
    }

    public void setCommAddress(int n) {
        this.getAddressInfo().setCommAddress(n);
    }

    public void setThermostatFirmwareNumber(int n) {
        this.getDeviceInfo().setFirmwareNumber(n);
    }

    public int getThermostatFirmwareNumber() {
        return this.getDeviceInfo().getFirmwareNumber();
    }

    public void setThermostatFirmwareVersion(int n) {
        this.getDeviceInfo().setFirmwareVersion(n);
    }

    public boolean isParentLegal(BComponent bComponent) {
        if (bComponent instanceof BWirelessStatNetwork) {
            return true;
        }
        if (!(bComponent instanceof BWirelessStatDeviceFolder)) {
            return false;
        }
        if (bComponent.getPropertyInParent() == null) {
            return true;
        }
        return bComponent.getPropertyInParent().getName().equals("discoveredDevices");
    }

    public void setZigbeeModMajorVersion(int n) {
        this.getCommunicationModuleInfo().setZigbeeModMajorVersion(n);
    }

    public void setZigbeeModMinorVersion(int n) {
        this.getCommunicationModuleInfo().setZigbeeModMinorVersion(n);
    }

    public void processMessage(Message message) {
        if (message != null) {
            this.setMsgOk();
            this.getWirelessNetwork().getUnsolicitedReceiveHandler().processResponse((WirelessStatReceivedMessage)message);
        } else {
            this.setMsgFault();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastHeartbeat = 0L;
        this.statusBit = 0;
    }

    public BWirelessStatDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$viconics$wireless$BWirelessStatDevice;
        if (clazz == null) {
            clazz = class$com$viconics$wireless$BWirelessStatDevice = BWirelessStatDevice.class("[Lcom.viconics.wireless.BWirelessStatDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

