/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.rsp;

import com.tridium.andoverInfinity.identify.BInfinityPointId;
import com.tridium.andoverInfinity.point.BInfinityProxyExt;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import javax.baja.control.BControlPoint;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BString;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BInfinityReadPointResponse
extends BDdfResponse
implements BIDdfReadResponse {
    public static final Type TYPE;
    static final Lexicon lex;
    private String answer;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$comm$rsp$BInfinityReadPointResponse;

    public Type getType() {
        return TYPE;
    }

    public BStatusValue parseReadValue(IDdfReadable iDdfReadable) {
        if (iDdfReadable instanceof BInfinityProxyExt) {
            BInfinityProxyExt bInfinityProxyExt = (BInfinityProxyExt)iDdfReadable;
            BControlPoint bControlPoint = bInfinityProxyExt.getParentPoint();
            BInfinityPointId bInfinityPointId = (BInfinityPointId)bInfinityProxyExt.getPointId();
            bInfinityPointId.setRawResponse(this.answer);
            int n = this.answer.indexOf(61);
            if (n == -1) {
                return null;
            }
            String string = this.answer.substring(n + 1).trim();
            int n2 = string.indexOf(" ");
            String string2 = n2 == -1 ? string : string.substring(0, n2);
            if (bControlPoint instanceof BStringPoint) {
                return new BStatusString(string);
            }
            if (bControlPoint instanceof BINumeric) {
                return this.parseNumeric(string2);
            }
            if (bControlPoint instanceof BIBoolean) {
                return this.parseBoolean(string2);
            }
            if (bControlPoint instanceof BIEnum) {
                return this.parseEnum(string2, bInfinityProxyExt);
            }
        }
        return null;
    }

    private final BStatusNumeric parseNumeric(String string) throws NumberFormatException {
        return new BStatusNumeric(this.stringToNumeric(string));
    }

    private final BStatusEnum parseEnum(String string, BInfinityProxyExt bInfinityProxyExt) throws NumberFormatException {
        BStatusEnum bStatusEnum = (BStatusEnum)bInfinityProxyExt.getReadValue().newCopy();
        try {
            BDouble bDouble = BDouble.make((double)this.stringToNumeric(string));
            bStatusEnum = (BStatusEnum)bInfinityProxyExt.getReadValue().newCopy();
            BDynamicEnum bDynamicEnum = bStatusEnum.getValue();
            bStatusEnum.setValue(bDynamicEnum.getRange().get((int)bDouble.getDouble()));
        }
        catch (NumberFormatException numberFormatException) {
            BEnum bEnum = this.getEnum(string, ((BControlPoint)this.getParent()).getFacets());
            bStatusEnum.setValue(bEnum);
        }
        return bStatusEnum;
    }

    private final double stringToNumeric(String string) throws NumberFormatException {
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(string);
                return d;
            }
            catch (NumberFormatException numberFormatException2) {
                if (string.equalsIgnoreCase("On") || string.equalsIgnoreCase("True")) {
                    return 1.0;
                }
                if (string.equalsIgnoreCase("-On")) {
                    return -1.0;
                }
                if (string.equalsIgnoreCase("Off") || string.equalsIgnoreCase("False")) {
                    return 0.0;
                }
                throw new NumberFormatException("not a number");
            }
        }
    }

    private final BStatusBoolean parseBoolean(String string) throws NumberFormatException {
        try {
            BStatusNumeric bStatusNumeric = this.parseNumeric(string);
            return (double)Math.round(bStatusNumeric.getValue()) == 0.0 ? new BStatusBoolean(false) : new BStatusBoolean(true);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                BFacets bFacets = ((BControlPoint)this.getParent()).getFacets();
                boolean bl = this.getBoolean(string, bFacets);
                return new BStatusBoolean(bl);
            }
            catch (Exception exception) {
                throw numberFormatException;
            }
        }
    }

    private final BEnum getEnum(String string, BFacets bFacets) throws NumberFormatException {
        if (bFacets != null) {
            try {
                BEnumRange bEnumRange = (BEnumRange)bFacets.get("range");
                BEnum bEnum = bEnumRange.get(string);
                return bEnum;
            }
            catch (InvalidEnumException invalidEnumException) {
                throw new NumberFormatException("answer does not match an enum tag");
            }
        }
        throw new NumberFormatException("No Enum Defined");
    }

    private final boolean getBoolean(String string, BFacets bFacets) throws NumberFormatException {
        if (bFacets != null) {
            BString bString = (BString)bFacets.get("trueText");
            BString bString2 = (BString)bFacets.get("falseText");
            if (bString != null && bString2 != null) {
                if (string.equalsIgnoreCase(bString.getString())) {
                    return true;
                }
                if (string.equalsIgnoreCase(bString2.getString())) {
                    return false;
                }
            }
        }
        if (lex.getText("point.boolean.define." + string) == "1") {
            return true;
        }
        if (lex.getText("point.boolean.define." + string) == "0") {
            return false;
        }
        throw new NumberFormatException("cannot convert string to boolean");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BInfinityReadPointResponse() {
    }

    public BInfinityReadPointResponse(String string) {
        this.answer = string;
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$comm$rsp$BInfinityReadPointResponse;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$comm$rsp$BInfinityReadPointResponse = BInfinityReadPointResponse.class("[Lcom.tridium.andoverInfinity.comm.rsp.BInfinityReadPointResponse;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$andoverInfinity$comm$rsp$BInfinityReadPointResponse;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$andoverInfinity$comm$rsp$BInfinityReadPointResponse = BInfinityReadPointResponse.class("[Lcom.tridium.andoverInfinity.comm.rsp.BInfinityReadPointResponse;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

