/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinitySuccessResponse;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BInfinitySetTimeRequest
extends BDdfRequest
implements Vt100Const,
RequiresNetworkAccess {
    public static final Property remainingRetryCount = BInfinitySetTimeRequest.newProperty((int)0, (int)0, null);
    public static final Type TYPE;
    BInfinityNetwork network;
    String jaceDateTimeString;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$comm$req$BInfinitySetTimeRequest;

    public int getRemainingRetryCount() {
        return this.getInt(remainingRetryCount);
    }

    public void setRemainingRetryCount(int n) {
        this.setInt(remainingRetryCount, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        int n = this.network.getScreen().getMode();
        this.network.getLog().trace("BInfinitySetTimeRequest:processReceive(), mode=" + Vt100Const.cursorModes[n]);
        switch (n) {
            case 4: 
            case 95: 
            case 134: 
            case 135: {
                this.network.getLog().error("error on sync time " + this.jaceDateTimeString + ",mode=" + Vt100Const.cursorModes[n]);
                throw new DdfResponseException("error setting time:" + Vt100Const.cursorModes[n]);
            }
            case 2: {
                return new BInfinitySuccessResponse();
            }
        }
        this.network.getLog().error("illegal mode on sync time " + this.jaceDateTimeString + ",mode=" + Vt100Const.cursorModes[n]);
        throw new DdfResponseException("illegal mode to set time:" + Vt100Const.cursorModes[n]);
    }

    public byte[] toByteArray() {
        int n = this.network.getScreen().getMode();
        StringBuffer stringBuffer = new StringBuffer();
        this.network.getLog().trace("BInfinitySetTimeRequest:toByteArray(), mode=" + Vt100Const.cursorModes[n]);
        switch (n) {
            case 0: 
            case 1: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + '\t').getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    stringBuffer.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), stringBuffer);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), stringBuffer);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                return this.network.getScreen().getRecovery(n).getBytes();
            }
            default: {
                String string = this.network.getScreen().getRecovery(n);
                stringBuffer.append(string);
            }
        }
        stringBuffer.append("\u001bOSED");
        this.jaceDateTimeString = this.getJaceDateTimeString();
        System.out.println("jaceDateTimeString:" + this.jaceDateTimeString);
        stringBuffer.append(this.jaceDateTimeString);
        stringBuffer.append("\r");
        return stringBuffer.toString().getBytes();
    }

    private final String getJaceDateTimeString() {
        BAbsTime bAbsTime = BAbsTime.now();
        int n = bAbsTime.getMinute();
        int n2 = bAbsTime.getSecond();
        String string = String.valueOf(bAbsTime.getYear());
        String string2 = bAbsTime.getMonth().getTag().toUpperCase().substring(0, 3);
        String string3 = String.valueOf(bAbsTime.getDay());
        String string4 = String.valueOf(bAbsTime.getHour());
        String string5 = String.valueOf(bAbsTime.getMinute());
        String string6 = String.valueOf(bAbsTime.getSecond());
        if (n < 10) {
            string5 = "0" + string5;
        }
        if (n2 < 10) {
            string6 = "0" + string6;
        }
        String string7 = string2 + ' ' + string3 + ',' + string + ' ' + string4 + ':' + string5 + ':' + string6;
        while (string7.length() < 32) {
            string7 = string7 + ' ';
        }
        return string7;
    }

    public void setNetwork(BInfinityNetwork bInfinityNetwork) {
        this.network = bInfinityNetwork;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.jaceDateTimeString = "";
    }

    public BInfinitySetTimeRequest() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$comm$req$BInfinitySetTimeRequest;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$comm$req$BInfinitySetTimeRequest = BInfinitySetTimeRequest.class("[Lcom.tridium.andoverInfinity.comm.req.BInfinitySetTimeRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

