/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityCommunicator;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.BInfinityReloadLineRequest;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityReloadStartResponse;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import javax.baja.sys.BBlob;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BInfinityReloadInfinetRequest
extends BDdfRequest
implements Vt100Const,
RequiresNetworkAccess,
BIDdfCustomRequest {
    public static final Property fileContents = BInfinityReloadInfinetRequest.newProperty((int)0, (BValue)BBlob.DEFAULT, null);
    public static final Type TYPE;
    BInfinityNetwork network;
    BufferedReader in;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$comm$req$BInfinityReloadInfinetRequest;

    public BBlob getFileContents() {
        return (BBlob)this.get(fileContents);
    }

    public void setFileContents(BBlob bBlob) {
        this.set(fileContents, (BValue)bBlob, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        int n = this.network.getScreen().getMode();
        if (this.network.getLog().isTraceOn()) {
            this.network.getLog().trace("BInfinitySaveInfinetRequest.processReceive, mode=" + Vt100Const.cursorModes[n]);
        }
        switch (n) {
            case 140: {
                return new BInfinityReloadStartResponse();
            }
        }
        throw new DdfResponseException("illegal mode on infinet save ,mode=" + Vt100Const.cursorModes[n]);
    }

    public byte[] toByteArray() {
        int n = this.network.getScreen().getMode();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.network.getLog().isTraceOn()) {
            this.network.getLog().trace("BInfinityReloadInfinetRequest:toByteArray(), mode=" + Vt100Const.cursorModes[n]);
        }
        switch (n) {
            case 0: 
            case 1: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + '\t').getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    stringBuffer.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), stringBuffer);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), stringBuffer);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                return this.network.getScreen().getRecovery(n).getBytes();
            }
            default: {
                String string = this.network.getScreen().getRecovery(n);
                stringBuffer.append(string);
            }
        }
        this.network.setReloadModeActive(true);
        stringBuffer.append("RELOAD -o\r");
        this.in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.getFileContents().copyBytes())));
        return stringBuffer.toString().getBytes();
    }

    public void processErrorResponse(DdfResponseException ddfResponseException) {
        this.network.setReloadModeActive(false);
        this.network.fireReloadModeDone((BValue)BString.make((String)ddfResponseException.getMessage()));
        this.network.getLog().error(ddfResponseException.getMessage());
    }

    public void processLateResponse(BIDdfResponse bIDdfResponse) {
    }

    public void processResponse(BIDdfResponse bIDdfResponse) {
        if (this.network.getLog().isTraceOn()) {
            this.network.getLog().trace("BInfinityReloadInfinetRequest:processResponse is sending first line");
        }
        try {
            String string = this.in.readLine();
            if (string != null) {
                string = string + '\n';
                if (this.network.getLog().isTraceOn()) {
                    this.network.getLog().trace("firstLine=" + string);
                }
                BInfinityReloadLineRequest bInfinityReloadLineRequest = new BInfinityReloadLineRequest(string, this.in);
                bInfinityReloadLineRequest.setNetwork(this.network);
                ((BInfinityCommunicator)this.network.getCommunicator()).communicate((BIDdfRequest)bInfinityReloadLineRequest);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.network.getLog().error("could not read first Line of reload file ,mode=" + Vt100Const.cursorModes[this.network.getScreen().getMode()] + exception);
        }
    }

    public void processTimeout() {
        this.network.setReloadModeActive(false);
        this.network.fireReloadModeDone((BValue)BString.make((String)"no response to reload command"));
        this.network.getLog().error("no response to reload command");
    }

    public void setNetwork(BInfinityNetwork bInfinityNetwork) {
        this.network = bInfinityNetwork;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$comm$req$BInfinityReloadInfinetRequest;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$comm$req$BInfinityReloadInfinetRequest = BInfinityReloadInfinetRequest.class("[Lcom.tridium.andoverInfinity.comm.req.BInfinityReloadInfinetRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

