/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityAckWithData;
import com.tridium.andoverInfinity.comm.rsp.BInfinityPingResponse;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BInfinityDevicePingRequest
extends BDdfPingRequest
implements Vt100Const,
RequiresNetworkAccess,
BIDdfCustomRequest {
    public static final Type TYPE;
    private static String ONLINE;
    private static String OFFLINE;
    BInfinityNetwork network;
    int recoveryCount;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$comm$req$BInfinityDevicePingRequest;

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        int n = this.network.getScreen().getMode();
        this.network.getLog().trace("BInfinityDevicePingRequest.processReceive(),mode=" + Vt100Const.cursorModes[n]);
        int n2 = this.network.getScreen().getCursorLine();
        String string = "";
        switch (n) {
            case 4: {
                BInfinityDeviceId bInfinityDeviceId = (BInfinityDeviceId)this.network.getNetworkDevice().getDeviceId();
                String string2 = this.network.getScreen().parseNetworkControllerNameFromLine1();
                if (string2 != null) {
                    bInfinityDeviceId.setControllerName(string2);
                }
                string = this.network.getScreen().getFullLine(n2 - 1);
                try {
                    string = string.substring(1, string.length() - 1).trim();
                    if (string.equalsIgnoreCase(ONLINE)) {
                        return new BInfinityPingResponse();
                    }
                    if (string.equalsIgnoreCase(OFFLINE)) {
                        throw new DdfResponseException("Device OffLine");
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                n2 = this.network.getScreen().findLastPromptLine();
                string = this.network.getScreen().getFullLine(n2 - 1);
                try {
                    string = string.substring(1, string.length() - 1).trim();
                    if (string.equalsIgnoreCase(ONLINE)) {
                        return new BInfinityPingResponse();
                    }
                    if (string.equalsIgnoreCase(OFFLINE)) {
                        throw new DdfResponseException("Device OffLine");
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                break;
            }
            default: {
                ++this.recoveryCount;
                if (this.recoveryCount > 2) {
                    this.network.getScreen().clearScreenBuffer();
                    throw new DdfResponseException("error, recoveryCount exceeded, resetting VT100 buffer...");
                }
                return new BInfinityAckWithData(this.network.getScreen().getRecovery(n));
            }
        }
        throw new DdfResponseException("error, response:" + string.trim() + " mode:" + Vt100Const.cursorModes[n]);
    }

    public byte[] toByteArray() {
        BInfinityDeviceId bInfinityDeviceId;
        int n = this.network.getScreen().getMode();
        StringBuffer stringBuffer = new StringBuffer();
        this.network.getLog().trace("BInfinityDevicePingRequest:toByteArray(), mode=" + Vt100Const.cursorModes[n]);
        switch (n) {
            case 10: 
            case 11: {
                return this.network.getScreen().getRecovery(n).getBytes();
            }
            case 0: 
            case 1: 
            case 138: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window\u001b6" + this.network.getNetworkDevice().getUserName() + '\t').getBytes();
            }
            case 4: {
                if (!this.network.getScreen().integrityCheck()) {
                    stringBuffer.append("\u001a");
                }
                if (this.network.getScreen().isInsertMode()) {
                    stringBuffer.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), stringBuffer);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), stringBuffer);
                bInfinityDeviceId = (BInfinityDeviceId)this.network.getNetworkDevice().getDeviceId();
                String string = this.network.getScreen().parseNetworkControllerNameFromLine1();
                if (string == null) break;
                bInfinityDeviceId.setControllerName(string);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                ++this.recoveryCount;
                return this.network.getScreen().getRecovery(n).getBytes();
            }
            default: {
                String string = this.network.getScreen().getRecovery(n);
                stringBuffer.append(string);
            }
        }
        bInfinityDeviceId = (BInfinityDeviceId)this.getDeviceId();
        stringBuffer.append("Print ");
        if (bInfinityDeviceId.getControllerName().length() != 0) {
            stringBuffer.append(bInfinityDeviceId.getControllerName()).append(" ");
        }
        stringBuffer.append("CommStatus\r");
        return stringBuffer.toString().getBytes();
    }

    public void processErrorResponse(DdfResponseException ddfResponseException) {
    }

    public void processLateResponse(BIDdfResponse bIDdfResponse) {
    }

    public void processResponse(BIDdfResponse bIDdfResponse) {
    }

    public void processTimeout() {
        this.network.setConnected(false);
    }

    public void setNetwork(BInfinityNetwork bInfinityNetwork) {
        this.network = bInfinityNetwork;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.recoveryCount = 0;
    }

    public BInfinityDevicePingRequest() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$comm$req$BInfinityDevicePingRequest;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$comm$req$BInfinityDevicePingRequest = BInfinityDevicePingRequest.class("[Lcom.tridium.andoverInfinity.comm.req.BInfinityDevicePingRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ONLINE = "OnLine";
        OFFLINE = "OffLine";
    }
}

