/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityLine;
import com.tridium.andoverInfinity.comm.CursorPosition;
import com.tridium.andoverInfinity.comm.MarkerPosition;
import com.tridium.andoverInfinity.comm.Vt100Const;
import java.util.StringTokenizer;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVt100
extends BStruct
implements Vt100Const {
    public static final Type TYPE;
    private static final int READING_TEXT = 0;
    private static final int READING_ESCAPE_SEQUENCE = 1;
    private static final int POSSIBLE_ESCAPE_SEQUENCE = 2;
    private boolean backupmodeNewLine;
    private ScreenBuffer screenBuffer;
    private StringBuffer escapeSequence;
    private StringBuffer possibleEscapeSequence;
    private int state;
    private int line;
    private CursorPosition oldPosition;
    private int col;
    private boolean readingGraphics;
    private boolean bell;
    private BInfinityNetwork network;
    private char currentTextMode;
    private boolean receivedNullCharacter;
    private boolean insertMode;
    private CursorPosition insertModeCursorPosition;
    private StringBuffer backup;
    private int insertMovesCount;
    private boolean readyToCheckForInsertMoves;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$comm$BVt100;

    public Type getType() {
        return TYPE;
    }

    public BInfinityNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(BInfinityNetwork bInfinityNetwork) {
        this.network = bInfinityNetwork;
    }

    public CursorPosition getCursorPosition() {
        return this.screenBuffer.getPos();
    }

    public byte[] getBackupBytes() {
        byte[] byArray = this.backup.toString().getBytes();
        this.backup = new StringBuffer();
        return byArray;
    }

    public void initializeBackupBuffer() {
        this.backup = new StringBuffer();
    }

    public boolean isBackupmodeNewLine() {
        return this.backupmodeNewLine;
    }

    public void processByte(char c) {
        if (this.network.getBackupModeActive()) {
            this.backup.append(c);
            this.backupmodeNewLine = c == '\r';
        }
        this.bell = false;
        if (c == '\u0007') {
            this.bell = true;
            this.network.setConnected(true);
        } else if (c == '\u001b') {
            this.state = 1;
            this.escapeSequence = new StringBuffer();
            this.escapeSequence.append(c);
        } else if (c == '\u000e') {
            this.readingGraphics = true;
        } else if (c == '\u000f') {
            this.readingGraphics = false;
        } else if (c == '\u0000') {
            this.insertModeCursorPosition = this.screenBuffer.getPos().newCopy();
            this.receivedNullCharacter = true;
            System.out.println("****** received null character-" + this.insertModeCursorPosition);
        } else if (c <= '\u007f') {
            if (this.state != 1) {
                this.receivedNullCharacter = false;
            }
            switch (this.state) {
                case 0: {
                    this.readyToCheckForInsertMoves = false;
                    if (this.readingGraphics) {
                        if (c == 'q') {
                            this.screenBuffer.write('-', this.line, this.col);
                            this.screenBuffer.writeFormat('-', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (c == 'x') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('|', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (c == 'j') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('j', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (c == 'k') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('k', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (c == 'l') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('l', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (c == 'm') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('m', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        }
                        ++this.col;
                        break;
                    }
                    if (c == '\n') {
                        ++this.line;
                        this.col = 0;
                        if (this.line < 24) {
                            this.screenBuffer.clearLine(this.line);
                        } else {
                            this.line = 23;
                            this.screenBuffer.scrollBufferUp();
                        }
                        this.screenBuffer.getPos().setLine(this.line);
                        this.screenBuffer.getPos().setCol(this.col);
                        int n = 0;
                        while (n < 24) {
                            this.network.fireTerminalUpdated((BValue)new BInfinityLine(n, 0, n, 0, this.getFullLine(n), this.getFormatLine(n)));
                            ++n;
                        }
                    } else if (c != '\r') {
                        this.screenBuffer.write(c, this.line, this.col);
                        this.screenBuffer.writeFormat(this.currentTextMode, this.line, this.col);
                        this.screenBuffer.pos.line = this.line;
                        ++this.screenBuffer.pos.col;
                    }
                    if (this.network.isTerminalModeActive()) {
                        BInfinityLine bInfinityLine = new BInfinityLine(this.oldPosition.line, this.oldPosition.col, this.screenBuffer.getPos().getLine(), this.screenBuffer.getPos().getCol(), this.getFullLine(this.oldPosition.line), this.getFormatLine(this.oldPosition.line));
                        this.network.fireTerminalUpdated((BValue)bInfinityLine);
                    }
                    ++this.col;
                    break;
                }
                case 1: {
                    this.escapeSequence.append(c);
                    String string = this.escapeSequence.toString();
                    if (string.equals("\u001b)0")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b(B")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?1h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?1l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?2h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?2l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?3h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?3l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?4h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?4l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?5h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?5l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?6h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?6l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?7h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?7l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?8h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?8l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?9h")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[?9l")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b>")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b=")) {
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[m")) {
                        this.currentTextMode = (char)78;
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[1m")) {
                        this.currentTextMode = (char)66;
                        this.state = 0;
                        break;
                    }
                    if (string.equals("\u001b[7m")) {
                        this.currentTextMode = (char)82;
                        this.state = 0;
                        break;
                    }
                    if (this.escapeSequence.charAt(1) != '[' || this.escapeSequence.charAt(this.escapeSequence.length() - 1) != 'H') break;
                    int n = string.indexOf(";");
                    if (n > 1) {
                        String string2 = this.escapeSequence.substring(2, n);
                        String string3 = this.escapeSequence.substring(n + 1, this.escapeSequence.length() - 1);
                        try {
                            this.line = Integer.parseInt(string2) - 1;
                            this.col = Integer.parseInt(string3) - 1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.state = 0;
                            this.network.getLog().error("detected illegal cursor move escape sequence:" + this.escapeSequence);
                            break;
                        }
                        this.screenBuffer.getPos().setLine(this.line);
                        this.screenBuffer.getPos().setCol(this.col);
                        CursorPosition cursorPosition = new CursorPosition(this.line, this.col);
                        if (cursorPosition.line != this.oldPosition.line) {
                            this.readyToCheckForInsertMoves = false;
                            this.insertMovesCount = 0;
                        } else if (this.readyToCheckForInsertMoves) {
                            this.insertMovesCount = cursorPosition.col == this.oldPosition.col + 1 ? ++this.insertMovesCount : 0;
                        } else {
                            this.readyToCheckForInsertMoves = true;
                        }
                        if (this.insertMovesCount > 3) {
                            if (!this.insertMode) {
                                this.network.getLog().trace("detected insert mode");
                            }
                            System.out.println("detected insert mode");
                            this.insertMode = true;
                        }
                        if (this.receivedNullCharacter) {
                            System.out.println("newPosition:" + cursorPosition);
                            if (cursorPosition.equals(this.insertModeCursorPosition)) {
                                System.out.println("setting insert mode true");
                                if (!this.insertMode) {
                                    this.network.getLog().trace("detected insert mode");
                                }
                                this.insertMode = true;
                            }
                        }
                        if (!cursorPosition.equals(this.oldPosition)) {
                            this.network.fireTerminalUpdated((BValue)new BInfinityLine(this.oldPosition.line, this.oldPosition.col, cursorPosition.line, cursorPosition.col, this.getFullLine(this.oldPosition.line), this.getFormatLine(this.oldPosition.line)));
                        }
                        this.oldPosition = cursorPosition;
                    }
                    this.state = 0;
                    break;
                }
            }
        }
    }

    public boolean isStateReadingText() {
        boolean bl = false;
        if (this.state == 0) {
            bl = true;
        }
        return bl;
    }

    public String getFullLine(int n) {
        if (n < 0 || n > 23) {
            return "";
        }
        return this.screenBuffer.stringBuffers[n].toString();
    }

    public String getTextLine(int n) {
        if (n < 0 || n > 23) {
            return "";
        }
        String string = this.screenBuffer.stringBuffers[n].toString();
        int n2 = string.lastIndexOf("|");
        if (n2 > 1) {
            return string.substring(1, n2).trim();
        }
        return "";
    }

    public String getFormatLine(int n) {
        if (n < 0 || n > 23) {
            return "";
        }
        return this.screenBuffer.formatBuffers[n].toString();
    }

    private static final boolean checkForCharacterInBuffer(StringBuffer stringBuffer, int n, char c) {
        boolean bl = false;
        if (stringBuffer.charAt(n) == c) {
            bl = true;
        }
        return bl;
    }

    public int getCursorLine() {
        return this.getCursorPosition().getLine();
    }

    public int getCursorCol() {
        return this.getCursorPosition().getCol();
    }

    public int lastNonBlankLine() {
        int n = 2;
        int n2 = 2;
        while (n2 < 21) {
            if (this.getTextLine(n2).length() > 0) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public int findLastPromptLine() {
        int n = 21;
        while (n > 2) {
            if (this.getTextLine(n).equals("R>")) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public boolean isCursorOnPrompt() {
        String string = this.getFullLine(this.getCursorLine());
        return string.startsWith("|R>") && this.getCursorCol() == 3;
    }

    public boolean isLineEmpty(int n) {
        String string = this.getTextLine(n);
        return string.length() == 0;
    }

    public void doDumpScreen() {
        this.screenBuffer.dump();
    }

    public int getMode() {
        int n = 0;
        n = this.validateSelectionBox();
        if (n > 0) {
            return n;
        }
        n = this.validateViewEditConnectLogout();
        if (n > 0) {
            return n;
        }
        n = this.validateFileEditSearchCheckTools();
        if (n > 0) {
            return n;
        }
        n = this.validateViewSummaryNoneDefinedDialog();
        if (n > 0) {
            return n;
        }
        n = this.validateBuildingListPleaseWait();
        if (n > 0) {
            return n;
        }
        n = this.validateCursorIsInCommandLineArea();
        if (n > 0) {
            return n;
        }
        n = this.validateOpenAConnectionDialog();
        if (n > 0) {
            return n;
        }
        int[] nArray = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37};
        int n2 = 0;
        while (n2 < nArray.length) {
            n = this.validateView(nArray[n2]);
            if (n > 0) {
                return n;
            }
            ++n2;
        }
        n = this.validateViewMessages();
        if (n > 0) {
            return n;
        }
        n = this.validateLogoutWarningDialog();
        if (n > 0) {
            return n;
        }
        n = this.validateLoginDialog();
        if (n > 0) {
            return n;
        }
        n = this.validateEditUser();
        if (n > 0) {
            return n;
        }
        n = this.validateEditPoint();
        if (n > 0) {
            return n;
        }
        n = this.validateEditFile();
        if (n > 0) {
            return n;
        }
        n = this.validateOpenDialog();
        if (n > 0) {
            return n;
        }
        n = this.validateYesNoDialogBox();
        if (n > 0) {
            if (this.isLine0ViewEditConnectLogout()) {
                try {
                    if (this.getBoxTitleText(1, 0, 79).startsWith("Person - ")) {
                        if (n == 18) {
                            return 108;
                        }
                        return 109;
                    }
                }
                catch (Exception exception) {}
                return n;
            }
            if (n == 18) {
                return 75;
            }
            return 76;
        }
        n = this.validateOKDialogBox();
        if (n > 0) {
            if (this.isLine0ViewEditConnectLogout()) {
                return n;
            }
            n2 = this.validateSearch();
            if (n2 != 0) {
                return n2;
            }
            return 77;
        }
        n = this.validateEditPerson();
        if (n > 0) {
            return n;
        }
        n = this.validateSearch();
        if (n > 0) {
            return n;
        }
        n = this.validateEditController();
        if (n > 0) {
            return n;
        }
        n = this.validateControllerOptions();
        if (n > 0) {
            return n;
        }
        n = this.validateSaveOrReloadInfinet();
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public void setContentLine(int n, String string) {
        this.screenBuffer.setContentLine(n, string);
    }

    public void setFormatLine(int n, String string) {
        this.screenBuffer.setFormatLine(n, string);
    }

    public void setPosition(CursorPosition cursorPosition) {
        this.screenBuffer.setPos(cursorPosition);
    }

    public String screenBufferToString() {
        return this.screenBuffer.toString();
    }

    private final boolean checkForSpaces(int n, int n2) {
        while (n2 < 79) {
            if (this.screenBuffer.stringBuffers[n].charAt(n2) != ' ') {
                System.out.println("col" + n2 + ":expecting space, but instead found " + this.screenBuffer.stringBuffers[n].charAt(n2));
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean integrityCheck() {
        if (this.getMode() == 4) {
            int n = 2;
            while (n < 21) {
                if (this.screenBuffer.stringBuffers[n].charAt(0) != '|') {
                    return false;
                }
                if (this.screenBuffer.stringBuffers[n].charAt(79) != '|') {
                    return false;
                }
                if (n == this.getCursorLine() && !this.checkForSpaces(n, this.getCursorCol())) {
                    return false;
                }
                if (n > this.getCursorLine() && !this.checkForSpaces(n, 1)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public ScreenBuffer screenBuffer() {
        return this.screenBuffer;
    }

    public String parseInfinetControllerNameFromLine1() {
        if (this.getMode() != 4) {
            return null;
        }
        String string = this.getFullLine(1);
        String string2 = this.getFormatLine(1);
        int n = string2.indexOf("B");
        int n2 = string2.lastIndexOf("B");
        if (n == -1) {
            return null;
        }
        String string3 = string.substring(n, n2 + 1);
        if (string3.indexOf("Command Window") == -1) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3.substring(17).trim());
        if (stringTokenizer.countTokens() == 1) {
            return "";
        }
        if (stringTokenizer.countTokens() == 2) {
            stringTokenizer.nextToken();
            return stringTokenizer.nextToken();
        }
        return null;
    }

    public String parseNetworkControllerNameFromLine1() {
        if (this.getMode() != 4) {
            return null;
        }
        String string = this.getFullLine(1);
        String string2 = this.getFormatLine(1);
        int n = string2.indexOf("B");
        int n2 = string2.lastIndexOf("B");
        if (n == -1) {
            return null;
        }
        String string3 = string.substring(n, n2 + 1);
        if (string3.indexOf("Command Window") == -1) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3.substring(17).trim());
        if (stringTokenizer.countTokens() > 0) {
            return stringTokenizer.nextToken();
        }
        return null;
    }

    public boolean isRootController() throws Exception {
        if (this.getMode() != 4) {
            throw new Exception("Not in command line mode");
        }
        String string = this.getFormatLine(1);
        int n = string.indexOf("B");
        int n2 = string.lastIndexOf("B");
        if (n < 0 || n2 < 0) {
            throw new Exception("can't determine title area");
        }
        String string2 = this.getFullLine(1).substring(n, n2 + 1).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(17));
        return stringTokenizer.countTokens() == 1;
    }

    private final boolean isLine0ViewEditConnectLogout() {
        String string = this.getFullLine(0);
        return string.indexOf("View") == 0 && string.indexOf("Edit") != -1 && string.indexOf("Connect") != -1 && string.indexOf("Logout") != -1;
    }

    private final boolean isLine0FileEditSearchCheckTools() {
        String string = this.getFullLine(0);
        return string.indexOf("File") == 0 && string.indexOf("Edit") != -1 && string.indexOf("Search") != -1 && string.indexOf("Check") != -1 && string.indexOf("Tools") != -1;
    }

    private final boolean isLine1Command() {
        String string;
        try {
            string = this.getBoxTitleText(1, 0, 79);
        }
        catch (Exception exception) {
            return false;
        }
        return string.indexOf("Command Window - ") != -1;
    }

    private final boolean isLine2Point() throws Exception {
        String string;
        try {
            string = this.getBoxTitleText(2, 2, 79);
            if (string.indexOf("Point - ") != -1) {
                return true;
            }
            if (string.indexOf("System Variable - ") != -1) {
                return true;
            }
        }
        catch (Exception exception) {}
        string = this.getBoxTitleText(2, 0, 79);
        if (string.indexOf("Point - ") != -1) {
            return true;
        }
        return string.indexOf("System Variable - ") != -1;
    }

    private final boolean isLine2Logs() throws Exception {
        String string = this.getBoxTitleText(2, 0, 79);
        return string.indexOf("Logs - ") != -1;
    }

    private final boolean isLine2File() throws Exception {
        String string = this.getBoxTitleText(2, 0, 79);
        return string.indexOf("File - ") != -1;
    }

    private final boolean isLine2Triggers() throws Exception {
        String string = this.getBoxTitleText(2, 0, 79);
        return string.indexOf("Triggers - ") != -1;
    }

    private final boolean isLine2Messages() {
        String string = this.getFullLine(2);
        String string2 = this.getFormatLine(2);
        int n = string2.indexOf("B");
        int n2 = string2.lastIndexOf("B");
        if (n == -1) {
            return false;
        }
        String string3 = string.substring(n, n2 + 1);
        if (string3.indexOf("Messages") == -1) {
            return false;
        }
        if (string2.startsWith("l-")) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n3 = 2;
            while (n3 < n) {
                if (stringBuffer.charAt(n3) != '-') {
                    return false;
                }
                ++n3;
            }
            n3 = n2 + 1;
            while (n3 < 79) {
                if (stringBuffer.charAt(n3) != '-') {
                    return false;
                }
                ++n3;
            }
            if (!string.endsWith("-|")) {
                return false;
            }
        }
        return true;
    }

    private final boolean isLineAllGraphics(int n, int n2, int n3) throws Exception {
        String string = this.getBoxTitleText(n, n2, n3);
        return string.length() == 0;
    }

    private final MarkerPosition[] findSurroundingBox() throws Exception {
        return this.findSurroundingBox(this.getCursorLine(), this.getCursorCol());
    }

    private final MarkerPosition[] findSurroundingBox(int n, int n2) throws Exception {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        if (n == 0) {
            n = 2;
            n2 = 2;
        }
        n6 = (n5 = this.lookForLeftSide(n, n2)) == 0 ? 79 : this.lookForRightSide(n, n2);
        if (n5 == -1 || n6 == -1 || n5 >= n6) {
            throw new Exception("Box Not Found");
        }
        n3 = this.lookForTopLine(n, n5);
        n4 = this.lookForBottomLine(n, n5);
        if (n3 == -1 || n4 == -1) {
            throw new Exception("Box Not Found");
        }
        if (n3 >= n4) {
            throw new Exception("Invalid Box Coordinate");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n3], n5, 'l')) {
            throw new Exception("upper left corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n3], n6, 'k')) {
            throw new Exception("upper right corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n4], n5, 'm')) {
            throw new Exception("bottom left corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n4], n6, 'j')) {
            throw new Exception("bottom right corner invalid");
        }
        String string = this.getBoxTitleText(n3, n5, n6);
        if (string.length() == 0 && (n5 != 0 || n6 != 79)) {
            return this.findSurroundingBox(n3 - 1, n2);
        }
        MarkerPosition markerPosition = new MarkerPosition(n3, n5);
        MarkerPosition markerPosition2 = new MarkerPosition(n3, n6);
        MarkerPosition markerPosition3 = new MarkerPosition(n4, n5);
        MarkerPosition markerPosition4 = new MarkerPosition(n4, n6);
        return new MarkerPosition[]{markerPosition, markerPosition2, markerPosition3, markerPosition4};
    }

    private final String getBoxTitleText(int n, int n2, int n3) throws Exception {
        if (n < 0 || n > 23) {
            throw new Exception("line number out of range");
        }
        if (BVt100.firstIndexOf(this.screenBuffer.formatBuffers[n], n2, 'l') == n2 && BVt100.firstIndexOf(this.screenBuffer.formatBuffers[n], n2, 'k') == n3) {
            int n4 = BVt100.firstIndexOf(this.screenBuffer.formatBuffers[n], n2 + 1, 'B');
            if (n4 == -1 || n4 > n3) {
                return "";
            }
            int n5 = n4;
            while (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n], n5, 'B') && n5 < 80) {
                ++n5;
            }
            return this.screenBuffer.stringBuffers[n].substring(n4, n5);
        }
        throw new Exception("not a box header line");
    }

    private static final int firstIndexOf(StringBuffer stringBuffer, int n, char c) {
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == c) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private final String getButtonName() throws Exception {
        int n = this.getCursorLine();
        int n2 = this.getCursorCol();
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        if (n == 0) {
            n = 2;
            n2 = 2;
        }
        n6 = (n5 = this.lookForLeftSide(n, n2)) == 0 ? 79 : this.lookForRightSide(n, n2);
        if (n5 == -1 || n6 == -1 || n5 >= n6) {
            throw new Exception("Left/Right of button box Not Found");
        }
        n3 = this.lookForTopLine(n, n5);
        n4 = this.lookForBottomLine(n, n5);
        if (n3 == -1 || n4 == -1) {
            throw new Exception("Top/Bottom of button box Not Found");
        }
        if (n3 >= n4) {
            throw new Exception("Invalid Box Coordinate");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n3], n5, 'l')) {
            throw new Exception("upper left corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n3], n6, 'k')) {
            throw new Exception("upper right corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n4], n5, 'm')) {
            throw new Exception("bottom left corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n4], n6, 'j')) {
            throw new Exception("bottom right corner invalid");
        }
        String string = this.getBoxTitleText(n3, n5, n6);
        if (string.length() != 0) {
            throw new Exception("button has a title");
        }
        String string2 = this.getFullLine(n);
        string2 = string2.substring(n5 + 1, n6).trim();
        return string2;
    }

    private final int lookForLeftSide(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = n2;
        while (n3 > -1) {
            if (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n], n3, '|')) {
                int n4 = n;
                while (n4 > 0) {
                    if (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n4], n3, 'l')) {
                        int n5 = n3;
                        int n6 = n3;
                        while (n6 < 80) {
                            n5 = n6;
                            if (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n4], n6, 'k')) break;
                            ++n6;
                        }
                        if (n5 >= n2) {
                            return n3;
                        }
                    }
                    --n4;
                }
            }
            --n3;
        }
        return -1;
    }

    private final int lookForRightSide(int n, int n2) {
        if (n == -1 || n2 == -1 || n2 > 79) {
            return -1;
        }
        int n3 = n2;
        while (n3 < 80) {
            if (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n], n3, '|')) {
                int n4 = n;
                while (n4 > 0) {
                    if (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n4], n3, 'k')) {
                        return n3;
                    }
                    --n4;
                }
            }
            ++n3;
        }
        return -1;
    }

    private final int lookForTopLine(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = n;
        while (n3 > 0) {
            if (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n3], n2, 'l')) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    private final int lookForBottomLine(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = n;
        while (n3 < 24) {
            if (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[n3], n2, 'm')) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private final int getNextNonBlankLine(int n) {
        if (n > this.screenBuffer.stringBuffers.length - 1) {
            return -1;
        }
        int n2 = n + 1;
        while (n2 < this.screenBuffer.stringBuffers.length) {
            if (this.getFullLine(n2).substring(1, 79).trim().length() > 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private final int validateViewEditConnectLogout() {
        if (this.isLine0ViewEditConnectLogout()) {
            int n = this.getCursorPosition().getLine();
            if (n == 0) {
                return 2;
            }
            String string = this.getFormatLine(0);
            int n2 = string.indexOf(78);
            if (n2 == -1) {
                return 0;
            }
            int n3 = n2;
            while (string.charAt(n3) == 'N' && n3 < 80) {
                ++n3;
            }
            String string2 = this.getFullLine(0).substring(n2, n3);
            if (string2.equals("View")) {
                return 12;
            }
            if (string2.equals("Edit")) {
                return 13;
            }
        }
        return 0;
    }

    private final int validateFileEditSearchCheckTools() {
        if (this.isLine0FileEditSearchCheckTools()) {
            int n = this.getCursorPosition().getLine();
            if (n == 0) {
                return 3;
            }
            String string = this.getFormatLine(0);
            int n2 = string.indexOf(78);
            if (n2 == -1) {
                return 0;
            }
            int n3 = n2;
            while (n3 < 80 && string.charAt(n3) == 'N') {
                ++n3;
            }
            String string2 = this.getFullLine(0).substring(n2, n3);
            if (string2.equals("File")) {
                return 62;
            }
            if (string2.equals("Edit")) {
                return 63;
            }
            if (string2.equals("Search")) {
                return 64;
            }
            if (string2.equals("Tools")) {
                return 65;
            }
        }
        return 0;
    }

    private final int validateCursorIsInCommandLineArea() {
        try {
            if (!this.isLine1Command()) {
                return 0;
            }
            MarkerPosition[] markerPositionArray = this.findSurroundingBox();
            if (this.isLine0ViewEditConnectLogout() && markerPositionArray[0].line == 1 && markerPositionArray[0].column == 0 && markerPositionArray[1].line == 1 && markerPositionArray[1].column == 79 && markerPositionArray[2].line == 21 && markerPositionArray[2].column == 0 && markerPositionArray[3].line == 21 && markerPositionArray[3].column == 79) {
                return 4;
            }
            if (markerPositionArray[0].line == 1 && markerPositionArray[0].column == 0 && markerPositionArray[1].line == 1 && markerPositionArray[1].column == 79 && markerPositionArray[2].line == 8 && markerPositionArray[2].column == 0 && markerPositionArray[3].line == 8 && markerPositionArray[3].column == 79) {
                return 73;
            }
            if (markerPositionArray[0].line == 9 && markerPositionArray[0].column == 0 && markerPositionArray[1].line == 9 && markerPositionArray[1].column == 79 && markerPositionArray[2].line == 21 && markerPositionArray[2].column == 0 && markerPositionArray[3].line == 21 && markerPositionArray[3].column == 79) {
                return 74;
            }
        }
        catch (Exception exception) {
            return 0;
        }
        return 0;
    }

    private final int validateOpenDialog() {
        String string;
        try {
            MarkerPosition[] markerPositionArray = this.findSurroundingBox();
            string = this.getBoxTitleText(markerPositionArray[0].line, markerPositionArray[0].column, markerPositionArray[1].column);
        }
        catch (Exception exception) {
            return 0;
        }
        if (string.indexOf("Open a User") != -1) {
            try {
                if (this.getBoxTitleText(2, 0, 79).startsWith("User - ")) {
                    if (this.isLine0ViewEditConnectLogout()) {
                        return 40;
                    }
                    return 0;
                }
            }
            catch (Exception exception) {}
            return 38;
        }
        if (string.indexOf("Open a Point") != -1) {
            if (this.isLine0ViewEditConnectLogout()) {
                try {
                    if (this.getBoxTitleText(2, 2, 79).startsWith("Point - ")) {
                        return 49;
                    }
                }
                catch (Exception exception) {}
                return 48;
            }
            try {
                if (this.getBoxTitleText(2, 2, 79).startsWith("Point - ")) {
                    return 85;
                }
            }
            catch (Exception exception) {}
            return 67;
        }
        if (string.indexOf("Open a System Variable") != -1) {
            if (this.isLine0ViewEditConnectLogout()) {
                return 58;
            }
            return 69;
        }
        if (string.indexOf("Open a File") != -1) {
            try {
                if (this.getBoxTitleText(2, 0, 79).startsWith("File - ")) {
                    return 60;
                }
            }
            catch (Exception exception) {}
            if (this.isLine0ViewEditConnectLogout()) {
                return 59;
            }
            return 91;
        }
        if (string.indexOf("Open a Commport") != -1) {
            return 92;
        }
        if (string.indexOf("Open a Controller") != -1) {
            return 93;
        }
        if (string.indexOf("Open an Infinet Controller") != -1) {
            return 94;
        }
        if (string.equals("Controller")) {
            return 93;
        }
        if (string.indexOf("System Time") != -1) {
            try {
                if (this.getButtonName().equals("OK")) {
                    return 96;
                }
                if (this.getButtonName().equals("CANCEL")) {
                    return 97;
                }
            }
            catch (Exception exception) {
                return 95;
            }
        }
        if (string.indexOf("ERROR : Invalid Time Value") != -1) {
            try {
                if (this.getButtonName().equals("OK")) {
                    return 134;
                }
                if (this.getButtonName().equals("CANCEL")) {
                    return 135;
                }
            }
            catch (Exception exception) {
                return 95;
            }
        }
        if (string.indexOf("Open a Person") != -1) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Person - ")) {
                    return 104;
                }
            }
            catch (Exception exception) {}
            return 98;
        }
        if (string.indexOf("Open an Area") != -1) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Area - ")) {
                    return 105;
                }
            }
            catch (Exception exception) {}
            return 99;
        }
        if (string.indexOf("Open a Door") != -1) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Door - ")) {
                    return 106;
                }
            }
            catch (Exception exception) {}
            return 100;
        }
        return 0;
    }

    private final int validateControllerOptions() {
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        try {
            if (!this.isLineAllGraphics(1, 3, 79)) {
                return 0;
            }
        }
        catch (Exception exception) {
            return 0;
        }
        String string = this.getFullLine(2).substring(4, 79).trim();
        if (string.startsWith("Controller Options")) {
            return 128;
        }
        return 0;
    }

    private final int validateEditUser() {
        String string;
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        if (!this.isLine1Command()) {
            return 0;
        }
        try {
            MarkerPosition[] markerPositionArray = this.findSurroundingBox();
            string = this.getBoxTitleText(markerPositionArray[0].line, markerPositionArray[0].column, markerPositionArray[1].column);
        }
        catch (Exception exception) {
            return 0;
        }
        if (string.indexOf("User - ") != -1) {
            return 39;
        }
        if (string.indexOf("Security Level") != -1) {
            return 39;
        }
        if (string.indexOf("Delete a User") != -1) {
            try {
                String string2 = this.getButtonName();
                if (string2.indexOf("OK") != -1) {
                    return 42;
                }
                if (string2.indexOf("CANCEL") != -1) {
                    return 43;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return 41;
        }
        if (string.indexOf("Teach") != -1) {
            try {
                String string3 = this.getButtonName();
                if (string3.indexOf("OK") != -1) {
                    return 45;
                }
                if (string3.indexOf("CANCEL") != -1) {
                    return 46;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return 44;
        }
        return 0;
    }

    private final int validateEditController() {
        String string;
        MarkerPosition[] markerPositionArray;
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        if (!this.isLine1Command()) {
            return 0;
        }
        try {
            markerPositionArray = this.findSurroundingBox();
            string = this.getBoxTitleText(markerPositionArray[0].line, markerPositionArray[0].column, markerPositionArray[1].column);
        }
        catch (Exception exception) {
            return 0;
        }
        if (string.indexOf("Controller - ") != -1) {
            return 129;
        }
        if (string.indexOf("Commport - ") != -1 || string.indexOf("DefaultMode") != -1 || string.indexOf("Baud") != -1 || string.indexOf("FlowControl") != -1) {
            return 133;
        }
        if (string.indexOf("Details") != -1) {
            try {
                string = this.getBoxTitleText(markerPositionArray[0].line - 1, markerPositionArray[0].column, markerPositionArray[1].column);
                if (string.indexOf("Controller - ") != -1) {
                    return 130;
                }
            }
            catch (Exception exception) {}
        }
        if (string.indexOf("TCP/IP") != -1) {
            try {
                string = this.getBoxTitleText(2, 0, 79);
                if (string.indexOf("Controller - ") != -1) {
                    return 131;
                }
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private final int validateEditPerson() {
        String string;
        MarkerPosition[] markerPositionArray;
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        try {
            markerPositionArray = this.findSurroundingBox();
            string = this.getBoxTitleText(markerPositionArray[0].line, markerPositionArray[0].column, markerPositionArray[1].column);
        }
        catch (Exception exception) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Person - ")) {
                    return 107;
                }
            }
            catch (Exception exception2) {}
            return 0;
        }
        if (string.startsWith("State")) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Person - ")) {
                    return 101;
                }
                if (this.getBoxTitleText(1, 0, 79).startsWith("Area - ")) {
                    return 102;
                }
                if (this.getBoxTitleText(1, 0, 79).startsWith("Door - ")) {
                    return 103;
                }
            }
            catch (Exception exception) {
                return 0;
            }
        }
        if (string.startsWith("Person - ")) {
            return 101;
        }
        if (string.startsWith("Area - ")) {
            return 102;
        }
        if (string.startsWith("AntiPassback Action")) {
            return 102;
        }
        if (string.startsWith("Door - ")) {
            return 103;
        }
        if (string.startsWith("Access Validation")) {
            if (this.getFullLine(3).indexOf("Exit Reader") != -1) {
                return 116;
            }
            return 113;
        }
        if (string.startsWith("Reader Options")) {
            if (this.getFullLine(3).indexOf("Exit Reader") != -1) {
                return 117;
            }
            return 114;
        }
        if (string.startsWith("Card Format")) {
            return 120;
        }
        if (string.length() == 0) {
            try {
                string = this.getBoxTitleText(markerPositionArray[0].line - 1, markerPositionArray[0].column, markerPositionArray[1].column);
                if (string.startsWith("Person - ")) {
                    String string2 = this.getFullLine(3);
                    if (string2.indexOf("Details 1") != -1) {
                        return 110;
                    }
                    if (string2.indexOf("Details 2") != -1) {
                        return 111;
                    }
                    if (string2.indexOf("Details 3") != -1) {
                        return 112;
                    }
                    return 107;
                }
                if (string.startsWith("Door - ")) {
                    StringTokenizer stringTokenizer;
                    String string3 = this.getFullLine(3);
                    if (string3.indexOf("Entry Reader Details1") != -1) {
                        return 114;
                    }
                    if (string3.indexOf("Entry Reader Details2") != -1) {
                        return 115;
                    }
                    if (string3.indexOf("Entry Reader") != -1) {
                        return 113;
                    }
                    if (string3.indexOf("Exit Reader Details1") != -1) {
                        return 117;
                    }
                    if (string3.indexOf("Exit Reader Details2") != -1) {
                        return 118;
                    }
                    if (string3.indexOf("Exit Reader") != -1) {
                        return 116;
                    }
                    if (string3.indexOf("Details1") != -1) {
                        return 119;
                    }
                    if (string3.indexOf("Details2") != -1) {
                        return 120;
                    }
                    if (string3.indexOf("Details3") != -1) {
                        return 121;
                    }
                    if (string3.indexOf("Details 3") != -1) {
                        return 121;
                    }
                    if (string3.substring(1, 79).trim().length() == 0 && (stringTokenizer = new StringTokenizer(this.getFullLine(5).substring(1, 79))).nextToken().equals("Port")) {
                        return 122;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private final int validateEditPoint() {
        Object object;
        boolean bl;
        block44: {
            bl = false;
            if (this.isLine0FileEditSearchCheckTools()) {
                bl = true;
            } else {
                if (!this.isLine1Command()) {
                    return 0;
                }
                bl = false;
            }
            try {
                if (this.isLineAllGraphics(2, 0, 79)) {
                    MarkerPosition[] markerPositionArray = this.findSurroundingBox();
                    if (markerPositionArray[0].line == 2 && markerPositionArray[0].column == 0 && ((StringTokenizer)(object = new StringTokenizer(this.getFullLine(5).substring(1, 79)))).nextToken().equals("Port")) {
                        if (bl) {
                            return 79;
                        }
                        return 51;
                    }
                }
            }
            catch (Exception exception) {}
            try {
                if (this.isLine2Logs()) {
                    if (bl) {
                        return 80;
                    }
                    return 55;
                }
            }
            catch (Exception exception) {}
            if (!this.isLine2Triggers()) break block44;
            try {
                try {
                    if (this.getButtonName().equals("OK")) {
                        if (bl) {
                            return 81;
                        }
                        return 57;
                    }
                }
                catch (Exception exception) {}
                if (bl) {
                    return 82;
                }
                return 56;
            }
            catch (Exception exception) {}
        }
        boolean bl2 = false;
        try {
            bl2 = this.isLine2Point();
        }
        catch (Exception exception) {}
        if (bl2) {
            String string;
            String string2;
            try {
                if (this.isLineAllGraphics(3, 0, 79)) {
                    int n = this.getNextNonBlankLine(3);
                    StringTokenizer stringTokenizer = new StringTokenizer(this.getFullLine(n).substring(1, 79));
                    if (stringTokenizer.nextToken().equals("Description")) {
                        int n2 = this.validateYesNoDialogBox();
                        if (n2 == 18) {
                            if (bl) {
                                return 83;
                            }
                            return 52;
                        }
                        if (n2 == 19) {
                            if (bl) {
                                return 84;
                            }
                            return 53;
                        }
                    }
                    if (bl) {
                        return 78;
                    }
                    return 50;
                }
            }
            catch (Exception exception) {}
            try {
                object = this.findSurroundingBox();
                string2 = this.getBoxTitleText(object[0].line, object[0].column, ((MarkerPosition)object[1]).column);
            }
            catch (Exception exception) {
                return 0;
            }
            if (string2.startsWith("Point - ") || string2.startsWith("System Variable - ")) {
                if (bl) {
                    return 68;
                }
                return 47;
            }
            if (string2.indexOf("Type") != -1 || string2.indexOf("State") != -1 || string2.indexOf("Electrical Type") != -1) {
                if (bl) {
                    return 68;
                }
                return 47;
            }
            if (string2.indexOf("Open a Point") != -1) {
                if (bl) {
                    return 85;
                }
                return 49;
            }
            try {
                string = this.getButtonName();
            }
            catch (Exception exception) {
                return 0;
            }
            if (string.equals("OK")) {
                if (bl) {
                    return 86;
                }
                return 54;
            }
        }
        return 0;
    }

    private final int validateSearch() {
        String string;
        String string2 = "";
        if (!this.isLine0FileEditSearchCheckTools()) {
            return 0;
        }
        try {
            MarkerPosition[] markerPositionArray = this.findSurroundingBox();
            string2 = this.getBoxTitleText(markerPositionArray[0].line, markerPositionArray[0].column, markerPositionArray[1].column);
        }
        catch (Exception exception) {
            return 0;
        }
        if (string2.startsWith("Search :")) {
            try {
                string = this.getButtonName();
                if (string.equals("OK")) {
                    return 124;
                }
                if (string.equals("CANCEL")) {
                    return 125;
                }
            }
            catch (Exception exception) {
                return 123;
            }
        }
        if (string2.startsWith("COPY ERROR") || string2.startsWith("CLEAR ERROR") || string2.startsWith("CUT ERROR")) {
            try {
                string = this.getButtonName();
                if (string.equals("OK")) {
                    return 126;
                }
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    private final int validateEditFile() {
        if (this.isLine0ViewEditConnectLogout()) {
            try {
                if (this.isLine1Command() && this.isLine2File()) {
                    return 61;
                }
            }
            catch (Exception exception) {}
            return 0;
        }
        if (this.isLine0FileEditSearchCheckTools()) {
            MarkerPosition[] markerPositionArray;
            try {
                markerPositionArray = this.findSurroundingBox();
            }
            catch (Exception exception) {
                return 0;
            }
            if (markerPositionArray[0].line == 1 && markerPositionArray[0].column == 0 && markerPositionArray[1].line == 1 && markerPositionArray[1].column == 79 && markerPositionArray[2].line == 21 && markerPositionArray[2].column == 0 && markerPositionArray[3].line == 21 && markerPositionArray[3].column == 79) {
                if (this.getFullLine(22).startsWith("SPACE =")) {
                    return 127;
                }
                return 66;
            }
        }
        return 0;
    }

    private final int validateBuildingListPleaseWait() {
        if (this.getFullLine(22).substring(1).trim().startsWith("Building list - please wait")) {
            return 139;
        }
        return 0;
    }

    private final int validateSelectionBox() {
        if (this.getFullLine(22).trim().startsWith("Cursor keys scroll")) {
            return 132;
        }
        return 0;
    }

    private final int validateOpenAConnectionDialog() {
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        if (!this.isLine1Command()) {
            return 0;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 2;
        while (n5 < 21) {
            String string = this.getFormatLine(n5);
            String string2 = this.getFullLine(n5);
            if (string2.indexOf("Open a Connection") != -1 && (n = string.indexOf(108, 10)) != -1 && (n2 = string.indexOf(107, n)) != -1) {
                n3 = n5;
            }
            if (n3 > 0 && string.indexOf(109, n) == n && string.indexOf(106, n) == n2) {
                n4 = n5;
            }
            ++n5;
        }
        if (n4 == -1 || n3 == -1 || n == -1 || n2 == -1) {
            return 0;
        }
        if (this.getCursorLine() > n3 && this.getCursorLine() < n4 && this.getCursorCol() > n && this.getCursorCol() < n2) {
            return 14;
        }
        return 0;
    }

    private final int validateViewMessages() {
        boolean bl;
        if (!this.isLine2Messages()) {
            return 0;
        }
        try {
            bl = this.isLineAllGraphics(3, 1, 78);
        }
        catch (Exception exception) {
            return 0;
        }
        if (!bl) {
            return 0;
        }
        String string = this.getFormatLine(18);
        int n = string.indexOf(108);
        if (n == -1) {
            return 0;
        }
        int n2 = string.indexOf(107, n + 1);
        if (n2 == -1) {
            return 0;
        }
        int n3 = string.indexOf(108, n2 + 1);
        if (n3 == -1) {
            return 0;
        }
        int n4 = string.indexOf(107, n3 + 1);
        if (n4 == -1) {
            return 0;
        }
        String string2 = this.getFullLine(19);
        if (string2.substring(n + 1, n2).indexOf("CLEAR") == -1) {
            return 0;
        }
        if (string2.substring(n3 + 1, n4).indexOf("EXIT") == -1) {
            return 0;
        }
        int n5 = this.getCursorLine();
        int n6 = this.getCursorCol();
        if (n5 > 3 && n5 < 17) {
            if (n6 > 1 && n6 < 78) {
                if (this.isLine0ViewEditConnectLogout()) {
                    return 21;
                }
                return 70;
            }
        } else if (n5 == 19) {
            if (n6 > n && n6 < n2) {
                if (this.isLine0ViewEditConnectLogout()) {
                    return 22;
                }
                return 71;
            }
            if (n6 > n3 && n6 < n4) {
                if (this.isLine0ViewEditConnectLogout()) {
                    return 23;
                }
                return 72;
            }
        }
        return 0;
    }

    private final int validateViewSummaryNoneDefinedDialog() {
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        if (!this.isLine1Command()) {
            return 0;
        }
        String string = "";
        try {
            MarkerPosition[] markerPositionArray = this.findSurroundingBox();
            string = this.getBoxTitleText(markerPositionArray[0].line, markerPositionArray[0].column, markerPositionArray[1].column);
            if (string.indexOf("View Summary") != -1 && this.getButtonName().equals("OK")) {
                return 17;
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    private final int validateLogoutWarningDialog() {
        int n = 0;
        if (!this.isLine0ViewEditConnectLogout()) {
            return n;
        }
        if (!this.isLine1Command()) {
            return n;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = 8;
        while (n8 < 16) {
            String string = this.getFormatLine(n8);
            if (n8 == 8) {
                n2 = string.indexOf(108, 1);
                if (n2 == -1) {
                    return 0;
                }
                n3 = string.indexOf(107, n2 + 1);
                if (n3 == -1) {
                    return 0;
                }
                if (this.getFullLine(n8).substring(n2 + 1, n3).indexOf("Logout WARNING") == -1) {
                    return 0;
                }
            }
            if (n8 > 8 && n8 < 15) {
                if (string.charAt(n2) != '|') {
                    return 0;
                }
                if (string.charAt(n3) != '|') {
                    return 0;
                }
                if (string.indexOf(108, n2 + 1) != -1) {
                    n4 = string.indexOf(108, n2 + 1);
                    n5 = string.indexOf(107, n4 + 1);
                    n6 = string.indexOf(108, n5 + 1);
                    n7 = string.indexOf(107, n6 + 1);
                }
            }
            if (n8 == 15) {
                if (string.charAt(n2) != 'm') {
                    return 0;
                }
                if (string.charAt(n3) != 'j') {
                    return 0;
                }
            }
            if (n8 == this.getCursorLine()) {
                if (n4 == -1 || n5 == -1 || n6 == -1 || n7 == -1) {
                    return 0;
                }
                if (this.getFullLine(n8).substring(n4, n5).indexOf("YES") == -1) {
                    return 0;
                }
                if (this.getFullLine(n8).substring(n6, n7).indexOf("NO") == -1) {
                    return 0;
                }
                if (this.getCursorCol() > n4 && this.getCursorCol() < n5) {
                    n = 15;
                } else if (this.getCursorCol() > n6 && this.getCursorCol() < n7) {
                    n = 16;
                }
            }
            ++n8;
        }
        return n;
    }

    private final int validateYesNoDialogBox() {
        String string;
        try {
            string = this.getButtonName();
        }
        catch (Exception exception) {
            return 0;
        }
        if (string.equalsIgnoreCase("YES")) {
            return 18;
        }
        if (string.equalsIgnoreCase("NO")) {
            return 19;
        }
        return 0;
    }

    private final int validateOKDialogBox() {
        MarkerPosition[] markerPositionArray;
        try {
            markerPositionArray = this.findSurroundingBox();
        }
        catch (Exception exception) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = 8;
        while (n4 < 16) {
            String string = this.getFormatLine(n4);
            if (n4 > markerPositionArray[0].line && n4 < markerPositionArray[2].line) {
                if (string.charAt(markerPositionArray[0].column) != '|') {
                    return 0;
                }
                if (string.charAt(markerPositionArray[1].column) != '|') {
                    return 0;
                }
                if (string.indexOf(108, markerPositionArray[0].column + 1) != -1 && string.indexOf(108, (n3 = string.indexOf(107, (n2 = string.indexOf(108, markerPositionArray[0].column + 1)) + 1)) + 1) != -1) {
                    return 0;
                }
            }
            if (n4 == this.getCursorLine()) {
                if (n2 == -1 || n3 == -1) {
                    return 0;
                }
                if (this.getFullLine(n4).substring(n2, n3).indexOf("OK") == -1) {
                    return 0;
                }
                if (this.getCursorCol() > n2 && this.getCursorCol() < n3) {
                    n = 20;
                }
            }
            ++n4;
        }
        return n;
    }

    private final int validateView(int n) {
        Object object;
        String string;
        int n2 = 0;
        try {
            string = this.getBoxTitleText(1, 0, 79);
        }
        catch (Exception exception) {
            return 0;
        }
        String string2 = this.getFullLine(2);
        string2 = string2.substring(1, string2.length() - 2).trim();
        if (string2.length() != 0) {
            return n2;
        }
        try {
            object = this.findSurroundingBox();
            if (object[0].line != 1 || object[0].column != 0 || object[1].line != 1 || object[1].column != 79 || object[2].line != 21 || object[2].column != 0 || object[3].line != 21 || object[3].column != 79) {
                return 0;
            }
        }
        catch (Exception exception) {
            return 0;
        }
        object = this.getFormatLine(4);
        int n3 = 1;
        while (n3 < 79) {
            if (((String)object).charAt(n3) != '-') {
                return 0;
            }
            ++n3;
        }
        String string3 = this.getFullLine(3);
        switch (n) {
            case 24: {
                if (string.indexOf("Point Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                if (string3.indexOf("Units") == -1) {
                    return 0;
                }
                if (string3.indexOf("Type") == -1) {
                    return 0;
                }
                if (string3.indexOf("C") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                if (this.isLine0ViewEditConnectLogout()) {
                    return 24;
                }
                return 87;
            }
            case 25: {
                if (string.indexOf("Input Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                if (string3.indexOf("Units") == -1) {
                    return 0;
                }
                if (string3.indexOf("C") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                return 25;
            }
            case 26: {
                if (string.indexOf("Output Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                if (string3.indexOf("Units") == -1) {
                    return 0;
                }
                if (string3.indexOf("C") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                return 26;
            }
            case 27: {
                if (string.indexOf("Numeric Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                if (string3.indexOf("Units") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                return 27;
            }
            case 28: {
                if (string.indexOf("String Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                return 28;
            }
            case 29: {
                if (string.indexOf("System Variable Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                if (this.isLine0ViewEditConnectLogout()) {
                    return 29;
                }
                return 90;
            }
            case 30: {
                if (string.indexOf("Date Time Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                return 30;
            }
            case 31: {
                if (string.indexOf("File Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Description") == -1) {
                    return 0;
                }
                if (string3.indexOf("Type") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                if (this.isLine0ViewEditConnectLogout()) {
                    return 31;
                }
                return 88;
            }
            case 32: {
                if (string.indexOf("Program Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Current Line") == -1) {
                    return 0;
                }
                if (string3.indexOf("TD") == -1) {
                    return 0;
                }
                if (string3.indexOf("TH") == -1) {
                    return 0;
                }
                if (string3.indexOf("TM") == -1) {
                    return 0;
                }
                if (string3.indexOf("TS") == -1) {
                    return 0;
                }
                if (string3.indexOf("State") == -1) {
                    return 0;
                }
                if (this.isLine0ViewEditConnectLogout()) {
                    return 32;
                }
                return 89;
            }
            case 33: {
                if (string.indexOf("Infinet Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Port") == -1) {
                    return 0;
                }
                if (string3.indexOf("Model") == -1) {
                    return 0;
                }
                if (string3.indexOf("Serial Number") == -1) {
                    return 0;
                }
                if (string3.indexOf("ID") == -1) {
                    return 0;
                }
                if (string3.indexOf("Status") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                return 33;
            }
            case 34: {
                if (string.indexOf("Controller Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Model") == -1) {
                    return 0;
                }
                if (string3.indexOf("ID") == -1) {
                    return 0;
                }
                if (string3.indexOf("Status") == -1) {
                    return 0;
                }
                return 34;
            }
            case 35: {
                if (string.indexOf("Disabled Point Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                if (string3.indexOf("Units") == -1) {
                    return 0;
                }
                if (string3.indexOf("Type") == -1) {
                    return 0;
                }
                if (string3.indexOf("C") == -1) {
                    return 0;
                }
                return 35;
            }
            case 36: {
                if (string.indexOf("Disabled System Variable Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Value") == -1) {
                    return 0;
                }
                return 36;
            }
            case 37: {
                if (string.indexOf("Disabled File Summary") == -1) {
                    return 0;
                }
                if (string3.indexOf("Name") == -1) {
                    return 0;
                }
                if (string3.indexOf("Description") == -1) {
                    return 0;
                }
                if (string3.indexOf("Type") == -1) {
                    return 0;
                }
                return 37;
            }
        }
        return 0;
    }

    private final int validateLoginDialog() {
        MarkerPosition[] markerPositionArray;
        int n = 0;
        if (!this.isLine0ViewEditConnectLogout()) {
            return n;
        }
        if (this.getFullLine(1).trim().length() != 0) {
            return n;
        }
        try {
            markerPositionArray = this.findSurroundingBox();
        }
        catch (Exception exception) {
            return 0;
        }
        String string = this.getFullLine(this.getCursorLine()).substring(markerPositionArray[0].column + 1, markerPositionArray[1].column).trim();
        if (string.startsWith("User Name")) {
            return 10;
        }
        if (string.startsWith("Password")) {
            return 11;
        }
        return 0;
    }

    private final int validateSaveOrReloadInfinet() {
        if (this.getFullLine(0).toUpperCase().indexOf("reload -o".toUpperCase()) != -1 && this.getFullLine(1).startsWith(" Enter any key within 60 seconds to start.") && this.getFullLine(2).startsWith(" [<ESC> at any point aborts]") && this.getCursorLine() < 20) {
            return 140;
        }
        if (this.getFullLine(0).toUpperCase().indexOf("save infinet".toUpperCase()) != -1 && this.getFullLine(1).startsWith(" Enter any key within 60 seconds to start.") && this.getFullLine(2).startsWith(" [<ESC> at any point aborts]")) {
            if (this.getCursorLine() == 3) {
                return 136;
            }
            return 138;
        }
        if (this.getFullLine(this.getCursorLine() - 1).startsWith(" EndOfReload")) {
            return 137;
        }
        int n = 0;
        while (n < 80) {
            if (this.getFormatLine(0).charAt(n) != 'N' && this.getFormatLine(23).charAt(n) != 'N') {
                return 0;
            }
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n2 < 23) {
            String string = this.getFullLine(n2);
            if (string.startsWith("---")) {
                this.network.getLog().error(string);
                this.network.pingFail(string);
                return 1;
            }
            if (string.charAt(0) == '|' || string.charAt(79) == '|') {
                return 0;
            }
            int n3 = 0;
            while (n3 < 80) {
                if (string.charAt(n3) != ' ') {
                    n = 1;
                }
                ++n3;
            }
            ++n2;
        }
        if (n == 0) {
            return 1;
        }
        return 138;
    }

    public String getRecovery() {
        return this.getRecovery(this.getMode());
    }

    public String getRecovery(int n) {
        switch (n) {
            case 0: {
                return "\u001a";
            }
            case 2: {
                return "\u001bOS";
            }
            case 4: {
                return "";
            }
            case 10: {
                return "\u001b6" + this.network.getNetworkDevice().getUserName() + '\t' + this.network.getNetworkDevice().getPassword() + "\r\u001bOS";
            }
            case 11: {
                return "\u001b6\u001b[A\u001b6" + this.network.getNetworkDevice().getUserName() + '\t' + this.network.getNetworkDevice().getPassword() + "\r\u001bOS";
            }
            case 19: {
                return "\u001b[D\r\u001bOS\u001bOS";
            }
            case 15: 
            case 22: {
                return "\t\r\u001bOS";
            }
            case 16: 
            case 17: 
            case 23: {
                return "\r\u001bOS";
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 48: 
            case 58: 
            case 59: 
            case 61: {
                return "\u001bOS\u001bOS";
            }
            case 40: 
            case 41: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 60: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 42: 
            case 45: {
                return "\t\r\u001bOS\u001bOS";
            }
            case 18: 
            case 20: {
                return "\r";
            }
            case 43: 
            case 46: {
                return "\r\u001bOS\u001bOS";
            }
            case 52: {
                return "\r\u001bOS\u001bOS\u001bOS";
            }
            case 53: {
                return "\u001b[D\r\u001bOS\u001bOS\u001bOS";
            }
            case 55: 
            case 56: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 57: {
                return "\r\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 3: {
                return "FQ";
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return "\u001bOSFQ";
            }
            case 74: {
                return "\u001bOS\u001bOSFQ";
            }
            case 75: {
                return "\t\r\u001bOS";
            }
            case 76: {
                return "\r\u001bOS";
            }
            case 77: {
                return "\rFQ";
            }
            case 78: 
            case 79: {
                return "\u001bOS\u001bOSFQ";
            }
            case 80: 
            case 82: {
                return "\u001bOS\u001bOS\u001bOSFQ";
            }
            case 81: {
                return "\r\u001bOS\u001bOS\u001bOSFQ";
            }
            case 83: {
                return "\r\u001bOS\u001bOSFQ";
            }
            case 84: {
                return "\u001b[D\r\u001bOS\u001bOSFQ";
            }
            case 85: {
                return "\u001bOS\u001bOS\u001bOSFQ";
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return "\u001bOSFQ";
            }
            case 86: {
                return "\r\u001bOSFQ";
            }
            case 68: {
                return "\u001bOSFQ";
            }
            case 91: {
                return "\u001bOS\u001bOSFQ";
            }
            case 92: 
            case 93: 
            case 94: {
                return "\u001bOS\u001bOS";
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return "\u001bOS\u001bOS";
            }
            case 134: {
                return "\t\r\u001bOS";
            }
            case 135: {
                return "\r\u001bOS";
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 108: {
                if (this.getFullLine(3).indexOf("Card Information") != -1) {
                    return "\r\u001bOS\u001bOS\u001bOS";
                }
                return "\r\u001bOS\u001bOS";
            }
            case 109: {
                if (this.getFullLine(3).indexOf("Card Information") != -1) {
                    return "\t\r\u001bOS\u001bOS\u001bOS";
                }
                return "\t\r\u001bOS\u001bOS";
            }
            case 110: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 111: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 112: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 113: 
            case 116: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 114: 
            case 117: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 115: 
            case 118: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 119: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 120: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 121: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 122: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 123: 
            case 124: 
            case 125: {
                return "\u001bOS\u001bOSFQ";
            }
            case 126: {
                return "\r\u001bOSFQ";
            }
            case 127: {
                return "\u001bOS\u001bOSFQ";
            }
            case 1: {
                return "window";
            }
            case 129: 
            case 133: {
                return "\u001bOS\u001bOS";
            }
            case 128: 
            case 130: 
            case 131: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 132: {
                return "\u001bOS";
            }
            case 136: 
            case 138: {
                return String.valueOf('\u001b');
            }
            case 137: {
                return "\r";
            }
            case 139: {
                return "";
            }
        }
        return "\t\u001bOS";
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    public void resetInsertMode() {
        this.insertMode = false;
    }

    public void clearScreenBuffer() {
        this.screenBuffer.clearBuffer();
    }

    public boolean isBell() {
        return this.bell;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.backupmodeNewLine = false;
        this.line = 0;
        this.oldPosition = new CursorPosition(0, 0);
        this.col = 0;
        this.readingGraphics = false;
        this.bell = false;
        this.currentTextMode = (char)78;
        this.receivedNullCharacter = false;
        this.insertMode = false;
        this.backup = new StringBuffer();
        this.insertMovesCount = 0;
        this.readyToCheckForInsertMoves = false;
    }

    public BVt100() {
        this.this();
        this.state = 0;
        this.screenBuffer = new ScreenBuffer();
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$comm$BVt100;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$comm$BVt100 = BVt100.class("[Lcom.tridium.andoverInfinity.comm.BVt100;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ScreenBuffer {
        CursorPosition pos;
        StringBuffer[] stringBuffers;
        StringBuffer[] formatBuffers;

        public void clearBuffer() {
            int n = 0;
            while (n < this.stringBuffers.length) {
                this.clearLine(n);
                ++n;
            }
            this.pos.setCol(0);
            this.pos.setLine(0);
            BVt100.this.getNetwork().refresh();
        }

        public void clearLine(int n) {
            int n2 = 0;
            while (n2 < this.stringBuffers[n].length()) {
                this.stringBuffers[n].setCharAt(n2, ' ');
                this.formatBuffers[n].setCharAt(n2, 'N');
                ++n2;
            }
        }

        public void setContentLine(int n, String string) {
            int n2 = 0;
            while (n2 < 80) {
                try {
                    this.stringBuffers[n].setCharAt(n2, string.charAt(n2));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.stringBuffers[n].setCharAt(n2, ' ');
                }
                ++n2;
            }
        }

        public void setFormatLine(int n, String string) {
            int n2 = 0;
            while (n2 < 80) {
                try {
                    this.formatBuffers[n].setCharAt(n2, string.charAt(n2));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.formatBuffers[n].setCharAt(n2, 'N');
                }
                ++n2;
            }
        }

        public void scrollBufferUp() {
            int n = 1;
            while (n < this.stringBuffers.length) {
                this.stringBuffers[n - 1] = this.stringBuffers[n];
                this.formatBuffers[n - 1] = this.formatBuffers[n];
                ++n;
            }
            this.stringBuffers[this.stringBuffers.length - 1] = new StringBuffer();
            this.formatBuffers[this.formatBuffers.length - 1] = new StringBuffer();
            n = 0;
            while (n < 80) {
                this.stringBuffers[this.stringBuffers.length - 1].append(' ');
                this.formatBuffers[this.formatBuffers.length - 1].append('N');
                ++n;
            }
        }

        public void write(char c, int n, int n2) {
            if (n < 0) {
                return;
            }
            if (n > 23) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n2 > 79) {
                return;
            }
            this.stringBuffers[n].setCharAt(n2, c);
        }

        public void writeFormat(char c, int n, int n2) {
            if (n < 0) {
                return;
            }
            if (n > 23) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n2 > 79) {
                return;
            }
            this.formatBuffers[n].setCharAt(n2, c);
        }

        public void dump() {
            System.out.println();
            System.out.println(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.stringBuffers.length) {
                stringBuffer.append(this.stringBuffers[n].toString() + ':' + n + "\r\n");
                ++n;
            }
            n = 0;
            while (n < this.formatBuffers.length) {
                stringBuffer.append(this.formatBuffers[n].toString() + ':' + n + "\r\n");
                ++n;
            }
            stringBuffer.append("Cursor:" + this.pos).append("\r\n");
            stringBuffer.append("Mode:" + Vt100Const.cursorModes[BVt100.this.getMode()]);
            return stringBuffer.toString();
        }

        public CursorPosition getPos() {
            return this.pos;
        }

        public void setPos(CursorPosition cursorPosition) {
            this.pos = cursorPosition;
        }

        public void moveCursorToStartOfNextLine() {
            this.pos.setLine(this.pos.getLine() + 1);
            this.pos.setCol(0);
        }

        private final /* synthetic */ void this() {
            this.pos = new CursorPosition(0, 0);
        }

        ScreenBuffer() {
            this.this();
            this.stringBuffers = new StringBuffer[24];
            this.formatBuffers = new StringBuffer[24];
            int n = 0;
            while (n < this.stringBuffers.length) {
                this.stringBuffers[n] = new StringBuffer();
                this.formatBuffers[n] = new StringBuffer();
                int n2 = 0;
                while (n2 < 80) {
                    this.stringBuffers[n].append(' ');
                    this.formatBuffers[n].append('N');
                    ++n2;
                }
                ++n;
            }
        }
    }
}

