/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddfSerial.comm.BDdfSerialNullReceiver;
import java.io.BufferedInputStream;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BInfinitySerialReceiver
extends BDdfSerialNullReceiver
implements Vt100Const {
    public static final Property responseTimeout = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)25), (BFacets)DdfFacets.combine((BFacets)IDdfFacetConst.MGR_INCLUDE, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.SECOND), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.MINUTE)));
    public static final Property elapsedTimeForEndOfMessage = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)3), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.makeSeconds((int)1), (String)"max", (BIDataValue)BRelTime.MINUTE));
    public static final Property elapsedTimeAfterPromptForEndOfMessage = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.make((long)100L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)5), (String)"max", (BIDataValue)BRelTime.make((long)2000L)));
    public static final Property elapsedTimeWhileInBackupModeForEndOfMessage = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)4), (String)"max", (BIDataValue)BRelTime.MINUTE));
    public static final Property elapsedTimeWhileInBuildingListForEndOfMessage = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)4), (String)"max", (BIDataValue)BRelTime.MINUTE));
    public static final Property trackBufferUtilization = BInfinitySerialReceiver.newProperty((int)0, (boolean)false, null);
    public static final Property bufferUtilization = BInfinitySerialReceiver.newProperty((int)3, (int)0, null);
    public static final Property bufferUtilizationMax = BInfinitySerialReceiver.newProperty((int)3, (int)0, null);
    public static final Type TYPE;
    private static final int FRAME_DONE = 6;
    private static final int WAITING_FOR_MORE = 7;
    private static final int TERMINAL_MODE = 8;
    private int state;
    long lastCharTime;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$comm$BInfinitySerialReceiver;

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public BRelTime getElapsedTimeForEndOfMessage() {
        return (BRelTime)this.get(elapsedTimeForEndOfMessage);
    }

    public void setElapsedTimeForEndOfMessage(BRelTime bRelTime) {
        this.set(elapsedTimeForEndOfMessage, (BValue)bRelTime, null);
    }

    public BRelTime getElapsedTimeAfterPromptForEndOfMessage() {
        return (BRelTime)this.get(elapsedTimeAfterPromptForEndOfMessage);
    }

    public void setElapsedTimeAfterPromptForEndOfMessage(BRelTime bRelTime) {
        this.set(elapsedTimeAfterPromptForEndOfMessage, (BValue)bRelTime, null);
    }

    public BRelTime getElapsedTimeWhileInBackupModeForEndOfMessage() {
        return (BRelTime)this.get(elapsedTimeWhileInBackupModeForEndOfMessage);
    }

    public void setElapsedTimeWhileInBackupModeForEndOfMessage(BRelTime bRelTime) {
        this.set(elapsedTimeWhileInBackupModeForEndOfMessage, (BValue)bRelTime, null);
    }

    public BRelTime getElapsedTimeWhileInBuildingListForEndOfMessage() {
        return (BRelTime)this.get(elapsedTimeWhileInBuildingListForEndOfMessage);
    }

    public void setElapsedTimeWhileInBuildingListForEndOfMessage(BRelTime bRelTime) {
        this.set(elapsedTimeWhileInBuildingListForEndOfMessage, (BValue)bRelTime, null);
    }

    public boolean getTrackBufferUtilization() {
        return this.getBoolean(trackBufferUtilization);
    }

    public void setTrackBufferUtilization(boolean bl) {
        this.setBoolean(trackBufferUtilization, bl, null);
    }

    public int getBufferUtilization() {
        return this.getInt(bufferUtilization);
    }

    public void setBufferUtilization(int n) {
        this.setInt(bufferUtilization, n, null);
    }

    public int getBufferUtilizationMax() {
        return this.getInt(bufferUtilizationMax);
    }

    public void setBufferUtilizationMax(int n) {
        this.setInt(bufferUtilizationMax, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void resetStatistics() {
        this.setBufferUtilization(0);
        this.setBufferUtilizationMax(0);
        super.resetStatistics();
    }

    private final void updateBufferUtilization() throws Exception {
        if (this.getTrackBufferUtilization()) {
            int n = ((BufferedInputStream)this.getSerialCommunicator().getSerialInputStream()).available();
            this.setBufferUtilization(n);
            if (n > this.getBufferUtilizationMax()) {
                this.setBufferUtilizationMax(n);
            }
        }
    }

    protected IDdfDataFrame doReceiveFrame() throws Exception {
        this.resetReceiveBuffer();
        if (this.state == 8) {
            this.updateBufferUtilization();
            this.readByteToBuffer();
            return this.getInternalBuffer();
        }
        this.state = 7;
        while (this.state != 6) {
            this.updateBufferUtilization();
            this.readByteToBuffer();
            if (this.getSerialCommunicator().getSerialInputStream().available() != 0 || this.getInternalBuffer().getFrameSize() <= 0) continue;
            if (this.getNetwork().getBackupModeActive()) {
                if (Clock.ticks() - this.lastCharTime > this.getElapsedTimeWhileInBackupModeForEndOfMessage().getMillis()) {
                    if (this.getNetwork().getLog().isTraceOn()) {
                        this.getNetwork().getLog().trace("SerialReceiver timed out while backup mode active");
                    }
                    this.state = 6;
                    continue;
                }
                if (!this.getNetwork().getScreen().isBackupmodeNewLine()) continue;
                this.state = 6;
                continue;
            }
            if (this.getNetwork().getScreen().getMode() == 139) {
                if (Clock.ticks() - this.lastCharTime <= this.getElapsedTimeWhileInBuildingListForEndOfMessage().getMillis()) continue;
                if (this.getNetwork().getLog().isTraceOn()) {
                    this.getNetwork().getLog().trace("SerialReceiver timed out on BUILDING_LIST clause");
                }
                this.state = 6;
                continue;
            }
            if (this.getNetwork().getScreen().isCursorOnPrompt()) {
                if (Clock.ticks() - this.lastCharTime <= this.getElapsedTimeAfterPromptForEndOfMessage().getMillis()) continue;
                if (this.getNetwork().getLog().isTraceOn()) {
                    this.getNetwork().getLog().trace("SerialReceiver end of message because prompt detected");
                }
                this.state = 6;
                continue;
            }
            if (Clock.ticks() - this.lastCharTime <= this.getElapsedTimeForEndOfMessage().getMillis()) continue;
            if (this.getNetwork().getLog().isTraceOn()) {
                this.getNetwork().getLog().trace("SerialReceiver end of message because of normal time out");
            }
            this.state = 6;
        }
        return this.getInternalBuffer();
    }

    protected int readByte() throws Exception {
        return this.getSerialCommunicator().getSerialInputStream().read();
    }

    protected void readByteToBuffer() throws Exception {
        int n = this.readByte();
        if (n != -1) {
            this.lastCharTime = Clock.ticks();
            this.getInternalBuffer().write(n);
            this.getNetwork().getScreen().processByte((char)(n & 0xFF));
        }
    }

    private final BInfinityNetwork getNetwork() {
        return (BInfinityNetwork)this.getSerialCommunicator().getDdfSerialNetwork();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.state = 0;
    }

    public BInfinitySerialReceiver() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$comm$BInfinitySerialReceiver;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$comm$BInfinitySerialReceiver = BInfinitySerialReceiver.class("[Lcom.tridium.andoverInfinity.comm.BInfinitySerialReceiver;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

