/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk.impl;

import com.tridium.silk.SoapEnvelope;
import com.tridium.silk.SoapFault;
import com.tridium.silk.impl.Soap12Envelope;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;

public class Soap12Fault
extends Soap12Envelope
implements SoapFault {
    public static String CODE_VERSIONMISMATCH = "VersionMismatch";
    public static String CODE_MUSTUNDERSTAND = "MustUnderstand";
    public static String CODE_SENDER = "Sender";
    public static String CODE_RECEIVER = "Receiver";

    public void addSubcode(String string) {
        XElem xElem = this.elemCode(true);
        XElem xElem2 = xElem.elem(this.getSubcodeTag());
        while (xElem2 != null) {
            xElem = xElem2;
            xElem2 = xElem.elem(this.getSubcodeTag());
        }
        xElem2 = new XElem(this.getEnvelopeNs(), this.getSubcodeTag());
        XElem xElem3 = new XElem(this.getEnvelopeNs(), this.getCodeValueTag());
        xElem3.addText(string);
        xElem.addContent((XContent)xElem2);
    }

    public void addReason(String string) {
        this.addReason(string, "en-US");
    }

    public void addReason(String string, String string2) {
        XElem xElem = new XElem(this.getEnvelopeNs(), this.getReasonTextTag());
        xElem.addAttr(this.getTextLangTag(), string2);
        xElem.addText(string);
        this.elemReason(true).addContent((XContent)xElem);
    }

    public SoapFault asFault() {
        return this;
    }

    public XElem getCode() {
        return this.elemCode(false);
    }

    public XElem getDetail(boolean bl) {
        return this.elemDetail(bl);
    }

    public SoapEnvelope getEnvelope() {
        return this;
    }

    public XElem getFault() {
        return this.elemFault(false);
    }

    public XElem getReason() {
        return this.elemReason(false);
    }

    public XElem getRole(boolean bl) {
        return this.elemRole(bl);
    }

    public boolean isMustUnderstand() {
        XElem xElem = this.elemCode(false);
        if (xElem == null) {
            return false;
        }
        XElem xElem2 = xElem.elem(this.getCodeValueTag());
        if (xElem2 == null) {
            return false;
        }
        String string = xElem2.string();
        if (string == null) {
            return false;
        }
        return string.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_MUSTUNDERSTAND);
    }

    public boolean isReceiver() {
        XElem xElem = this.elemCode(false);
        if (xElem == null) {
            return false;
        }
        XElem xElem2 = xElem.elem(this.getCodeValueTag());
        if (xElem2 == null) {
            return false;
        }
        String string = xElem2.string();
        if (string == null) {
            return false;
        }
        return string.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_RECEIVER);
    }

    public boolean isSender() {
        XElem xElem = this.elemCode(false);
        if (xElem == null) {
            return false;
        }
        XElem xElem2 = xElem.elem(this.getCodeValueTag());
        if (xElem2 == null) {
            return false;
        }
        String string = xElem2.string();
        if (string == null) {
            return false;
        }
        return string.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_SENDER);
    }

    public boolean isVersionMismatch() {
        XElem xElem = this.elemCode(false);
        if (xElem == null) {
            return false;
        }
        XElem xElem2 = xElem.elem(this.getCodeValueTag());
        if (xElem2 == null) {
            return false;
        }
        String string = xElem2.string();
        if (string == null) {
            return false;
        }
        return string.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_VERSIONMISMATCH);
    }

    protected XElem elemCode(boolean bl) {
        XElem xElem = this.elemFault(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getCodeTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.getCodeTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    protected XElem elemDetail(boolean bl) {
        XElem xElem = this.elemFault(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getDetailTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.getDetailTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    protected XElem elemReason(boolean bl) {
        XElem xElem = this.elemFault(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getReasonTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.getReasonTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    protected XElem elemRole(boolean bl) {
        XElem xElem = this.elemFault(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getRoleTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.getRoleTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    public String getCodeTag() {
        return "Code";
    }

    public String getCodeValueTag() {
        return "Value";
    }

    public String getDetailTag() {
        return "Detail";
    }

    public String getReasonTag() {
        return "Reason";
    }

    public String getReasonTextTag() {
        return "Text";
    }

    public String getRoleTag() {
        return "Role";
    }

    public String getSubcodeTag() {
        return "Subcode";
    }

    public String getTextLangTag() {
        return "xml:lang";
    }

    public Soap12Fault() {
        this.elemFault(true);
        this.elemCode(true);
        this.elemReason(true);
    }

    public Soap12Fault(String string, String string2, String string3, XContent xContent) {
        if (string == null) {
            throw new NullPointerException("Fault code can not be null.");
        }
        if (string3 == null) {
            throw new NullPointerException("Fault reason can not be null.");
        }
        XNs xNs = this.getEnvelopeNs();
        this.elemFault(true);
        XElem xElem = new XElem(xNs, this.getCodeValueTag());
        xElem.addText(xNs.prefix() + ':' + string);
        this.elemCode(true).addContent((XContent)xElem);
        if (string2 != null) {
            this.addSubcode(string2);
        }
        this.addReason(string3);
        if (xContent != null) {
            this.elemDetail(true).addContent(xContent);
        }
    }

    public Soap12Fault(XElem xElem) {
        super(xElem);
    }
}

