/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk;

import com.tridium.silk.SoapFault;
import com.tridium.silk.impl.Soap11Envelope;
import com.tridium.silk.impl.Soap12Envelope;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

public abstract class SoapEnvelope {
    public static final Version SOAP_11 = new Version("http://schemas.xmlsoap.org/soap/envelope/");
    public static final Version SOAP_12 = new Version("http://www.w3.org/2003/05/soap-envelope");
    protected XElem envelope;

    public void addEntry(XElem xElem) {
        this.elemBody(true).addContent((XContent)xElem);
    }

    public void addHeader(XElem xElem) {
        this.elemHeader(true).addContent((XContent)xElem);
    }

    public abstract SoapFault asFault();

    public abstract String getContentType();

    public XElem getBody() {
        return this.elemBody(false);
    }

    public XElem[] getEntries() {
        XElem xElem = this.elemBody(false);
        if (xElem == null) {
            return new XElem[0];
        }
        return xElem.elems();
    }

    public XElem getEntry(String string) {
        XElem xElem = this.getBody();
        if (xElem == null) {
            return null;
        }
        return xElem.elem(string);
    }

    public XNs getEnvelopeNs() {
        return this.envelope.ns();
    }

    public XElem getHeader() {
        return this.elemHeader(false);
    }

    public XElem[] getHeaders() {
        XElem xElem = this.elemHeader(false);
        if (xElem == null) {
            return new XElem[0];
        }
        return xElem.elems();
    }

    public XElem getRoot() {
        return this.envelope;
    }

    public boolean isFault() {
        XElem xElem = this.elemFault(false);
        boolean bl = false;
        if (xElem != null) {
            bl = true;
        }
        return bl;
    }

    public static SoapEnvelope make(Version version) {
        if (version == SOAP_11) {
            return new Soap11Envelope();
        }
        return new Soap12Envelope();
    }

    public abstract SoapEnvelope newEnvelope();

    public abstract SoapFault newFault(String var1, String var2, String var3, XContent var4);

    public abstract SoapFault newReceiverFault(String var1, String var2, Throwable var3);

    public abstract SoapFault newSenderFault(String var1, String var2, Throwable var3);

    public void setRoot(XElem xElem) {
        this.envelope = xElem;
    }

    public String toString() {
        String string = SoapEnvelope.toString(this.envelope);
        if (string == null) {
            return super.toString();
        }
        return string;
    }

    public static XText toXml(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return new XText(stringWriter.toString());
    }

    public void write(OutputStream outputStream) throws Exception {
        XWriter xWriter = new XWriter(outputStream);
        xWriter.prolog();
        this.envelope.write(xWriter);
        xWriter.flush();
    }

    protected XElem elemBody(boolean bl) {
        XElem xElem = this.envelope.elem(this.getBodyTag());
        if (xElem == null && bl) {
            xElem = new XElem(this.envelope.ns(), this.getBodyTag());
            this.envelope.addContent((XContent)xElem);
        }
        return xElem;
    }

    protected XElem elemFault(boolean bl) {
        XElem xElem = this.elemBody(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getFaultTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.envelope.ns(), this.getFaultTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    protected XElem elemHeader(boolean bl) {
        XElem xElem = this.envelope.elem(this.getHeaderTag());
        if (xElem == null && bl) {
            xElem = new XElem(this.envelope.ns(), this.getHeaderTag());
            this.envelope.addContent((XContent)xElem);
        }
        return xElem;
    }

    protected String getBodyTag() {
        return "Body";
    }

    protected String getEnvelopeTag() {
        return "Envelope";
    }

    protected String getFaultTag() {
        return "Fault";
    }

    protected String getHeaderTag() {
        return "Header";
    }

    static String toString(XElem xElem) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
            xElem.write(xWriter);
            xWriter.flush();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Version {
        private String uri;

        public String toString() {
            return this.uri;
        }

        private Version(String string) {
            this.uri = string;
        }
    }
}

