/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk;

import com.tridium.silk.Fault;
import com.tridium.silk.SoapContext;
import com.tridium.silk.SoapEnvelope;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import javax.baja.io.Base64;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SoapClient {
    String action;
    String authorization;
    URL url;

    public SoapEnvelope send(SoapEnvelope soapEnvelope) throws Exception, Fault {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", soapEnvelope.getContentType());
        if (this.action != null) {
            httpURLConnection.setRequestProperty("SOAPAction", this.action);
        }
        if (this.authorization != null) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + this.authorization);
        }
        OutputStream outputStream = httpURLConnection.getOutputStream();
        soapEnvelope.write(outputStream);
        outputStream.flush();
        InputStream inputStream = httpURLConnection.getInputStream();
        SoapEnvelope soapEnvelope2 = null;
        try {
            soapEnvelope2 = SoapContext.parse(inputStream);
        }
        catch (Exception exception) {
            if (httpURLConnection.getResponseCode() / 100 != 2) {
                throw new IOException(httpURLConnection.getResponseMessage());
            }
            throw exception;
        }
        try {
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {}
        if (soapEnvelope2.isFault()) {
            throw new Fault(soapEnvelope2.asFault());
        }
        return soapEnvelope2;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setAuthorization(String string, String string2) {
        if (string == null) {
            this.authorization = null;
            return;
        }
        this.authorization = string + ':' + (string2 == null ? "" : string2);
        this.authorization = Base64.encode((byte[])this.authorization.getBytes());
    }

    void debug(SoapEnvelope soapEnvelope) throws Exception, Fault {
        Socket socket = new Socket(this.url.getHost(), 80);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        soapEnvelope.write(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write("POST ".getBytes());
        outputStream.write(this.url.getFile().getBytes());
        outputStream.write(" HTTP/1.1\r\n".getBytes());
        outputStream.write("Host: ".getBytes());
        outputStream.write(this.url.getHost().getBytes());
        outputStream.write("\r\n".getBytes());
        outputStream.write(("Content-Type: " + soapEnvelope.getContentType() + "\r\n").getBytes());
        outputStream.write(("Content-Length: " + byArray.length + "\r\n").getBytes());
        if (this.action != null) {
            outputStream.write("SOAPAction: ".getBytes());
            outputStream.write(this.action.getBytes());
            outputStream.write("\r\n".getBytes());
        }
        if (this.authorization != null) {
            outputStream.write(("Authorization: Basic " + this.authorization + "\r\n").getBytes());
        }
        outputStream.write("\r\n".getBytes());
        soapEnvelope.write(outputStream);
        outputStream.flush();
        InputStream inputStream = socket.getInputStream();
        int n = inputStream.read();
        while (n >= 0) {
            System.out.print((char)n);
            n = inputStream.read();
        }
        outputStream.close();
        inputStream.close();
    }

    private final /* synthetic */ void this() {
        this.action = null;
        this.authorization = null;
    }

    public SoapClient(URL uRL) {
        this.this();
        this.url = uRL;
    }
}

