/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dust.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XWriter;

public class XmlUtils {
    public static XElem bajaToXml(String string, BValue bValue) {
        XElem xElem = new XElem(string);
        if (bValue instanceof BComponent) {
            BComponent bComponent = bValue.asComponent();
            Property[] propertyArray = bComponent.getPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                xElem.addContent((XContent)XmlUtils.bajaToXml(propertyArray[n].getName(), bComponent.get(propertyArray[n])));
                ++n;
            }
            return xElem;
        }
        xElem.addText(bValue.toString(null));
        return xElem;
    }

    public static BValue xmlToBaja(XElem xElem) {
        XElem[] xElemArray = xElem.elems();
        if (xElemArray == null || xElemArray.length == 0) {
            String string = xElem.string();
            if (string != null) {
                return BString.make((String)string);
            }
            return BString.DEFAULT;
        }
        BComponent bComponent = new BComponent();
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].name();
            string = SlotPath.escape((String)string);
            bComponent.add(string, XmlUtils.xmlToBaja(xElemArray[n]));
            ++n;
        }
        return bComponent;
    }

    public static String xmlToString(XElem xElem) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
            xElem.write(xWriter);
            xWriter.flush();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

