/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dust.point;

import com.tridium.dust.BSmartMeshClient;
import com.tridium.dust.messages.GetConfigReq;
import com.tridium.dust.messages.GetConfigRes;
import com.tridium.dust.messages.Mote;
import com.tridium.dust.messages.MoteProfile;
import com.tridium.dust.point.BDustPointDeviceExt;
import com.tridium.dust.point.BDustPointDiscoveryResult;
import com.tridium.dust.util.BDustDiscoveryJob;
import java.util.TreeMap;
import javax.baja.naming.SlotPath;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDustPointDiscoveryJob
extends BDustDiscoveryJob {
    public static final Type TYPE;
    protected BValue args;
    protected BDustPointDeviceExt ext;
    static /* synthetic */ Class class$com$tridium$dust$point$BDustPointDiscoveryJob;

    public Type getType() {
        return TYPE;
    }

    public void doDiscover(Context context) {
        boolean bl = true;
        try {
            MoteProfile moteProfile;
            BSmartMeshClient bSmartMeshClient = this.ext.getSmartMeshClient();
            GetConfigReq getConfigReq = new GetConfigReq(bSmartMeshClient.getControlToken(), "all", new String[]{"config", "Motes"});
            XElem xElem = bSmartMeshClient.send(getConfigReq.encode());
            GetConfigRes getConfigRes = new GetConfigRes(xElem);
            xElem = getConfigRes.getConfig();
            xElem = xElem.elem("Motes");
            XElem[] xElemArray = xElem.elems("Mote");
            int n = xElemArray.length;
            this.log().message("Found " + n + " motes.");
            Mote[] moteArray = new Mote[n];
            int n2 = 0;
            while (n2 < n) {
                moteArray[n2] = new Mote(xElemArray[n2]);
                ++n2;
            }
            if (this.isCanceled()) {
                this.canceled();
                return;
            }
            this.progress(25);
            getConfigReq = new GetConfigReq(bSmartMeshClient.getControlToken(), "all", new String[]{"config", "MoteProfiles"});
            xElem = bSmartMeshClient.send(getConfigReq.encode());
            getConfigRes = new GetConfigRes(xElem);
            xElem = getConfigRes.getConfig();
            xElem = xElem.elem("MoteProfiles");
            xElemArray = xElem.elems("MoteProfile");
            n = xElemArray.length;
            this.log().message("Found " + n + " mote profiles.");
            TreeMap<String, MoteProfile> treeMap = new TreeMap<String, MoteProfile>();
            int n3 = 0;
            while (n3 < n) {
                moteProfile = new MoteProfile(xElemArray[n3]);
                treeMap.put(moteProfile.getProfileName(), moteProfile);
                ++n3;
            }
            if (this.isCanceled()) {
                this.canceled();
                return;
            }
            n3 = 51;
            this.progress(n3);
            n = moteArray.length;
            Context context2 = Transaction.start((BComponent)this, (Context)context);
            int n4 = 0;
            while (n4 < n) {
                String string = "Mote-" + moteArray[n4].displayMac();
                String string2 = moteArray[n4].getProfileName();
                if (string2 == null || string2.length() == 0) {
                    this.log().message(string + " had no profile name.");
                } else {
                    moteProfile = (MoteProfile)treeMap.get(string2);
                    if (moteProfile == null) {
                        this.log().message(string + ", could not find profile: " + string2);
                    } else {
                        BDustPointDiscoveryResult bDustPointDiscoveryResult = new BDustPointDiscoveryResult(string, moteProfile);
                        BString bString = BString.make((String)moteArray[n4].getMoteId());
                        bDustPointDiscoveryResult.setMoteId(bString.getString());
                        BString bString2 = BString.make((String)moteArray[n4].getMacAddr());
                        bDustPointDiscoveryResult.setMacAddr(bString2.getString());
                        this.addResult(SlotPath.escape((String)string), (BValue)bDustPointDiscoveryResult);
                        if (this.isCanceled()) {
                            Transaction.end((BComponent)this, (Context)context2);
                            this.canceled();
                            return;
                        }
                    }
                }
                ++n4;
            }
            Transaction.end((BComponent)this, (Context)context2);
            this.progress(100);
            this.success();
        }
        catch (Throwable throwable) {
            this.failed(throwable);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BDustPointDiscoveryJob() {
    }

    public BDustPointDiscoveryJob(BDustPointDeviceExt bDustPointDeviceExt, BValue bValue) {
        super(bDustPointDeviceExt.getDustNetwork());
        this.ext = bDustPointDeviceExt;
        this.args = bValue;
    }

    static {
        Class clazz = class$com$tridium$dust$point$BDustPointDiscoveryJob;
        if (clazz == null) {
            clazz = class$com$tridium$dust$point$BDustPointDiscoveryJob = BDustPointDiscoveryJob.class("[Lcom.tridium.dust.point.BDustPointDiscoveryJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

