/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dust.messages;

import com.tridium.dust.messages.Msg;
import com.tridium.dust.util.Special;
import javax.baja.xml.XElem;

public class Notification
extends Msg {
    String macAddr;
    String moteId;
    XElem[] samples;

    public void decode(XElem xElem) {
        XElem xElem2 = Notification.childElem(xElem, "moteId");
        this.moteId = xElem2.string();
        xElem2 = Notification.childElem(xElem, "macAddr");
        this.macAddr = xElem2.string();
        Special special = Special.getMoteSpecial(this.macAddr);
        if (special != null) {
            this.samples = special.getSamples(xElem);
        } else {
            xElem2 = xElem.elem("samples");
            if (xElem2 != null) {
                this.samples = xElem2.elems();
            }
        }
    }

    public String getMacAddr() {
        return this.macAddr;
    }

    public String getMoteId() {
        return this.moteId;
    }

    public String getSampleChId(int n) {
        return this.samples[n].get("chId", null);
    }

    public int getSampleSize() {
        if (this.samples == null) {
            return 0;
        }
        return this.samples.length;
    }

    public String getSampleTime(int n) {
        return Notification.childElem(this.samples[n], "time").string();
    }

    public String getSampleValue(int n) {
        return Notification.childElem(this.samples[n], "val").string();
    }

    public Notification() {
    }

    public Notification(XElem xElem) {
        this.decode(xElem);
    }
}

