/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dust;

import com.tridium.dust.BDustNetwork;
import com.tridium.dust.alarm.BDustAlarmDeviceExt;
import com.tridium.dust.messages.GetConfigReq;
import com.tridium.dust.messages.GetConfigRes;
import com.tridium.dust.messages.LoginReq;
import com.tridium.dust.messages.LoginRes;
import com.tridium.dust.messages.LogoutReq;
import com.tridium.dust.messages.NetworkConfig;
import com.tridium.dust.messages.SetConfigReq;
import com.tridium.dust.messages.SubscribeReq;
import com.tridium.dust.messages.SubscribeRes;
import com.tridium.dust.messages.SystemConfig;
import com.tridium.dust.objects.BNetworkConfig;
import com.tridium.dust.objects.BSystemConfig;
import com.tridium.dust.point.BDustPointDeviceExt;
import com.tridium.dust.util.BDustPollScheduler;
import com.tridium.dust.util.BDustState;
import com.tridium.dust.util.Datasheet000_0002;
import com.tridium.dust.util.Datasheet100_0001;
import com.tridium.dust.util.Special;
import com.tridium.dust.util.XmlException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.baja.driver.BDevice;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSmartMeshClient
extends BDevice {
    public static final Property hostname = BSmartMeshClient.newProperty((int)8, (String)"dcc.dustnetworks.com", null);
    public static final Property username = BSmartMeshClient.newProperty((int)0, (String)"admin", null);
    public static final Property password = BSmartMeshClient.newProperty((int)0, (BValue)BPassword.make((String)"admin"), null);
    public static final Property controlDebug = BSmartMeshClient.newProperty((int)0, (boolean)false, null);
    public static final Property controlPort = BSmartMeshClient.newProperty((int)0, (int)4445, null);
    public static final Property controlToken = BSmartMeshClient.newProperty((int)3, (String)"", null);
    public static final Property notificationDebug = BSmartMeshClient.newProperty((int)0, (boolean)false, null);
    public static final Property notificationPort = BSmartMeshClient.newProperty((int)3, (int)0, null);
    public static final Property notificationToken = BSmartMeshClient.newProperty((int)3, (String)"", null);
    public static final Property networkConfig = BSmartMeshClient.newProperty((int)0, (BValue)new BNetworkConfig(), null);
    public static final Property systemConfig = BSmartMeshClient.newProperty((int)0, (BValue)new BSystemConfig(), null);
    public static final Property state = BSmartMeshClient.newProperty((int)3, (BValue)BDustState.detached, null);
    public static final Property pollScheduler = BSmartMeshClient.newProperty((int)4, (BValue)new BDustPollScheduler(), null);
    public static final Property points = BSmartMeshClient.newProperty((int)0, (BValue)new BDustPointDeviceExt(), null);
    public static final Property alarms = BSmartMeshClient.newProperty((int)0, (BValue)new BDustAlarmDeviceExt(), null);
    public static final Action attach = BSmartMeshClient.newAction((int)20, null);
    public static final Action detach = BSmartMeshClient.newAction((int)20, null);
    public static final Action reattach = BSmartMeshClient.newAction((int)16, null);
    public static final Action setSystemName = BSmartMeshClient.newAction((int)16, (BValue)BString.make((String)"systemName"), null);
    public static final Action setLocation = BSmartMeshClient.newAction((int)16, (BValue)BString.make((String)"location"), null);
    public static final Action setNetName = BSmartMeshClient.newAction((int)16, (BValue)BString.make((String)"netName"), null);
    public static final Action setMainFrameSize = BSmartMeshClient.newAction((int)16, (BValue)BInteger.make((int)200), (BFacets)BFacets.makeInt((int)10, (int)1024));
    public static final Action setMaxMotes = BSmartMeshClient.newAction((int)16, (BValue)BInteger.make((int)15), (BFacets)BFacets.makeInt((int)1, (int)500));
    public static final Type TYPE;
    private NotificationChannel channel;
    private BDustNetwork network;
    static /* synthetic */ Class class$com$tridium$dust$BSmartMeshClient;

    public String getHostname() {
        return this.getString(hostname);
    }

    public void setHostname(String string) {
        this.setString(hostname, string, null);
    }

    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String string) {
        this.setString(username, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public boolean getControlDebug() {
        return this.getBoolean(controlDebug);
    }

    public void setControlDebug(boolean bl) {
        this.setBoolean(controlDebug, bl, null);
    }

    public int getControlPort() {
        return this.getInt(controlPort);
    }

    public void setControlPort(int n) {
        this.setInt(controlPort, n, null);
    }

    public String getControlToken() {
        return this.getString(controlToken);
    }

    public void setControlToken(String string) {
        this.setString(controlToken, string, null);
    }

    public boolean getNotificationDebug() {
        return this.getBoolean(notificationDebug);
    }

    public void setNotificationDebug(boolean bl) {
        this.setBoolean(notificationDebug, bl, null);
    }

    public int getNotificationPort() {
        return this.getInt(notificationPort);
    }

    public void setNotificationPort(int n) {
        this.setInt(notificationPort, n, null);
    }

    public String getNotificationToken() {
        return this.getString(notificationToken);
    }

    public void setNotificationToken(String string) {
        this.setString(notificationToken, string, null);
    }

    public BNetworkConfig getNetworkConfig() {
        return (BNetworkConfig)this.get(networkConfig);
    }

    public void setNetworkConfig(BNetworkConfig bNetworkConfig) {
        this.set(networkConfig, (BValue)bNetworkConfig, null);
    }

    public BSystemConfig getSystemConfig() {
        return (BSystemConfig)this.get(systemConfig);
    }

    public void setSystemConfig(BSystemConfig bSystemConfig) {
        this.set(systemConfig, (BValue)bSystemConfig, null);
    }

    public BDustState getState() {
        return (BDustState)this.get(state);
    }

    public void setState(BDustState bDustState) {
        this.set(state, (BValue)bDustState, null);
    }

    public BDustPollScheduler getPollScheduler() {
        return (BDustPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BDustPollScheduler bDustPollScheduler) {
        this.set(pollScheduler, (BValue)bDustPollScheduler, null);
    }

    public BDustPointDeviceExt getPoints() {
        return (BDustPointDeviceExt)this.get(points);
    }

    public void setPoints(BDustPointDeviceExt bDustPointDeviceExt) {
        this.set(points, (BValue)bDustPointDeviceExt, null);
    }

    public BDustAlarmDeviceExt getAlarms() {
        return (BDustAlarmDeviceExt)this.get(alarms);
    }

    public void setAlarms(BDustAlarmDeviceExt bDustAlarmDeviceExt) {
        this.set(alarms, (BValue)bDustAlarmDeviceExt, null);
    }

    public void attach() {
        this.invoke(attach, null, null);
    }

    public void detach() {
        this.invoke(detach, null, null);
    }

    public void reattach() {
        this.invoke(reattach, null, null);
    }

    public void setSystemName(BString bString) {
        this.invoke(setSystemName, (BValue)bString, null);
    }

    public void setLocation(BString bString) {
        this.invoke(setLocation, (BValue)bString, null);
    }

    public void setNetName(BString bString) {
        this.invoke(setNetName, (BValue)bString, null);
    }

    public void setMainFrameSize(BInteger bInteger) {
        this.invoke(setMainFrameSize, (BValue)bInteger, null);
    }

    public void setMaxMotes(BInteger bInteger) {
        this.invoke(setMaxMotes, (BValue)bInteger, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.attach();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context != Context.decoding && this.isRunning()) {
            if (property == hostname || property == controlPort) {
                this.reattach();
            } else if (property == status) {
                if (this.isDown() || this.isDisabled() || this.isFault()) {
                    if (this.getState().isEngaged()) {
                        this.detach();
                    }
                } else if (this.getState().isDisengaged()) {
                    this.attach();
                }
            }
        }
    }

    public void doAttach() {
        if (this.getState().isEngaged() || this.isDisabled() || this.isFatalFault()) {
            return;
        }
        this.getLog().trace("Attaching");
        try {
            this.setAttaching();
            LoginReq loginReq = new LoginReq(this.getUsername(), this.getPassword().getString());
            XElem xElem = this.send(loginReq.encode());
            LoginRes loginRes = new LoginRes(xElem);
            String string = loginRes.getToken();
            if (string == null) {
                throw new XmlException("Login failed", xElem);
            }
            this.setControlToken(string);
            xElem = this.send(new SubscribeReq(string).encode());
            SubscribeRes subscribeRes = new SubscribeRes(xElem);
            this.setNotificationToken(subscribeRes.getNotificationToken());
            this.setNotificationPort(subscribeRes.getNotificationPort());
            this.setAttached();
            this.pingOk();
            this.channel = new NotificationChannel();
            this.channel.start();
            GetConfigReq getConfigReq = new GetConfigReq(this.getControlToken(), "all", new String[]{"config", "Network"});
            GetConfigRes getConfigRes = new GetConfigRes(this.send(getConfigReq.encode()));
            xElem = getConfigRes.getConfig();
            xElem = xElem.elem("Network");
            this.getNetworkConfig().update(new NetworkConfig(xElem));
            this.getLog().trace("Attached");
        }
        catch (Exception exception) {
            this.pingFail(exception.toString());
            this.getLog().error("Attach failed", (Throwable)exception);
            this.setDetached();
        }
    }

    public void doDetach() {
        if (this.getState().isDisengaged()) {
            return;
        }
        this.getLog().trace("Detaching");
        try {
            this.setDetaching();
            if (this.channel != null) {
                this.channel.interrupt();
                this.channel = null;
            }
            LogoutReq logoutReq = new LogoutReq(this.getControlToken());
            this.send(logoutReq.encode());
        }
        catch (Exception exception) {
            this.getLog().error("Detach failed", (Throwable)exception);
        }
        this.setControlToken("");
        this.setNotificationPort(0);
        this.setNotificationToken("");
        this.setDetached();
    }

    public void doPing() {
        try {
            if (this.getState().isAttached()) {
                GetConfigReq getConfigReq = new GetConfigReq(this.getControlToken(), "all", new String[]{"config", "System"});
                GetConfigRes getConfigRes = new GetConfigRes(this.send(getConfigReq.encode()));
                XElem xElem = getConfigRes.getConfig();
                xElem = xElem.elem("System");
                this.getSystemConfig().update(new SystemConfig(xElem));
                this.pingOk();
            } else if (this.getState().isDetached()) {
                this.attach();
            }
        }
        catch (Throwable throwable) {
            this.getLog().error("Ping failed", throwable);
            this.pingFail(throwable.getMessage());
        }
    }

    public void doSetSystemName(BString bString) throws Exception {
        XElem xElem = new XElem("systemName").addText(bString.getString());
        xElem = new XElem("System").addContent((XContent)xElem);
        xElem = new XElem("config").addContent((XContent)xElem);
        SetConfigReq setConfigReq = new SetConfigReq(this.getControlToken(), xElem);
        this.send(setConfigReq.encode());
        this.doPing();
    }

    public void doSetLocation(BString bString) throws Exception {
        XElem xElem = new XElem("location").addText(bString.getString());
        xElem = new XElem("System").addContent((XContent)xElem);
        xElem = new XElem("config").addContent((XContent)xElem);
        SetConfigReq setConfigReq = new SetConfigReq(this.getControlToken(), xElem);
        this.send(setConfigReq.encode());
        this.doPing();
    }

    public void doSetNetName(BString bString) throws Exception {
        XElem xElem = new XElem("netName").addText(bString.toString(null));
        xElem = new XElem("Network").addContent((XContent)xElem);
        xElem = new XElem("config").addContent((XContent)xElem);
        SetConfigReq setConfigReq = new SetConfigReq(this.getControlToken(), xElem);
        this.send(setConfigReq.encode());
        GetConfigReq getConfigReq = new GetConfigReq(this.getControlToken(), "all", new String[]{"config", "Network"});
        GetConfigRes getConfigRes = new GetConfigRes(this.send(getConfigReq.encode()));
        xElem = getConfigRes.getConfig();
        xElem = xElem.elem("Network");
        this.getNetworkConfig().update(new NetworkConfig(xElem));
    }

    public void doSetMainFrameSize(BInteger bInteger) throws Exception {
        XElem xElem = new XElem("mainFrameSize").addText(bInteger.toString(null));
        xElem = new XElem("Network").addContent((XContent)xElem);
        xElem = new XElem("config").addContent((XContent)xElem);
        SetConfigReq setConfigReq = new SetConfigReq(this.getControlToken(), xElem);
        this.send(setConfigReq.encode());
        GetConfigReq getConfigReq = new GetConfigReq(this.getControlToken(), "all", new String[]{"config", "Network"});
        GetConfigRes getConfigRes = new GetConfigRes(this.send(getConfigReq.encode()));
        xElem = getConfigRes.getConfig();
        xElem = xElem.elem("Network");
        this.getNetworkConfig().update(new NetworkConfig(xElem));
    }

    public void doSetMaxMotes(BInteger bInteger) throws Exception {
        XElem xElem = new XElem("maxMotes").addText(bInteger.toString(null));
        xElem = new XElem("Network").addContent((XContent)xElem);
        xElem = new XElem("config").addContent((XContent)xElem);
        SetConfigReq setConfigReq = new SetConfigReq(this.getControlToken(), xElem);
        this.send(setConfigReq.encode());
        GetConfigReq getConfigReq = new GetConfigReq(this.getControlToken(), "all", new String[]{"config", "Network"});
        GetConfigRes getConfigRes = new GetConfigRes(this.send(getConfigReq.encode()));
        xElem = getConfigRes.getConfig();
        xElem = xElem.elem("Network");
        this.getNetworkConfig().update(new NetworkConfig(xElem));
    }

    public void doReattach() {
        this.doDetach();
        this.doAttach();
    }

    public Type getNetworkType() {
        return BDustNetwork.TYPE;
    }

    public BDustNetwork getDustNetwork() {
        if (this.network == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BDustNetwork) {
                    this.network = (BDustNetwork)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.network;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        this.getDustNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public IFuture postPing() {
        this.getDustNetwork().enqueue((Runnable)new Invocation((BComponent)this, ping, null, null));
        return null;
    }

    public XElem send(XElem xElem) throws Exception {
        XElem xElem2 = this.send(xElem, this.getHostname(), this.getControlPort());
        XElem xElem3 = xElem2.elem("fault");
        if (xElem3 == null) {
            return xElem2;
        }
        if ((xElem3 = xElem3.elem("value")) == null) {
            throw new XmlException(xElem);
        }
        if ((xElem3 = xElem3.elem("struct")) == null) {
            throw new XmlException(xElem);
        }
        XElem[] xElemArray = xElem3.elems("member");
        if (xElemArray == null) {
            throw new XmlException(xElem);
        }
        int n = 0;
        while (n < xElemArray.length) {
            xElem3 = xElemArray[n].elem("name");
            if (xElem3 != null && xElem3.string().equalsIgnoreCase("faultString") && (xElem3 = xElemArray[n].elem("value")) != null && (xElem3 = xElem3.elem("string")) != null) {
                throw new XmlException(xElem3.string(), xElem);
            }
            ++n;
        }
        throw new XmlException(xElem);
    }

    public void started() throws Exception {
        this.network = null;
        super.started();
    }

    public void stopped() throws Exception {
        try {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            if (this.getState().isEngaged()) {
                this.detach();
            }
        }
        catch (Exception exception) {}
        super.stopped();
    }

    private final byte[] bytes(XElem xElem) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
        xWriter.prolog();
        xElem.write(xWriter);
        xWriter.close();
        return byteArrayOutputStream.toByteArray();
    }

    private final XElem send(XElem xElem, String string, int n) throws Exception {
        boolean bl = this.getControlDebug();
        if (bl) {
            System.out.println(this.toPathString() + " REQUEST: ");
            xElem.dump();
        }
        URL uRL = new URL("http://" + string + ':' + n);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "text/xml");
        XWriter xWriter = new XWriter(httpURLConnection.getOutputStream());
        xWriter.prolog();
        xElem.write(xWriter);
        xWriter.flush();
        XElem xElem2 = null;
        try {
            XParser xParser = XParser.make((InputStream)httpURLConnection.getInputStream());
            xElem2 = xParser.parse(true);
            if (bl) {
                System.out.println(this.toPathString() + " RESPONSE: ");
                xElem2.dump();
            }
        }
        catch (Exception exception) {
            if (httpURLConnection.getResponseCode() / 100 != 2) {
                exception.printStackTrace();
                throw new IOException(httpURLConnection.getResponseMessage());
            }
            throw exception;
        }
        try {
            xWriter.close();
        }
        catch (Exception exception) {}
        return xElem2;
    }

    private final void setAttached() {
        this.setState(BDustState.attached);
    }

    private final void setAttaching() {
        this.setState(BDustState.attaching);
    }

    private final void setDetached() {
        this.setState(BDustState.detached);
    }

    private final void setDetaching() {
        this.setState(BDustState.detaching);
    }

    static final /* synthetic */ byte[] access$0(BSmartMeshClient bSmartMeshClient, XElem xElem) throws Exception {
        return bSmartMeshClient.bytes(xElem);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$dust$BSmartMeshClient;
        if (clazz == null) {
            clazz = class$com$tridium$dust$BSmartMeshClient = BSmartMeshClient.class("[Lcom.tridium.dust.BSmartMeshClient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Special.setSpecial("000_0002", new Datasheet000_0002());
        Special.setSpecial("100_0001", new Datasheet100_0001());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NotificationChannel
    extends Thread {
        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 314->318)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private NotificationChannel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Event
    implements Runnable {
        XElem msg;

        public void run() {
            String string = this.msg.name();
            if (string.equals("data")) {
                BSmartMeshClient.this.getPoints().processNotification(this.msg);
            } else if (string.equals("event")) {
                BSmartMeshClient.this.getAlarms().processNotification(this.msg);
            }
        }

        public Event(XElem xElem) {
            this.msg = xElem;
        }
    }
}

