/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciCoreParser;

import com.jci.jciCoreParser.BJciGeneralLibraryParse;
import com.jci.jciCoreParser.util.FXAppPoint;
import com.jci.jciCoreParser.util.LonPointInfo;
import com.jci.jciCoreParser.util.LonStructInfo;
import com.jci.jciCoreParser.util.PtTrendInfo;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BJciGeneralParseApd
extends BJciGeneralLibraryParse {
    public static final Type TYPE;
    static Lexicon lex;
    public static final int Enum = 0;
    public static final int Numeric = 1;
    public static final int Boolean = 2;
    public static final int InitialFXBuilderFormat = 0;
    public static final int UpdatedFXBuilderFormatVer4 = 1;
    public static final String validInitialFXToolVersion1 = "3.0.0";
    public static final String validInitialFXToolVersion2 = "4.0.0";
    public static final String validInitialFXToolVersion3 = "4.0.0";
    public static final String nvrwDirection = "Input";
    public static final String nvrDirection = "Output";
    public static final String nvrwDirectionVer4 = "In";
    public static final String nvrDirectionVer4 = "Out";
    public static HashMap lonstructinfo;
    public static HashMap niagaraptinfo;
    protected Array conditionList;
    protected XElem apdRoot;
    protected XElem syslibRoot;
    protected XParser xparSysLibFile;
    protected XParser xparAPDFile;
    protected boolean useSysLibFile;
    protected Comparator verComp;
    protected boolean apdFileOk;
    protected int UnitsOfMeasure;
    protected int parseVersion;
    protected int libraryIssues;
    private int lonElementTypePlaceholder;
    protected int[] tempordinals;
    protected String[] temptags;
    static /* synthetic */ Class class$com$jci$jciCoreParser$BJciGeneralParseApd;

    public Type getType() {
        return TYPE;
    }

    public boolean verifySysLibFile() {
        block5: {
            this.useSysLibFile = false;
            if (this.sysLibFilePath.length() != 0) {
                try {
                    File file = new File(this.sysLibFilePath);
                    if (!file.exists()) break block5;
                    this.xparSysLibFile = XParser.make((File)file);
                    this.syslibRoot = this.xparSysLibFile.parse();
                    if (this.determineLibraryType(this.syslibRoot) == 0) {
                        this.useSysLibFile = true;
                        break block5;
                    }
                    this.libraryIssues = 2;
                    this.logError(lex.getText("parseAPD.badLibraryFile") + ' ' + this.sysLibFilePath);
                    this.sysLibFilePath = "";
                }
                catch (Exception exception) {
                    this.libraryIssues = 2;
                    System.out.println("lib issue in verify is " + this.libraryIssues);
                    this.logError(lex.getText("parseAPD.badLibraryFile") + ' ' + this.sysLibFilePath);
                    this.sysLibFilePath = "";
                    exception.printStackTrace();
                }
            } else {
                this.libraryIssues = 1;
                this.sysLibFilePath = "";
            }
        }
        return this.useSysLibFile;
    }

    public boolean verifyConfigFile() {
        XElem xElem = this.apdRoot.elem("Device");
        XElem xElem2 = this.apdRoot.elem("Tool");
        String string = xElem2.text().toString();
        string = this.removeText(string);
        boolean bl = false;
        if (xElem.text().toString().toLowerCase().indexOf("fx") >= 0) {
            bl = true;
        } else {
            this.logError(lex.getText("parseAPD.badDeviceType"));
            bl = false;
        }
        if (this.verComp.compare(string, validInitialFXToolVersion1) >= 0 && this.verComp.compare(string, "4.0.0") < 0) {
            this.parseVersion = 0;
            bl = true;
        } else if (this.verComp.compare(string, "4.0.0") >= 0) {
            this.parseVersion = 1;
            bl = true;
        } else {
            this.logError(lex.getText("parseAPD.illegalAPDFileVersion") + ' ' + string + ' ' + lex.getText("parseAPD.cannotImport"));
            return false;
        }
        return bl;
    }

    protected String removeText(String string) {
        string = string.trim();
        int n = string.indexOf(32);
        String string2 = string.substring(n + 1);
        return string2;
    }

    protected void setGraphicFilesFromLibrary() {
        String string = this.syslibRoot.get("GraphicFile", null);
        if (string == null) {
            string = this.syslibRoot.get("Graphic1File", null);
        }
        if (string != null) {
            this.setGraphicFileName(string.trim());
        }
    }

    protected void setAppGroupFromLibrary() {
        String string = this.syslibRoot.get("Description", null);
        if (string != null) {
            String string2 = string.trim();
            this.setAppGroup(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkPointWithLibraryRetry(FXAppPoint fXAppPoint) {
        boolean bl = false;
        int n = this.syslibRoot.elems().length;
        int n2 = 0;
        while (n2 < n) {
            block26: {
                block27: {
                    Object object;
                    String string;
                    XElem xElem = this.syslibRoot.elems()[n2];
                    if (!fXAppPoint.originalname.equals(xElem.name()) || !(string = xElem.get("Import", "false").toLowerCase().trim()).equals("true")) break block26;
                    String string2 = xElem.get("Description", fXAppPoint.description).trim();
                    String string3 = xElem.get("Name", fXAppPoint.currentname).trim();
                    if (string2 == null || string2.length() == 0) {
                        string2 = fXAppPoint.description;
                    }
                    if (string3 == null || string3.length() == 0) {
                        string3 = fXAppPoint.currentname;
                    }
                    fXAppPoint.description = string2;
                    fXAppPoint.currentname = string3;
                    fXAppPoint.isGlobal = false;
                    String string4 = xElem.get("Alternate_SI_Units", null);
                    String string5 = xElem.get("Alternate_US_Units", null);
                    if (string4 != null && string4.length() > 0 && string5 != null && string5.length() > 0) {
                        object = new LonPointInfo(string4.trim(), string5.trim());
                        fXAppPoint.setUnitOverride((LonPointInfo)object);
                    } else {
                        fXAppPoint.setUnitOverride(null);
                    }
                    object = xElem.get("PointOrder", null);
                    if (object != null && ((String)object).length() > 0) {
                        try {
                            fXAppPoint.setPointOrder(Integer.parseInt(((String)object).trim()));
                        }
                        catch (Exception exception) {}
                    }
                    boolean bl2 = this.setupExtensions(xElem, fXAppPoint);
                    String string6 = xElem.get("Condition_Name1", null);
                    String string7 = xElem.get("Condition1", null);
                    String string8 = xElem.get("Condition_Name2", null);
                    String string9 = xElem.get("Condition2", null);
                    String string10 = xElem.get("Condition3", null);
                    String string11 = xElem.get("Condition_Name3", null);
                    if (string6 != null) {
                        string6 = string6.trim();
                    }
                    if (string7 != null) {
                        string7 = string7.trim();
                    }
                    if (string8 != null) {
                        string8 = string8.trim();
                    }
                    if (string9 != null) {
                        string9 = string9.trim();
                    }
                    if (string11 != null) {
                        string11 = string11.trim();
                    }
                    if (string10 != null) {
                        string10 = string10.trim();
                    }
                    if (string6 != null && string6.length() == 0) {
                        string6 = null;
                    }
                    if (string7 != null && string7.length() == 0) {
                        string7 = null;
                    }
                    if (string8 != null && string8.length() == 0) {
                        string8 = null;
                    }
                    if (string9 != null && string9.length() == 0) {
                        string9 = null;
                    }
                    if (string11 != null && string11.length() == 0) {
                        string11 = null;
                    }
                    if (string10 != null && string10.length() == 0) {
                        string10 = null;
                    }
                    if (string6 == null || string7 == null) break block27;
                    boolean bl3 = this.matchCondition(string6, string7);
                    if (!bl3) break block26;
                    if (string8 != null && string9 != null) {
                        boolean bl4 = this.matchCondition(string8, string9);
                        if (bl4) {
                            if (string11 != null && string10 != null) {
                                boolean bl5 = this.matchCondition(string11, string10);
                                if (bl5) {
                                    bl = true;
                                    break;
                                }
                                break block26;
                            } else {
                                bl = true;
                                break;
                            }
                        }
                        break block26;
                    } else {
                        bl = true;
                        break;
                    }
                }
                bl = true;
                break;
            }
            ++n2;
        }
        fXAppPoint.setValidAdd(bl);
        return bl;
    }

    protected boolean matchCondition(String string, String string2) {
        String string3;
        FXAppPoint fXAppPoint = new FXAppPoint(string, null);
        int n = this.conditionList.indexOf((Object)fXAppPoint);
        if (n > -1) {
            FXAppPoint fXAppPoint2 = (FXAppPoint)this.conditionList.get(n);
            string3 = fXAppPoint2.value;
        } else {
            string3 = string.indexOf(46) > 0 ? (this.parseVersion == 1 ? this.getValueFromStructInApdVer4New(string) : this.getValueFromStructInApd(string)) : (this.parseVersion == 1 ? this.getValueFromApdVer4(string) : this.getValueFromApd(string));
            FXAppPoint fXAppPoint3 = new FXAppPoint(string, string3);
            this.conditionList.add((Object)fXAppPoint3);
        }
        if (string3 != null) {
            boolean bl = this.testCondition(string2, string3);
            return bl;
        }
        return false;
    }

    protected String getValueFromApd(String string) {
        XElem xElem = this.apdRoot.elem("Profile").elem("CPs").elem(string);
        if (xElem != null) {
            String string2 = this.getElementText(xElem, "Value");
            if (string2.equals("none")) {
                return null;
            }
            return string2;
        }
        return null;
    }

    protected String getValueFromStructInApd(String string) {
        String string2 = null;
        String[] stringArray = TextUtil.split((String)string, (char)'.');
        String string3 = stringArray[0];
        XElem xElem = this.apdRoot.elem("Profile").elem("CPs").elem(string3);
        int n = 1;
        while (n < stringArray.length) {
            xElem = xElem.elem(stringArray[n]);
            ++n;
        }
        if (xElem != null && (string2 = this.getElementText(xElem, "Value")).equals("none")) {
            string2 = null;
        }
        return string2;
    }

    protected boolean testCondition(String string, String string2) {
        boolean bl = false;
        String string3 = string.trim();
        String string4 = ",";
        int n = string3.indexOf(string4);
        int n2 = 0;
        while (n > 0 && !bl) {
            bl = string2.equals(string3.substring(n2, n));
            string3 = string3.substring(n + 1).trim();
            n = string3.indexOf(string4);
        }
        if (!bl) {
            bl = string3.equals(string2);
        }
        return bl;
    }

    protected String getValueFromStructInApdVer4New(String string) {
        String string2 = null;
        String[] stringArray = TextUtil.split((String)string, (char)'.');
        String string3 = stringArray[0];
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = null;
            ++n;
        }
        stringArray2[0] = this.getValueFromApdVer4(string3);
        String string4 = this.getSNVTTypeFromApdVer4(string3);
        LonStructInfo lonStructInfo = this.determineIsStruct(string4);
        if (lonStructInfo != null) {
            int n2 = 1;
            while (n2 < stringArray.length) {
                int n3 = lonStructInfo.findLibField(stringArray[n2]);
                int n4 = lonStructInfo.maxFieldCount();
                if (n3 > -1) {
                    int n5;
                    String string5 = this.getFieldValueFromStruct(stringArray2[n2 - 1], n3, n4);
                    if (string5.charAt(0) == '(') {
                        n5 = string5.indexOf(44);
                        string5 = string5.substring(1, n5);
                    }
                    stringArray2[n2] = string5;
                    n5 = lonStructInfo.fieldSnvtTypes[n3];
                    LonStructInfo lonStructInfo2 = this.determineIsStruct(new Integer(n5).toString());
                    if (lonStructInfo2 == null) break;
                    lonStructInfo = lonStructInfo2;
                } else {
                    System.out.println("field not found " + string3 + '.' + stringArray[n2]);
                }
                ++n2;
            }
            string2 = stringArray2[stringArray2.length - 1];
        }
        return string2;
    }

    protected String getValueFromApdVer4(String string) {
        String string2 = null;
        XElem xElem = this.apdRoot.elem("ApplicationProfile");
        if (xElem != null) {
            XElem[] xElemArray = xElem.elems();
            int n = 0;
            while (n < xElemArray.length) {
                String string3 = xElemArray[n].get("Name");
                if (string.equals(string3)) {
                    string2 = xElemArray[n].get("Value");
                    if (string2 == null || string2.length() == 0) {
                        return null;
                    }
                    if (string2.charAt(0) == '(') {
                        int n2 = string2.indexOf(44);
                        string2 = string2.substring(1, n2);
                    } else {
                        int n3 = string2.indexOf(44);
                        if (n3 >= 0) {
                            String string4;
                            string2 = string4 = string2.replace(',', '.');
                        }
                    }
                    return string2;
                }
                ++n;
            }
        }
        return string2;
    }

    protected String getSNVTTypeFromApdVer4(String string) {
        String string2 = "-1";
        XElem xElem = this.apdRoot.elem("ApplicationProfile");
        if (xElem != null) {
            XElem[] xElemArray = xElem.elems();
            int n = 0;
            while (n < xElemArray.length) {
                String string3 = xElemArray[n].get("Name");
                if (string.equals(string3)) {
                    string2 = xElemArray[n].get("Type");
                    if (string2 == null || string2.length() == 0) {
                        return null;
                    }
                    return string2;
                }
                ++n;
            }
        }
        return string2;
    }

    protected String getSNVTTypeFromApd(String string) {
        String string2 = "-1";
        XElem xElem = this.apdRoot.elem("Profile").elem("CPs").elem(string);
        if (xElem != null) {
            String string3 = this.getElementText(xElem, "SNVTType");
            string2 = string3.equals("none") ? "-1" : string3;
        }
        return string2;
    }

    protected boolean setupExtensions(XElem xElem, FXAppPoint fXAppPoint) {
        boolean bl = false;
        fXAppPoint.clearLibraryExtensions();
        XElem xElem2 = xElem.elem("Extensions");
        if (xElem2 != null) {
            bl = true;
            fXAppPoint.shouldAlarm = this.needExtension(xElem2, "Alarm", fXAppPoint);
            fXAppPoint.shouldTot = this.needExtension(xElem2, "Totalization", fXAppPoint);
            XElem xElem3 = xElem2.elem("Trend");
            if (xElem3 != null) {
                fXAppPoint.shouldTrend = false;
                boolean bl2 = this.needExtension(xElem3, "Interval", fXAppPoint);
                boolean bl3 = this.needExtension(xElem3, "COV", fXAppPoint);
                String string = xElem3.get("Interval_Time", null);
                String string2 = xElem3.get("COV_Tolerence", null);
                if (bl2) {
                    fXAppPoint.trendIntervalInfo = new PtTrendInfo('i', string);
                }
                if (bl3) {
                    fXAppPoint.trendCOVInfo = new PtTrendInfo('c', string2);
                }
            } else {
                fXAppPoint.shouldTrend = this.needExtension(xElem2, "Trend", fXAppPoint);
            }
        } else {
            fXAppPoint.shouldTrend = this.needExtension(xElem, "Trend", fXAppPoint);
            fXAppPoint.shouldAlarm = this.needExtension(xElem, "Alarm", fXAppPoint);
            fXAppPoint.shouldTot = this.needExtension(xElem, "Total", fXAppPoint);
        }
        return bl;
    }

    protected boolean needExtension(XElem xElem, String string, FXAppPoint fXAppPoint) {
        String string2 = xElem.get(string, "False");
        if (string2.trim().length() == 0) {
            string2 = "False";
        }
        if (string.equals("Alarm")) {
            fXAppPoint.alarmPrototypeName = string2;
        }
        if (string.equals("Totalization")) {
            fXAppPoint.totPrototypeName = string2;
        }
        if (string.equals("Trend")) {
            fXAppPoint.trendPrototypeName = string2;
        }
        return string2.toLowerCase().trim().equals("false") ^ true;
    }

    protected LonStructInfo determineIsStruct(String string) {
        Integer n = new Integer(string);
        LonStructInfo lonStructInfo = (LonStructInfo)lonstructinfo.get(n);
        return lonStructInfo;
    }

    protected boolean isValueStruct(String string) {
        return string.charAt(0) == '{';
    }

    protected String getFieldValueFromStruct(String string, int n, int n2) {
        String[] stringArray = new String[n2];
        int n3 = 0;
        int n4 = 0;
        if (this.isValueStruct(string)) {
            String string2 = string.substring(2, string.length() - 2);
            while (n4 < string2.length()) {
                String string3;
                if (string2.charAt(n4) == '{') {
                    string3 = "{";
                    ++n4;
                    while (string2.charAt(n4) != '}') {
                        string3 = string3 + string2.charAt(n4);
                        ++n4;
                    }
                    stringArray[n3] = string3 = string3 + '}';
                    ++n3;
                    ++n4;
                    ++n4;
                    ++n4;
                    continue;
                }
                if (string2.charAt(n4) == ' ' && string2.charAt(n4 + 1) == ' ') {
                    string3 = "";
                    ++n4;
                    ++n4;
                    while (n4 < string2.length() && string2.charAt(n4) != ' ') {
                        string3 = string3 + string2.charAt(n4);
                        ++n4;
                    }
                    stringArray[n3] = string3;
                    ++n3;
                    ++n4;
                    continue;
                }
                string3 = "";
                while (n4 < string2.length() && string2.charAt(n4) != ' ') {
                    string3 = string3 + string2.charAt(n4);
                    ++n4;
                }
                stringArray[n3] = string3;
                ++n3;
                if (n4 < string2.length() - 1 && string2.charAt(n4 + 1) == ' ') {
                    ++n4;
                }
                ++n4;
            }
        }
        return stringArray[n];
    }

    protected String getElementText(XElem xElem, String string) {
        String string2 = "none";
        XElem xElem2 = xElem.elem(string);
        if (xElem2 != null && xElem2.text() != null) {
            string2 = xElem2.text().toString();
        }
        return string2.trim();
    }

    public String determineNiagaraTypeAsString(String string, boolean bl) {
        String string2 = null;
        string2 = bl ? string + "Point" : string + "Writable";
        return string2;
    }

    protected String determineNiagaraType(int n, String string) {
        String string2 = "";
        switch (n) {
            case 0: {
                string2 = string2 + "Enum";
                break;
            }
            case 1: {
                string2 = string2 + "Numeric";
                break;
            }
            case 2: {
                string2 = string2 + "Boolean";
                break;
            }
        }
        if (string.equals(nvrwDirection) || string.equals(nvrwDirectionVer4)) {
            string2 = string2 + "Writable";
        } else if (string.equals(nvrDirection) || string.equals(nvrDirectionVer4)) {
            string2 = string2 + "Point";
        }
        return string2;
    }

    protected void addEnumTypeInfo(FXAppPoint fXAppPoint, XElem xElem) {
        XElem[] xElemArray;
        XElem xElem2;
        String string = "Enum";
        if (string.equals(xElem.get("Type")) && (xElem2 = xElem.elem("States")) != null && (xElemArray = xElem2.elems("State")).length > 0) {
            String[] stringArray = new String[xElemArray.length];
            int[] nArray = new int[xElemArray.length];
            int n = 0;
            while (n < xElemArray.length) {
                XElem xElem3 = xElemArray[n];
                if (xElem3 != null) {
                    stringArray[n] = SlotPath.escape((String)TextUtil.toFriendly((String)xElem3.get("Name")));
                    nArray[n] = xElem3.geti("Value");
                }
                ++n;
            }
            fXAppPoint.enumOrdinals = nArray;
            fXAppPoint.enumStrings = stringArray;
        }
    }

    protected void populateNiagaraptInfo() {
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        String[] stringArray2 = new String[256];
        int[] nArray2 = new int[256];
        String string = "Enum_";
        int n = 0;
        while (n < 256) {
            stringArray2[n] = string + n;
            nArray2[n] = n;
            ++n;
        }
        niagaraptinfo.put(new Integer(22), new LonPointInfo(0, "SNVT_lev_disc", "", "", stringArray, nArray, "22", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(29), new LonPointInfo(1, "SNVT_ppm", "ppm", "ppm", stringArray, nArray, "29", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(81), new LonPointInfo(1, "SNVT_lev_precent", "%", "%", stringArray, nArray, "81", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(103), new LonPointInfo(0, "SNVT_hvac_emerg", "", "", stringArray, nArray, "103", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(108), new LonPointInfo(0, "SNVT_hvac_mode", "", "", stringArray, nArray, "108", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(105), new LonPointInfo(1, "SNVT_temp_p", "deg C", "deg F", stringArray, nArray, "105", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(107), new LonPointInfo(1, "SNVT_time_sec", "s", "s", stringArray, nArray, "107", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(109), new LonPointInfo(0, "SNVT_occupancy", "", "", stringArray, nArray, "109", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(114), new LonPointInfo(1, "SNVT_address", "Addr", "Addr", stringArray, nArray, "114", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(123), new LonPointInfo(1, "SNVT_time_min", "min", "min", stringArray, nArray, "123", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(124), new LonPointInfo(1, "SNVT_time_hours", "h", "h", stringArray, nArray, "124", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(147), new LonPointInfo(1, "SNVT_temp_diff_p", "deg C", "deg F", stringArray, nArray, "147", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(153), new LonPointInfo(1, "SNVT_enthalphy", "kJ/kg", "BTU/Lb", stringArray, nArray, "153", this.lonElementTypePlaceholder));
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArray3[2] = 255;
        niagaraptinfo.put(new Integer(10149), new LonPointInfo(0, "UNVT_Logic", "", "", new String[]{"LOG_OFF", "LOG_ON", "LOG_NUL"}, nArray3, "10149", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(10160), new LonPointInfo(0, "UNVT_pilot_status", "", "", stringArray, nArray, "10160", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(1000), new LonPointInfo(1, "MT_8_Percent", "%", "%", stringArray, nArray, "1000", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(1001), new LonPointInfo(1, "U16", null, null, stringArray, nArray, "1001", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(1003), new LonPointInfo(1, "U8", null, null, stringArray, nArray, "1003", this.lonElementTypePlaceholder));
        int[] nArray4 = new int[19];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[5] = 5;
        nArray4[6] = 6;
        nArray4[7] = 7;
        nArray4[8] = 8;
        nArray4[9] = 9;
        nArray4[10] = 10;
        nArray4[11] = 11;
        nArray4[12] = 12;
        nArray4[13] = 13;
        nArray4[14] = 14;
        nArray4[15] = 15;
        nArray4[16] = 16;
        nArray4[17] = 17;
        nArray4[18] = 255;
        niagaraptinfo.put(new Integer(1004), new LonPointInfo(0, "Enum_object_request", "", "", new String[]{"Normal", "Disable", "Update_Status", "Self_Test", "Update_Alarm", "Report_Mask", "Override", "Enable", "Remove_Override", "Clear_Status", "Clear_Alarm", "Alarm_Notify_Enable", "Alarm_Notify_Disable", "Manual_Control", "Remote_Control", "Program", "Clear_Reset", "Reset", "Invalid"}, nArray4, "1004", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(15), new LonPointInfo(1, "SNVT_Flow", "l/s", "CFM", stringArray, nArray, "15", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(51), new LonPointInfo(1, "SNVT_Count_f", "kPa", "in wg", stringArray, nArray, "51", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(5000), new LonPointInfo(0, "SNVT_overid_t", "", "", stringArray, nArray, "5000", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(10175), new LonPointInfo(0, "UNVT_enumeration", "", "", stringArray2, nArray2, "10175", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(7), new LonPointInfo(0, "SNVT_char_ascii", "", "", stringArray2, nArray2, "7", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(11), new LonPointInfo(0, "SNVT_date_day", "", "", stringArray2, nArray2, "11", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(38), new LonPointInfo(0, "SNVT_telcom", "", "", stringArray2, nArray2, "38", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(69), new LonPointInfo(0, "SNVT_config_src", "", "", stringArray2, nArray2, "69", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(97), new LonPointInfo(0, "SNVT_override", "", "", stringArray2, nArray2, "97", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(118), new LonPointInfo(0, "SNVT_evap_state", "", "", stringArray2, nArray2, "118", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(119), new LonPointInfo(0, "SNVT_therm_mode", "", "", stringArray2, nArray2, "119", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(120), new LonPointInfo(0, "SNVT_defr_mode", "", "", stringArray2, nArray2, "120", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(121), new LonPointInfo(0, "SNVT_defr_term", "", "", stringArray2, nArray2, "121", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(122), new LonPointInfo(0, "SNVT_defr_state", "", "", stringArray2, nArray2, "122", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(132), new LonPointInfo(0, "SNVT_fire_init", "", "", stringArray2, nArray2, "132", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(133), new LonPointInfo(0, "SNVT_fire_indcte", "", "", stringArray2, nArray2, "133", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(145), new LonPointInfo(0, "SNVT_hvac_type", "", "", stringArray2, nArray2, "145", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(1), new LonPointInfo(1, "SNVT_amp", "A", "A", stringArray, nArray, "1", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(2), new LonPointInfo(1, "SNVT_amp_mil", "mA", "mA", stringArray, nArray, "2", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(3), new LonPointInfo(1, "SNVT_angle", "radian", "deg", stringArray, nArray, "3", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(4), new LonPointInfo(1, "SNVT_angle_vel", "radians/s", "rpm", stringArray, nArray, "4", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(5), new LonPointInfo(1, "SNVT_btu_kilo", "kBTU", "kBTU", stringArray, nArray, "5", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(6), new LonPointInfo(1, "SNVT_btu_mega", "MBTU", "MBTU", stringArray, nArray, "6", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(8), new LonPointInfo(1, "SNVT_count", "count", "count", stringArray, nArray, "8", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(9), new LonPointInfo(1, "SNVT_count_inc", "count", "count", stringArray, nArray, "9", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(13), new LonPointInfo(1, "SNVT_elec_kwh", "kWH", "kWH", stringArray, nArray, "13", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(14), new LonPointInfo(1, "SNVT_elec_whr", "Wh", "Wh", stringArray, nArray, "14", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(16), new LonPointInfo(1, "SNVT_flow_mil", "ml/s", "CFM", stringArray, nArray, "16", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(17), new LonPointInfo(1, "SNVT_length", "m", "in", stringArray, nArray, "17", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(18), new LonPointInfo(1, "SNVT_length_kilo", "km", "miles", stringArray, nArray, "18", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(19), new LonPointInfo(1, "SNVT_length_micr", "um", "in", stringArray, nArray, "19", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(20), new LonPointInfo(1, "SNVT_length_mil", "mm", "in", stringArray, nArray, "20", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(21), new LonPointInfo(1, "SNVT_lev_cont", "%", "%", stringArray, nArray, "21", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(23), new LonPointInfo(1, "SNVT_mass", "kg", "lbm", stringArray, nArray, "23", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(24), new LonPointInfo(1, "SNVT_mass_kilo", "kg", "lbm", stringArray, nArray, "24", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(25), new LonPointInfo(1, "SNVT_mass_mega", "kg", "lbm", stringArray, nArray, "25", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(26), new LonPointInfo(1, "SNVT_mass_mil", "kg", "lbm", stringArray, nArray, "26", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(27), new LonPointInfo(1, "SNVT_power", "W", "W", stringArray, nArray, "27", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(28), new LonPointInfo(1, "SNVT_power_kilo", "kW", "kW", stringArray, nArray, "28", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(30), new LonPointInfo(1, "SNVT_press", "kPa", "PSI", stringArray, nArray, "30", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(31), new LonPointInfo(1, "SNVT_res", "Ohms", "Ohms", stringArray, nArray, "31", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(32), new LonPointInfo(1, "SNVT_res_kilo", "kOhms", "kOhms", stringArray, nArray, "32", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(33), new LonPointInfo(1, "SNVT_sound_db", "dB", "dB", stringArray, nArray, "33", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(34), new LonPointInfo(1, "SNVT_speed", "m/s", "ft/s", stringArray, nArray, "34", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(35), new LonPointInfo(1, "SNVT_speed_mil", "m/s", "ft/s", stringArray, nArray, "35", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(39), new LonPointInfo(1, "SNVT_temp", "deg C", "deg F", stringArray, nArray, "39", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(41), new LonPointInfo(1, "SNVT_vol", "l", "gal", stringArray, nArray, "41", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(42), new LonPointInfo(1, "SNVT_vol_kilo", "kl", "gal", stringArray, nArray, "42", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(43), new LonPointInfo(1, "SNVT_vol_mil", "ml", "cu in", stringArray, nArray, "43", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(44), new LonPointInfo(1, "SNVT_volt", "V", "V", stringArray, nArray, "44", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(45), new LonPointInfo(1, "SNVT_volt_dbmv", "V", "V", stringArray, nArray, "45", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(46), new LonPointInfo(1, "SNVT_volt_kilo", "kV", "kV", stringArray, nArray, "46", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(47), new LonPointInfo(1, "SNVT_volt_mil", "mV", "mV", stringArray, nArray, "47", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(48), new LonPointInfo(1, "SNVT_amp_f", "A", "A", stringArray, nArray, "48", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(49), new LonPointInfo(1, "SNVT_angle_f", "radian", "deg", stringArray, nArray, "49", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(50), new LonPointInfo(1, "SNVT_angle_vel_f", "radians/s", "rpm", stringArray, nArray, "50", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(52), new LonPointInfo(1, "SNVT_count_inc_f", "count", "count", stringArray, nArray, "52", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(53), new LonPointInfo(1, "SNVT_flow_f", "l/s", "CFM", stringArray, nArray, "53", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(54), new LonPointInfo(1, "SNVT_length_f", "m", "in", stringArray, nArray, "54", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(55), new LonPointInfo(1, "SNVT_lev_cont_f", "%", "%", stringArray, nArray, "55", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(56), new LonPointInfo(1, "SNVT_mass_f", "kg", "lbm", stringArray, nArray, "56", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(57), new LonPointInfo(1, "SNVT_power_f", "W", "W", stringArray, nArray, "57", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(58), new LonPointInfo(1, "SNVT_ppm_f", "ppm", "ppm", stringArray, nArray, "58", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(59), new LonPointInfo(1, "SNVT_press_f", "Pa", "PSI", stringArray, nArray, "59", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(60), new LonPointInfo(1, "SNVT_res_f", "Ohms", "Ohms", stringArray, nArray, "60", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(61), new LonPointInfo(1, "SNVT_sound_db_f", "dB", "dB", stringArray, nArray, "61", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(62), new LonPointInfo(1, "SNVT_speed_f", "m/s", "ft/s", stringArray, nArray, "62", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(63), new LonPointInfo(1, "SNVT_temp_f", "deg C", "deg F", stringArray, nArray, "63", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(64), new LonPointInfo(1, "SNVT_time_f", "s", "s", stringArray, nArray, "64", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(65), new LonPointInfo(1, "SNVT_vol_f", "l", "gal", stringArray, nArray, "65", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(66), new LonPointInfo(1, "SNVT_volt_f", "V", "V", stringArray, nArray, "66", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(67), new LonPointInfo(1, "SNVT_btu_f", "BTU", "BTU", stringArray, nArray, "67", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(68), new LonPointInfo(1, "SNVT_elec_whr_f", "Wh", "Wh", stringArray, nArray, "68", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(71), new LonPointInfo(1, "SNVT_grammage", "g/sq m", "g/sq m", stringArray, nArray, "71", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(72), new LonPointInfo(1, "SNVT_grammage_f", "g/sq m", "g/sq m", stringArray, nArray, "72", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(75), new LonPointInfo(1, "SNVT_freq_f", "Hz", "Hz", stringArray, nArray, "75", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(76), new LonPointInfo(1, "SNVT_freq_hz", "Hz", "Hz", stringArray, nArray, "76", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(77), new LonPointInfo(1, "SNVT_freq_kilohz", "kHz", "kHz", stringArray, nArray, "77", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(78), new LonPointInfo(1, "SNVT_freq_milhz", "Hz", "Hz", stringArray, nArray, "78", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(79), new LonPointInfo(1, "SNVT_lux", "Lux", "Lux", stringArray, nArray, "79", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(82), new LonPointInfo(1, "SNVT_multiplier", "Mult", "Mult", stringArray, nArray, "82", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(98), new LonPointInfo(1, "SNVT_pwr_fact", "PF", "PF", stringArray, nArray, "98", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(99), new LonPointInfo(1, "SNVT_pwr_fact_f", "PF", "PF", stringArray, nArray, "99", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(100), new LonPointInfo(1, "SNVT_density", "kg/cu", "kg/cu", stringArray, nArray, "100", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(101), new LonPointInfo(1, "SNVT_density_f", "kg/cu", "kg/cu", stringArray, nArray, "101", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(102), new LonPointInfo(1, "SNVT_rpm", "radians/s", "RPM", stringArray, nArray, "102", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(104), new LonPointInfo(1, "SNVT_angle_deg", "radian", "deg", stringArray, nArray, "104", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(110), new LonPointInfo(1, "SNVT_area", "m2", "sq ft", stringArray, nArray, "110", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(113), new LonPointInfo(1, "SNVT_press_p", "Pa", "PSI", stringArray, nArray, "113", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(125), new LonPointInfo(1, "SNVT_ph", "pH", "pH", stringArray, nArray, "125", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(126), new LonPointInfo(1, "SNVT_ph_f", "pH", "pH", stringArray, nArray, "126", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(129), new LonPointInfo(1, "SNVT_smo_obscur", "%", "%", stringArray, nArray, "129", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(131), new LonPointInfo(1, "SNVT_temp_ror", "deg C/m", "deg F/m", stringArray, nArray, "131", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(138), new LonPointInfo(1, "SNVT_volt_ac", "V AC", "V AC", stringArray, nArray, "138", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(139), new LonPointInfo(1, "SNVT_amp_ac", "A AC", "A AC", stringArray, nArray, "139", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(140), new LonPointInfo(1, "SNVT_dummy_140", null, null, stringArray, nArray, "140", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(141), new LonPointInfo(1, "SNVT_dummy_141", null, null, stringArray, nArray, "141", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(142), new LonPointInfo(1, "SNVT_dummy_142", null, null, stringArray, nArray, "142", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(143), new LonPointInfo(1, "SNVT_turbidity", "ntu", "ntu", stringArray, nArray, "143", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(144), new LonPointInfo(1, "SNVT_turbidity_f", "ntu", "ntu", stringArray, nArray, "144", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(10224), new LonPointInfo(0, "UNVT_byte", "", "", stringArray2, nArray2, "10224", this.lonElementTypePlaceholder));
        int[] nArray5 = new int[4];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 255;
        niagaraptinfo.put(new Integer(10157), new LonPointInfo(0, "UNVT_exception_date", "", "", new String[]{"Exdate_normal", "Exdate_holiday", "Exdate_alternate", "Exdate_nul"}, nArray5, "10157", this.lonElementTypePlaceholder));
        int[] nArray6 = new int[2];
        nArray6[1] = 1;
        niagaraptinfo.put(new Integer(5028), new LonPointInfo(0, "SetPointConfig", "", "", new String[]{"Absolute", "Normal"}, nArray6, "5028", this.lonElementTypePlaceholder));
        int[] nArray7 = new int[2];
        nArray7[1] = 1;
        niagaraptinfo.put(new Integer(5203), new LonPointInfo(0, "UnitSystem", "", "", new String[]{"SI", "US"}, nArray7, "5203", this.lonElementTypePlaceholder));
        int[] nArray8 = new int[4];
        nArray8[1] = 1;
        nArray8[2] = 2;
        nArray8[3] = 3;
        niagaraptinfo.put(new Integer(10200), new LonPointInfo(0, "UNVT_balov_duct", "", "", new String[]{"SingleDuct", "SingleDuctExh", "DualDuct", "DualDuctExh"}, nArray8, "10200", this.lonElementTypePlaceholder));
        int[] nArray9 = new int[7];
        nArray9[1] = 1;
        nArray9[2] = 2;
        nArray9[3] = 3;
        nArray9[4] = 4;
        nArray9[5] = 5;
        nArray9[6] = 255;
        niagaraptinfo.put(new Integer(10201), new LonPointInfo(0, "UNVT_balov_fo", "", "", new String[]{"Normal", "Closed", "MinFlow1", "MaxFlow1", "MinFlow2", "MaxFlow2", "Invalid"}, nArray9, "10201", this.lonElementTypePlaceholder));
        int[] nArray10 = new int[4];
        nArray10[1] = 1;
        nArray10[2] = 2;
        nArray10[3] = 3;
        niagaraptinfo.put(new Integer(10202), new LonPointInfo(0, "UNVT_balov_autocal", "", "", new String[]{"Waiting", "InProcess", "Completed", "TimeOut"}, nArray10, "10202", this.lonElementTypePlaceholder));
        int[] nArray11 = new int[8];
        nArray11[1] = 1;
        nArray11[2] = 2;
        nArray11[3] = 3;
        nArray11[4] = 4;
        nArray11[5] = 5;
        nArray11[6] = 6;
        nArray11[7] = 255;
        niagaraptinfo.put(new Integer(10204), new LonPointInfo(0, "UNVT_Cmd_Fdbk", "", "", new String[]{"ACalOk", "ACalInProgress", "AlreadyStarted", "NoBalancerOvr", "InvalidFlowHood", "InvalidFlowGain", "FlowUnreliable", "Invalid"}, nArray11, "10204", this.lonElementTypePlaceholder));
        int[] nArray12 = new int[8];
        nArray12[1] = 1;
        nArray12[2] = 2;
        nArray12[3] = 3;
        nArray12[4] = 4;
        nArray12[5] = 5;
        nArray12[6] = 6;
        nArray12[7] = 255;
        niagaraptinfo.put(new Integer(10205), new LonPointInfo(0, "UNVT_RecGainSt", "", "", new String[]{"NoCommand", "CmdSuccess", "NoBalancerOvr", "NoFlowUpdate", "FlowUnreliable", "GainOutOfRange", "InProgress", "Invalid"}, nArray12, "10205", this.lonElementTypePlaceholder));
        int[] nArray13 = new int[7];
        nArray13[1] = 1;
        nArray13[2] = 2;
        nArray13[3] = 3;
        nArray13[4] = 4;
        nArray13[5] = 5;
        nArray13[6] = 6;
        niagaraptinfo.put(new Integer(10206), new LonPointInfo(0, "UNVT_AutocalState", "", "", new String[]{"NonePerformed", "InProcess", "Completed", "TimedOut", "FalseEffAC", "TrueEffAC", "ClosingDamper"}, nArray13, "10206", this.lonElementTypePlaceholder));
        int[] nArray14 = new int[8];
        nArray14[1] = 1;
        nArray14[2] = 2;
        nArray14[3] = 3;
        nArray14[4] = 4;
        nArray14[5] = 5;
        nArray14[6] = 6;
        nArray14[7] = 7;
        niagaraptinfo.put(new Integer(10207), new LonPointInfo(0, "UNVT_boxft_st", "", "", new String[]{"NoTestData", "DriveToStartPos", "AverageFlowRead", "DriveAwayFromStart", "DriveBackToStart", "CompleteNormal", "CompleteErrors", "TestCancelled"}, nArray14, "10207", this.lonElementTypePlaceholder));
        niagaraptinfo.put(new Integer(5201), new LonPointInfo(0, "DeviceSensorType", "", "", new String[]{"Linear0-10Volts", "SquareRoot0-10Volts", "Linear2-10Volts", "Linear0-2Volts", "SquareRoot0-2Volts", "Linear0.4-2Volts", "Linear0-20mA", "SquareRoot0-20mA", "Linear4-20mA", "Resistance_EUR_2k", "Resistance_US_1k6", "A99", "NTC_2252_Ohms", "NTC_10_kOhms", "Ni1000_JC", "Ni1000_JC_Extended", "Ni1000_Landis", "Ni1000_DIN", "Pt1000", "RadioMetric"}, new int[]{1, 33, 65, 2, 34, 66, 3, 35, 67, 5, 37, 6, 7, 39, 8, 40, 72, 104, 9, 10}, "5201", this.lonElementTypePlaceholder));
        int[] nArray15 = new int[15];
        nArray15[1] = 1;
        nArray15[2] = 2;
        nArray15[3] = 3;
        nArray15[4] = 4;
        nArray15[5] = 5;
        nArray15[6] = 6;
        nArray15[7] = 7;
        nArray15[8] = 8;
        nArray15[9] = 9;
        nArray15[10] = 10;
        nArray15[11] = 11;
        nArray15[12] = 12;
        nArray15[13] = 13;
        nArray15[14] = 255;
        niagaraptinfo.put(new Integer(10164), new LonPointInfo(0, "UNVT_timezone", "", "", new String[]{"GMT", "CET_Central_Europe", "EET_Central_Europe", "AST_Atlantic_Standard", "EST_Eastern_Standard", "CST_Central_Standard", "MST_Mountain_Standard", "PAST_Pacific_Standard", "AKST_Alaska_Standard", "AEST_Eastern_Standard", "ACST_Central_Standard", "New_Zeland", "East_Brazil", "West_Brazil", "DST_Disabled"}, nArray15, "10164", this.lonElementTypePlaceholder));
    }

    protected void populateLonStructInfo() {
        int n;
        String[] stringArray = new String[21];
        int[] nArray = new int[21];
        String[] stringArray2 = new String[25];
        int[] nArray2 = new int[25];
        String[] stringArray3 = new String[25];
        int[] nArray3 = new int[25];
        String string = "event";
        int n2 = 0;
        while (n2 < 21) {
            n = n2 + 1;
            stringArray[n2] = string + n;
            nArray[n2] = 10193;
            ++n2;
        }
        n2 = 0;
        while (n2 < 25) {
            n = n2 + 1;
            stringArray2[n2] = string + n;
            stringArray3[n2] = string + n;
            nArray2[n2] = 10194;
            nArray3[n2] = 10192;
            ++n2;
        }
        lonstructinfo.put(new Integer(92), new LonStructInfo("92", "SNVT_obj_request", new String[]{"objectId", "objectRequest"}, new String[]{"Id", "Request"}, new int[]{1001, 1004}));
        lonstructinfo.put(new Integer(93), new LonStructInfo("93", "SNVT_obj_status", new String[]{"objectId", "invalidId", "invalidRequest", "disabled", "outOfLimits", "openCircuit", "outOfService", "mechanicalFault", "feedbackFailure", "overRange", "underRange", "electricalFault", "unableToMeasure", "commFailure", "failSelfTest", "selfTestInProgress", "lockedOut", "manualControl", "inAlarm", "inOverride", "reportMask", "programmingMode", "programmingFail", "alarmNotifyDisabled", "resetComplete", "reserved2"}, new String[]{"Id", "Invalid_Id", "Invalid_Request", "Disabled", "Out_Of_Limits", "Open_Circuit", "Out_Of_Service", "Mechanical_Fault", "Feedback_Failure", "Over_Range", "Under_Range", "Electrical_Fault", "Unable_To_Measure", "Comm_Failure", "Fail_SelfTest", "Self_Test_In_Progress", "Locked_Out", "Manual_Control", "In_Alarm", "In_Override", "Report_Mask", "Programming_Mode", "Programming_Fail", "Alarm_Notify_Disabled", "Reset_Complete", "Reserved2"}, new int[]{1001, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224, 10224}));
        lonstructinfo.put(new Integer(95), new LonStructInfo("95", "SNVT_switch", new String[]{"value", "state"}, new String[]{"Value", "State"}, new int[]{1000, 10149}));
        lonstructinfo.put(new Integer(106), new LonStructInfo("106", "SNVT_temp_setpt", new String[]{"occupiedCool", "standbyCool", "unoccupiedCool", "occupiedHeat", "standbyHeat", "unoccupiedHeat"}, new String[]{"Occupied_Cool", "StandBy_Cool", "Unoccupied_Cool", "Occupied_Heat", "StandBy_Heat", "Unoccupied_Heat"}, new int[]{105, 105, 105, 105, 105, 105}));
        lonstructinfo.put(new Integer(111), new LonStructInfo("111", "SNVT_hvac_overid", new String[]{"state", "percent", "flow"}, new String[]{"State", "Percent", "Flow"}, new int[]{5000, 81, 15}));
        lonstructinfo.put(new Integer(112), new LonStructInfo("112", "SNVT_hvac_status", new String[]{"mode", "heatOutputPrimary", "heatOutputSecondary", "coolOutput", "economizerOutput", "fanOutput", "inAlarm"}, new String[]{"Mode", "Heat_Output_Primary", "Heat_Output_Secondary", "Cool_Output", "Economizer_Output", "Fan_Output", "In_Alarm"}, new int[]{108, 81, 81, 81, 81, 81, 10224}));
        lonstructinfo.put(new Integer(128), new LonStructInfo("128", "SNVT_tod_event", new String[]{"currentState", "nextState", "timeToNextState"}, new String[]{"Current_state", "Next_state", "Time_to_next_state"}, new int[]{109, 109, 123}));
        lonstructinfo.put(new Integer(10184), new LonStructInfo("10184", "UNVT_event_schedule", new String[]{"hour", "minute", "status", "alternateDays", "normalDays"}, new String[]{"Hour", "Minute", "Status", "AlternateDays", "NormalDays"}, new int[]{1003, 1003, 10149, 10175, 10175}));
        lonstructinfo.put(new Integer(40020), new LonStructInfo("40020", "UNVT_event_schedule_array4", new String[]{"event1", "event2", "event3", "event4"}, new String[]{"Event1", "Event2", "Event3", "Event4"}, new int[]{10184, 10184, 10184, 10184}));
        lonstructinfo.put(new Integer(10193), new LonStructInfo("10193", "UNVT_evtsched_ext", new String[]{"startHour", "startMinute", "stopHour", "stopMinute", "status", "dayMask"}, new String[]{"StartHour", "StartMinute", "StopHour", "StopMinute", "Status", "DayMask"}, new int[]{1003, 1003, 1003, 1003, 10149, 10175}));
        lonstructinfo.put(new Integer(10194), new LonStructInfo("10194", "UNVT_exceptevt", new String[]{"startMonth", "startDay", "endMonth", "endDay", "exceptionDate"}, new String[]{"Start_month", "Start_day", "End_month", "End_day", "Exception_date"}, new int[]{10224, 10224, 10224, 10224, 10157}));
        lonstructinfo.put(new Integer(40060), new LonStructInfo("40060", "UNVT_OnOffSched", stringArray, nArray));
        lonstructinfo.put(new Integer(40070), new LonStructInfo("40070", "UNVT_ExcepDayCalendar", stringArray2, nArray2));
        lonstructinfo.put(new Integer(10192), new LonStructInfo("10192", "UNVT_occsched_ext", new String[]{"GroupID", "Hour", "Minute", "Occstatus", "DayMask"}, new int[]{1003, 1003, 1003, 109, 10175}));
        lonstructinfo.put(new Integer(40050), new LonStructInfo("40050", "UNVT_OccSched", stringArray3, nArray3));
        lonstructinfo.put(new Integer(10195), new LonStructInfo("10195", "UNVT_scalefactor", new String[]{"Multipler", "ModuloDiv"}, new int[]{8, 8}));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.xparSysLibFile = null;
        this.xparAPDFile = null;
        this.parseVersion = -1;
        this.lonElementTypePlaceholder = -1;
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.tempordinals = nArray;
        this.temptags = new String[]{"enum0", "enum1"};
    }

    public BJciGeneralParseApd() {
        this.this();
    }

    static {
        Class clazz = class$com$jci$jciCoreParser$BJciGeneralParseApd;
        if (clazz == null) {
            clazz = class$com$jci$jciCoreParser$BJciGeneralParseApd = BJciGeneralParseApd.class("[Lcom.jci.jciCoreParser.BJciGeneralParseApd;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$jci$jciCoreParser$BJciGeneralParseApd;
        if (clazz2 == null) {
            clazz2 = class$com$jci$jciCoreParser$BJciGeneralParseApd = BJciGeneralParseApd.class("[Lcom.jci.jciCoreParser.BJciGeneralParseApd;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

