/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BModuleStatus;
import com.tridium.install.part.BPart;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;

public class SoftwareTableRow
implements SortableTableUtil.SortableRow {
    private Array forwardDeps = new Array(class$com$tridium$install$BDependency == null ? (class$com$tridium$install$BDependency = SoftwareTableRow.class$("com.tridium.install.BDependency")) : class$com$tridium$install$BDependency);
    private HashMap reverseDepsByRow = new HashMap();
    private BPart currentPart = null;
    private boolean outOfDate = false;
    private boolean needsCommission = false;
    private long installablePartSize = Long.MIN_VALUE;
    private BInstallable installable;
    private SoftwareTableModel model;
    private BInstallable highestVersionInstallable = null;
    private BPartInstallStatus installStatus = BPartInstallStatus.noChange;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    static /* synthetic */ Class class$com$tridium$install$part$BPart;
    static /* synthetic */ Class class$com$tridium$install$BDependency;

    public SoftwareTableRow(SoftwareTableModel softwareTableModel) {
        this.model = softwareTableModel;
    }

    public int compareComment(SoftwareTableRow softwareTableRow) {
        int n;
        int n2 = SoftwareTableRow.getStatusRank(this.getStatus());
        if (n2 < (n = SoftwareTableRow.getStatusRank(softwareTableRow.getStatus()))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return TextUtil.toLowerCase((String)this.getComment()).compareTo(TextUtil.toLowerCase((String)softwareTableRow.getComment()));
    }

    public Object getRowId() {
        return this.getPartName();
    }

    public int compareToRowForColumn(SortableTableUtil.SortableRow sortableRow, int n) {
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)sortableRow;
        switch (n) {
            case 0: {
                return TextUtil.toLowerCase((String)this.getPartName()).compareTo(TextUtil.toLowerCase((String)softwareTableRow.getPartName()));
            }
            case 3: {
                return this.compareComment(softwareTableRow);
            }
            case 1: {
                if (this.getCurrentPart() == null) {
                    if (softwareTableRow.getCurrentPart() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (softwareTableRow.getCurrentPart() == null) {
                    return 1;
                }
                return this.getCurrentPart().getVersion().compareTo((Object)softwareTableRow.getCurrentPart().getVersion());
            }
            case 2: {
                if (this.getInstallable() == null) {
                    if (softwareTableRow.getInstallable() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (softwareTableRow.getInstallable() == null) {
                    return 1;
                }
                return this.getInstallable().getVersion().compareTo((Object)softwareTableRow.getInstallable().getVersion());
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static String statusToComment(int n) {
        switch (n) {
            case 6: {
                return lex.getText("StationSoftwareView.status.notInstalled");
            }
            case 3: 
            case 4: {
                return lex.getText("StationSoftwareView.status.outOfDate");
            }
            case 1: 
            case 2: 
            case 5: {
                return lex.getText("StationSoftwareView.status.upToDate");
            }
            case 7: {
                return lex.getText("StationSoftwareView.status.badInstallable");
            }
            case 8: 
            case 9: {
                return lex.getText("StationSoftwareView.status.badTarget");
            }
            case 10: 
            case 11: {
                return lex.getText("StationSoftwareView.status.noLocal");
            }
            case 12: {
                return lex.getText("StationSoftwareView.status.needCommissioningOod");
            }
            case 13: {
                return lex.getText("StationSoftwareView.status.needCommissioningMissing");
            }
        }
        return "";
    }

    public String getComment() {
        switch (this.getInstallStatus().getOrdinal()) {
            case 2: {
                return lex.getText("StationSoftwareView.status.install", new Object[]{this.installable.getVersion()});
            }
            case 3: {
                return lex.getText("StationSoftwareView.status.upgrade", new Object[]{this.installable.getVersion()});
            }
            case 4: {
                return lex.getText("StationSoftwareView.status.reinstall", new Object[]{this.installable.getVersion()});
            }
            case 5: {
                return lex.getText("StationSoftwareView.status.downgrade", new Object[]{this.installable.getVersion()});
            }
            case 6: {
                return lex.getText("StationSoftwareView.status.uninstall", new Object[]{this.currentPart.getVersion()});
            }
        }
        return SoftwareTableRow.statusToComment(this.getStatus());
    }

    public BPart getCurrentPart() {
        return this.currentPart;
    }

    public BImage getPartIcon() {
        if (this.getCurrentPart() == null) {
            if (this.getInstallablePart() == null) {
                return BImage.make((BIcon)this.getInstallable().getIcon());
            }
            return BImage.make((BIcon)this.getInstallablePart().getIcon());
        }
        return BImage.make((BIcon)this.getCurrentPart().getIcon());
    }

    public BVersion getCurrentVersion() {
        return this.currentPart == null ? null : this.currentPart.getVersion();
    }

    public String getInstallableName() {
        return this.installable == null ? null : this.installable.getInstallableName();
    }

    public BPart getInstallablePart() {
        return this.installable == null ? null : this.installable.getPart();
    }

    public BPart getHighestVersionedPart() {
        return this.highestVersionInstallable == null ? null : this.highestVersionInstallable.getPart();
    }

    public long getInstallablePartSize() {
        if (this.installable == null) {
            return 0L;
        }
        if (this.installablePartSize == Long.MIN_VALUE) {
            this.installablePartSize = this.installable instanceof BModuleInstallable ? ((BModulePart)this.getInstallablePart()).getFilteredFileSize(this.model.getTargetPlatform().getModuleContent(), this.model.getTargetPlatform().getStripLineNumbers()) : this.installable.getInstallableFileSize();
        }
        return this.installablePartSize;
    }

    public BVersion getHighestInstallableVersion() {
        if (this.highestVersionInstallable == null) {
            return this.installable == null ? null : this.installable.getVersion();
        }
        return this.highestVersionInstallable.getVersion();
    }

    public void setLatestAvailableInstallable(BInstallable bInstallable) {
        this.highestVersionInstallable = bInstallable;
    }

    public BVersion getInstallableVersion() {
        return this.installable == null ? null : this.installable.getVersion();
    }

    public String getPartName() {
        return this.installable == null ? this.currentPart.getPartName() : this.installable.getInstallableName();
    }

    public long getSizeDeltaOnCommit() {
        if (this.installStatus == BPartInstallStatus.install) {
            return this.getInstallablePartSize();
        }
        if (this.installStatus == BPartInstallStatus.uninstall) {
            BInstallable bInstallable = this.currentPart.getInstallable();
            if (bInstallable != null) {
                return -1L * bInstallable.getInstallableFileSize();
            }
        } else if (this.installStatus == BPartInstallStatus.upgrade || this.installStatus == BPartInstallStatus.downgrade || this.installStatus == BPartInstallStatus.reinstall) {
            if (this.currentPart.getInstallable() == null) {
                return 0L;
            }
            return this.getInstallablePartSize() - this.currentPart.getInstallable().getInstallableFileSize();
        }
        return 0L;
    }

    public String getType() {
        if (this.currentPart == null) {
            if (this.installable.getPart() == null) {
                return this.installable.getDisplayName(null);
            }
            return BPart.getPartTypeShortName((Type)this.installable.getPart().getType());
        }
        return BPart.getPartTypeShortName((Type)this.currentPart.getType());
    }

    public int hashCode() {
        return this.getPartName().hashCode();
    }

    public boolean isModule() {
        BPart bPart = this.currentPart == null ? this.getInstallablePart() : this.currentPart;
        return bPart instanceof BModulePart;
    }

    public void setCurrentPart(BPart bPart) {
        this.currentPart = bPart;
        this.outOfDate = this.model.oodScenario.getPartStatus(bPart) == BPartInstallStatus.upgrade;
        this.updateRow();
    }

    public void setInstallable(BInstallable bInstallable) {
        if (this.installable != bInstallable) {
            this.installable = bInstallable;
            this.installablePartSize = Long.MIN_VALUE;
            this.updateRow();
        }
    }

    public BInstallable getInstallable() {
        return this.installable;
    }

    public String toString() {
        return this.getPartName();
    }

    public void setForwardDeps(Array array) {
        this.forwardDeps = array;
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                BDependency bDependency = (BDependency)array.get(i);
                if (bDependency.canSolveWith(this.model.scenario.getSolutionParameters().solvers)) continue;
                this.needsCommission = !this.model.scenario.getTargetPlatform().meets(bDependency);
                break;
            }
        }
    }

    public Array getForwardDeps() {
        return this.forwardDeps;
    }

    public Array getDependentParts() {
        Array array = new Array(class$com$tridium$install$part$BPart == null ? (class$com$tridium$install$part$BPart = SoftwareTableRow.class$("com.tridium.install.part.BPart")) : class$com$tridium$install$part$BPart);
        Iterator iterator = this.reverseDepsByRow.keySet().iterator();
        while (iterator.hasNext()) {
            SoftwareTableRow softwareTableRow = (SoftwareTableRow)iterator.next();
            if (softwareTableRow.getInstallablePart() == null) {
                array.add((Object)softwareTableRow.getCurrentPart());
                continue;
            }
            array.add((Object)softwareTableRow.getInstallablePart());
        }
        return array;
    }

    public Map getReverseDeps() {
        return this.reverseDepsByRow;
    }

    public void addReverseDep(SoftwareTableRow softwareTableRow, BDependency bDependency) {
        this.reverseDepsByRow.put(softwareTableRow, bDependency);
    }

    public void clearDeps() {
        this.forwardDeps.clear();
        this.reverseDepsByRow.clear();
    }

    public int getStatus() {
        if (this.currentPart == null) {
            if (this.installable != null) {
                if (this.installable instanceof BModuleInstallable && ((BModulePart)this.installable.getPart()).getStatus() != BModuleStatus.ok) {
                    return 7;
                }
                return this.needsCommission ? 13 : 6;
            }
        } else {
            if (this.installable == null) {
                if (this.currentPart instanceof BModulePart) {
                    BModuleStatus bModuleStatus = ((BModulePart)this.currentPart).getStatus();
                    if (bModuleStatus == BModuleStatus.nomanifest) {
                        return 10;
                    }
                    if (bModuleStatus == BModuleStatus.ok) {
                        return 11;
                    }
                    return 8;
                }
                return 11;
            }
            BVersion bVersion = this.currentPart.getVersion();
            BVersion bVersion2 = this.installable.getPart().getVersion();
            if (this.installable instanceof BModuleInstallable && !((BModulePart)this.installable.getPart()).getStatus().equals((Object)BModuleStatus.ok)) {
                if (this.currentPart instanceof BModulePart && !((BModulePart)this.currentPart).getStatus().equals((Object)BModuleStatus.ok)) {
                    return 9;
                }
                return 7;
            }
            if (this.currentPart instanceof BModulePart && !((BModulePart)this.currentPart).getStatus().equals((Object)BModuleStatus.ok)) {
                return 8;
            }
            switch (bVersion.checkVersionRequirement(bVersion2)) {
                case 2: {
                    if (this.currentPart instanceof BModulePart) {
                        BModulePart bModulePart = (BModulePart)this.currentPart;
                        BModulePart bModulePart2 = (BModulePart)this.installable.getPart();
                        if (bModulePart.getBuildAbsTime() != null && bModulePart2.getBuildAbsTime() != null) {
                            int n = bModulePart2.getBuildAbsTime().compareTo((Object)bModulePart.getBuildAbsTime());
                            if (n > 0) {
                                return this.outOfDate ? 3 : 12;
                            }
                            if (n < 0) {
                                return 1;
                            }
                            return 2;
                        }
                        return 2;
                    }
                    return 2;
                }
                case 16: {
                    return 5;
                }
                case 8: {
                    return this.outOfDate ? 4 : 12;
                }
                case 4: {
                    return this.outOfDate ? 3 : 12;
                }
            }
            return 1;
        }
        return 0;
    }

    public static int getStatus(BInstallable bInstallable, BPart bPart) {
        if (bPart == null) {
            if (bInstallable != null) {
                if (bInstallable instanceof BModuleInstallable && ((BModulePart)bInstallable.getPart()).getStatus() != BModuleStatus.ok) {
                    return 7;
                }
                return 6;
            }
        } else {
            if (bInstallable == null) {
                if (bPart instanceof BModulePart) {
                    BModuleStatus bModuleStatus = ((BModulePart)bPart).getStatus();
                    if (bModuleStatus == BModuleStatus.nomanifest) {
                        return 10;
                    }
                    if (bModuleStatus == BModuleStatus.ok) {
                        return 11;
                    }
                    return 8;
                }
                return 11;
            }
            BVersion bVersion = bPart.getVersion();
            BVersion bVersion2 = bInstallable.getPart().getVersion();
            if (bInstallable instanceof BModuleInstallable && !((BModulePart)bInstallable.getPart()).getStatus().equals((Object)BModuleStatus.ok)) {
                if (bPart instanceof BModulePart && !((BModulePart)bPart).getStatus().equals((Object)BModuleStatus.ok)) {
                    return 9;
                }
                return 7;
            }
            if (bPart instanceof BModulePart && !((BModulePart)bPart).getStatus().equals((Object)BModuleStatus.ok)) {
                return 8;
            }
            switch (bVersion.checkVersionRequirement(bVersion2)) {
                case 2: {
                    if (bPart instanceof BModulePart) {
                        BModulePart bModulePart = (BModulePart)bPart;
                        BModulePart bModulePart2 = (BModulePart)bInstallable.getPart();
                        if (bModulePart.getBuildAbsTime() != null && bModulePart2.getBuildAbsTime() != null) {
                            int n = bModulePart2.getBuildAbsTime().compareTo((Object)bModulePart.getBuildAbsTime());
                            if (n > 0) {
                                return 3;
                            }
                            if (n < 0) {
                                return 1;
                            }
                            return 2;
                        }
                        return 2;
                    }
                    return 2;
                }
                case 16: {
                    return 5;
                }
                case 8: {
                    return 4;
                }
                case 4: {
                    return 3;
                }
            }
            return 1;
        }
        return 0;
    }

    public void updateRow() {
        this.installStatus = this.model.getScenario().getPartStatus(this.getPart());
    }

    public BPart getPart() {
        return this.installable == null ? this.currentPart : this.installable.getPart();
    }

    public BPartInstallStatus getInstallStatus() {
        return this.installStatus;
    }

    public static int getStatusRank(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                return 0;
            }
            case 3: 
            case 4: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 1: 
            case 2: 
            case 5: {
                return 6;
            }
            case 0: 
            case 10: 
            case 11: {
                return 7;
            }
        }
        return 5;
    }

    protected boolean needsCommission() {
        return this.needsCommission;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

