/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BPartInstallStatus;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.ui.table.TableCellRenderer;

public class SoftwareCellRenderer
extends TableCellRenderer {
    public SoftwareTableModel getSoftwareTableModel() {
        return (SoftwareTableModel)this.getTable().getModel();
    }

    public BBrush getForeground(TableCellRenderer.Cell cell) {
        if (cell.column == 3) {
            if (this.getSoftwareTableModel().getInstallStatusAt(cell.row) != BPartInstallStatus.noChange) {
                return BColor.blue.toBrush();
            }
            switch (this.getSoftwareTableModel().getStatusAt(cell.row)) {
                case 6: 
                case 13: {
                    return BColor.blue.toBrush();
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    return BColor.red.toBrush();
                }
            }
        }
        return super.getForeground(cell);
    }

    public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
        int n = this.getSoftwareTableModel().getStatusAt(cell.row);
        if (cell.column == 3) {
            switch (n) {
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    return BColor.red.toBrush();
                }
            }
        }
        return super.getSelectionForeground(cell);
    }

    public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
        String string = this.getCellText(cell);
        double d = Theme.table().getCellFont().width(string) + 12.0;
        if (this.getSoftwareTableModel().getCellIcon(cell.row, cell.column) != null) {
            d += 20.0;
        }
        return d;
    }

    public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
        SoftwareTableModel softwareTableModel = this.getSoftwareTableModel();
        this.paintCellBackground(graphics, cell);
        double d = 2.0;
        double d2 = (cell.height - 16.0) / 2.0;
        BImage bImage = softwareTableModel.getCellIcon(cell.row, cell.column);
        if (bImage != null) {
            graphics.drawImage(bImage, d, d2);
            d += 20.0;
        }
        String string = this.getCellText(cell);
        BFont bFont = Theme.table().getCellFont();
        switch (softwareTableModel.getColumnAlignment(cell.column).getOrdinal()) {
            case 2: {
                d = cell.width - 2.0 - bFont.width(string);
                break;
            }
            case 1: {
                d = (cell.width - bFont.width(string)) / 2.0;
            }
        }
        graphics.setFont(bFont);
        graphics.drawString(string, d, bFont.getAscent() + 2.0);
    }
}

