/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import com.tridium.ui.theme.Theme;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class InstallCommand
extends AsyncCommand {
    private SoftwareTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public static InstallCommand makeInstall(BWidget bWidget, SoftwareTableModel softwareTableModel) {
        return new InstallCommand(bWidget, softwareTableModel, "StationSoftwareView.command.installSelected");
    }

    public static InstallCommand makeReinstall(BWidget bWidget, SoftwareTableModel softwareTableModel) {
        return new InstallCommand(bWidget, softwareTableModel, "StationSoftwareView.command.reinstallSelected");
    }

    public static InstallCommand makeUpgrade(BWidget bWidget, SoftwareTableModel softwareTableModel) {
        return new InstallCommand(bWidget, softwareTableModel, "StationSoftwareView.command.upgradeSelected");
    }

    public static InstallCommand makeDowngrade(BWidget bWidget, SoftwareTableModel softwareTableModel) {
        return new InstallCommand(bWidget, softwareTableModel, "StationSoftwareView.command.downgradeSelected");
    }

    protected InstallCommand(BWidget bWidget, SoftwareTableModel softwareTableModel, String string) {
        super(bWidget, lex, string);
        this.tableModel = softwareTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstallScenario install(BWidget bWidget, SoftwareTableModel softwareTableModel, int[] nArray, boolean bl) throws Exception {
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)bWidget);
        try {
            BWidget bWidget2;
            int n;
            TreeMap<PartSpec, Object> treeMap = new TreeMap<PartSpec, Object>();
            BInstallable[] bInstallableArray = softwareTableModel.getScenario().getToInstall();
            for (n = 0; n < bInstallableArray.length; ++n) {
                treeMap.put(bInstallableArray[n].getPart().getPartSpec(), bInstallableArray[n]);
            }
            for (n = 0; n < nArray.length; ++n) {
                bWidget2 = softwareTableModel.getInstallableAt(nArray[n]);
                treeMap.put(bWidget2.getPart().getPartSpec(), bWidget2);
            }
            bInstallableArray = new BInstallable[treeMap.size()];
            treeMap.values().toArray(bInstallableArray);
            InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)softwareTableModel.getScenario().getTargetPlatform(), (String[])softwareTableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])bInstallableArray, (SolutionParameters)softwareTableModel.getScenario().getSolutionParameters(), (InstallableRegistry)softwareTableModel.getInstallableRegistry());
            if (installScenario.getExcludedInstallables().length > 0) {
                if (bl) {
                    BDialog.error((BWidget)bWidget, (String)lex.getText("InstallCommand.excluded.title"), (Object)lex.getText("InstallCommand.excluded.message"));
                }
            } else if (installScenario.getUnmetDependencies().length > 0) {
                bWidget2 = installScenario.getUnmetDependencies();
                boolean bl2 = false;
                for (int i = 0; i < ((BWidget)bWidget2).length; ++i) {
                    if (bWidget2[i].canSolveWith(installScenario.getSolutionParameters().solvers)) continue;
                    bl2 = true;
                }
                if (bl2) {
                    if (bl) {
                        BDialog.error((BWidget)bWidget, (String)lex.getText("InstallCommand.mustCommission.title"), (Object)lex.getText("InstallCommand.mustCommission.message"));
                    } else {
                        softwareTableModel.setScenario(installScenario);
                    }
                } else if (bl) {
                    BDialog.error((BWidget)bWidget, (String)lex.getText("InstallCommand.unmet.title"), (Object)InstallCommand.makeUnmetDialog(installScenario));
                }
            } else if (bl) {
                bWidget2 = InstallCommand.makeAlsoInstallDialog(treeMap, installScenario);
                if (bWidget2 == null || 1 == BDialog.confirm((BWidget)bWidget, (String)lex.getText("InstallCommand.alsoInstall.title"), (Object)bWidget2, (int)3)) {
                    softwareTableModel.setScenario(installScenario);
                }
            } else {
                softwareTableModel.setScenario(installScenario);
            }
            bWidget2 = installScenario;
            return bWidget2;
        }
        finally {
            if (bWbShell != null) {
                bWbShell.exitBusy();
            }
        }
    }

    public void doInvokeAsync() {
        try {
            InstallCommand.install(this.getOwner(), this.tableModel, this.tableModel.getTable().getSelection().getRows(), true);
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
    }

    public static BWidget makeAlsoInstallDialog(Map map, InstallScenario installScenario) {
        BPart bPart;
        BIndentPane bIndentPane = null;
        BInstallable[] bInstallableArray = installScenario.getToInstall();
        for (int i = 0; i < bInstallableArray.length; ++i) {
            bPart = bInstallableArray[i].getPart();
            if (map.containsKey(bPart.getPartSpec())) continue;
            if (bIndentPane == null) {
                bIndentPane = new BIndentPane();
                bIndentPane.add(LexiconText.make((String)"provisioningNiagara", (String)"InstallCommand.alsoInstall.header"));
                bIndentPane.indent();
            }
            bIndentPane.add(bInstallableArray[i].getInstallableFileName());
        }
        if (bIndentPane == null) {
            return null;
        }
        bIndentPane.unindent();
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane(bIndentPane, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        bPart = new BConstrainedPane((BWidget)bScrollPane);
        bPart.setFixedSize(275.0, 300.0);
        return new BEdgePane(null, null, null, null, (BWidget)bPart);
    }

    public static BWidget makeUnmetDialog(InstallScenario installScenario) {
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.add(LexiconText.make((String)"provisioningNiagara", (String)"InstallCommand.unmet.heading"));
        BDependency[] bDependencyArray = installScenario.getUnmetDependencies();
        bIndentPane.indent();
        for (int i = 0; i < bDependencyArray.length; ++i) {
            if (!bDependencyArray[i].canSolveWith(installScenario.getSolutionParameters().solvers)) continue;
            bIndentPane.add(bDependencyArray[i].toString());
        }
        bIndentPane.unindent();
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
        bConstrainedPane.setFixedSize(275.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)bConstrainedPane);
    }
}

