/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.program;

import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.provisioningNiagara.BNiagaraNetworkBatchAgent;
import com.tridium.provisioningNiagara.program.BProvisioningRobot;
import com.tridium.provisioningNiagara.program.BRobotJobStep;
import com.tridium.provisioningNiagara.ui.program.ProvisioningCompiler;
import com.tridium.provisioningNiagara.ui.program.ProvisioningRobotEditorCommands;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.console.BConsole;
import java.io.File;
import javax.baja.batchJob.BValueList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.JavaParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BProvisioningRobotEditor
extends BWbComponentView
implements BConsole.HyperlinkInterceptor {
    public static final Action codeTextModified = BProvisioningRobotEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$ui$program$BProvisioningRobotEditor == null ? (class$com$tridium$provisioningNiagara$ui$program$BProvisioningRobotEditor = BProvisioningRobotEditor.class$("com.tridium.provisioningNiagara.ui.program.BProvisioningRobotEditor")) : class$com$tridium$provisioningNiagara$ui$program$BProvisioningRobotEditor));
    protected static String defaultDepends = "program";
    protected static String boilerplate = "// depends: " + defaultDepends + "\n" + "\n" + "import javax.baja.sys.*;\n" + "\n" + "/*\n" + " Provisioning Robot Programming Tips\n" + " -----------------------------------\n" + " \n" + " 1) The class must be named RobotImpl, and must extend com.tridium.program.Robot.\n" + " 2) List any direct module dependencies at the top of the source, using a comment:\n" + "      \"// depends:\" module [ \"; \" module ] ...\n" + "    Additional modules required by the listed modules will be identified automatically - for\n" + "    example, it is not necessary to list baja if a module that depends on baja is also listed.\n" + "    Note that the robot will fail to run on any station that is missing any of the required\n" + "    modules.\n" + " 3) The only method required to be implemented by Robot subclasses is run().\n" + " 4) The robot is compiled against the \"j2me\" profile, so a number of Java API classes and methods\n" + "    available in the \"j2se\" profile will not be available.  That profile is based on IBM's jclMax\n" + "    class library, whose API javadoc is not available for reference.   However, it's generally\n" + "    safe to code against the Foundation Profile (see http://java.sun.com/products/foundation/) if\n" + "    you avoid the security packages.\n" + " 5) Text written to System.out will appear in each station's console output, accessible by connecting\n" + "    to the stations using the Application Director platform view.   Programmers will probably find\n" + "    it more useful to send text output to the Robot superclass' \"log\" variable instead.  All text\n" + "    written to \"log\" will be stored with the job's step execution details.\n" + " 6) To find results for completed robot executions, you can use the Station Job List view on a\n" + "    particular station's StationProxy extension, or the Niagara Network Job List view on the\n" + "    network's provisioning extension.\n" + " 7) Robots can be sent to stations for execution only when the stations have a Program Service.\n" + "    The job step will fail for the station if the Program Service is missing.\n" + " 8) Robots containing inner classes will only run on stations having version 3.4 or higher of \n" + "    the program module. \n" + " */ \n" + "public class RobotImpl\n" + "  extends com.tridium.program.Robot\n" + "{\n" + "\n" + "  public void run()\n" + "    throws Exception\n" + "  {\n" + "    process(Sys.getStation());\n" + "  }\n" + "\n" + "  public void process(BComponent c)\n" + "    throws Exception\n" + "  {\n" + "    // do something here\n" + "    log.println(c.toPathString() + \" [\" + c.getType() + \"]\");\n" + "    \n" + "    // recurse\n" + "    BComponent[] kids = c.getChildComponents();\n" + "    for(int i=0; i<kids.length; ++i)\n" + "      process(kids[i]);\n" + "  }\n" + "\n" + "}\n";
    protected static UiLexicon uiLex = UiLexicon.bajaui;
    protected static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    static String statusOk = uiLex.getText("programEditor.status.ok");
    static String statusNeedsCompile = uiLex.getText("programEditor.status.needsCompile");
    static String statusError = uiLex.getText("programEditor.status.error");
    static BImage statusOkIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    static BImage statusNeedsCompileIcon = BImage.make((String)"module://icons/x16/shapes/circleGold.png");
    static BImage statusErrorIcon = BImage.make((String)"module://icons/x16/shapes/circleRed.png");
    protected ProvisioningRobotEditorCommands commands = new ProvisioningRobotEditorCommands(this);
    protected BTextEditor editor;
    protected BLabel status;
    protected ProvisioningCompiler compiler = new ProvisioningCompiler(this);
    protected boolean modified = false;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$program$BProvisioningRobotEditor;

    public void codeTextModified() {
        this.invoke(codeTextModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BProvisioningRobotEditor() {
        this.editor = new BTextEditor();
        this.editor.setParser((TextParser)new JavaParser());
        this.linkTo(null, (BComponent)this.editor, (Slot)BTextEditor.textModified, (Slot)codeTextModified);
        this.setTransferWidget((BTransferWidget)this.editor);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(8, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(9, true);
        this.setCommandEnabled(10, true);
        this.status = new BLabel("status not initialized");
        this.status.setHalign(BHalign.left);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.status, 5.0, 0.0, 10.0, 0.0);
        BTextEditorPane bTextEditorPane = new BTextEditorPane(this.editor);
        this.setContent((BWidget)new BEdgePane((BWidget)bBorderPane, null, null, null, (BWidget)bTextEditorPane));
        this.linkTo("lk0", (BComponent)bTextEditorPane.getEditor(), (Slot)BTextEditor.textModified, (Slot)setModified);
    }

    public void updateStatus() {
        if (this.modified || this.compiler.getClassName() == null || this.computeChecksum() != this.compiler.checksum) {
            this.status.setText(statusNeedsCompile);
            this.status.setImage(statusNeedsCompileIcon);
        } else {
            this.status.setText(statusOk);
            this.status.setImage(statusOkIcon);
        }
    }

    public void updateStatusToError() {
        this.status.setText(statusError);
        this.status.setImage(statusErrorIcon);
    }

    public int computeChecksum() {
        return this.editor.getText().hashCode();
    }

    public void doCodeTextModified() {
        if (!this.isModifiedStateLocked()) {
            this.setModified();
            this.modified = true;
            this.updateStatus();
        }
    }

    public void notifyCodeTextUpToDate() {
        this.modified = false;
    }

    public BMenu[] getViewMenus() {
        return this.commands.getViewMenus();
    }

    public BToolBar getViewToolBar() {
        return this.commands.getViewToolBar();
    }

    protected void doLoadValue(BObject bObject, Context context) {
        BProvisioningRobot bProvisioningRobot = (BProvisioningRobot)bObject;
        bProvisioningRobot.lease(Integer.MAX_VALUE);
        this.compiler.load(bProvisioningRobot);
        if (bProvisioningRobot.getSource().trim().length() == 0) {
            this.editor.setText(boilerplate);
        } else {
            this.editor.setText(bProvisioningRobot.getSource());
        }
        this.updateStatus();
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BProvisioningRobot bProvisioningRobot = (BProvisioningRobot)bObject;
        this.compiler.saveRobot(bProvisioningRobot, this.getSource(), this.getDependencies());
        this.modified = false;
        this.updateStatus();
        return bProvisioningRobot;
    }

    public void submitJob() throws Exception {
        BProvisioningRobot bProvisioningRobot = (BProvisioningRobot)this.saveValue();
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(this.getCurrentValue());
        bNiagaraNetwork.lease(1);
        DefaultListModel defaultListModel = new DefaultListModel();
        BDevice[] bDeviceArray = BNiagaraNetworkBatchAgent.INSTANCE.listBatchDevices((BDeviceNetwork)bNiagaraNetwork);
        if (bDeviceArray.length == 0) {
            BDialog.message((BWidget)this, (String)lex.getText("ProvisioningRobotEditor.noStations.dlgTitle"), (Object)lex.getText("ProvisioningRobotEditor.noStations.dlgMessage"));
            return;
        }
        for (int i = 0; i < bDeviceArray.length; ++i) {
            defaultListModel.addItem(BImage.make((BIcon)bDeviceArray[i].getIcon()), (Object)new StationItem(bDeviceArray[i]));
        }
        BCheckList bCheckList = new BCheckList();
        bCheckList.setModel((ListModel)defaultListModel);
        if (bDeviceArray.length == 1) {
            bCheckList.getSelection().select(0, true);
        }
        BBrush bBrush = Theme.scrollPane().getControlBackground();
        BScrollPane bScrollPane = new BScrollPane((BWidget)bCheckList);
        bScrollPane.setViewportBackground(bBrush);
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        bFlowPane.add("label", (BValue)new BLabel(lex.getText("ProvisioningRobotEditor.stations.dlgMessage")));
        if (1 == BCommandDialog.open((BWidget)this, (String)lex.getText("ProvisioningRobotEditor.stations.dlgTitle"), (Object)new BBorderPane((BWidget)new BEdgePane((BWidget)bFlowPane, (BWidget)new BBox(250.0, 0.0), (BWidget)new BBox(0.0, 300.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{new CheckAllCommand(bCheckList), DialogCommand.makeOk((BWidget)this), DialogCommand.makeCancel((BWidget)this)})) {
            BOrd bOrd;
            StringBuffer stringBuffer = new StringBuffer("provisioningNiagara:NiagaraNetworkJobBuilder?");
            int[] nArray = bCheckList.getSelection().getItems();
            if (nArray.length > 0) {
                bOrd = null;
                for (int i = 0; i < nArray.length; ++i) {
                    BString bString = BString.make((String)((StationItem)bCheckList.getModel().getItem(nArray[i])).getStationName());
                    bOrd = bOrd == null ? BValueList.make((BValue)bString) : BValueList.add((BValueList)bOrd, (BValue)bString);
                }
                stringBuffer.append("stations=");
                stringBuffer.append(ViewQueryParameter.encode(bOrd));
                stringBuffer.append(';');
            }
            stringBuffer.append("steps=");
            stringBuffer.append(ViewQueryParameter.encode((BIEncodable)new BRobotJobStep(bProvisioningRobot)));
            bOrd = BOrd.make((BOrd)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt"), (OrdQuery)new ViewQuery(stringBuffer.toString()));
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
            bWbShell.hyperlink(bOrd);
        }
    }

    public CommandArtifact invokeCommand(int n) throws Exception {
        switch (n) {
            case 6: {
                return this.editor.doFind();
            }
            case 8: {
                return this.editor.doFindNext();
            }
            case 7: {
                return this.editor.doFindPrev();
            }
            case 9: {
                return this.editor.doReplace();
            }
            case 10: {
                return this.editor.doGoto();
            }
        }
        return super.invokeCommand(n);
    }

    public String getDependencies() {
        String string = this.getSource();
        if (string.startsWith("// depends:")) {
            int n = string.indexOf(58);
            int n2 = string.indexOf(10);
            if (n >= 0 && n2 >= 0) {
                return string.trim().substring(n + 1, n2);
            }
            return defaultDepends;
        }
        return defaultDepends;
    }

    public String getSource() {
        return this.editor.getText();
    }

    public boolean consoleHyperlink(File file, int n, int n2, int n3, int n4) {
        if (!file.equals(this.compiler.java)) {
            return false;
        }
        this.highlight(n, n2, n3, n4);
        return true;
    }

    public void highlight(int n, int n2, int n3, int n4) {
        this.highlight(this.editor, n, n2, n3, n4);
    }

    void highlight(BTextEditor bTextEditor, int n, int n2, int n3, int n4) {
        Position position = bTextEditor.getModel().getEndPosition();
        Position position2 = new Position(n - 1, n2 - 1);
        Position position3 = new Position(n3 - 1, n4);
        if (position2.compareTo((Object)position) > 0) {
            position2 = position;
        }
        if (position3.compareTo((Object)position) > 0) {
            position3 = position;
        }
        bTextEditor.getSelection().select(position2, position3);
        bTextEditor.moveCaretPosition(position3);
        bTextEditor.requestFocus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class StationItem {
        private BNiagaraStation station;

        public StationItem(BDevice bDevice) {
            this.station = (BNiagaraStation)bDevice;
        }

        public String toString() {
            return this.station.getDisplayName(null);
        }

        public String getStationName() {
            return this.station.getStationName();
        }
    }

    private class CheckAllCommand
    extends DialogCommand {
        private BCheckList checkList;

        public CheckAllCommand(BCheckList bCheckList) {
            super((BWidget)BProvisioningRobotEditor.this, -1, lex, "ProvisioningRobotEditor.stations.checkAll");
            this.checkList = bCheckList;
        }

        public CommandArtifact doInvoke() {
            try {
                this.checkList.getSelection().selectAll();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }
}

