/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.license;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.ExtPathFilter;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.provisioningNiagara.license.BSupervisorLicenses;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

public class BSupervisorLicenseTree
extends BTree {
    public static final Action handleSelectionModified = BSupervisorLicenseTree.newAction((int)0, null);
    public static final Topic valueUpdated = BSupervisorLicenseTree.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$ui$license$BSupervisorLicenseTree == null ? (class$com$tridium$provisioningNiagara$ui$license$BSupervisorLicenseTree = BSupervisorLicenseTree.class$("com.tridium.provisioningNiagara.ui.license.BSupervisorLicenseTree")) : class$com$tridium$provisioningNiagara$ui$license$BSupervisorLicenseTree));
    private static final BIcon HOST_ICON = BIcon.std((String)"host.png");
    private static final BIcon LICENSE_ICON = BIcon.std((String)"file.png");
    private static final IFileFilter LAR_FILTER = new ExtFileFilter("TODO", "lar");
    private static final IFilePathFilter LAR_PATH_FILTER = new ExtPathFilter("lar");
    private static final IFileFilter LICENSE_FILTER = new ExtFileFilter("TODO", "license,lar");
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private Command importFile = new ImportFile();
    private Command exportFile = new ExportFile();
    private Command delete = new Delete();
    private SyncOnline syncOnline = new SyncOnline();
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$license$BSupervisorLicenseTree;
    static /* synthetic */ Class class$com$tridium$sys$license$dom$VendorCertificate;
    static /* synthetic */ Class class$com$tridium$sys$license$dom$VendorLicense;
    static /* synthetic */ Class class$com$tridium$platform$license$BEnvLicenseSummary;

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public void fireValueUpdated(BValue bValue) {
        this.fire(valueUpdated, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSupervisorLicenseTree() {
        this.setModel(new Model());
        this.setMultipleSelection(true);
        this.linkTo(null, (BComponent)this, (Slot)BTree.selectionModified, (Slot)handleSelectionModified);
    }

    public String getDetailsText() throws Exception {
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        if (treeNodeArray.length == 1 && treeNodeArray[0] instanceof LicenseNode) {
            return ((LicenseNode)treeNodeArray[0]).getContents();
        }
        return "";
    }

    public void importLicenseArchive(BLicenseArchiveFile bLicenseArchiveFile, Context context) throws Exception {
        this.getSupervisorLicenses().importLicenseFile((BIFile)bLicenseArchiveFile);
        this.reload();
        BDialog.message((BWidget)this, (Object)LEX.getText("SupervisorLicenseTree.importFile.success"));
    }

    public void load(BSupervisorLicenses bSupervisorLicenses, Context context) throws Exception {
        ((Model)this.getModel()).load(bSupervisorLicenses, context);
    }

    public void reload() throws Exception {
        ((Model)this.getModel()).reload();
    }

    public Command[] getCommands() {
        return new Command[]{this.importFile, this.exportFile, this.delete, this.syncOnline};
    }

    public BSupervisorLicenses getSupervisorLicenses() {
        return ((Model)this.getModel()).getSupervisorLicenses();
    }

    public int dragOver(TransferContext transferContext) {
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                if (!(bObjectArray[i] instanceof BLicenseFile) && !(bObjectArray[i] instanceof BLicenseArchiveFile)) continue;
                return 16;
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            boolean bl = false;
            for (int i = 0; i < bObjectArray.length; ++i) {
                if (!(bObjectArray[i] instanceof BLicenseFile) && !(bObjectArray[i] instanceof BLicenseArchiveFile)) continue;
                this.getSupervisorLicenses().importLicenseFile((BIFile)bObjectArray[i]);
                bl = true;
            }
            if (bl) {
                this.reload();
                BDialog.message((BWidget)this, (Object)LEX.getText("SupervisorLicenseTree.importFile.success"));
            }
        }
        return null;
    }

    public void doHandleSelectionModified() {
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        this.delete.setEnabled(treeNodeArray.length > 0);
        this.fireValueUpdated(null);
    }

    private String[] getSelectedHostIds() {
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < treeNodeArray.length; ++i) {
            if (treeNodeArray[i] instanceof HostNode) {
                hashSet.add(((HostNode)treeNodeArray[i]).getHostId());
                continue;
            }
            hashSet.add(((LicenseNode)treeNodeArray[i]).getHostId());
        }
        String[] stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SyncOnline
    extends AsyncCommand {
        public boolean canceled = false;

        public SyncOnline() {
            super((BWidget)BSupervisorLicenseTree.this, LEX.getText("SupervisorLicenseTree.syncOnline.label"), null, null, LEX.getText("SupervisorLicenseTree.syncOnline.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block30: {
                try {
                    int n;
                    VendorLicense[] vendorLicenseArray;
                    int n2;
                    VendorCertificate[] vendorCertificateArray;
                    TreeNode[] treeNodeArray = BSupervisorLicenseTree.this.getSelection().getNodes();
                    int n3 = 0;
                    int n4 = 0;
                    Array array = new Array(class$com$tridium$sys$license$dom$VendorCertificate == null ? (class$com$tridium$sys$license$dom$VendorCertificate = BSupervisorLicenseTree.class$("com.tridium.sys.license.dom.VendorCertificate")) : class$com$tridium$sys$license$dom$VendorCertificate);
                    HashSet<String> hashSet = new HashSet<String>();
                    BCertificateSummary[] bCertificateSummaryArray = BSupervisorLicenseTree.this.getSupervisorLicenses().getCertificateSummaries();
                    if (PortalLicenseUtil.requestLicensesOnline()) {
                        vendorCertificateArray = PortalLicenseUtil.getPortalUpdates((BCertificateSummary[])bCertificateSummaryArray);
                        for (n2 = 0; n2 < vendorCertificateArray.length; ++n2) {
                            array.add((Object)vendorCertificateArray[n2]);
                            CertificateDatabase.LOCAL_INSTANCE.add(vendorCertificateArray[n2]);
                            hashSet.add(vendorCertificateArray[n2].getVendor());
                        }
                    }
                    vendorCertificateArray = PortalLicenseUtil.getUpdatedCertificates((BCertificateSummary[])bCertificateSummaryArray, (CertificateDatabase)CertificateDatabase.LOCAL_INSTANCE);
                    for (n2 = 0; n2 < vendorCertificateArray.length; ++n2) {
                        if (hashSet.contains(vendorCertificateArray[n2].getVendor())) continue;
                        array.add((Object)vendorCertificateArray[n2]);
                    }
                    if (treeNodeArray.length == 0) {
                        if (4 != BDialog.confirm((BWidget)BSupervisorLicenseTree.this, (String)LEX.getText("SupervisorLicenseTree.syncAll.confirmTitle"), (Object)LEX.getText("SupervisorLicenseTree.syncAll.confirmMessage"))) {
                            return;
                        }
                        this.canceled = false;
                        BLabel bLabel = new BLabel(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{"0"}));
                        bLabel.setHalign(BHalign.left);
                        BDialog bDialog = new BDialog(this.getOwner(), LEX.getText("SupervisorLicenseTree.syncAll.workingTitle"), false, (BWidget)new BEdgePane((BWidget)new BBox(300.0, 0.0), (BWidget)new BBorderPane((BWidget)new BButtonPane(new Command[]{new CancelSync()}), 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)bLabel, 10.0, 10.0, 10.0, 10.0)));
                        bDialog.setBoundsCenteredOnOwner();
                        bDialog.open();
                        try {
                            VendorLicense[] vendorLicenseArray2;
                            Array array2 = new Array(class$com$tridium$sys$license$dom$VendorLicense == null ? (class$com$tridium$sys$license$dom$VendorLicense = BSupervisorLicenseTree.class$("com.tridium.sys.license.dom.VendorLicense")) : class$com$tridium$sys$license$dom$VendorLicense);
                            BEnvLicenseSummary[] bEnvLicenseSummaryArray = BSupervisorLicenseTree.this.getSupervisorLicenses().licenseIterator();
                            while (bEnvLicenseSummaryArray.hasNext()) {
                                int n5;
                                VendorLicense[] vendorLicenseArray3;
                                if (this.canceled) {
                                    array2.clear();
                                    break;
                                }
                                array2.add(bEnvLicenseSummaryArray.next());
                                if (array2.size() < 100) continue;
                                vendorLicenseArray2 = BEnvLicenseSummary.make((VendorLicense[])((VendorLicense[])array2.trim()));
                                array2.clear();
                                if (PortalLicenseUtil.requestLicensesOnline()) {
                                    vendorLicenseArray3 = PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])vendorLicenseArray2);
                                    for (n5 = 0; n5 < vendorLicenseArray3.length; ++n5) {
                                        LicenseDatabase.LOCAL_INSTANCE.add(vendorLicenseArray3[n5]);
                                        if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(vendorLicenseArray3[n5])) continue;
                                        bLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{String.valueOf(++n3)}));
                                    }
                                }
                                vendorLicenseArray3 = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])vendorLicenseArray2, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
                                for (n5 = 0; n5 < vendorLicenseArray3.length; ++n5) {
                                    if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(vendorLicenseArray3[n5])) continue;
                                    bLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{String.valueOf(++n3)}));
                                }
                            }
                            if (array2.size() > 0) {
                                bEnvLicenseSummaryArray = BEnvLicenseSummary.make((VendorLicense[])((VendorLicense[])array2.trim()));
                                array2.clear();
                                if (PortalLicenseUtil.requestLicensesOnline()) {
                                    vendorLicenseArray2 = PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])bEnvLicenseSummaryArray);
                                    for (int i = 0; i < vendorLicenseArray2.length; ++i) {
                                        LicenseDatabase.LOCAL_INSTANCE.add(vendorLicenseArray2[i]);
                                        if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(vendorLicenseArray2[i])) continue;
                                        bLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{String.valueOf(++n3)}));
                                    }
                                }
                                vendorLicenseArray2 = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])bEnvLicenseSummaryArray, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
                                for (int i = 0; i < vendorLicenseArray2.length; ++i) {
                                    if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(vendorLicenseArray2[i])) continue;
                                    bLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{String.valueOf(++n3)}));
                                }
                            }
                            for (int i = 0; i < array.size(); ++i) {
                                if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add((VendorCertificate)array.get(i))) continue;
                                bLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.cert.working", new Object[]{String.valueOf(++n4)}));
                            }
                        }
                        finally {
                            bDialog.close();
                        }
                        if (n3 > 0 || n4 > 0) {
                            BSupervisorLicenseTree.this.reload();
                        }
                        BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("SupervisorLicenseTree.syncOnline.completeTitle"), (Object)new BEdgePane((BWidget)new BBox(300.0, 1.0), null, null, null, (BWidget)new BLabel(LEX.getText("SupervisorLicenseTree.syncOnline.completeMessage", new Object[]{String.valueOf(n3), String.valueOf(n4)}), BHalign.left)));
                        break block30;
                    }
                    Array array3 = new Array(class$com$tridium$platform$license$BEnvLicenseSummary == null ? (class$com$tridium$platform$license$BEnvLicenseSummary = BSupervisorLicenseTree.class$("com.tridium.platform.license.BEnvLicenseSummary")) : class$com$tridium$platform$license$BEnvLicenseSummary);
                    for (int i = 0; i < treeNodeArray.length; ++i) {
                        if (treeNodeArray[i] instanceof HostNode) {
                            vendorLicenseArray = (HostNode)treeNodeArray[i];
                            LicenseNode[] licenseNodeArray = vendorLicenseArray.getChildren();
                            for (int j = 0; j < licenseNodeArray.length; ++j) {
                                array3.add((Object)BEnvLicenseSummary.make((VendorLicense)licenseNodeArray[j].getVendorLicense()));
                            }
                            continue;
                        }
                        vendorLicenseArray = (LicenseNode)treeNodeArray[i];
                        array3.add((Object)BEnvLicenseSummary.make((VendorLicense)vendorLicenseArray.getVendorLicense()));
                    }
                    BEnvLicenseSummary[] bEnvLicenseSummaryArray = (BEnvLicenseSummary[])array3.trim();
                    if (PortalLicenseUtil.requestLicensesOnline()) {
                        vendorLicenseArray = PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])bEnvLicenseSummaryArray);
                        for (int i = 0; i < vendorLicenseArray.length; ++i) {
                            LicenseDatabase.LOCAL_INSTANCE.add(vendorLicenseArray[i]);
                            if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(vendorLicenseArray[i])) continue;
                            ++n3;
                        }
                    }
                    vendorLicenseArray = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])bEnvLicenseSummaryArray, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
                    for (n = 0; n < vendorLicenseArray.length; ++n) {
                        if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(vendorLicenseArray[n])) continue;
                        ++n3;
                    }
                    for (n = 0; n < array.size(); ++n) {
                        if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add((VendorCertificate)array.get(n))) continue;
                        ++n4;
                    }
                    if (n3 > 0 || n4 > 0) {
                        BSupervisorLicenseTree.this.reload();
                    }
                    BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("SupervisorLicenseTree.syncOnline.completeTitle"), (Object)LEX.getText("SupervisorLicenseTree.syncOnline.completeMessage", new Object[]{String.valueOf(n3), String.valueOf(n4)}));
                }
                catch (Exception exception) {
                    CommandUtil.error((Command)this, (Throwable)exception);
                }
            }
        }
    }

    private class CancelSync
    extends Command {
        public CancelSync() {
            super((BWidget)BSupervisorLicenseTree.this, UiLexicon.bajaui().getText("cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            ((BSupervisorLicenseTree)BSupervisorLicenseTree.this).syncOnline.canceled = true;
            return null;
        }
    }

    private class Delete
    extends Command {
        public Delete() {
            super((BWidget)BSupervisorLicenseTree.this, LEX.getText("SupervisorLicenseTree.delete.label"), null, null, LEX.getText("SupervisorLicenseTree.delete.description"));
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() throws Exception {
            TreeNode[] treeNodeArray = BSupervisorLicenseTree.this.getSelection().getNodes();
            if (treeNodeArray.length > 0 && 4 == BDialog.confirm((BWidget)BSupervisorLicenseTree.this, (String)LEX.getText("SupervisorLicenseTree.delete.confirmTitle"), (Object)LEX.getText("SupervisorLicenseTree.delete.confirmMessage"))) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    if (treeNodeArray[i] instanceof HostNode) {
                        for (int j = 0; j < treeNodeArray[i].getChildCount(); ++j) {
                            BSupervisorLicenseTree.this.getSupervisorLicenses().remove(((LicenseNode)treeNodeArray[i].getChild(j)).getVendorLicense());
                        }
                        continue;
                    }
                    BSupervisorLicenseTree.this.getSupervisorLicenses().remove(((LicenseNode)treeNodeArray[i]).getVendorLicense());
                }
                BSupervisorLicenseTree.this.getSelection().deselectAll();
                BSupervisorLicenseTree.this.reload();
            }
            return null;
        }
    }

    private class ExportFile
    extends Command {
        public ExportFile() {
            super((BWidget)BSupervisorLicenseTree.this, LEX.getText("SupervisorLicenseTree.exportFile.label"), null, null, LEX.getText("SupervisorLicenseTree.exportFile.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            TreeNode[] treeNodeArray = BSupervisorLicenseTree.this.getSelection().getNodes();
            if (treeNodeArray.length == 0 && 8 == BDialog.confirm((BWidget)BSupervisorLicenseTree.this, (String)LEX.getText("SupervisorLicenseTree.exportFile.confirmTitle"), (Object)LEX.getText("SupervisorLicenseTree.exportFile.confirmMessage"))) {
                return null;
            }
            BDirectory bDirectory = FavoriteDirectory.loadByPath((String)TYPE.toString(), (String)"larDir", null);
            FilePath filePath = BFileChooserDialog.chooseFilePath((BWidget)BSupervisorLicenseTree.this, null, (String)LEX.getText("SupervisorLicenseTree.exportFile.title"), (String)LEX.getText("SupervisorLicenseTree.exportFile.message"), (BIFile)bDirectory, (IFileFilter)LAR_FILTER, (IFilePathFilter)LAR_PATH_FILTER, null, (String)"licenses.lar");
            if (filePath == null) {
                return null;
            }
            BIFile bIFile = BFileSystem.INSTANCE.findFile(filePath);
            if (bIFile == null) {
                bIFile = BFileSystem.INSTANCE.makeFile(filePath);
            } else if (8 == BDialog.confirm((BWidget)BSupervisorLicenseTree.this, (String)LEX.getText("SupervisorLicenseTree.exportFile.replaceTitle"), (Object)LEX.getText("SupervisorLicenseTree.exportFile.replaceMessage", new Object[]{filePath.getName()}))) {
                return null;
            }
            FavoriteDirectory.savePath((String)TYPE.toString(), (String)"larDir", (BDirectory)((BDirectory)bIFile.getNavParent()));
            OutputStream outputStream = bIFile.getOutputStream();
            try {
                if (treeNodeArray.length == 0) {
                    BSupervisorLicenseTree.this.getSupervisorLicenses().exportLicenses(outputStream);
                } else {
                    BSupervisorLicenseTree.this.getSupervisorLicenses().exportLicenses(BSupervisorLicenseTree.this.getSelectedHostIds(), outputStream);
                }
                BDialog.message((BWidget)BSupervisorLicenseTree.this, (Object)LEX.getText("SupervisorLicenseTree.exportFile.success"));
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            return null;
        }
    }

    private class ImportFile
    extends Command {
        public ImportFile() {
            super((BWidget)BSupervisorLicenseTree.this, LEX.getText("SupervisorLicenseTree.importFile.label"), null, null, LEX.getText("SupervisorLicenseTree.importFile.description"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BIFile bIFile = BFileChooserDialog.chooseFile((BWidget)BSupervisorLicenseTree.this, null, (String)LEX.getText("SupervisorLicenseTree.importFile.title"), (String)LEX.getText("SupervisorLicenseTree.importFile.message"), (BIFile)FavoriteDirectory.loadByPath((String)TYPE.toString(), (String)"larDir", null), (IFileFilter)LICENSE_FILTER, (IFileFilter)LICENSE_FILTER);
            if (bIFile == null) {
                return null;
            }
            BSupervisorLicenseTree.this.getSupervisorLicenses().importLicenseFile(bIFile);
            BSupervisorLicenseTree.this.reload();
            BDialog.message((BWidget)BSupervisorLicenseTree.this, (Object)LEX.getText("SupervisorLicenseTree.importFile.success"));
            return null;
        }
    }

    private class LicenseNode
    extends TreeNode {
        private VendorLicense vendorLicense;
        private Context cx;

        public LicenseNode(HostNode hostNode, VendorLicense vendorLicense, Context context) {
            super((TreeNode)hostNode);
            this.update(vendorLicense);
            this.cx = context;
        }

        public String getText() {
            return LicenseInfo.getSummaryText((VendorLicense)this.vendorLicense, (Context)this.cx);
        }

        public boolean update(VendorLicense vendorLicense) {
            if (this.vendorLicense == null || !vendorLicense.getSignature().equals(this.vendorLicense.getSignature())) {
                this.vendorLicense = vendorLicense;
                return true;
            }
            return false;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)LICENSE_ICON);
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int n) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public VendorLicense getVendorLicense() {
            return this.vendorLicense;
        }

        public String getHostId() {
            return this.getVendorLicense().getHostId();
        }

        public String getContents() throws Exception {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.vendorLicense.save((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
    }

    private class HostNode
    extends TreeNode {
        private String hostId;
        private LicenseNode[] children = null;
        private Context cx;

        public HostNode(TreeModel treeModel, String string, Context context) {
            super(treeModel);
            this.hostId = string;
            this.cx = context;
        }

        public String getHostId() {
            return this.hostId;
        }

        public String getText() {
            return this.getHostId();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)HOST_ICON);
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeNode getChild(int n) {
            return this.getChildren()[n];
        }

        public synchronized boolean update() throws Exception {
            if (this.children == null) {
                return false;
            }
            TreeMap<String, LicenseNode> treeMap = new TreeMap<String, LicenseNode>();
            TreeSet<String> treeSet = new TreeSet<String>();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this.children.length; ++i) {
                treeSet.add(this.children[i].getText());
                treeMap.put(this.children[i].getText(), this.children[i]);
            }
            VendorLicense[] vendorLicenseArray = this.getSupervisorLicenses().getLicenses(this.hostId);
            for (int i = 0; i < vendorLicenseArray.length; ++i) {
                String string = LicenseInfo.getSummaryText((VendorLicense)vendorLicenseArray[i], (Context)this.cx);
                LicenseNode licenseNode = (LicenseNode)((Object)treeMap.get(string));
                if (licenseNode == null) {
                    treeMap.put(string, new LicenseNode(this, vendorLicenseArray[i], this.cx));
                    bl = true;
                    bl2 = true;
                    continue;
                }
                bl = licenseNode.update(vendorLicenseArray[i]) || bl;
                treeSet.remove(licenseNode.getText());
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                treeMap.remove(iterator.next());
                bl2 = true;
                bl = true;
            }
            if (bl2) {
                this.children = new LicenseNode[treeMap.size()];
                treeMap.values().toArray(this.children);
            }
            return bl;
        }

        public LicenseNode[] getChildren() {
            try {
                if (this.children == null) {
                    VendorLicense[] vendorLicenseArray = this.getSupervisorLicenses().getLicenses(this.hostId);
                    this.children = new LicenseNode[vendorLicenseArray.length];
                    for (int i = 0; i < vendorLicenseArray.length; ++i) {
                        this.children[i] = new LicenseNode(this, vendorLicenseArray[i], this.cx);
                    }
                }
                return this.children;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public BSupervisorLicenses getSupervisorLicenses() {
            return ((Model)this.getModel()).getSupervisorLicenses();
        }
    }

    private class Model
    extends TreeModel {
        private HostNode[] hostNodes = new HostNode[0];
        private Context cx;
        private BSupervisorLicenses supervisorLicenses = null;

        private Model() {
        }

        public synchronized void load(BSupervisorLicenses bSupervisorLicenses, Context context) throws Exception {
            int n;
            this.supervisorLicenses = bSupervisorLicenses;
            this.cx = context;
            String[] stringArray = this.supervisorLicenses.getLicensedHostIds();
            TreeMap<String, HostNode> treeMap = new TreeMap<String, HostNode>();
            boolean bl = false;
            boolean bl2 = false;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (n = 0; n < this.hostNodes.length; ++n) {
                treeMap.put(this.hostNodes[n].getHostId(), this.hostNodes[n]);
                treeSet.add(this.hostNodes[n].getHostId());
            }
            for (n = 0; n < stringArray.length; ++n) {
                HostNode hostNode = (HostNode)((Object)treeMap.get(stringArray[n]));
                if (hostNode == null) {
                    treeMap.put(stringArray[n], new HostNode(this, stringArray[n], context));
                    bl2 = true;
                    continue;
                }
                treeSet.remove(stringArray[n]);
                bl = hostNode.update() || bl;
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                treeMap.remove(iterator.next());
                bl2 = true;
            }
            if (bl2) {
                bl = true;
                this.hostNodes = new HostNode[treeMap.size()];
                treeMap.values().toArray(this.hostNodes);
            }
            if (bl) {
                this.updateTree();
                BSupervisorLicenseTree.this.fireValueUpdated(null);
            }
        }

        public synchronized void reload() throws Exception {
            this.load(this.supervisorLicenses, this.cx);
        }

        public int getRootCount() {
            return this.hostNodes.length;
        }

        public TreeNode getRoot(int n) {
            return this.hostNodes[n];
        }

        public BSupervisorLicenses getSupervisorLicenses() {
            return this.supervisorLicenses;
        }
    }
}

