/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.ui.StationModel;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.ui.theme.Theme;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;

public class BProvisioningManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$ui$BProvisioningManager == null ? (class$com$tridium$provisioningNiagara$ui$BProvisioningManager = BProvisioningManager.class$("com.tridium.provisioningNiagara.ui.BProvisioningManager")) : class$com$tridium$provisioningNiagara$ui$BProvisioningManager));
    protected static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$provisioningNiagara$ui$BProvisioningManager == null ? (class$com$tridium$provisioningNiagara$ui$BProvisioningManager = BProvisioningManager.class$("com.tridium.provisioningNiagara.ui.BProvisioningManager")) : class$com$tridium$provisioningNiagara$ui$BProvisioningManager));
    protected static final BBrush cutFg = BColor.make((int)100, (int)100, (int)100).toBrush();
    private static String lexUser = lex.getText("platformConnection.username");
    private static String lexPassword = lex.getText("platformConnection.password");
    private static String lexPort = lex.getText("platformConnection.port");
    private static String lexStatus = lex.getText("platformConnection.status");
    private static String lexHealth = lex.getText("platformConnection.health");
    private static String lexNotProvisioning = lex.getText("ProvisioningManager.notProvisioning");
    protected BIDeviceFolder folder;
    protected BNiagaraNetwork network;
    protected TableCellRenderer extRenderer = new ExtCellRenderer();
    protected TableCellRenderer renderer = new PlatformCellRenderer();
    protected BImage[] extIcons = new BImage[]{BImage.make((BIcon)BIcon.std((String)"computer.png")), BImage.make((String)"module://provisioningNiagara/icons/software.png")};
    protected String[] extNames = new String[]{"provisioningNiagara_StationProxy", "provisioningNiagara_SoftwareStationExt"};
    protected double extsWidth = 4 + this.extNames.length * 20 + 4;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$BProvisioningManager;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$BProvisioningNiagaraNetworkExt;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doLoadValue(BObject bObject, Context context) {
        super.doLoadValue(bObject, context);
        this.folder = (BIDeviceFolder)bObject;
        try {
            this.network = (BNiagaraNetwork)this.folder.getNetwork();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.network == null || this.network.getChildren(class$com$tridium$provisioningNiagara$BProvisioningNiagaraNetworkExt == null ? (class$com$tridium$provisioningNiagara$BProvisioningNiagaraNetworkExt = BProvisioningManager.class$("com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt")) : class$com$tridium$provisioningNiagara$BProvisioningNiagaraNetworkExt).length == 0) {
            this.setContent((BWidget)new BLabel(lexNotProvisioning));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ExtCellRenderer
    extends PlatformCellRenderer {
        protected ExtCellRenderer() {
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return BProvisioningManager.this.extsWidth;
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            this.paintCellBackground(graphics, cell);
            if (cell.value instanceof BDeviceFolder) {
                return;
            }
            for (int i = 0; i < BProvisioningManager.this.extIcons.length; ++i) {
                graphics.drawImage(BProvisioningManager.this.extIcons[i], (double)(4 + i * 20), (cell.height - 16.0) / 2.0);
            }
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.value instanceof BDeviceFolder) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }
    }

    protected class PlatformCellRenderer
    extends TableCellRenderer {
        protected PlatformCellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BComponent bComponent = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
            if (bComponent instanceof BNiagaraStation) {
                try {
                    BNiagaraStation bNiagaraStation = (BNiagaraStation)bComponent;
                    if (bNiagaraStation.isPendingMove()) {
                        return cutFg;
                    }
                    BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
                    BColor bColor = (BColor)bPlatformConnection.getStatus().getForegroundColor(null);
                    if (bColor != null) {
                        return bColor.toBrush();
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return super.getForeground(cell);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BComponent bComponent = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
            if (bComponent instanceof BDeviceFolder) {
                return Theme.table().getGridBrush();
            }
            try {
                BNiagaraStation bNiagaraStation = (BNiagaraStation)bComponent;
                BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
                BColor bColor = (BColor)bPlatformConnection.getStatus().getBackgroundColor(null);
                if (bColor != null) {
                    return bColor.toBrush();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return super.getBackground(cell);
        }

        protected BComponentTable getComponentTable() {
            return BProvisioningManager.this.getModel().getTable();
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            String string = this.getCellText(cell);
            double d = this.getFont(cell).width(string) + 12.0;
            if (cell.column == 0 && this.getComponentTable().getModel().getRowIcon(cell.row) != null) {
                d += 20.0;
            }
            return d;
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            String string;
            TableModel tableModel = this.getComponentTable().getModel();
            this.paintCellBackground(graphics, cell);
            double d = 2.0;
            double d2 = (cell.height - 16.0) / 2.0;
            if (cell.column == 0 && (string = tableModel.getRowIcon(cell.row)) != null) {
                graphics.drawImage((BImage)string, d, d2);
                d += 20.0;
            }
            string = this.getCellText(cell);
            BFont bFont = this.getFont(cell);
            switch (tableModel.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    d = cell.width - 2.0 - bFont.width(string);
                    break;
                }
                case 1: {
                    d = (cell.width - bFont.width(string)) / 2.0;
                }
            }
            graphics.setFont(bFont);
            graphics.drawString(string, d, (cell.height + bFont.getAscent() - bFont.getDescent()) / 2.0);
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            if (cell.value instanceof BObject) {
                return ((BObject)cell.value).toString(null);
            }
            return String.valueOf(cell.value);
        }
    }

    protected class Exts
    extends MgrColumn {
        public Exts() {
            super(lex.getText("ProvisioningManager.extsColumn"), 0);
        }

        public Object get(Object object) {
            return (BComponent)object;
        }

        public TableCellRenderer getCellRenderer() {
            return BProvisioningManager.this.extRenderer;
        }

        void cellDoubleClicked(BMgrTable bMgrTable, BMouseEvent bMouseEvent, int n, int n2) {
            BWbShell bWbShell;
            RectGeom rectGeom = bMgrTable.getCellBounds(n, n2);
            BComponent bComponent = bMgrTable.getComponentAt(n);
            if (bComponent instanceof BDeviceFolder) {
                return;
            }
            int n3 = (int)(bMouseEvent.getX() - rectGeom.x);
            int n4 = (n3 - 4) / 20;
            if (0 <= n4 && n4 < BProvisioningManager.this.extNames.length && (bWbShell = bMgrTable.getManager().getWbShell()) != null) {
                BOrd bOrd = BOrd.make((String)(bComponent.getNavOrd().toString() + "/" + BProvisioningManager.this.extNames[n4]));
                bWbShell.hyperlink(new HyperlinkInfo(bOrd, (BInputEvent)bMouseEvent));
            }
        }
    }

    protected class Addr
    extends MgrColumn.Prop {
        public Addr() {
            super(BNiagaraStation.address, 4);
        }

        public TableCellRenderer getCellRenderer() {
            return BProvisioningManager.this.renderer;
        }
    }

    protected class Mixin
    extends MgrColumn.MixinProp {
        public Mixin(Type type, String string, Property[] propertyArray, int n) {
            super(type, string, propertyArray, n);
        }

        public Mixin(Type type, Property[] propertyArray, int n) {
            super(type, propertyArray, n);
        }

        public TableCellRenderer getCellRenderer() {
            return BProvisioningManager.this.renderer;
        }
    }

    protected class Name
    extends MgrColumn.Name {
        public Name() {
            super(4);
        }

        public TableCellRenderer getCellRenderer() {
            return BProvisioningManager.this.renderer;
        }
    }

    protected class Model
    extends StationModel {
        private MgrColumn nameCol;
        private MgrColumn extsCol;
        private MgrColumn addrCol;
        private MgrColumn statusCol;
        private MgrColumn healthCol;
        private MgrColumn userCol;
        private MgrColumn passCol;
        private MgrColumn portCol;
        private MgrColumn[] cols;

        public Model(BProvisioningManager bProvisioningManager2) {
            super((BDeviceManager)bProvisioningManager2);
            this.nameCol = new Name();
            this.extsCol = new Exts();
            this.addrCol = new Addr();
            this.statusCol = new Mixin(BPlatformConnection.TYPE, lexStatus, new Property[]{BPlatformConnection.status}, 4);
            this.healthCol = new Mixin(BPlatformConnection.TYPE, lexHealth, new Property[]{BPlatformConnection.health}, 4);
            this.userCol = new Mixin(BPlatformConnection.TYPE, lexUser, new Property[]{BPlatformConnection.credentials, BUsernameAndPassword.username}, 3);
            this.passCol = new Mixin(BPlatformConnection.TYPE, lexPassword, new Property[]{BPlatformConnection.credentials, BUsernameAndPassword.password}, 3);
            this.portCol = new Mixin(BPlatformConnection.TYPE, lexPort, new Property[]{BPlatformConnection.port}, 3);
            this.cols = new MgrColumn[]{this.nameCol, this.extsCol, this.addrCol, this.statusCol, this.healthCol, this.userCol, this.passCol, this.portCol};
        }

        protected String makeTableTitle() {
            return BProvisioningManager.this.getType().getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.cols;
        }

        protected boolean subscribeToChild(BComponent bComponent, BComponent bComponent2) {
            return bComponent2 instanceof BPlatformConnection;
        }
    }

    protected class Controller
    extends DeviceController {
        public Controller(BProvisioningManager bProvisioningManager2) {
            super((BDeviceManager)bProvisioningManager2);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.allDescendants, this.edit};
        }

        public void cellDoubleClicked(BMgrTable bMgrTable, BMouseEvent bMouseEvent, int n, int n2) {
            MgrColumn mgrColumn = bMgrTable.columnIndexToMgrColumn(n2);
            if (mgrColumn instanceof Exts) {
                ((Exts)mgrColumn).cellDoubleClicked(bMgrTable, bMouseEvent, n, n2);
            } else {
                Model model = (Model)this.getManager().getModel();
                Type type = model.getFolderType();
                BComponent bComponent = this.getTable().getComponentAt(n);
                BWbShell bWbShell = this.getManager().getWbShell();
                if (bComponent != null && bComponent.getType().is(type) && bWbShell != null) {
                    bWbShell.hyperlink(new HyperlinkInfo(BOrd.make((BOrd)bComponent.getNavOrd(), (OrdQuery)new ViewQuery(BProvisioningManager.this.getType().toString())), (BInputEvent)bMouseEvent));
                    return;
                }
                super.cellDoubleClicked(bMgrTable, bMouseEvent, n, n2);
            }
        }
    }
}

