/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.station;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.ProvisioningNiagaraManagerImpl;
import com.tridium.provisioningNiagara.station.BStationProxy;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BHost;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.PlatformDaemon;
import javax.baja.provisioningNiagara.station.ProvisioningStationManager;
import javax.baja.sys.Context;

public class ProvisioningStationManagerImpl
implements ProvisioningStationManager {
    private BNiagaraStation station;
    private BStationProxy proxy;

    public ProvisioningStationManagerImpl(ProvisioningNiagaraManagerImpl provisioningNiagaraManagerImpl, BNiagaraStation bNiagaraStation) {
        this.station = bNiagaraStation;
        bNiagaraStation.lease(1);
        this.proxy = (BStationProxy)bNiagaraStation.getMixIn(BStationProxy.TYPE);
    }

    public void poll(ICancelHint iCancelHint, Context context) throws Exception {
        this.proxy.lease(Integer.MAX_VALUE);
        this.proxy.invokeSync(BStationProxy.poll, iCancelHint, context);
    }

    public BStationStatus getStationStatus() {
        this.proxy.lease(1);
        return this.proxy.getStationStatus();
    }

    public boolean canStart() {
        BStationStatus bStationStatus = this.getStationStatus();
        if (bStationStatus == BStationStatus.running || bStationStatus == BStationStatus.starting) {
            return false;
        }
        return this.canRestart() || bStationStatus != BStationStatus.halted && bStationStatus != BStationStatus.failed;
    }

    public boolean canRestart() {
        this.proxy.lease(1);
        return this.proxy.getIsRestartEnabled();
    }

    public boolean canReboot() {
        this.proxy.lease(1);
        return this.proxy.getIsRebootEnabled();
    }

    public void saveStation(IPlatformOperationListener iPlatformOperationListener) throws Exception {
        this.proxy.lease(1);
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.proxy.saveStation((ICancelHint)platformOperationListener, (DaemonSessionTaskListener)platformOperationListener);
    }

    public void saveStationAsync() {
        this.proxy.lease(1);
        this.proxy.saveStation();
    }

    public void stopStation(IPlatformOperationListener iPlatformOperationListener) throws Exception {
        this.proxy.lease(1);
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.proxy.stopStation((ICancelHint)platformOperationListener, (DaemonSessionTaskListener)platformOperationListener);
    }

    public void stopStationAsync() {
        this.proxy.lease(1);
        this.proxy.stopStation();
    }

    public void startStation(IPlatformOperationListener iPlatformOperationListener) throws Exception {
        this.proxy.lease(1);
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.proxy.startStation((ICancelHint)platformOperationListener, (DaemonSessionTaskListener)platformOperationListener);
    }

    public void startStationAsync() {
        this.proxy.lease();
        this.proxy.startStation();
    }

    public void killStation(IPlatformOperationListener iPlatformOperationListener) throws Exception {
        this.proxy.lease(1);
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.proxy.killStation((ICancelHint)platformOperationListener, (DaemonSessionTaskListener)platformOperationListener);
    }

    public void killStationAsync() {
        this.proxy.lease(1);
        this.proxy.killStation();
    }

    public void restartStation() throws Exception {
        this.proxy.lease(1);
        this.proxy.restartStation();
    }

    public void restartStationAsync() {
        this.proxy.lease(1);
        this.proxy.restartStation();
    }

    public void rebootHost() throws Exception {
        this.proxy.lease(1);
        this.proxy.rebootHost();
    }

    public BFoxProxySession getFoxSession() throws Exception {
        this.station.lease(1);
        BFoxClientConnection bFoxClientConnection = this.station.getClientConnection();
        return BFoxProxySession.make((BHost)bFoxClientConnection.getRemoteHost(), (int)bFoxClientConnection.getPort(), (String)bFoxClientConnection.getUsername(), (String)bFoxClientConnection.getPassword().getValue());
    }

    public PlatformDaemon getPlatformDaemon() throws Exception {
        this.station.lease(1);
        BPlatformConnection bPlatformConnection = (BPlatformConnection)this.station.getMixIn(BPlatformConnection.TYPE);
        return bPlatformConnection.getPlatformDaemon();
    }
}

