/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.station;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.BNiagaraProvisioningChannel;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.file.FilePath;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

public class BStationProxy
extends BProvisioningStationExt
implements BIMixIn,
BIPollable {
    public static final Property stationStatus = BStationProxy.newProperty((int)3, (BValue)BStationStatus.unknown, null);
    public static final Property pollFrequency = BStationProxy.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property isRestartEnabled = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property isRebootEnabled = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property isAutoStart = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property isAutoRestart = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property isAcceptingMessages = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property logBufferSize = BStationProxy.newProperty((int)3, (int)Short.MAX_VALUE, null);
    public static final Property logBufferFileSize = BStationProxy.newProperty((int)3, (int)Short.MAX_VALUE, null);
    public static final Property numCpus = BStationProxy.newProperty((int)3, (int)1, null);
    public static final Property currentCpuUsage = BStationProxy.newProperty((int)3, (int)-1, null);
    public static final Property overallCpuUsage = BStationProxy.newProperty((int)3, (int)-1, null);
    public static final Property totalPhysicalMemory = BStationProxy.newProperty((int)3, (int)-1, null);
    public static final Property freePhysicalMemory = BStationProxy.newProperty((int)3, (int)-1, null);
    public static final Property filesystemAttributes = BStationProxy.newProperty((int)3, (BValue)new BVector(), null);
    public static final Action poll = BStationProxy.newAction((int)16, null);
    public static final Action pollWithNotify = BStationProxy.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    public static final Action dumpThreads = BStationProxy.newAction((int)16, null);
    public static final Action saveStation = BStationProxy.newAction((int)16, null);
    public static final Action saveStationWithNotify = BStationProxy.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    public static final Action stopStation = BStationProxy.newAction((int)144, null);
    public static final Action stopStationWithNotify = BStationProxy.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    public static final Action startStation = BStationProxy.newAction((int)0, null);
    public static final Action killStation = BStationProxy.newAction((int)144, null);
    public static final Action killStationWithNotify = BStationProxy.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    public static final Action restartStation = BStationProxy.newAction((int)144, null);
    public static final Action rebootHost = BStationProxy.newAction((int)144, null);
    public static final Action updateLogBufferSize = BStationProxy.newAction((int)20, null);
    public static final Action updateStartSettings = BStationProxy.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$station$BStationProxy == null ? (class$com$tridium$provisioningNiagara$station$BStationProxy = BStationProxy.class$("com.tridium.provisioningNiagara.station.BStationProxy")) : class$com$tridium$provisioningNiagara$station$BStationProxy));
    private boolean allowStartUpdate = true;
    private boolean startUpdated = false;
    private boolean inPoll = false;
    public static BIcon ICON = BIcon.std((String)"computer.png");
    public static final String FACET_TIMEOUT = "timeout";
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$station$BStationProxy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$BFilesystemAttributes;

    public BStationStatus getStationStatus() {
        return (BStationStatus)this.get(stationStatus);
    }

    public void setStationStatus(BStationStatus bStationStatus) {
        this.set(stationStatus, (BValue)bStationStatus, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public boolean getIsRestartEnabled() {
        return this.getBoolean(isRestartEnabled);
    }

    public void setIsRestartEnabled(boolean bl) {
        this.setBoolean(isRestartEnabled, bl, null);
    }

    public boolean getIsRebootEnabled() {
        return this.getBoolean(isRebootEnabled);
    }

    public void setIsRebootEnabled(boolean bl) {
        this.setBoolean(isRebootEnabled, bl, null);
    }

    public boolean getIsAutoStart() {
        return this.getBoolean(isAutoStart);
    }

    public void setIsAutoStart(boolean bl) {
        this.setBoolean(isAutoStart, bl, null);
    }

    public boolean getIsAutoRestart() {
        return this.getBoolean(isAutoRestart);
    }

    public void setIsAutoRestart(boolean bl) {
        this.setBoolean(isAutoRestart, bl, null);
    }

    public boolean getIsAcceptingMessages() {
        return this.getBoolean(isAcceptingMessages);
    }

    public void setIsAcceptingMessages(boolean bl) {
        this.setBoolean(isAcceptingMessages, bl, null);
    }

    public int getLogBufferSize() {
        return this.getInt(logBufferSize);
    }

    public void setLogBufferSize(int n) {
        this.setInt(logBufferSize, n, null);
    }

    public int getLogBufferFileSize() {
        return this.getInt(logBufferFileSize);
    }

    public void setLogBufferFileSize(int n) {
        this.setInt(logBufferFileSize, n, null);
    }

    public int getNumCpus() {
        return this.getInt(numCpus);
    }

    public void setNumCpus(int n) {
        this.setInt(numCpus, n, null);
    }

    public int getCurrentCpuUsage() {
        return this.getInt(currentCpuUsage);
    }

    public void setCurrentCpuUsage(int n) {
        this.setInt(currentCpuUsage, n, null);
    }

    public int getOverallCpuUsage() {
        return this.getInt(overallCpuUsage);
    }

    public void setOverallCpuUsage(int n) {
        this.setInt(overallCpuUsage, n, null);
    }

    public int getTotalPhysicalMemory() {
        return this.getInt(totalPhysicalMemory);
    }

    public void setTotalPhysicalMemory(int n) {
        this.setInt(totalPhysicalMemory, n, null);
    }

    public int getFreePhysicalMemory() {
        return this.getInt(freePhysicalMemory);
    }

    public void setFreePhysicalMemory(int n) {
        this.setInt(freePhysicalMemory, n, null);
    }

    public BVector getFilesystemAttributes() {
        return (BVector)this.get(filesystemAttributes);
    }

    public void setFilesystemAttributes(BVector bVector) {
        this.set(filesystemAttributes, (BValue)bVector, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public void pollWithNotify(BString bString) {
        this.invoke(pollWithNotify, (BValue)bString, null);
    }

    public void dumpThreads() {
        this.invoke(dumpThreads, null, null);
    }

    public void saveStation() {
        this.invoke(saveStation, null, null);
    }

    public void saveStationWithNotify(BString bString) {
        this.invoke(saveStationWithNotify, (BValue)bString, null);
    }

    public void stopStation() {
        this.invoke(stopStation, null, null);
    }

    public void stopStationWithNotify(BString bString) {
        this.invoke(stopStationWithNotify, (BValue)bString, null);
    }

    public void startStation() {
        this.invoke(startStation, null, null);
    }

    public void killStation() {
        this.invoke(killStation, null, null);
    }

    public void killStationWithNotify(BString bString) {
        this.invoke(killStationWithNotify, (BValue)bString, null);
    }

    public void restartStation() {
        this.invoke(restartStation, null, null);
    }

    public void rebootHost() {
        this.invoke(rebootHost, null, null);
    }

    public void updateLogBufferSize() {
        this.invoke(updateLogBufferSize, null, null);
    }

    public void updateStartSettings() {
        this.invoke(updateStartSettings, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context context) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("StationProxy");
    }

    public void subscribed() {
        try {
            BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            bProvisioningNiagaraNetworkExt.getPollScheduler().subscribe(this);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void unsubscribed() {
        try {
            BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            bProvisioningNiagaraNetworkExt.getPollScheduler().unsubscribe(this);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.allowStartUpdate && (property == isAutoStart || property == isAutoRestart)) {
            this.startUpdated = true;
        }
    }

    public BFilesystemAttributes getFilesystemAttributes(FilePath filePath) throws Exception {
        if (this.isUnoperational()) {
            return null;
        }
        if (this.isRunning()) {
            return DaemonFileUtil.getFilesystemAttributes((BDaemonSession)this.getDaemonSession(), (FilePath)filePath);
        }
        return this.channel().getFilesystemAttributes(this.getStationName(), filePath);
    }

    public String getStationName() {
        return this.getNiagaraStation().getStationName();
    }

    public String getStationDisplayName() {
        return this.getNiagaraStation().getDisplayName(null);
    }

    public InputStream getStationOutput(boolean bl, boolean bl2) throws Exception {
        if (this.isUnoperational()) {
            return null;
        }
        if (this.isRunning()) {
            return this.getStationSurrogate().getStationOutput(bl, bl2);
        }
        return this.channel().getStationOutput(this.getStationName(), bl, bl2);
    }

    public void startStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().startStation(iCancelHint, daemonSessionTaskListener);
        } else {
            this.channel().startStation(this.getStationName(), iCancelHint, daemonSessionTaskListener);
        }
    }

    public void stopStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().stopStation(BStationProxy.stationShutdownCancelHint(iCancelHint, null), daemonSessionTaskListener);
        } else {
            this.channel().stopStation(this.getStationName(), iCancelHint, daemonSessionTaskListener);
        }
    }

    public void saveStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().saveStation(iCancelHint, daemonSessionTaskListener);
        } else {
            this.channel().saveStation(this.getStationName(), iCancelHint, daemonSessionTaskListener);
        }
    }

    public void killStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().killStation(iCancelHint, daemonSessionTaskListener);
        } else {
            this.channel().killStation(this.getStationName(), iCancelHint, daemonSessionTaskListener);
        }
    }

    public void doPoll(Context context) throws Exception {
        this.doPollWithNotify(null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPollWithNotify(BString var1_1, Context var2_2) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        var3_3 = this.startAsyncAction(var1_1, var2_2);
        try {
            if (this.inPoll) {
                this.asyncActionComplete(var3_3, null, var2_2);
                return;
            }
            this.inPoll = true;
            if (this.isUnoperational()) {
                this.clearDown();
                this.asyncActionComplete(var3_3, null, var2_2);
                this.inPoll = false;
                return;
            }
            var4_4 = BDaemonSession.DEFAULT_TIMEOUT;
            if (var2_2 != null) {
                var4_4 = var2_2.getFacets().geti("timeout", var4_4);
            }
            if ((var5_7 = this.getDaemonSession()) == null) {
                this.setDown();
                this.asyncActionComplete(var3_3, null, var2_2);
                this.inPoll = false;
                return;
            }
            var6_8 = var5_7.updateHostProperties(var4_4);
            var7_9 = this;
            synchronized (var7_9) {
                this.setNumCpus(var6_8.getNumCpus());
                this.setCurrentCpuUsage(var6_8.getCurrentCpuUsage());
                this.setOverallCpuUsage(var6_8.getOverallCpuUsage());
                this.setTotalPhysicalMemory(var6_8.getTotalPhysicalMemory());
                this.setFreePhysicalMemory(var6_8.getFreePhysicalMemory());
                var8_10 /* !! */  = new Array(BStationProxy.class$java$lang$String == null ? (BStationProxy.class$java$lang$String = BStationProxy.class$("java.lang.String")) : BStationProxy.class$java$lang$String);
                var9_11 = this.getFilesystemAttributes().getProperties();
                while (var9_11.next(BStationProxy.class$com$tridium$platform$BFilesystemAttributes == null ? BStationProxy.class$("com.tridium.platform.BFilesystemAttributes") : BStationProxy.class$com$tridium$platform$BFilesystemAttributes)) {
                    var8_10 /* !! */ .add((Object)var9_11.slot().getName());
                }
                var9_11 = var6_8.getFilesystemAttributes().getProperties();
                while (var9_11.next(BStationProxy.class$com$tridium$platform$BFilesystemAttributes == null ? BStationProxy.class$("com.tridium.platform.BFilesystemAttributes") : BStationProxy.class$com$tridium$platform$BFilesystemAttributes)) {
                    var10_13 = var9_11.slot().getName();
                    var8_10 /* !! */ .remove((Object)var10_13);
                    var11_14 = (BFilesystemAttributes)var9_11.get();
                    var12_15 = this.getFilesystemAttributes().getProperty(var10_13);
                    if (var12_15 == null) {
                        this.getFilesystemAttributes().add(var10_13, var11_14.newCopy());
                        continue;
                    }
                    var13_16 = (BFilesystemAttributes)this.getFilesystemAttributes().get(var12_15);
                    var14_17 = var11_14.getProperties();
                    while (var14_17.next()) {
                        var15_18 = (BValue)var14_17.get();
                        if (var15_18 instanceof BComplex) {
                            var13_16.set(var14_17.property(), (BValue)((BComplex)((BComplex)var15_18).newCopy()));
                            continue;
                        }
                        var13_16.set(var14_17.property(), var15_18);
                    }
                }
                for (var9_12 = 0; var9_12 < var8_10 /* !! */ .size(); ++var9_12) {
                    this.getFilesystemAttributes().remove((String)var8_10 /* !! */ .get(var9_12));
                }
            }
            var7_9 = this.getStationSurrogate();
            var8_10 /* !! */  = this;
            synchronized (var8_10 /* !! */ ) {
                if (var7_9 != null) ** break block29
                this.clearDown();
                this.asyncActionComplete(var3_3, null, var2_2);
            }
            this.inPoll = false;
            return;
            {
                ** try [egrp 6[TRYBLOCK] [11 : 553->721)] { 
lbl75:
                // 1 sources

                try {
                    if (!this.startUpdated) {
                        this.allowStartUpdate = false;
                        if (var7_9.getIsAutoStart() != this.getIsAutoStart()) {
                            this.setIsAutoStart(var7_9.getIsAutoStart());
                        }
                        if (var7_9.getIsAutoRestart() != this.getIsAutoRestart()) {
                            this.setIsAutoRestart(var7_9.getIsAutoRestart());
                        }
                        this.allowStartUpdate = true;
                    }
                    this.setStationStatus(var7_9.getStationStatus());
                    this.setIsAcceptingMessages(var7_9.getIsAcceptingMessages());
                    this.setLogBufferFileSize(var7_9.getLogBufferFileSize());
                    this.setLogBufferSize(var7_9.getLogBufferSize());
                    this.setIsRestartEnabled(var7_9.isRestartEnabled());
                    this.setIsRebootEnabled(var6_8.supportsServlet("reboot") != false && var6_8.getHostId().equals(Nre.getHostId()) == false);
                    this.clearDown();
                }
                catch (IOException var4_5) {
                    this.setDown();
                    this.reset();
                }
                ** break block30
lbl95:
                // 1 sources

                finally {
                    this.inPoll = false;
                }
            }
        }
        catch (Exception var4_6) {
            this.asyncActionException(var3_3, var4_6, var2_2);
            return;
        }
lbl-1000:
        // 2 sources

        {
            this.asyncActionComplete(var3_3, null, var2_2);
            return;
        }
    }

    public void reset() {
        this.setStationStatus(BStationStatus.unknown);
        this.setIsAcceptingMessages(false);
        this.setIsRestartEnabled(false);
        this.setIsRebootEnabled(false);
    }

    public void doStopStation(Context context) throws Exception {
        this.doStopStationWithNotify(null, context);
    }

    public void doStopStationWithNotify(BString bString, Context context) throws Exception {
        BProvisioningStationExt.CanceledListener canceledListener = this.startAsyncAction(bString, context);
        try {
            if (this.isUnoperational()) {
                this.asyncActionComplete(canceledListener, null, context);
                return;
            }
            this.setStationStatus(BStationStatus.stopping);
            if (canceledListener == null) {
                this.getStationSurrogate().stopStationAsync();
            } else {
                this.getStationSurrogate().stopStation(BStationProxy.stationShutdownCancelHint(canceledListener, null), null);
            }
        }
        catch (Exception exception) {
            this.asyncActionException(canceledListener, exception, context);
            return;
        }
        this.asyncActionComplete(canceledListener, null, context);
    }

    public static ICancelHint stationShutdownCancelHint(ICancelHint iCancelHint, RuntimeException runtimeException) {
        try {
            BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            int n = bProvisioningNiagaraNetworkExt.getStationShutdownTimeout();
            if (n <= 0) {
                return iCancelHint;
            }
            TimedCancel timedCancel = new TimedCancel(iCancelHint, n, runtimeException);
            timedCancel.start();
            return timedCancel;
        }
        catch (Exception exception) {
            return iCancelHint;
        }
    }

    public static ICancelHint rebootCancelHint(ICancelHint iCancelHint, RuntimeException runtimeException) {
        try {
            BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            int n = bProvisioningNiagaraNetworkExt.getDeviceRebootTimeout();
            if (n <= 0) {
                return iCancelHint;
            }
            TimedCancel timedCancel = new TimedCancel(iCancelHint, n, runtimeException);
            timedCancel.start();
            return timedCancel;
        }
        catch (Exception exception) {
            return iCancelHint;
        }
    }

    public void doStartStation() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.setStationStatus(BStationStatus.starting);
        this.getStationSurrogate().startStationAsync();
    }

    public void doKillStation(Context context) throws Exception {
        this.doKillStationWithNotify(null, context);
    }

    public void doKillStationWithNotify(BString bString, Context context) throws Exception {
        BProvisioningStationExt.CanceledListener canceledListener = this.startAsyncAction(bString, context);
        try {
            if (this.isUnoperational()) {
                this.asyncActionComplete(canceledListener, null, context);
                return;
            }
            if (canceledListener == null) {
                this.getStationSurrogate().killStationAsync();
            } else {
                this.getStationSurrogate().killStation((ICancelHint)canceledListener, null);
            }
        }
        catch (Exception exception) {
            this.asyncActionException(canceledListener, exception, context);
            return;
        }
        this.asyncActionComplete(canceledListener, null, context);
    }

    public void doRestartStation(Context context) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (!this.getIsRestartEnabled()) {
            throw new IllegalStateException("Restart not permitted");
        }
        this.setStationStatus(BStationStatus.stopping);
        this.getStationSurrogate().restartStationAsync();
    }

    public void doRebootHost() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (!this.getIsRebootEnabled()) {
            throw new IllegalStateException("Reboot not permitted");
        }
        this.getDaemonSession().sendRebootRequest(false);
        this.reset();
    }

    public void doDumpThreads() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().dumpThreads();
    }

    public void doSaveStation(Context context) throws Exception {
        this.doSaveStationWithNotify(null, context);
    }

    public void doSaveStationWithNotify(BString bString, Context context) throws Exception {
        BProvisioningStationExt.CanceledListener canceledListener = this.startAsyncAction(bString, context);
        try {
            if (this.isUnoperational()) {
                this.asyncActionComplete(canceledListener, null, context);
                return;
            }
            if (canceledListener == null) {
                this.getStationSurrogate().saveStationAsync();
            } else {
                this.getStationSurrogate().saveStation((ICancelHint)canceledListener, null);
            }
        }
        catch (Exception exception) {
            this.asyncActionException(canceledListener, exception, context);
            return;
        }
        this.asyncActionComplete(canceledListener, null, context);
    }

    public void doUpdateLogBufferSize() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().updateLogBufferSize(this.getLogBufferSize(), this.getLogBufferFileSize());
    }

    public void doUpdateStartSettings() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().updateSettings(this.getIsAutoStart(), this.getIsAutoRestart());
        this.startUpdated = false;
    }

    protected BStationSurrogate getStationSurrogate() throws Exception {
        BDaemonSession bDaemonSession = this.getDaemonSession();
        return bDaemonSession == null ? null : BStationSurrogate.make((BDaemonSession)bDaemonSession, (String)this.getStationName());
    }

    protected BNiagaraProvisioningChannel channel() throws Exception {
        BFoxSession bFoxSession = (BFoxSession)BOrd.toSession((BObject)this);
        return (BNiagaraProvisioningChannel)bFoxSession.getConnection().getChannels().get("niagaraProv", BNiagaraProvisioningChannel.TYPE);
    }

    public boolean isUnoperational() {
        return this.isDisabled() || this.isFault();
    }

    protected void setDown() {
        if (!this.getStatus().isDown()) {
            int n = this.getStatus().getBits();
            this.setStatus(BStatus.make((int)(n |= 4)));
        }
    }

    protected void clearDown() {
        if (this.getStatus().isDown()) {
            int n = this.getStatus().getBits();
            this.setStatus(BStatus.make((int)(n &= 0xFFFFFFFB)));
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    public static void main(String[] stringArray) {
        try {
            BFoxProxySession bFoxProxySession = BFoxProxySession.make((BHost)BLocalHost.INSTANCE, (int)1911, (String)"admin", (String)"");
            bFoxProxySession.engageNoRetry("stationProxyTest");
            BComponent bComponent = (BComponent)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get((BObject)bFoxProxySession);
            bComponent.lease(1);
            BComponent bComponent2 = (BComponent)bComponent.get("velma");
            bComponent2.lease(1);
            BStationProxy bStationProxy = (BStationProxy)bComponent2.getMixIn(TYPE);
            bStationProxy.lease(1);
            bStationProxy.invokeSync(saveStationWithNotify, null, null);
            bFoxProxySession.disengage("stationProxyTest");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class TimedCancel
    extends Thread
    implements ICancelHint {
        private ICancelHint cancelHint;
        private long timeoutSeconds;
        private boolean isTimedOut = false;
        private RuntimeException throwOnTimeout = null;

        public TimedCancel(ICancelHint iCancelHint, long l, RuntimeException runtimeException) {
            super("Station Shutdown Timeout");
            this.cancelHint = iCancelHint;
            this.timeoutSeconds = l;
            this.throwOnTimeout = runtimeException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(this.timeoutSeconds * 1000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.isTimedOut = true;
                if (this.cancelHint != null && this.cancelHint instanceof BProvisioningStationExt.CanceledListener) {
                    ((BProvisioningStationExt.CanceledListener)this.cancelHint).setCanceled();
                }
            }
        }

        public boolean isCanceled() {
            if (this.isTimedOut) {
                if (this.throwOnTimeout != null) {
                    throw this.throwOnTimeout;
                }
                return true;
            }
            if (this.cancelHint == null) {
                return false;
            }
            return this.cancelHint.isCanceled();
        }
    }
}

