/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.program;

import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.program.BProgramService;
import com.tridium.program.BRobotCode;
import com.tridium.program.BRobotResult;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.program.BProvisioningRobot;
import com.tridium.provisioningNiagara.program.BRobotStepDetails;
import com.tridium.util.TimeFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.fox.BFoxProxySession;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BRobotJobStep
extends BDeviceJobStep
implements BIEncodable {
    public static final Property robotOrd = BRobotJobStep.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$program$BRobotJobStep == null ? (class$com$tridium$provisioningNiagara$program$BRobotJobStep = BRobotJobStep.class$("com.tridium.provisioningNiagara.program.BRobotJobStep")) : class$com$tridium$provisioningNiagara$program$BRobotJobStep));
    public static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});
    private static final BIcon ICON = BIcon.std((String)"script.png");
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$program$BRobotJobStep;

    public BOrd getRobotOrd() {
        return (BOrd)this.get(robotOrd);
    }

    public void setRobotOrd(BOrd bOrd) {
        this.set(robotOrd, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRobotJobStep() {
    }

    public BRobotJobStep(BProvisioningRobot bProvisioningRobot) {
        this.setRobotOrd(bProvisioningRobot.getOrdInSpace());
    }

    protected BDeviceStepDetails makeDetails(BDevice bDevice) {
        BNiagaraStation bNiagaraStation = (BNiagaraStation)bDevice;
        BRobotStepDetails bRobotStepDetails = new BRobotStepDetails(bNiagaraStation, this);
        this.add(SlotPath.escape((String)bNiagaraStation.getStationName()), (BValue)bRobotStepDetails, 4);
        return bRobotStepDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService bBatchJobService, BDeviceStepDetails bDeviceStepDetails, BDevice bDevice, DeviceNetworkJobOp deviceNetworkJobOp) throws Exception {
        BPlatformConnection bPlatformConnection = (BPlatformConnection)bDevice.getMixIn(BPlatformConnection.TYPE);
        BDaemonSession bDaemonSession = bPlatformConnection.getDaemonSession();
        if (bPlatformConnection.isUnoperational()) {
            bDeviceStepDetails.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnoperational", new String[]{bDevice.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)bPlatformConnection.getStatus())});
            bDeviceStepDetails.complete(BJobState.failed);
            return;
        }
        if (bDaemonSession == null) {
            bDeviceStepDetails.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnavailable", new String[]{bDevice.getDisplayName(null)});
            bDeviceStepDetails.complete(BJobState.failed);
            return;
        }
        BRobotCode bRobotCode = this.getRobot((BObject)bBatchJobService).getRobotCode();
        String[] stringArray = bRobotCode.parseDependencies();
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)bDaemonSession, null, (boolean)false);
        bRemoteDaemonPlatform.checkSession();
        for (int i = 0; i < stringArray.length; ++i) {
            if (bRemoteDaemonPlatform.meets(BDependency.forModule((String)stringArray[i]))) continue;
            bDeviceStepDetails.failed("provisioningNiagara", "RobotJobStep.unmetDependency", new String[]{bDevice.getDisplayName(null), stringArray[i]});
            bDeviceStepDetails.complete(BJobState.failed);
            return;
        }
        BFoxProxySession bFoxProxySession = BProvisioningNiagaraNetworkExt.getFoxProxySession((BNiagaraStation)bDevice);
        String string = "robotStep" + TimeFormat.format((BAbsTime)bDeviceStepDetails.getStartTime(), (Context)TIMESTAMP_FORMAT);
        bFoxProxySession.engageNoRetry(string);
        try {
            BProgramService bProgramService = (BProgramService)BOrd.make((String)"service:program:ProgramService").get((BObject)bFoxProxySession);
            bProgramService.lease(1);
            BRobotResult bRobotResult = bProgramService.runRobot(bRobotCode);
            ((BRobotStepDetails)bDeviceStepDetails).setRobotResult(bRobotResult);
        }
        finally {
            bFoxProxySession.disengage(string);
        }
    }

    protected BProvisioningRobot getRobot(BObject bObject) {
        return (BProvisioningRobot)this.getRobotOrd().get(bObject);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public String toString(Context context) {
        return this.getLexicon().getText("RobotJobStep.display");
    }

    public void encode(DataOutput dataOutput) throws IOException {
        this.getRobotOrd().encode(dataOutput);
    }

    public BObject decode(DataInput dataInput) throws IOException {
        BRobotJobStep bRobotJobStep = new BRobotJobStep();
        bRobotJobStep.setRobotOrd((BOrd)BOrd.DEFAULT.decode(dataInput));
        return bRobotJobStep;
    }

    public String encodeToString() throws IOException {
        return this.getRobotOrd().encodeToString();
    }

    public BObject decodeFromString(String string) throws IOException {
        BRobotJobStep bRobotJobStep = new BRobotJobStep();
        bRobotJobStep.setRobotOrd((BOrd)BOrd.DEFAULT.decodeFromString(string));
        return bRobotJobStep;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

