/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.license;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

public class BLicenseStationExt
extends BProvisioningStationExt {
    public static final Property lastUpdate = BLicenseStationExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property licenseStatus = BLicenseStationExt.newProperty((int)1, (BValue)BLicenseStatus.unknown, null);
    public static final Property licenseSummary = BLicenseStationExt.newProperty((int)1, (BValue)new BEnvLicenseSummary(), null);
    public static final Property certificateSummaries = BLicenseStationExt.newProperty((int)1, (BValue)new BVector(), null);
    public static final Action poll = BLicenseStationExt.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$license$BLicenseStationExt == null ? (class$com$tridium$provisioningNiagara$license$BLicenseStationExt = BLicenseStationExt.class$("com.tridium.provisioningNiagara.license.BLicenseStationExt")) : class$com$tridium$provisioningNiagara$license$BLicenseStationExt));
    private static final BIcon icon = BIcon.std((String)"doc.png");
    private static final Log LOG = Log.getLog((String)"provisioningNiagara");
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$license$BLicenseStationExt;
    static /* synthetic */ Class class$com$tridium$platform$license$BCertificateSummary;

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime bAbsTime) {
        this.set(lastUpdate, (BValue)bAbsTime, null);
    }

    public BLicenseStatus getLicenseStatus() {
        return (BLicenseStatus)this.get(licenseStatus);
    }

    public void setLicenseStatus(BLicenseStatus bLicenseStatus) {
        this.set(licenseStatus, (BValue)bLicenseStatus, null);
    }

    public BEnvLicenseSummary getLicenseSummary() {
        return (BEnvLicenseSummary)this.get(licenseSummary);
    }

    public void setLicenseSummary(BEnvLicenseSummary bEnvLicenseSummary) {
        this.set(licenseSummary, (BValue)bEnvLicenseSummary, null);
    }

    public BVector getCertificateSummaries() {
        return (BVector)this.get(certificateSummaries);
    }

    public void setCertificateSummaries(BVector bVector) {
        this.set(certificateSummaries, (BValue)bVector, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context context) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("LicenseStationExt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPoll() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        try {
            VendorLicense[] vendorLicenseArray = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])new BEnvLicenseSummary[]{this.makeLicenseSummary()}, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
            VendorCertificate[] vendorCertificateArray = PortalLicenseUtil.getUpdatedCertificates((BCertificateSummary[])this.makeCertificateSummaries(), (CertificateDatabase)CertificateDatabase.LOCAL_INSTANCE);
            if (vendorLicenseArray.length == 0 && vendorCertificateArray.length == 0) {
                this.setLicenseStatus(BLicenseStatus.upToDate);
            } else {
                this.setLicenseStatus(BLicenseStatus.outOfDate);
            }
        }
        catch (Exception exception) {
            this.setLicenseStatus(BLicenseStatus.unknown);
            this.processException(exception);
        }
        finally {
            this.setLastUpdate(BAbsTime.now());
        }
    }

    public BEnvLicenseSummary makeLicenseSummary() throws Exception {
        if (this.isUnoperational()) {
            throw new BajaRuntimeException("License ext for " + this.getNiagaraStation().getDisplayName(null) + " status is " + this.getStatus());
        }
        BPlatformConnection bPlatformConnection = (BPlatformConnection)this.getNiagaraStation().getMixIn(BPlatformConnection.TYPE);
        if (bPlatformConnection.isUnoperational()) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " status is " + bPlatformConnection.getStatus());
        }
        BDaemonSession bDaemonSession = bPlatformConnection.getDaemonSession();
        if (bDaemonSession == null) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " is unavailable");
        }
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)bDaemonSession, null, (boolean)false);
        bRemoteDaemonPlatform.checkSession(null);
        String string = bRemoteDaemonPlatform.getBrandPart().isNull() ? null : bRemoteDaemonPlatform.getBrandPart().getPartName();
        BEnvLicenseSummary bEnvLicenseSummary = new BEnvLicenseSummary(bRemoteDaemonPlatform.getHostId(), string);
        BDirectory bDirectory = (BDirectory)bDaemonSession.getFileSpace().findFile(new FilePath("!licenses"));
        if (bDirectory != null) {
            BIFile[] bIFileArray = bDirectory.listFiles();
            for (int i = 0; i < bIFileArray.length; ++i) {
                if (!"license".equals(bIFileArray[i].getExtension())) continue;
                try {
                    VendorLicense vendorLicense = VendorLicense.make((BIFile)bIFileArray[i]);
                    LicenseDatabase.LOCAL_INSTANCE.add(vendorLicense);
                    bEnvLicenseSummary.updateVendorInfo(vendorLicense);
                    continue;
                }
                catch (Exception exception) {
                    LOG.error("Invalid license file - " + bIFileArray[i] + " for station " + this.getNiagaraStation().getDisplayName(null));
                }
            }
        }
        this.setLicenseSummary(bEnvLicenseSummary);
        return bEnvLicenseSummary;
    }

    public BCertificateSummary[] makeCertificateSummaries() throws Exception {
        String string;
        int n;
        Object[] objectArray;
        if (this.isUnoperational()) {
            throw new BajaRuntimeException("License ext for " + this.getNiagaraStation().getDisplayName(null) + " status is " + this.getStatus());
        }
        BPlatformConnection bPlatformConnection = (BPlatformConnection)this.getNiagaraStation().getMixIn(BPlatformConnection.TYPE);
        if (bPlatformConnection.isUnoperational()) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " status is " + bPlatformConnection.getStatus());
        }
        BDaemonSession bDaemonSession = bPlatformConnection.getDaemonSession();
        if (bDaemonSession == null) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " is unavailable");
        }
        BDirectory bDirectory = (BDirectory)bDaemonSession.getFileSpace().findFile(new FilePath("!certificates"));
        Array array = new Array(class$com$tridium$platform$license$BCertificateSummary == null ? (class$com$tridium$platform$license$BCertificateSummary = BLicenseStationExt.class$("com.tridium.platform.license.BCertificateSummary")) : class$com$tridium$platform$license$BCertificateSummary);
        this.getCertificateSummaries().removeAll();
        if (bDirectory != null) {
            objectArray = bDirectory.listFiles();
            for (n = 0; n < objectArray.length; ++n) {
                if (!"certificate".equals(objectArray[n].getExtension())) continue;
                try {
                    string = BCertificateSummary.make((BIFile)objectArray[n]);
                    array.add((Object)string);
                    this.getCertificateSummaries().add(SlotPath.escape((String)string.getVendor()), (BValue)string);
                    continue;
                }
                catch (Exception exception) {
                    LOG.error("Invalid certificate file - " + objectArray[n] + " for station " + this.getNiagaraStation().getDisplayName(null));
                }
            }
        }
        objectArray = this.getLicenseSummary().getVendors();
        for (n = 0; n < objectArray.length; ++n) {
            string = SlotPath.escape((String)objectArray[n]);
            Property property = this.getCertificateSummaries().getProperty(string);
            if (property != null) continue;
            BCertificateSummary bCertificateSummary = BCertificateSummary.makeEmpty((String)objectArray[n]);
            array.add((Object)bCertificateSummary);
            this.getCertificateSummaries().add(string, (BValue)bCertificateSummary);
        }
        return (BCertificateSummary[])array.trim();
    }

    public void setCertificateSummaries(BCertificateSummary[] bCertificateSummaryArray) {
        this.getCertificateSummaries().removeAll();
        for (int i = 0; i < bCertificateSummaryArray.length; ++i) {
            this.getCertificateSummaries().add(SlotPath.escape((String)bCertificateSummaryArray[i].getVendor()), bCertificateSummaryArray[i].newCopy());
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

