/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.backup;

import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.backup.BBackupStationExt;
import com.tridium.provisioningNiagara.software.BInstallStep;
import java.io.IOException;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBackupStepDetails
extends BDeviceStepDetails {
    public static final Property backupFileOrd = BBackupStepDetails.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$backup$BBackupStepDetails == null ? (class$com$tridium$provisioningNiagara$backup$BBackupStepDetails = BBackupStepDetails.class$("com.tridium.provisioningNiagara.backup.BBackupStepDetails")) : class$com$tridium$provisioningNiagara$backup$BBackupStepDetails));
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$backup$BBackupStepDetails;

    public BOrd getBackupFileOrd() {
        return (BOrd)this.get(backupFileOrd);
    }

    public void setBackupFileOrd(BOrd bOrd) {
        this.set(backupFileOrd, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBackupStepDetails() {
    }

    public BBackupStepDetails(BNiagaraStation bNiagaraStation, BDeviceJobStep bDeviceJobStep) {
        super((BDevice)bNiagaraStation, bDeviceJobStep);
        try {
            BBackupStationExt bBackupStationExt = (BBackupStationExt)bNiagaraStation.getMixIn(BBackupStationExt.TYPE);
            this.setBackupFileOrd(bBackupStationExt.newBackupFileOrd());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BOrd startRestoreJob(BObject bObject, Context context) throws Exception {
        BBatchJobService bBatchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(bObject);
        bBatchJobService.lease();
        BIFile bIFile = (BIFile)this.getBackupFileOrd().get(bObject);
        BNiagaraNetworkJob bNiagaraNetworkJob = new BNiagaraNetworkJob(((BString)this.getDeviceId()).toString());
        bNiagaraNetworkJob.addStep(new BInstallStep(bIFile, false));
        return bBatchJobService.submitJob((BBatchJob)bNiagaraNetworkJob, null).getNavOrd();
    }

    public void doDispose() throws Exception {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        if (!this.getBackupFileOrd().isNull()) {
            try {
                BIFile bIFile = (BIFile)this.getBackupFileOrd().get();
                Log.getLog((String)"provisioningNiagara").message("Deleting backup file " + bIFile.getFilePath().getBody());
                bIFile.delete();
            }
            catch (UnresolvedException unresolvedException) {
                Log.getLog((String)"provisioningNiagara").error("Backup file not found: " + this.getBackupFileOrd());
            }
            catch (IOException iOException) {
                Log.getLog((String)"provisioningNiagara").error("Error deleting backup file " + this.getBackupFileOrd(), (Throwable)iOException);
            }
            this.setBackupFileOrd(BOrd.NULL);
        }
        super.doDispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

