/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.backup;

import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.provisioningNiagara.backup.BBackupStepDetails;
import com.tridium.provisioningNiagara.software.BInstallStep;
import com.tridium.util.TimeFormat;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.provisioningNiagara.backup.BProvisioningBackupStep;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

public class BBackupStationExt
extends BProvisioningStationExt {
    public static final Property lastBackupTime = BBackupStationExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Action startBackup = BBackupStationExt.newAction((int)0, null);
    public static final Topic backupCreated = BBackupStationExt.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$backup$BBackupStationExt == null ? (class$com$tridium$provisioningNiagara$backup$BBackupStationExt = BBackupStationExt.class$("com.tridium.provisioningNiagara.backup.BBackupStationExt")) : class$com$tridium$provisioningNiagara$backup$BBackupStationExt));
    private static final BIcon icon = BIcon.std((String)"backup.png");
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$backup$BBackupStationExt;
    static /* synthetic */ Class class$javax$baja$file$BIFile;
    static /* synthetic */ Class class$javax$baja$batchJob$BIJobStepSummary;

    public BAbsTime getLastBackupTime() {
        return (BAbsTime)this.get(lastBackupTime);
    }

    public void setLastBackupTime(BAbsTime bAbsTime) {
        this.set(lastBackupTime, (BValue)bAbsTime, null);
    }

    public BOrd startBackup() {
        return (BOrd)this.invoke(startBackup, null, null);
    }

    public void fireBackupCreated(BOrd bOrd) {
        this.fire(backupCreated, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBatchJob startRestore(BIFile bIFile, Context context) throws Exception {
        BNiagaraNetworkJob bNiagaraNetworkJob = new BNiagaraNetworkJob(this.getNiagaraStation().getStationName());
        bNiagaraNetworkJob.addStep(new BInstallStep(bIFile, false));
        BBatchJobService bBatchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)this);
        return bBatchJobService.submitJob((BBatchJob)bNiagaraNetworkJob, context);
    }

    public BIFile[] listBackupFiles() throws Exception {
        BBatchJobService bBatchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)this);
        bBatchJobService.lease(3);
        Array array = new Array(class$javax$baja$file$BIFile == null ? (class$javax$baja$file$BIFile = BBackupStationExt.class$("javax.baja.file.BIFile")) : class$javax$baja$file$BIFile);
        Cursor cursor = bBatchJobService.getJobQueryManager().listStepSummaries(BProvisioningBackupStep.TYPE, "deviceId", (BSimple)BString.make((String)this.getNiagaraStation().getStationName()), (BObject)this);
        while (cursor.next(class$javax$baja$batchJob$BIJobStepSummary == null ? BBackupStationExt.class$("javax.baja.batchJob.BIJobStepSummary") : class$javax$baja$batchJob$BIJobStepSummary)) {
            try {
                BBackupStepDetails bBackupStepDetails = (BBackupStepDetails)BBatchJobStepLogFile.find((BIJobStepSummary)((BIJobStepSummary)cursor.get()), (BObject)this).getDetails();
                if (bBackupStepDetails.getState() != BJobState.success) continue;
                try {
                    array.add((Object)((BIFile)bBackupStepDetails.getBackupFileOrd().get((BObject)this)));
                }
                catch (UnresolvedException unresolvedException) {
                }
            }
            catch (UnresolvedException unresolvedException) {}
        }
        return (BIFile[])array.trim();
    }

    public String getDisplayNameInParent(Context context) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("BackupStationExt");
    }

    public BOrd doStartBackup(Context context) throws Exception {
        if (this.isUnoperational()) {
            return BOrd.NULL;
        }
        BBatchJob bBatchJob = BProvisioningBackupStep.makeJob(this.getNiagaraStation().getStationName());
        bBatchJob.submit(context);
        return bBatchJob.getHandleOrd();
    }

    public BOrd newBackupFileOrd() throws Exception {
        String string = this.getNiagaraStation().getStationName();
        FilePath filePath = new FilePath("^provisioningNiagara/stationData").merge(string).merge("backups");
        StringBuffer stringBuffer = new StringBuffer("backup_");
        stringBuffer.append(string);
        stringBuffer.append("_");
        stringBuffer.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYMMDD_HHmm"));
        stringBuffer.append(".dist");
        return BOrd.make((OrdQuery)filePath.merge(stringBuffer.toString()));
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

