/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BNiagaraProvisioningChannel;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.provisioningNiagara.backup.BBackupStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BSupervisorLicenses;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.software.ProvisioningRegistry;
import com.tridium.provisioningNiagara.station.BStationPollScheduler;
import com.tridium.provisioningNiagara.station.BStationProxy;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.fox.BFoxProxySession;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.provisioningNiagara.backup.BProvisioningBackupStep;
import javax.baja.schedule.BTriggerSchedule;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.units.BUnit;
import javax.baja.util.Array;

public class BProvisioningNiagaraNetworkExt
extends BAbstractService {
    public static final Property backupSchedule = BProvisioningNiagaraNetworkExt.newProperty((int)0, (BValue)new BTriggerSchedule(), null);
    public static final Property software = BProvisioningNiagaraNetworkExt.newProperty((int)3, (BValue)new BSoftwareContainer(), null);
    public static final Property licenses = BProvisioningNiagaraNetworkExt.newProperty((int)1, (BValue)new BSupervisorLicenses(), null);
    public static final Property pollScheduler = BProvisioningNiagaraNetworkExt.newProperty((int)0, (BValue)new BStationPollScheduler(), null);
    public static final Property deviceRebootTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)600, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Property stationShutdownTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)180, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Action startBackup = BProvisioningNiagaraNetworkExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$BProvisioningNiagaraNetworkExt == null ? (class$com$tridium$provisioningNiagara$BProvisioningNiagaraNetworkExt = BProvisioningNiagaraNetworkExt.class$("com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt")) : class$com$tridium$provisioningNiagara$BProvisioningNiagaraNetworkExt));
    private static final Type[] serviceTypes = new Type[]{TYPE};
    public static final Log log = Log.getLog((String)"provisioningNiagara");
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private ProvisioningRegistry installableRegistry = null;
    private int oldStatus = -1;
    private boolean serviceStarted = false;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$BProvisioningNiagaraNetworkExt;
    static /* synthetic */ Class class$java$lang$String;

    public BTriggerSchedule getBackupSchedule() {
        return (BTriggerSchedule)this.get(backupSchedule);
    }

    public void setBackupSchedule(BTriggerSchedule bTriggerSchedule) {
        this.set(backupSchedule, (BValue)bTriggerSchedule, null);
    }

    public BSoftwareContainer getSoftware() {
        return (BSoftwareContainer)this.get(software);
    }

    public void setSoftware(BSoftwareContainer bSoftwareContainer) {
        this.set(software, (BValue)bSoftwareContainer, null);
    }

    public BSupervisorLicenses getLicenses() {
        return (BSupervisorLicenses)this.get(licenses);
    }

    public void setLicenses(BSupervisorLicenses bSupervisorLicenses) {
        this.set(licenses, (BValue)bSupervisorLicenses, null);
    }

    public BStationPollScheduler getPollScheduler() {
        return (BStationPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BStationPollScheduler bStationPollScheduler) {
        this.set(pollScheduler, (BValue)bStationPollScheduler, null);
    }

    public int getDeviceRebootTimeout() {
        return this.getInt(deviceRebootTimeout);
    }

    public void setDeviceRebootTimeout(int n) {
        this.setInt(deviceRebootTimeout, n, null);
    }

    public int getStationShutdownTimeout() {
        return this.getInt(stationShutdownTimeout);
    }

    public void setStationShutdownTimeout(int n) {
        this.setInt(stationShutdownTimeout, n, null);
    }

    public BOrd startBackup() {
        return (BOrd)this.invoke(startBackup, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNiagaraNetwork getNetwork() {
        return (BNiagaraNetwork)this.getParent();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNiagaraNetwork;
    }

    public void started() throws Exception {
        Slot slot = this.getSlot("backupTrigger");
        if (slot == null) {
            this.linkTo("backupTrigger", (BComponent)this.getBackupSchedule(), (Slot)BTriggerSchedule.trigger, (Slot)startBackup);
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        BBatchJobService bBatchJobService;
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = false;
        try {
            Sys.getService((Type)Sys.getType((String)"provisioning:ProvisioningService"));
            this.configFail("Cannot have ProvisioningService and ProvisioningNiagaraNetworkExt on the same station");
            return;
        }
        catch (TypeNotFoundException typeNotFoundException) {
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        try {
            bBatchJobService = (BBatchJobService)Sys.getService((Type)Sys.getType((String)"batchJob:BatchJobService"));
            bBatchJobService.serviceStarted();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.configFail("ProvisioningNiagaraNetworkExt requires that a BatchJobService be installed");
        }
        bBatchJobService = this.getComponentSpace();
        bBatchJobService.enableMixIn(BPlatformConnection.TYPE);
        bBatchJobService.enableMixIn(BStationProxy.TYPE);
        bBatchJobService.enableMixIn(BSoftwareStationExt.TYPE);
        bBatchJobService.enableMixIn(BBackupStationExt.TYPE);
        bBatchJobService.enableMixIn(BLicenseStationExt.TYPE);
        if (BFoxChannelRegistry.getPrototype().get("niagaraProv") == null) {
            BFoxChannelRegistry.getPrototype().add("niagaraProv", (BValue)new BNiagaraProvisioningChannel());
        }
        this.updateStatus();
        this.getSoftware().serviceStarted();
    }

    public void serviceStopped() {
        this.serviceStarted = false;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "provisioning");
    }

    public void updateStatus() {
        int n = this.getStatus().getBits();
        n = !this.getEnabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.isFatalFault() ? (n |= 2) : (n &= 0xFFFFFFFD);
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            BDeviceExt[] bDeviceExtArray = bDeviceArray[i].getDeviceExts();
            for (int j = 0; j < bDeviceExtArray.length; ++j) {
                if (!(bDeviceExtArray[j] instanceof BPlatformConnection) && !(bDeviceExtArray[j] instanceof BProvisioningStationExt)) continue;
                try {
                    bDeviceExtArray[j].updateStatus();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        this.oldStatus = n;
    }

    public static BFoxProxySession getFoxProxySession(BNiagaraStation bNiagaraStation) throws Exception {
        BFoxClientConnection bFoxClientConnection = bNiagaraStation.getClientConnection();
        return BFoxProxySession.make((BHost)bNiagaraStation.getRemoteHost(), (int)bFoxClientConnection.getPort(), (boolean)bFoxClientConnection.getUseFoxs(), (String)bFoxClientConnection.getUsername(), (String)bFoxClientConnection.getPassword().getValue());
    }

    public BOrd doStartBackup(Context context) throws Exception {
        Object object;
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BProvisioningNiagaraNetworkExt.class$("java.lang.String")) : class$java$lang$String);
        for (int i = 0; i < bDeviceArray.length; ++i) {
            object = (BNiagaraStation)bDeviceArray[i];
            BBackupStationExt bBackupStationExt = (BBackupStationExt)object.getMixIn(BBackupStationExt.TYPE);
            if (bBackupStationExt == null || !bBackupStationExt.getEnabled()) continue;
            array.add((Object)object.getStationName());
        }
        if (array.size() > 0) {
            BBatchJobService bBatchJobService = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
            object = new BNiagaraNetworkJob((String[])array.trim());
            ((BNiagaraNetworkJob)((Object)object)).addStep(new BProvisioningBackupStep());
            return (BOrd)bBatchJobService.invoke(BBatchJobService.submitJobAction, (BValue)object, context);
        }
        return BOrd.NULL;
    }

    public ProvisioningRegistry getInstallableRegistry() {
        if (this.installableRegistry == null) {
            BFoxSession bFoxSession = (BFoxSession)this.getSession();
            BNiagaraProvisioningChannel bNiagaraProvisioningChannel = (BNiagaraProvisioningChannel)bFoxSession.getConnection().getChannels().get("niagaraProv", BNiagaraProvisioningChannel.TYPE);
            this.installableRegistry = new ProvisioningRegistry(bNiagaraProvisioningChannel);
        }
        return this.installableRegistry;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

