/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonSSLRequiredException;
import com.tridium.platform.daemon.DaemonSessionListener;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.provisioningNiagara.BPlatformWorker;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.naming.BHost;
import javax.baja.platform.PlatformDaemon;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BPlatformConnection
extends BDeviceExt
implements BIMixIn,
BIPingable,
DaemonSessionListener {
    public static final Property status = BPlatformConnection.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BPlatformConnection.newProperty((int)3, (String)"", null);
    public static final Property port = BPlatformConnection.newProperty((int)0, (int)3011, null);
    public static final Property credentials = BPlatformConnection.newProperty((int)0, (BValue)new BUsernameAndPassword("", ""), null);
    public static final Property secure = BPlatformConnection.newProperty((int)5, (boolean)false, null);
    public static final Property health = BPlatformConnection.newProperty((int)65, (BValue)new BPingHealth(), null);
    public static final Property alarmSourceInfo = BPlatformConnection.newProperty((int)0, (BValue)BPlatformConnection.initAlarmSourceInfo(), null);
    public static final Property worker = BPlatformConnection.newProperty((int)4, (BValue)new BPlatformWorker(), null);
    public static final Action ping = BPlatformConnection.newAction((int)16, null);
    public static final Action ackAlarm = BPlatformConnection.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$BPlatformConnection == null ? (class$com$tridium$provisioningNiagara$BPlatformConnection = BPlatformConnection.class$("com.tridium.provisioningNiagara.BPlatformConnection")) : class$com$tridium$provisioningNiagara$BPlatformConnection));
    private static final BIcon icon = BIcon.std((String)"connection.png");
    static final int FATAL_FAULT = 1;
    private BDaemonSession daemonSession = null;
    private Object sessionMonitor = new Byte(0);
    private int flags = 0;
    private int oldStatus = -1;
    private boolean pingActive = false;
    private HealthSubscriber healthSubscriber = null;
    private static final int MAX_HOST_LENGTH = 2000;
    private AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$BPlatformConnection;
    static /* synthetic */ Class class$javax$baja$naming$BHost;
    static /* synthetic */ Class array$Ljava$lang$String;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword bUsernameAndPassword) {
        this.set(credentials, (BValue)bUsernameAndPassword, null);
    }

    public boolean getSecure() {
        return this.getBoolean(secure);
    }

    public void setSecure(boolean bl) {
        this.setBoolean(secure, bl, null);
    }

    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    public void setHealth(BPingHealth bPingHealth) {
        this.set(health, (BValue)bPingHealth, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo bAlarmSourceInfo) {
        this.set(alarmSourceInfo, (BValue)bAlarmSourceInfo, null);
    }

    public BPlatformWorker getWorker() {
        return (BPlatformWorker)this.get(worker);
    }

    public void setWorker(BPlatformWorker bPlatformWorker) {
        this.set(worker, (BValue)bPlatformWorker, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context context) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("PlatformConnection");
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNiagaraStation;
    }

    public void started() throws Exception {
        Property property = this.getProperty("pingTrigger");
        if (property != null) {
            this.remove(property);
        }
        this.healthSubscriber = new HealthSubscriber();
        this.checkSSLSupport();
        this.checkFatalFault();
        this.updateStatus();
    }

    public void stopped() {
        if (this.healthSubscriber != null) {
            this.healthSubscriber.unsubscribeAll();
            this.healthSubscriber = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == port || property == credentials || property == secure) {
            this.reset();
            if (property == secure) {
                Object object = this.sessionMonitor;
                synchronized (object) {
                    this.daemonSession = null;
                }
            }
            if (property == credentials) {
                this.clearFault();
                this.updateStatus();
            }
        } else if (property == status) {
            BNiagaraStation bNiagaraStation = this.getNiagaraStation();
            BDeviceExt[] bDeviceExtArray = bNiagaraStation.getDeviceExts();
            for (int i = 0; i < bDeviceExtArray.length; ++i) {
                if (!(bDeviceExtArray[i] instanceof BProvisioningStationExt)) continue;
                try {
                    bDeviceExtArray[i].updateStatus();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == ping) {
            Object object = this.sessionMonitor;
            synchronized (object) {
                if (!this.pingActive) {
                    this.pingActive = true;
                    return this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
                }
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() {
        try {
            if (!this.isRunning() || this.isUnoperational()) {
                return;
            }
            try {
                this.getDaemonSession();
                if (this.daemonSession != null) {
                    this.daemonSession.connect();
                    this.daemonSession.sendMessages(new XmlResponseMessage[0], BDaemonSession.DEFAULT_TIMEOUT);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            Object object = this.sessionMonitor;
            synchronized (object) {
                this.pingActive = false;
            }
        }
    }

    public BPingMonitor getMonitor() {
        return this.getNetwork().getMonitor();
    }

    public void pingOk() {
        if (this.getDevice().isRunning()) {
            this.getHealth().pingOk();
            this.clearFault();
            if (this.getStatus().isDown()) {
                this.updateStatus();
            }
        }
    }

    public void pingFail(String string) {
        this.getHealth().pingFail(string);
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        return this.getHealth().doAckAlarm(bAlarmRecord);
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo bAlarmSourceInfo = new BAlarmSourceInfo();
        bAlarmSourceInfo.setSourceName(BFormat.make((String)"%parent.parent.parent.displayName% %parent.parent.displayName% %parent.displayName%"));
        bAlarmSourceInfo.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        bAlarmSourceInfo.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return bAlarmSourceInfo;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    protected void setFault(String string) {
        if (!this.getStatus().isFault()) {
            int n = this.getStatus().getBits();
            this.setFaultCause(string);
            this.setStatus(BStatus.make((int)(n |= 2)));
        }
    }

    protected void clearFault() {
        if (!this.fatalFault() && this.getStatus().isFault() && !this.getNiagaraStation().isFault()) {
            int n = this.getStatus().getBits();
            this.setFaultCause("");
            this.setStatus(BStatus.make((int)(n &= 0xFFFFFFFD)));
        }
    }

    public final boolean isUnoperational() {
        return this.isFatalFault() || this.isFault() || this.isDisabled();
    }

    public final boolean isFatalFault() {
        return this.fatalFault();
    }

    private void checkFatalFault() {
        if (this.fatalFault()) {
            return;
        }
        try {
            BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            if (bProvisioningNiagaraNetworkExt.isFatalFault()) {
                this.fatalFault(true);
                this.setFaultCause("Network extension fault: " + bProvisioningNiagaraNetworkExt.getFaultCause());
                return;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        if (this.getNiagaraStation() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
            return;
        }
        if (this.getNiagaraStation().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
            return;
        }
        if (this.getNiagaraNetwork() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraNetwork");
            return;
        }
        if (this.getNiagaraNetwork().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Network fault: " + this.getNiagaraNetwork().getFaultCause());
            return;
        }
    }

    public BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getDevice();
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDaemonSession getDaemonSession() throws Exception {
        if (!this.isRunning()) {
            return null;
        }
        Object object = this.sessionMonitor;
        synchronized (object) {
            if (this.daemonSession != null && !this.getNiagaraStation().getRemoteHost().equals((Object)this.daemonSession.getHost())) {
                this.reset();
            }
            if (this.daemonSession == null) {
                BHost bHost = this.getNiagaraStation().getRemoteHost();
                try {
                    if (this.getSecure()) {
                        Class clazz = this.getSecureSessionClass();
                        if (clazz == null) {
                            this.setSecure(false);
                            throw new BajaRuntimeException("PlatCrypto module required for secure communication.");
                        }
                        if (clazz != null) {
                            this.daemonSession = this.getSecureSession(clazz, bHost, this.getPort());
                        }
                    } else {
                        this.daemonSession = BDaemonSession.make((BHost)bHost, (int)this.getPort());
                    }
                    this.connect(this.daemonSession);
                }
                catch (DaemonSSLRequiredException daemonSSLRequiredException) {
                    Class clazz = this.getSecureSessionClass();
                    if (clazz != null) {
                        Integer n = this.getSSLPort(daemonSSLRequiredException.getNewLocation());
                        this.daemonSession = this.getSecureSession(this.getSecureSessionClass(), bHost, n);
                        this.connect(this.daemonSession);
                        this.setSecure(true);
                        if (n != null) {
                            this.setPort(n);
                        }
                    }
                    this.daemonSession = null;
                    throw new BajaRuntimeException("PlatCrypto module required for secure communication.");
                }
                catch (AuthenticationException authenticationException) {
                    this.daemonSession = null;
                }
                catch (Exception exception) {
                    this.daemonSession = null;
                    throw exception;
                }
            }
            return this.daemonSession;
        }
    }

    private Integer getSSLPort(String string) {
        try {
            int n;
            if (string != null && string.length() < 2000 && string.startsWith("https://") && (n = string.lastIndexOf(":")) > 0) {
                return Integer.valueOf(string.substring(n + 1, string.length() - 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5011;
    }

    private void connect(BDaemonSession bDaemonSession) throws Exception {
        this.daemonSession.addListener((DaemonSessionListener)this);
        this.daemonSession.setCredentials((BICredentials)this.getCredentials(), true);
        this.daemonSession.connect();
    }

    private void checkSSLSupport() {
        boolean bl;
        boolean bl2 = bl = this.getSecureSessionClass() != null;
        if (bl) {
            this.showProperty(secure);
        } else {
            this.hideProperty(secure);
            this.setSecure(false);
        }
    }

    private void hideProperty(Property property) {
        this.setFlags((Slot)property, this.getFlags((Slot)property) | 1 | 4);
    }

    private void showProperty(Property property) {
        this.setFlags((Slot)property, this.getFlags((Slot)property) & 0xFFFFFFFA);
    }

    private BDaemonSession getSecureSession(Class clazz, BHost bHost, Integer n) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getMethod("make", class$javax$baja$naming$BHost == null ? (class$javax$baja$naming$BHost = BPlatformConnection.class$("javax.baja.naming.BHost")) : class$javax$baja$naming$BHost, Integer.TYPE, array$Ljava$lang$String == null ? (array$Ljava$lang$String = BPlatformConnection.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        return (BDaemonSession)method.invoke((Object)clazz, bHost, n, null);
    }

    private Class getSecureSessionClass() {
        try {
            Type type = Sys.getType((String)"platCrypto:DaemonSecureSession");
            if (type != null) {
                return type.getTypeClass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public PlatformDaemon getPlatformDaemon() throws Exception {
        return NiagaraPlatformDaemon.make((BDaemonSession)this.getDaemonSession(), null);
    }

    public void reset() {
        if (this.daemonSession != null) {
            try {
                this.daemonSession.removeListener((DaemonSessionListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.daemonSession = null;
    }

    public void sessionConnected(BDaemonSession bDaemonSession) {
        this.pingOk();
    }

    public void sessionDisconnected(BDaemonSession bDaemonSession) {
        this.getHealth().setDown(true);
        this.updateStatus();
    }

    public void sessionConnectionError(BDaemonSession bDaemonSession, Throwable throwable) {
        if (throwable instanceof AuthenticationException) {
            this.pingFail("Authentication Failed");
            this.setFault("Authentication Failed");
        } else {
            this.clearFault();
            this.pingFail(throwable.toString());
        }
    }

    public void updateStatus() {
        BStatus bStatus;
        int n = this.getStatus().getBits();
        BNiagaraStation bNiagaraStation = this.getNiagaraStation();
        if (bNiagaraStation == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
        }
        if (this.getCredentials().getUsername().trim().length() == 0) {
            n |= 2;
            this.setFaultCause("Missing user name");
        }
        BStatus bStatus2 = bNiagaraStation == null ? BStatus.ok : bNiagaraStation.getStatus();
        BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = null;
        try {
            bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        BStatus bStatus3 = bStatus = bProvisioningNiagaraNetworkExt == null ? BStatus.ok : bProvisioningNiagaraNetworkExt.getStatus();
        n = bStatus2.isDisabled() || bStatus.isDisabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.getHealth().inFailure() ? (n |= 4) : (n &= 0xFFFFFFFB);
        if (this.fatalFault()) {
            n |= 2;
        } else if (bProvisioningNiagaraNetworkExt == null) {
            n |= 2;
            this.setFaultCause("No niagara provisioning network extension");
        } else if (bStatus2.isFault()) {
            n |= 2;
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
        }
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 502) {
            return this.alarmSupport;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public BIcon getIcon() {
        return icon;
    }

    private boolean fatalFault() {
        return (this.flags & 1) != 0;
    }

    private void fatalFault(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HealthSubscriber
    extends Subscriber {
        private BAbsTime lastFailTime;
        private BAbsTime lastOkTime;

        public HealthSubscriber() {
            this.subscribe((BComponent)BPlatformConnection.this.getNiagaraStation(), 1);
            this.lastFailTime = BPlatformConnection.this.getNiagaraStation().getHealth().getLastFailTime();
            this.lastOkTime = BPlatformConnection.this.getNiagaraStation().getHealth().getLastOkTime();
        }

        public void event(BComponentEvent bComponentEvent) {
            BPingHealth bPingHealth;
            if (!(bComponentEvent.getId() != 0 || bComponentEvent.getSlot().asProperty() != BNiagaraStation.health || (bPingHealth = (BPingHealth)bComponentEvent.getValue()).getLastFailTime().equals((Object)this.lastFailTime) && bPingHealth.getLastOkTime().equals((Object)this.lastOkTime))) {
                this.lastFailTime = bPingHealth.getLastFailTime();
                this.lastOkTime = bPingHealth.getLastOkTime();
                BPlatformConnection.this.ping();
            }
        }
    }
}

