/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxObject;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.ClosableCursor;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.ConsoleInputStream;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.fox.ChunkedInputStream;
import com.tridium.platform.fox.ChunkedOutputStream;
import com.tridium.platform.fox.MessageClient;
import com.tridium.platform.fox.TaskDispatcher;
import com.tridium.platform.fox.TaskListenerClient;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.naming.BOrd;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;

public class BNiagaraProvisioningChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$BNiagaraProvisioningChannel == null ? (class$com$tridium$provisioningNiagara$BNiagaraProvisioningChannel = BNiagaraProvisioningChannel.class$("com.tridium.provisioningNiagara.BNiagaraProvisioningChannel")) : class$com$tridium$provisioningNiagara$BNiagaraProvisioningChannel));
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$BNiagaraProvisioningChannel;
    static /* synthetic */ Class class$com$tridium$sys$license$dom$VendorLicense;
    static /* synthetic */ Class class$com$tridium$platform$license$BEnvLicenseSummary;
    static /* synthetic */ Class class$com$tridium$platform$license$BCertificateSummary;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BNiagaraProvisioningChannel() {
        super("niagaraProv");
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "getFilesystemAttributes") {
            return this.getFilesystemAttributes(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        if (string == "findInstallable") {
            this.findInstallable(foxCircuit);
            return;
        }
        if (string == "getInstallableByPath") {
            this.getInstallableByPath(foxCircuit);
            return;
        }
        if (string == "findInstallables") {
            this.findInstallables(foxCircuit);
            return;
        }
        if (string == "getInstallables") {
            this.getInstallables(foxCircuit);
            return;
        }
        if (string == "registerInstallable") {
            this.registerInstallable(foxCircuit);
            return;
        }
        if (string == "registerStationInstallable") {
            this.registerStationInstallable(foxCircuit);
            return;
        }
        if (string == "getStationOutput") {
            this.getStationOutput(foxCircuit);
            return;
        }
        if (string == "startStation") {
            this.startStation(foxCircuit);
            return;
        }
        if (string == "stopStation") {
            this.stopStation(foxCircuit);
            return;
        }
        if (string == "killStation") {
            this.killStation(foxCircuit);
            return;
        }
        if (string == "saveStation") {
            this.saveStation(foxCircuit);
            return;
        }
        if (string == "getUpdatedLicenses") {
            this.getUpdatedLicenses(foxCircuit);
            return;
        }
        if (string == "getLicenseSummaries") {
            this.getLicenseSummaries(foxCircuit);
            return;
        }
        if (string == "importLicenseFile") {
            this.importLicenseFile(foxCircuit);
            return;
        }
        if (string == "importLicenseArchiveFile") {
            this.importLicenseArchiveFile(foxCircuit);
            return;
        }
        if (string == "getLicensedHostIds") {
            this.getLicensedHostIds(foxCircuit);
            return;
        }
        if (string == "getLicenses") {
            this.getLicenses(foxCircuit);
            return;
        }
        if (string == "exportLicenses") {
            this.exportLicenses(foxCircuit);
            return;
        }
        if (string == "removeLicense") {
            this.removeLicense(foxCircuit);
            return;
        }
        if (string == "addLicense") {
            this.addLicense(foxCircuit);
            return;
        }
        if (string == "licenseIterator") {
            this.licenseIterator(foxCircuit);
            return;
        }
        if (string == "getCertificateSummaries") {
            this.getCertificateSummaries(foxCircuit);
            return;
        }
        if (string == "addCertificate") {
            this.addCertificate(foxCircuit);
            return;
        }
        throw new InvalidCommandException(string);
    }

    public BFilesystemAttributes getFilesystemAttributes(String string, FilePath filePath) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getFilesystemAttributes");
        }
        FoxRequest foxRequest = this.makeRequest("getFilesystemAttributes");
        foxRequest.add("stationName", string);
        foxRequest.add("path", filePath.getBody());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        FoxObject foxObject = (FoxObject)foxResponse.getOptional("attributes");
        if (foxObject == null) {
            return null;
        }
        return (BFilesystemAttributes)DecoderFactory.decode((FoxObject)foxObject, null);
    }

    public FoxResponse getFilesystemAttributes(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        FilePath filePath = new FilePath(foxRequest.getString("path"));
        BNiagaraStation bNiagaraStation = this.getStation((FoxMessage)foxRequest);
        if (bNiagaraStation != null) {
            BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
            BogCodec.add((FoxMessage)foxResponse, (String)"attributes", (BValue)DaemonFileUtil.getFilesystemAttributes((BDaemonSession)bPlatformConnection.getDaemonSession(), (FilePath)filePath), null);
        }
        return foxResponse;
    }

    public void startStation(String string, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:startStation");
        }
        this.stationControl("startStation", string, iCancelHint, daemonSessionTaskListener);
    }

    public void startStation(FoxCircuit foxCircuit) throws Exception {
        BStationSurrogate bStationSurrogate;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:startStation");
        }
        if ((bStationSurrogate = this.getStationSurrogate(foxMessage)) != null) {
            bStationSurrogate.startStation(null, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("type", "end");
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void saveStation(String string, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:saveStation");
        }
        this.stationControl("saveStation", string, iCancelHint, daemonSessionTaskListener);
    }

    public void saveStation(FoxCircuit foxCircuit) throws Exception {
        BStationSurrogate bStationSurrogate;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:saveStation");
        }
        if ((bStationSurrogate = this.getStationSurrogate(foxMessage)) != null) {
            bStationSurrogate.saveStation(null, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("type", "end");
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void stopStation(String string, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:stopStation");
        }
        this.stationControl("stopStation", string, iCancelHint, daemonSessionTaskListener);
    }

    public void stopStation(FoxCircuit foxCircuit) throws Exception {
        BStationSurrogate bStationSurrogate;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:stopStation");
        }
        if ((bStationSurrogate = this.getStationSurrogate(foxMessage)) != null) {
            bStationSurrogate.stopStation(BStationProxy.stationShutdownCancelHint(null, null), (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("type", "end");
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void killStation(String string, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:killStation");
        }
        this.stationControl("killStation", string, iCancelHint, daemonSessionTaskListener);
    }

    public void killStation(FoxCircuit foxCircuit) throws Exception {
        BStationSurrogate bStationSurrogate;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:killStation");
        }
        if ((bStationSurrogate = this.getStationSurrogate(foxMessage)) != null) {
            bStationSurrogate.killStation(null, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("type", "end");
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public InputStream getStationOutput(String string, boolean bl, boolean bl2) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getStationOutput");
        }
        FoxCircuit foxCircuit = this.openCircuit("getStationOutput");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("stationName", string);
        foxMessage.add("follow", bl);
        foxMessage.add("updatesOnly", bl2);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        return ConsoleInputStream.make((InputStream)foxCircuit.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getStationOutput(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getStationOutput");
        }
        boolean bl = foxMessage.getBoolean("follow");
        boolean bl2 = foxMessage.getBoolean("updatesOnly");
        BStationSurrogate bStationSurrogate = this.getStationSurrogate(foxMessage);
        if (bStationSurrogate == null) return;
        InputStream inputStream = bStationSurrogate.getStationOutput(bl, bl2);
        OutputStream outputStream = foxCircuit.getOutputStream();
        try {
            int n = 4096;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[]{0, 0, 0, 0};
            long l = Clock.ticks();
            while (true) {
                long l2;
                int n2;
                block26: {
                    n2 = inputStream.read(byArray, 0, n);
                    if (n2 >= 0) break block26;
                    return;
                }
                try {
                    if (n2 == 0) {
                        l2 = Clock.ticks();
                        if (l2 - l > 500L) {
                            outputStream.write(byArray2, 0, 4);
                            l = l2;
                        }
                    } else {
                        outputStream.write(n2 >>> 24 & 0xFF);
                        outputStream.write(n2 >>> 16 & 0xFF);
                        outputStream.write(n2 >>> 8 & 0xFF);
                        outputStream.write(n2 >>> 0 & 0xFF);
                        outputStream.write(byArray, 0, n2);
                        l = Clock.ticks();
                    }
                    outputStream.flush();
                    foxCircuit.flush();
                }
                catch (InterruptedIOException interruptedIOException) {
                    l2 = Clock.ticks();
                    if (l2 - l <= 500L) continue;
                    outputStream.write(byArray2, 0, 4);
                    outputStream.flush();
                    foxCircuit.flush();
                    l = l2;
                }
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private void stationControl(String string, String string2, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit(string);
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("stationName", string2);
        TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        try {
            while (true) {
                if (iCancelHint != null && iCancelHint.isCanceled()) {
                    throw new ICancelHint.CanceledException();
                }
                FoxMessage foxMessage2 = foxCircuit.readMessage();
                if (taskListenerClient.handleMessage(foxMessage2) || !foxMessage2.getString("type").equals("end")) continue;
                return;
            }
        }
        finally {
            taskListenerClient.close();
        }
    }

    private BNiagaraStation getStation(FoxMessage foxMessage) throws Exception {
        String string = foxMessage.getString("stationName");
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[i];
            if (!bNiagaraStation.getStationName().equals(string)) continue;
            return bNiagaraStation;
        }
        return null;
    }

    private BStationSurrogate getStationSurrogate(FoxMessage foxMessage) throws Exception {
        BNiagaraStation bNiagaraStation = this.getStation(foxMessage);
        if (bNiagaraStation == null) {
            return null;
        }
        BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
        return BStationSurrogate.make((BDaemonSession)bPlatformConnection.getDaemonSession(), (String)bNiagaraStation.getStationName());
    }

    public VendorLicense[] getUpdatedLicenses(BEnvLicenseSummary[] bEnvLicenseSummaryArray) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getUpdatedLicenses");
        }
        FoxCircuit foxCircuit = this.openCircuit("getUpdatedLicenses");
        for (int i = 0; i < bEnvLicenseSummaryArray.length; ++i) {
            this.writeLicenseSummaryMessage(foxCircuit, bEnvLicenseSummaryArray[i]);
        }
        this.writeEndOfDataMessage(foxCircuit);
        foxCircuit.flush();
        Array array = new Array(class$com$tridium$sys$license$dom$VendorLicense == null ? (class$com$tridium$sys$license$dom$VendorLicense = BNiagaraProvisioningChannel.class$("com.tridium.sys.license.dom.VendorLicense")) : class$com$tridium$sys$license$dom$VendorLicense);
        VendorLicense vendorLicense = this.readLicense(foxCircuit);
        while (vendorLicense != null) {
            array.add((Object)vendorLicense);
            vendorLicense = this.readLicense(foxCircuit);
        }
        return (VendorLicense[])array.trim();
    }

    public void getUpdatedLicenses(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getUpdatedLicenses");
        }
        BEnvLicenseSummary bEnvLicenseSummary = this.readLicenseSummary(foxCircuit);
        while (bEnvLicenseSummary != null) {
            VendorLicense[] vendorLicenseArray = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])new BEnvLicenseSummary[]{bEnvLicenseSummary}, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
            for (int i = 0; i < vendorLicenseArray.length; ++i) {
                this.writeLicenseMessage(foxCircuit, vendorLicenseArray[i]);
            }
            bEnvLicenseSummary = this.readLicenseSummary(foxCircuit);
        }
        this.writeEndOfDataMessage(foxCircuit);
        foxCircuit.flush();
    }

    public BEnvLicenseSummary[] getLicenseSummaries(String[] stringArray) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getLicenseSummaries");
        }
        FoxCircuit foxCircuit = this.openCircuit("getLicenseSummaries");
        FoxMessage foxMessage = new FoxMessage();
        for (int i = 0; i < stringArray.length; ++i) {
            foxMessage.add("hostId", stringArray[i]);
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        Array array = new Array(class$com$tridium$platform$license$BEnvLicenseSummary == null ? (class$com$tridium$platform$license$BEnvLicenseSummary = BNiagaraProvisioningChannel.class$("com.tridium.platform.license.BEnvLicenseSummary")) : class$com$tridium$platform$license$BEnvLicenseSummary);
        BEnvLicenseSummary bEnvLicenseSummary = this.readLicenseSummary(foxCircuit);
        while (bEnvLicenseSummary != null) {
            array.add((Object)bEnvLicenseSummary);
            bEnvLicenseSummary = this.readLicenseSummary(foxCircuit);
        }
        return (BEnvLicenseSummary[])array.trim();
    }

    public void getLicenseSummaries(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getLicenseSummaries");
        }
        FoxMessage foxMessage = foxCircuit.readMessage();
        String[] stringArray = foxMessage.listStrings("hostId");
        for (int i = 0; i < stringArray.length; ++i) {
            VendorLicense[] vendorLicenseArray = LicenseDatabase.LOCAL_INSTANCE.getLicenses(stringArray[i]);
            BEnvLicenseSummary[] bEnvLicenseSummaryArray = BEnvLicenseSummary.make((VendorLicense[])vendorLicenseArray);
            for (int j = 0; j < bEnvLicenseSummaryArray.length; ++j) {
                this.writeLicenseSummaryMessage(foxCircuit, bEnvLicenseSummaryArray[j]);
            }
        }
        this.writeEndOfDataMessage(foxCircuit);
        foxCircuit.flush();
    }

    public BCertificateSummary[] getCertificateSummaries() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getCertificateSummaries");
        }
        FoxCircuit foxCircuit = this.openCircuit("getCertificateSummaries");
        Array array = new Array(class$com$tridium$platform$license$BCertificateSummary == null ? (class$com$tridium$platform$license$BCertificateSummary = BNiagaraProvisioningChannel.class$("com.tridium.platform.license.BCertificateSummary")) : class$com$tridium$platform$license$BCertificateSummary);
        BCertificateSummary bCertificateSummary = this.readCertSummary(foxCircuit);
        while (bCertificateSummary != null) {
            array.add((Object)bCertificateSummary);
            bCertificateSummary = this.readCertSummary(foxCircuit);
        }
        return (BCertificateSummary[])array.trim();
    }

    public void getCertificateSummaries(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getCertificateSummaries");
        }
        BCertificateSummary[] bCertificateSummaryArray = BCertificateSummary.make((VendorCertificate[])CertificateDatabase.LOCAL_INSTANCE.getCertificates());
        for (int i = 0; i < bCertificateSummaryArray.length; ++i) {
            this.writeCertSummaryMessage(foxCircuit, bCertificateSummaryArray[i]);
        }
        this.writeEndOfDataMessage(foxCircuit);
        foxCircuit.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLicenseFile(BIFile bIFile) throws Exception {
        FoxCircuit foxCircuit;
        if (this.isTraceOn()) {
            this.trace("c:importLicenseFile");
        }
        if (bIFile instanceof BLicenseFile) {
            foxCircuit = this.openCircuit("importLicenseFile");
        } else if (bIFile instanceof BLicenseArchiveFile) {
            foxCircuit = this.openCircuit("importLicenseArchiveFile");
        } else {
            throw new IllegalArgumentException(bIFile.getFilePath().getBody() + " is not a valid license file");
        }
        InputStream inputStream = bIFile.getInputStream();
        ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(foxCircuit);
        try {
            FileUtil.pipe((InputStream)inputStream, (long)bIFile.getSize(), (OutputStream)chunkedOutputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                chunkedOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void importLicenseFile(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:importLicenseFile");
        }
        LicenseDatabase.LOCAL_INSTANCE.add(VendorLicense.make((String)"provClient", (InputStream)new ChunkedInputStream(foxCircuit), (boolean)true));
    }

    public void importLicenseArchiveFile(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:importLicenseArchiveFile");
        }
        LicenseDatabase.LOCAL_INSTANCE.importLicenses((InputStream)new ChunkedInputStream(foxCircuit));
    }

    public String[] getLicensedHostIds() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getLicensedHostIds");
        }
        FoxCircuit foxCircuit = this.openCircuit("getLicensedHostIds");
        FoxMessage foxMessage = foxCircuit.readMessage();
        return foxMessage.listStrings("hostId");
    }

    public void getLicensedHostIds(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getLicensedHostIds");
        }
        String[] stringArray = LicenseDatabase.LOCAL_INSTANCE.getHostIds();
        FoxMessage foxMessage = new FoxMessage();
        for (int i = 0; i < stringArray.length; ++i) {
            foxMessage.add("hostId", stringArray[i]);
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
    }

    public VendorLicense[] getLicenses(String string) throws Exception {
        VendorLicense vendorLicense;
        if (this.isTraceOn()) {
            this.trace("c:getLicenses");
        }
        FoxCircuit foxCircuit = this.openCircuit("getLicenses");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("hostId", string);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        Array array = new Array(class$com$tridium$sys$license$dom$VendorLicense == null ? (class$com$tridium$sys$license$dom$VendorLicense = BNiagaraProvisioningChannel.class$("com.tridium.sys.license.dom.VendorLicense")) : class$com$tridium$sys$license$dom$VendorLicense);
        while ((vendorLicense = this.readLicense(foxCircuit)) != null) {
            array.add((Object)vendorLicense);
        }
        return (VendorLicense[])array.trim();
    }

    public void getLicenses(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getLicenses");
        }
        FoxMessage foxMessage = foxCircuit.readMessage();
        VendorLicense[] vendorLicenseArray = LicenseDatabase.LOCAL_INSTANCE.getLicenses(foxMessage.getString("hostId"));
        for (int i = 0; i < vendorLicenseArray.length; ++i) {
            this.writeLicenseMessage(foxCircuit, vendorLicenseArray[i]);
        }
        this.writeEndOfDataMessage(foxCircuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLicenses(OutputStream outputStream) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:exportLicenses");
        }
        FoxCircuit foxCircuit = this.openCircuit("exportLicenses");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("scope", "all");
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        ChunkedInputStream chunkedInputStream = new ChunkedInputStream(foxCircuit);
        try {
            FileUtil.pipe((InputStream)chunkedInputStream, (OutputStream)outputStream);
        }
        finally {
            try {
                chunkedInputStream.close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLicenses(String[] stringArray, OutputStream outputStream) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:exportLicenses");
        }
        FoxCircuit foxCircuit = this.openCircuit("exportLicenses");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("scope", "hostIds");
        for (int i = 0; i < stringArray.length; ++i) {
            foxMessage.add("hostId", stringArray[i]);
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        ChunkedInputStream chunkedInputStream = new ChunkedInputStream(foxCircuit);
        try {
            FileUtil.pipe((InputStream)chunkedInputStream, (OutputStream)outputStream);
        }
        finally {
            try {
                chunkedInputStream.close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLicenses(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:exportLicenses");
        }
        FoxMessage foxMessage = foxCircuit.readMessage();
        ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(foxCircuit);
        try {
            if (foxMessage.getString("scope").equals("all")) {
                LicenseDatabase.LOCAL_INSTANCE.exportLicenses((OutputStream)chunkedOutputStream);
            } else {
                LicenseDatabase.LOCAL_INSTANCE.exportLicenses(foxMessage.listStrings("hostId"), (OutputStream)chunkedOutputStream);
            }
        }
        finally {
            try {
                chunkedOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void removeLicense(VendorLicense vendorLicense) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:removeLicense");
        }
        FoxCircuit foxCircuit = this.openCircuit("removeLicense");
        this.writeLicenseMessage(foxCircuit, vendorLicense);
    }

    public void removeLicense(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:removeLicense");
        }
        LicenseDatabase.LOCAL_INSTANCE.remove(this.readLicense(foxCircuit));
    }

    public boolean addLicense(VendorLicense vendorLicense) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:addLicense");
        }
        FoxCircuit foxCircuit = this.openCircuit("addLicense");
        this.writeLicenseMessage(foxCircuit, vendorLicense);
        FoxMessage foxMessage = foxCircuit.readMessage();
        return foxMessage.getBoolean("result");
    }

    public void addLicense(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:addLicense");
        }
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("result", LicenseDatabase.LOCAL_INSTANCE.add(this.readLicense(foxCircuit)));
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
    }

    public boolean addCertificate(VendorCertificate vendorCertificate) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:addCertificate");
        }
        FoxCircuit foxCircuit = this.openCircuit("addCertificate");
        this.writeCertificateMessage(foxCircuit, vendorCertificate);
        FoxMessage foxMessage = foxCircuit.readMessage();
        return foxMessage.getBoolean("result");
    }

    public void addCertificate(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:addCertificate");
        }
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("result", CertificateDatabase.LOCAL_INSTANCE.add(this.readCertificate(foxCircuit)));
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
    }

    public Iterator licenseIterator() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:licenseIterator");
        }
        return new LicenseIterator(this.openCircuit("licenseIterator"));
    }

    public void licenseIterator(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:licenseIterator");
        }
        Iterator iterator = LicenseDatabase.LOCAL_INSTANCE.iterator();
        while (iterator.hasNext()) {
            this.writeLicenseMessage(foxCircuit, (VendorLicense)iterator.next());
        }
        this.writeEndOfDataMessage(foxCircuit);
    }

    private void writeLicenseSummaryMessage(FoxCircuit foxCircuit, BEnvLicenseSummary bEnvLicenseSummary) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("type", "licenseSummary");
        BogCodec.add((FoxMessage)foxMessage, (String)"data", (BValue)bEnvLicenseSummary, null);
        foxCircuit.writeMessage(foxMessage);
    }

    private BEnvLicenseSummary readLicenseSummary(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        while (!foxMessage.getString("type").equals("licenseSummary")) {
            if (foxMessage.getString("type").equals("endOfData")) {
                return null;
            }
            foxMessage = foxCircuit.readMessage();
        }
        return (BEnvLicenseSummary)DecoderFactory.decode((FoxMessage)foxMessage, (String)"data", null);
    }

    private void writeCertSummaryMessage(FoxCircuit foxCircuit, BCertificateSummary bCertificateSummary) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("type", "certSummary");
        BogCodec.add((FoxMessage)foxMessage, (String)"data", (BValue)bCertificateSummary, null);
        foxCircuit.writeMessage(foxMessage);
    }

    private BCertificateSummary readCertSummary(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        while (!foxMessage.getString("type").equals("certSummary")) {
            if (foxMessage.getString("type").equals("endOfData")) {
                return null;
            }
            foxMessage = foxCircuit.readMessage();
        }
        return (BCertificateSummary)DecoderFactory.decode((FoxMessage)foxMessage, (String)"data", null);
    }

    private void writeLicenseMessage(FoxCircuit foxCircuit, VendorLicense vendorLicense) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("type", "license");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        vendorLicense.save((OutputStream)byteArrayOutputStream, true);
        foxMessage.add("data", byteArrayOutputStream.toByteArray());
        foxCircuit.writeMessage(foxMessage);
    }

    private VendorLicense readLicense(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        while (!foxMessage.getString("type").equals("license")) {
            if (foxMessage.getString("type").equals("endOfData")) {
                return null;
            }
            foxMessage = foxCircuit.readMessage();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(foxMessage.getBlob("data"));
        return VendorLicense.make((String)"provisioning", (InputStream)byteArrayInputStream, (boolean)true);
    }

    private void writeCertificateMessage(FoxCircuit foxCircuit, VendorCertificate vendorCertificate) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("type", "certificate");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        vendorCertificate.save((OutputStream)byteArrayOutputStream, true);
        foxMessage.add("data", byteArrayOutputStream.toByteArray());
        foxCircuit.writeMessage(foxMessage);
    }

    private VendorCertificate readCertificate(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        while (!foxMessage.getString("type").equals("certificate")) {
            if (foxMessage.getString("type").equals("endOfData")) {
                return null;
            }
            foxMessage = foxCircuit.readMessage();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(foxMessage.getBlob("data"));
        return VendorCertificate.make((String)"provisioning", (InputStream)byteArrayInputStream, (boolean)true);
    }

    private void writeEndOfDataMessage(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("type", "endOfData");
        foxCircuit.writeMessage(foxMessage);
    }

    public BInstallable getInstallableByPath(FilePath filePath) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallableByPath");
        }
        FoxCircuit foxCircuit = this.openCircuit("getInstallableByPath");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("pathString", filePath.getBody());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if ("notFound".equals(foxMessage2.getString("status"))) {
            return null;
        }
        return (BInstallable)DecoderFactory.decode((FoxMessage)foxMessage2, (String)"payload", null);
    }

    public void getInstallableByPath(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getInstallableByPath");
        }
        BIFile bIFile = BFileSystem.INSTANCE.findFile(new FilePath(foxMessage.getString("pathString")));
        BInstallable bInstallable = null;
        if (bIFile != null) {
            bInstallable = BInstallable.make((BIFile)bIFile);
        }
        FoxMessage foxMessage2 = new FoxMessage();
        if (bInstallable == null) {
            foxMessage2.add("status", "notFound");
        } else {
            foxMessage2.add("status", "ok");
            BogCodec.add((FoxMessage)foxMessage2, (String)"payload", (BValue)bInstallable, null);
        }
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void registerStationInstallable(BInstallable bInstallable, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:registerInstallable");
        }
        if (bInstallable.getInstallableFileOrd().isNull()) {
            throw new IllegalArgumentException("Installable has no associated file");
        }
        FoxCircuit foxCircuit = this.openCircuit("registerInstallable");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("name", bInstallable.getInstallableName());
        foxMessage.add("fileName", bInstallable.getInstallableFileName());
        BogCodec.add((FoxMessage)foxMessage, (String)"version", (BValue)bInstallable.getVersion(), null);
        BogCodec.add((FoxMessage)foxMessage, (String)"typeSpec", (BValue)bInstallable.getType().getTypeSpec(), null);
        BogCodec.add((FoxMessage)foxMessage, (String)"fileOrd", (BValue)bInstallable.getInstallableFileOrd(), null);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
        try {
            while (true) {
                FoxMessage foxMessage2;
                if ("status".equals((foxMessage2 = foxCircuit.readMessage()).getString("type"))) {
                    return;
                }
                taskListenerClient.handleMessage(foxMessage2);
            }
        }
        finally {
            taskListenerClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStationInstallable(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:registerStationInstallable");
        }
        try {
            BIFile bIFile;
            BInstallable bInstallable;
            String string = foxMessage.getString("name");
            BVersion bVersion = (BVersion)DecoderFactory.decode((FoxMessage)foxMessage, (String)"version", null);
            BTypeSpec bTypeSpec = (BTypeSpec)DecoderFactory.decode((FoxMessage)foxMessage, (String)"typeSpec", null);
            BOrd bOrd = (BOrd)DecoderFactory.decode((FoxMessage)foxMessage, (String)"fileOrd", null);
            BInstallable bInstallable2 = LocalInstallableRegistry.getInstance().findInstallable(string, bVersion.getVendorVersion(), bTypeSpec.getResolvedType(), (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
            FoxMessage foxMessage2 = new FoxMessage();
            if (bInstallable2 == null && (bInstallable = BInstallable.make((BIFile)(bIFile = (BIFile)bOrd.get()))) != null) {
                LocalInstallableRegistry.getInstance().register(bInstallable, null);
            }
            foxMessage2.add("type", "status");
            foxMessage2.add("status", "ok");
            foxCircuit.writeMessage(foxMessage2);
            foxCircuit.flush();
        }
        finally {
            foxCircuit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstallable(BInstallable bInstallable, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:registerInstallable");
        }
        if (bInstallable.getInstallableFileOrd().isNull()) {
            throw new IllegalArgumentException("Installable has no associated file");
        }
        BIFile bIFile = (BIFile)bInstallable.getInstallableFileOrd().get();
        if (bIFile != null && bIFile.getStore() instanceof BLocalFileStore) {
            FoxCircuit foxCircuit = this.openCircuit("registerInstallable");
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("name", bInstallable.getInstallableName());
            foxMessage.add("fileName", bInstallable.getInstallableFileName());
            BogCodec.add((FoxMessage)foxMessage, (String)"version", (BValue)bInstallable.getVersion(), null);
            BogCodec.add((FoxMessage)foxMessage, (String)"typeSpec", (BValue)bInstallable.getType().getTypeSpec(), null);
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
            try {
                while (true) {
                    FoxMessage foxMessage2;
                    if ("status".equals((foxMessage2 = foxCircuit.readMessage()).getString("type"))) {
                        if ("continue".equals(foxMessage2.getString("status"))) {
                            ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(foxCircuit);
                            InputStream inputStream = bIFile.getInputStream();
                            try {
                                FileUtil.pipe((InputStream)inputStream, (long)bIFile.getSize(), (OutputStream)chunkedOutputStream);
                            }
                            finally {
                                try {
                                    inputStream.close();
                                }
                                catch (Exception exception) {}
                                try {
                                    chunkedOutputStream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        return;
                    }
                    taskListenerClient.handleMessage(foxMessage2);
                }
            }
            finally {
                taskListenerClient.close();
            }
        }
        throw new IllegalArgumentException("Installable is not a local file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstallable(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:registerInstallable");
        }
        try {
            String string = foxMessage.getString("name");
            String string2 = foxMessage.getString("fileName");
            BVersion bVersion = (BVersion)DecoderFactory.decode((FoxMessage)foxMessage, (String)"version", null);
            BTypeSpec bTypeSpec = (BTypeSpec)DecoderFactory.decode((FoxMessage)foxMessage, (String)"typeSpec", null);
            BInstallable bInstallable = LocalInstallableRegistry.getInstance().findInstallable(string, bVersion.getVendorVersion(), bTypeSpec.getResolvedType(), (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
            FoxMessage foxMessage2 = new FoxMessage();
            if (bInstallable == null) {
                foxMessage2.add("type", "status");
                foxMessage2.add("status", "continue");
                foxCircuit.writeMessage(foxMessage2);
                foxCircuit.flush();
                LocalInstallableRegistry.getInstance().register(string, string2, bVersion, (InputStream)new ChunkedInputStream(foxCircuit), null);
            } else {
                foxMessage2.add("type", "status");
                foxMessage2.add("status", "duplicate");
                foxCircuit.writeMessage(foxMessage2);
                foxCircuit.flush();
            }
        }
        finally {
            foxCircuit.close();
        }
    }

    public ClosableCursor getInstallables(boolean bl, boolean bl2, DaemonSessionTaskListener daemonSessionTaskListener, String string, String string2) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallables");
        }
        FoxCircuit foxCircuit = this.openCircuit("getInstallables");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("latestOnly", bl);
        foxMessage.add("sendSpec", bl2);
        if (string != null) {
            foxMessage.add("includes", string);
        }
        if (string2 != null) {
            foxMessage.add("excludes", string2);
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        return new GetInstallablesCursor(foxCircuit, daemonSessionTaskListener);
    }

    public ClosableCursor getInstallables(BDependency bDependency, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallables");
        }
        FoxCircuit foxCircuit = this.openCircuit("getInstallables");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("latestOnly", false);
        foxMessage.add("sendSpec", false);
        BogCodec.add((FoxMessage)foxMessage, (String)"depend", (BValue)bDependency, null);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        return new GetInstallablesCursor(foxCircuit, daemonSessionTaskListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInstallables(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getInstallables");
        }
        boolean bl = foxMessage.getBoolean("latestOnly", false);
        boolean bl2 = foxMessage.getBoolean("sendSpec", false);
        String string = foxMessage.getString("includes", null);
        String string2 = foxMessage.getString("excludes", null);
        FoxObject foxObject = (FoxObject)foxMessage.getOptional("depend");
        try {
            ClosableCursor closableCursor = foxObject == null ? LocalInstallableRegistry.getInstance().getInstallables(bl, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit), string, string2) : LocalInstallableRegistry.getInstance().getInstallables((BDependency)DecoderFactory.decode((FoxObject)foxObject, null), (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
            try {
                BInstallable bInstallable;
                while (closableCursor.next(class$com$tridium$install$installable$BInstallable == null ? BNiagaraProvisioningChannel.class$("com.tridium.install.installable.BInstallable") : class$com$tridium$install$installable$BInstallable)) {
                    bInstallable = (BInstallable)closableCursor.get();
                    FoxMessage foxMessage2 = new FoxMessage();
                    if (bl2) {
                        foxMessage2.add("type", "spec");
                        BogCodec.add((FoxMessage)foxMessage2, (String)"payload", (BValue)BInstallableSpec.make((BInstallable)bInstallable), null);
                    } else {
                        foxMessage2.add("type", "installable");
                        bInstallable.getDependencies();
                        BogCodec.add((FoxMessage)foxMessage2, (String)"payload", (BValue)bInstallable, null);
                    }
                    foxCircuit.writeMessage(foxMessage2);
                    foxCircuit.flush();
                }
                bInstallable = new FoxMessage();
                bInstallable.add("type", "end");
                foxCircuit.writeMessage((FoxMessage)bInstallable);
                foxCircuit.flush();
            }
            finally {
                closableCursor.close();
            }
        }
        finally {
            foxCircuit.close();
        }
    }

    public BInstallable[] findInstallables(BDependency bDependency, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:findInstallable");
        }
        FoxCircuit foxCircuit = this.openCircuit("findInstallables");
        FoxMessage foxMessage = new FoxMessage();
        BogCodec.add((FoxMessage)foxMessage, (String)"depend", (BValue)bDependency, null);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
        Array array = new Array(class$com$tridium$install$installable$BInstallable == null ? (class$com$tridium$install$installable$BInstallable = BNiagaraProvisioningChannel.class$("com.tridium.install.installable.BInstallable")) : class$com$tridium$install$installable$BInstallable);
        try {
            while (true) {
                FoxMessage foxMessage2;
                if (taskListenerClient.handleMessage(foxMessage2 = foxCircuit.readMessage())) continue;
                String string = foxMessage2.getString("type");
                if (string.equals("result")) {
                    array.add(DecoderFactory.decode((FoxMessage)foxMessage2, (String)"payload", null));
                    continue;
                }
                if (!string.equals("end")) continue;
                BInstallable[] bInstallableArray = (BInstallable[])array.trim();
                return bInstallableArray;
            }
        }
        finally {
            taskListenerClient.close();
            foxCircuit.close();
        }
    }

    public void findInstallables(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage;
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:findInstallables");
        }
        BDependency bDependency = (BDependency)DecoderFactory.decode((FoxMessage)foxMessage2, (String)"depend", null);
        BInstallable[] bInstallableArray = LocalInstallableRegistry.getInstance().findInstallables(bDependency, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        for (int i = 0; i < bInstallableArray.length; ++i) {
            foxMessage = new FoxMessage();
            foxMessage.add("type", "result");
            bInstallableArray[i].getDependencies();
            BogCodec.add((FoxMessage)foxMessage, (String)"payload", (BValue)bInstallableArray[i], null);
            foxCircuit.writeMessage(foxMessage);
        }
        foxMessage = new FoxMessage();
        foxMessage.add("type", "end");
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        foxCircuit.close();
    }

    public BInstallable findInstallable(BDependency bDependency, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:findInstallable");
        }
        FoxCircuit foxCircuit = this.openCircuit("findInstallable");
        FoxMessage foxMessage = new FoxMessage();
        BogCodec.add((FoxMessage)foxMessage, (String)"depend", (BValue)bDependency, null);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
        try {
            while (true) {
                FoxMessage foxMessage2;
                if (taskListenerClient.handleMessage(foxMessage2 = foxCircuit.readMessage())) continue;
                String string = foxMessage2.getString("type");
                if (string.equals("result")) {
                    BInstallable bInstallable = (BInstallable)DecoderFactory.decode((FoxMessage)foxMessage2, (String)"payload", null);
                    return bInstallable;
                }
                if (!string.equals("notFound")) continue;
                BInstallable bInstallable = null;
                return bInstallable;
            }
        }
        finally {
            taskListenerClient.close();
            foxCircuit.close();
        }
    }

    public void findInstallable(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:findInstallable");
        }
        BDependency bDependency = (BDependency)DecoderFactory.decode((FoxMessage)foxMessage, (String)"depend", null);
        BInstallable bInstallable = LocalInstallableRegistry.getInstance().findInstallable(bDependency, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        FoxMessage foxMessage2 = new FoxMessage();
        if (bInstallable == null) {
            foxMessage2.add("type", "notFound");
        } else {
            foxMessage2.add("type", "result");
            bInstallable.getDependencies();
            BogCodec.add((FoxMessage)foxMessage2, (String)"payload", (BValue)bInstallable, null);
        }
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
        foxCircuit.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LicenseIterator
    implements Iterator {
        private FoxCircuit circuit;
        private VendorLicense nextObject = null;

        public LicenseIterator(FoxCircuit foxCircuit) {
            this.circuit = foxCircuit;
        }

        public boolean hasNext() {
            if (this.circuit == null) {
                return false;
            }
            if (this.nextObject == null) {
                try {
                    this.nextObject = BNiagaraProvisioningChannel.this.readLicense(this.circuit);
                    if (this.nextObject == null) {
                        this.circuit = null;
                        return false;
                    }
                    return true;
                }
                catch (Exception exception) {
                    this.circuit = null;
                    this.nextObject = null;
                    exception.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        public Object next() {
            if (this.hasNext()) {
                VendorLicense vendorLicense = this.nextObject;
                this.nextObject = null;
                return vendorLicense;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class GetInstallablesCursor
    implements ClosableCursor {
        private FoxCircuit circuit;
        private MessageClient[] messageClients;
        private BObject current = null;

        public GetInstallablesCursor(FoxCircuit foxCircuit, DaemonSessionTaskListener daemonSessionTaskListener) {
            this(foxCircuit, new MessageClient[]{new TaskListenerClient(daemonSessionTaskListener)});
        }

        public GetInstallablesCursor(FoxCircuit foxCircuit, MessageClient[] messageClientArray) {
            this.messageClients = messageClientArray;
            this.circuit = foxCircuit;
        }

        public Context getContext() {
            return null;
        }

        public boolean next() {
            try {
                FoxMessage foxMessage;
                String string;
                do {
                    foxMessage = null;
                    boolean bl = true;
                    block4: while (bl) {
                        bl = false;
                        foxMessage = this.circuit.readMessage();
                        for (int i = 0; i < this.messageClients.length; ++i) {
                            if (!this.messageClients[i].handleMessage(foxMessage)) continue;
                            bl = true;
                            continue block4;
                        }
                    }
                    string = foxMessage.getString("type");
                    if (!string.equals("end")) continue;
                    this.close();
                    return false;
                } while (!string.equals("installable") && !string.equals("spec"));
                this.current = (BObject)DecoderFactory.decode((FoxMessage)foxMessage, (String)"payload", null);
                return true;
            }
            catch (RuntimeException runtimeException) {
                this.close();
                throw runtimeException;
            }
            catch (Exception exception) {
                this.close();
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public boolean nextComponent() {
            return this.next(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BNiagaraProvisioningChannel.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        }

        public boolean next(Class clazz) {
            while (this.next()) {
                if (!clazz.isAssignableFrom(this.current.getClass())) continue;
                return true;
            }
            this.close();
            return false;
        }

        public BObject get() {
            return this.current;
        }

        public void close() {
            this.circuit.close();
            for (int i = 0; i < this.messageClients.length; ++i) {
                this.messageClients[i].close();
            }
        }
    }
}

