/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.remoteVideo.BRemoteFoxVideoSource;
import com.tridium.remoteVideo.BRemoteVideoChannel;
import com.tridium.remoteVideo.BRemoteVideoEventRecall;
import com.tridium.remoteVideo.BRemoteVideoService;
import com.tridium.remoteVideo.BRemoteVideoSourceToken;
import com.tridium.remoteVideo.RemoteFoxVideoStream;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.camera.BIRemoteVideoSource;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.camera.control.BIVideoZoomControl;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import java.lang.reflect.Method;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BRemoteVideoSource
extends BComponent
implements BIVideoSource,
BIVideoPanTiltControl,
BIVideoZoomControl,
BIVideoFocusControl,
BIVideoIrisControl,
BIVideoMoveToPresetControl,
BIVideoStorePresetControl,
BIVideoCamera,
BIVideoEventProvider,
BIVideoAlarmRecorder,
BIRemoteVideoSource {
    public static final Property cameraHandleOrd = BRemoteVideoSource.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property cameraOrd = BRemoteVideoSource.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property niagaraStation = BRemoteVideoSource.newProperty((int)0, (String)"", null);
    public static final Property eventRecaller = BRemoteVideoSource.newProperty((int)0, (BValue)new BRemoteVideoEventRecall(), null);
    public static final Property foxVideoSourceMasterStation = BRemoteVideoSource.newProperty((int)0, (BValue)new BRemoteFoxVideoSource(), null);
    public static final Action move = BRemoteVideoSource.newAction((int)0, (BValue)BVideoPanTiltEnum.none, null);
    public static final Action zoom = BRemoteVideoSource.newAction((int)0, (BValue)BVideoZoomEnum.none, null);
    public static final Action focusControl = BRemoteVideoSource.newAction((int)0, (BValue)BVideoFocusEnum.none, null);
    public static final Action irisControl = BRemoteVideoSource.newAction((int)0, (BValue)BVideoIrisEnum.none, null);
    public static final Action moveToPreset = BRemoteVideoSource.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action storePreset = BRemoteVideoSource.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action startRecordingAlarm = BRemoteVideoSource.newAction((int)0, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    public static final boolean ASYNC = true;
    public static final boolean SYNC = false;
    static /* synthetic */ Class class$com$tridium$remoteVideo$BRemoteVideoSource;

    public final BOrd getCameraHandleOrd() {
        return (BOrd)this.get(cameraHandleOrd);
    }

    public final void setCameraHandleOrd(BOrd bOrd) {
        this.set(cameraHandleOrd, (BValue)bOrd, null);
    }

    public final BOrd getCameraOrd() {
        return (BOrd)this.get(cameraOrd);
    }

    public final void setCameraOrd(BOrd bOrd) {
        this.set(cameraOrd, (BValue)bOrd, null);
    }

    public final String getNiagaraStation() {
        return this.getString(niagaraStation);
    }

    public final void setNiagaraStation(String string) {
        this.setString(niagaraStation, string, null);
    }

    public final BVideoEventRecall getEventRecaller() {
        return (BVideoEventRecall)this.get(eventRecaller);
    }

    public final void setEventRecaller(BVideoEventRecall bVideoEventRecall) {
        this.set(eventRecaller, (BValue)bVideoEventRecall, null);
    }

    public final BRemoteFoxVideoSource getFoxVideoSourceMasterStation() {
        return (BRemoteFoxVideoSource)this.get(foxVideoSourceMasterStation);
    }

    public final void setFoxVideoSourceMasterStation(BRemoteFoxVideoSource bRemoteFoxVideoSource) {
        this.set(foxVideoSourceMasterStation, (BValue)bRemoteFoxVideoSource, null);
    }

    public final void move(BVideoPanTiltEnum bVideoPanTiltEnum) {
        this.invoke(move, (BValue)bVideoPanTiltEnum, null);
    }

    public final void zoom(BVideoZoomEnum bVideoZoomEnum) {
        this.invoke(zoom, (BValue)bVideoZoomEnum, null);
    }

    public final void focusControl(BVideoFocusEnum bVideoFocusEnum) {
        this.invoke(focusControl, (BValue)bVideoFocusEnum, null);
    }

    public final void irisControl(BVideoIrisEnum bVideoIrisEnum) {
        this.invoke(irisControl, (BValue)bVideoIrisEnum, null);
    }

    public final void moveToPreset(BValue bValue) {
        this.invoke(moveToPreset, bValue, null);
    }

    public final void storePreset(BValue bValue) {
        this.invoke(storePreset, bValue, null);
    }

    public final void startRecordingAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(startRecordingAlarm, (BValue)bAlarmRecord, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final boolean isLicensed() {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "remoteVideo");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final boolean isCameraFault() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        try {
            Class<?> clazz = bIVideoSource.getClass();
            Method method = clazz.getMethod("isFault", null);
            Object object = method.invoke((Object)bIVideoSource, null);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final String getCameraFaultCause() {
        boolean bl = this.isCameraFault();
        return this.getCameraFaultCause((BObject)this.getVideoSource(), bl);
    }

    protected final String getCameraFaultCause(BObject bObject, boolean bl) {
        if (bObject == null) {
            return "";
        }
        try {
            Class<?> clazz = bObject.getClass();
            Method method = clazz.getMethod("getFaultCause", null);
            Object object = method.invoke((Object)bObject, null);
            if (object instanceof String) {
                String string = (String)object;
                if (bl && string.length() == 0 && bObject instanceof BComplex) {
                    return this.getCameraFaultCause((BObject)((BComplex)bObject).getParent(), bl);
                }
                return string;
            }
            if (bl && bObject instanceof BComplex) {
                return this.getCameraFaultCause((BObject)((BComplex)bObject).getParent(), bl);
            }
            return "";
        }
        catch (Exception exception) {
            if (bl && bObject instanceof BComplex) {
                return this.getCameraFaultCause((BObject)((BComplex)bObject).getParent(), bl);
            }
            return "";
        }
    }

    public final BIVideoSource getVideoSource() {
        BIVideoSource bIVideoSource = this.findVideoSource(this);
        if (bIVideoSource instanceof BDevice) {
            ((BDevice)bIVideoSource).fw(11);
        }
        return bIVideoSource;
    }

    protected final BIVideoSource findVideoSource(BComponent bComponent) {
        bComponent.lease();
        SlotCursor slotCursor = bComponent.getSlots();
        while (slotCursor.nextObject()) {
            if (!(slotCursor.get() instanceof BRemoteVideoSourceToken)) continue;
            return (BIVideoSource)bComponent;
        }
        SlotCursor slotCursor2 = bComponent.getSlots();
        while (slotCursor2.nextComponent()) {
            BIVideoSource bIVideoSource;
            if (!(slotCursor2.get() instanceof BComponent) || (bIVideoSource = this.findVideoSource((BComponent)slotCursor2.get())) == null) continue;
            return bIVideoSource;
        }
        return null;
    }

    public final BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getVideoSource().getFoxVideoStreamSetting();
    }

    public final BRelTime getInterframeTimeout() {
        return this.getVideoSource().getInterframeTimeout();
    }

    public final BColor getPreferredBackgroundColor() {
        return this.getVideoSource().getPreferredBackgroundColor();
    }

    public final BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getVideoSource().getPreferredAspectRatio();
    }

    public final BVideoCompressionEnum getPreferredCompression() {
        return this.getVideoSource().getPreferredCompression();
    }

    public final BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getVideoSource().getPreferredFrameRate();
    }

    public final BVideoResolutionEnum getPreferredResolution() {
        return this.getVideoSource().getPreferredResolution();
    }

    public final void initPlaybackParams(BPlaybackParams bPlaybackParams, IVideoSession iVideoSession) {
        this.getVideoSource().initPlaybackParams(bPlaybackParams, iVideoSession);
    }

    public final boolean isFoxVideoStreamPreferred() {
        return this.getVideoSource().isFoxVideoStreamPreferred();
    }

    public final boolean isTimestampPreferred() {
        return this.getVideoSource().isTimestampPreferred();
    }

    public final IVideoDecoder makeVideoDecoder(BPlaybackParams bPlaybackParams) {
        return this.getVideoSource().makeVideoDecoder(bPlaybackParams);
    }

    public final VideoPlaybackSession newPlaybackSession(IVideoPlayback iVideoPlayback) {
        return this.getVideoSource().newPlaybackSession(iVideoPlayback);
    }

    public final void streamToDestination(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        this.getVideoSource().streamToDestination(bPlaybackParams, iVideoDestination);
    }

    public final boolean supportsPlaybackControl() {
        return this.getVideoSource().supportsPlaybackControl();
    }

    public final BOrd getSlotPathOrd() {
        return super.getSlotPathOrd();
    }

    public final BValue invokeRemoteMethod(String string, BValue bValue, boolean bl) throws Exception {
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation bNiagaraStation = (BNiagaraStation)bNiagaraNetwork.getStation(this.getNiagaraStation());
        BFoxClientConnection bFoxClientConnection = bNiagaraStation.getClientConnection();
        bFoxClientConnection.engageNoRetry((BFoxClientConnection.Interest)RemoteFoxVideoStream.REMOTE_VIDEO_INTEREST);
        if (bFoxClientConnection.isConnected()) {
            BRemoteVideoChannel bRemoteVideoChannel = (BRemoteVideoChannel)bFoxClientConnection.getChannels().get("remoteVideo");
            return bRemoteVideoChannel.remoteMethod(this.getCameraOrd().toString(), string, bValue, bl);
        }
        return null;
    }

    public final boolean isStorePresetEnabled() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        boolean bl = false;
        if (bIVideoSource instanceof BIVideoStorePresetControl && ((BIVideoStorePresetControl)bIVideoSource).isStorePresetEnabled()) {
            bl = true;
        }
        return bl;
    }

    public final Action getStorePresetAction() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        if (bIVideoSource instanceof BIVideoMoveToPresetControl) {
            return ((BIVideoStorePresetControl)bIVideoSource).getStorePresetAction();
        }
        return null;
    }

    public final void doStorePreset(BValue bValue) throws Exception {
        this.invokeRemoteMethod("storePreset", bValue, true);
    }

    public final boolean isMoveToPresetEnabled() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        boolean bl = false;
        if (bIVideoSource instanceof BIVideoMoveToPresetControl && ((BIVideoMoveToPresetControl)bIVideoSource).isMoveToPresetEnabled()) {
            bl = true;
        }
        return bl;
    }

    public final Action getMoveToPresetAction() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        if (bIVideoSource instanceof BIVideoMoveToPresetControl) {
            return ((BIVideoMoveToPresetControl)bIVideoSource).getMoveToPresetAction();
        }
        return null;
    }

    public final void doMoveToPreset(BValue bValue) throws Exception {
        this.invokeRemoteMethod("moveToPreset", bValue, true);
    }

    public final boolean isIrisEnabled() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        boolean bl = false;
        if (bIVideoSource instanceof BIVideoIrisControl && ((BIVideoIrisControl)bIVideoSource).isIrisEnabled()) {
            bl = true;
        }
        return bl;
    }

    public final void doIrisControl(BVideoIrisEnum bVideoIrisEnum) throws Exception {
        this.invokeRemoteMethod("irisControl", (BValue)bVideoIrisEnum, true);
    }

    public final boolean isFocusEnabled() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        boolean bl = false;
        if (bIVideoSource instanceof BIVideoFocusControl && ((BIVideoFocusControl)bIVideoSource).isFocusEnabled()) {
            bl = true;
        }
        return bl;
    }

    public final void doFocusControl(BVideoFocusEnum bVideoFocusEnum) throws Exception {
        this.invokeRemoteMethod("focusControl", (BValue)bVideoFocusEnum, true);
    }

    public final boolean isZoomEnabled() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        boolean bl = false;
        if (bIVideoSource instanceof BIVideoZoomControl && ((BIVideoZoomControl)bIVideoSource).isZoomEnabled()) {
            bl = true;
        }
        return bl;
    }

    public final void doZoom(BVideoZoomEnum bVideoZoomEnum) throws Exception {
        this.invokeRemoteMethod("zoom", (BValue)bVideoZoomEnum, true);
    }

    public final boolean isPanTiltEnabled() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        boolean bl = false;
        if (bIVideoSource instanceof BIVideoPanTiltControl && ((BIVideoPanTiltControl)bIVideoSource).isPanTiltEnabled()) {
            bl = true;
        }
        return bl;
    }

    public final void doMove(BVideoPanTiltEnum bVideoPanTiltEnum) throws Exception {
        this.invokeRemoteMethod("move", (BValue)bVideoPanTiltEnum, true);
    }

    public final String getCameraDescription() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        if (bIVideoSource instanceof BIVideoCamera) {
            return ((BIVideoCamera)bIVideoSource).getCameraDescription();
        }
        return "RemoteVideoSource";
    }

    public final BIVideoDvr getDvr() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        if (bIVideoSource instanceof BIVideoCamera) {
            return ((BIVideoCamera)bIVideoSource).getDvr();
        }
        return null;
    }

    public final BAbsTime getCameraTime() {
        try {
            BValue bValue = this.invokeRemoteMethod("getCameraTime", null, false);
            if (bValue == null) {
                return null;
            }
            if (bValue instanceof BAbsTime) {
                return (BAbsTime)bValue;
            }
            throw new BajaRuntimeException("Expected 'getCameraTime()' to return BAbsTime not " + bValue.getType().getTypeSpec() + ". Remote camera: " + this.getCameraOrd() + " at remote station " + this.getNiagaraStation());
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("Error invoking 'getCameraTime()' on remote camera: " + this.getCameraOrd() + " at remote station " + this.getNiagaraStation(), (Throwable)exception);
        }
    }

    public final BPointDeviceExt getEvents() {
        return null;
    }

    public final void doStartRecordingAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        BIVideoSource bIVideoSource = this.getVideoSource();
        if (bIVideoSource instanceof BIVideoAlarmRecorder) {
            this.invokeRemoteMethod("startRecordingAlarm", (BValue)bAlarmRecord, true);
        }
    }

    public final AgentList getAgents(Context context) {
        AgentInfo agentInfo;
        String string;
        AgentList agentList = super.getAgents(context);
        if (this.addLiveVideoView()) {
            string = this.getCameraViewTypeSpec();
            agentInfo = Sys.getRegistry().getType(string).getAgentInfo();
            agentList.add(agentInfo);
            if (this.areCameraViewsTopMost()) {
                agentList.toTop(agentInfo);
            }
        }
        if (this.addPlaybackView()) {
            string = this.getPlaybackViewTypeSpec();
            agentInfo = Sys.getRegistry().getType(string).getAgentInfo();
            agentList.add(agentInfo);
            if (this.areCameraViewsTopMost()) {
                agentList.toTop(agentInfo);
            }
        }
        try {
            string = Sys.getRegistry().getType("accessControl:HxWbAccessView").getAgentInfo();
            agentList.add((AgentInfo)string);
        }
        catch (Exception exception) {}
        return agentList;
    }

    protected final boolean addLiveVideoView() {
        return true;
    }

    protected final boolean addPlaybackView() {
        return true;
    }

    protected final String getCameraViewTypeSpec() {
        return "videoDriver:LiveVideo";
    }

    protected final String getPlaybackViewTypeSpec() {
        return "videoDriver:VideoPlayback";
    }

    protected final boolean areCameraViewsTopMost() {
        return true;
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BRemoteVideoService;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$remoteVideo$BRemoteVideoSource;
        if (clazz == null) {
            clazz = class$com$tridium$remoteVideo$BRemoteVideoSource = BRemoteVideoSource.class("[Lcom.tridium.remoteVideo.BRemoteVideoSource;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

