/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.components.BStatusComponent;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BStatusPollableComponent
extends BStatusComponent
implements BIStatus {
    public static final Property faultCause = BStatusPollableComponent.newProperty((int)3, (String)"", null);
    public static final Property pollInterval = BStatusPollableComponent.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false));
    public static final Property lastUpdate = BStatusPollableComponent.newProperty((int)3, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Action poll = BStatusPollableComponent.newAction((int)16, null);
    public static final Action read = BStatusPollableComponent.newAction((int)20, null);
    public static final Type TYPE;
    Clock.Ticket pollTicket;
    static /* synthetic */ Class class$com$tridium$ak255$components$BStatusPollableComponent;
    static /* synthetic */ Class class$com$tridium$ak255$components$BStatusComponent;

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BRelTime getPollInterval() {
        return (BRelTime)this.get(pollInterval);
    }

    public void setPollInterval(BRelTime bRelTime) {
        this.set(pollInterval, (BValue)bRelTime, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime bAbsTime) {
        this.set(lastUpdate, (BValue)bAbsTime, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initPollTicket();
    }

    public void stopped() throws Exception {
        this.cancelPollTicket();
    }

    public String getDeviceType() {
        return this.getDevice().getType().toString();
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)pollInterval)) {
            this.initPollTicket();
        }
        super.changed(property, context);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)poll)) {
            return this.postPoll();
        }
        if (action.equals((Object)read)) {
            return this.postRead();
        }
        return super.post(action, bValue, context);
    }

    protected IFuture postRead() {
        if (this.isRunning() && !this.getStatus().isDisabled() && !this.getStatus().isDown()) {
            return this.getDevice().postAsync((Runnable)new Invocation((BComponent)this, poll, null, null));
        }
        return null;
    }

    public void doRead() {
        this.doPoll();
    }

    protected IFuture postPoll() {
        if (this.isRunning() && !this.getStatus().isDisabled() && !this.getStatus().isDown() && (this.isSubscribed() || this.isChildSubscribed())) {
            return this.getDevice().postAsync((Runnable)new Invocation((BComponent)this, poll, null, null));
        }
        return null;
    }

    public void doPoll() {
        System.out.println("*** Warning *** subclass must override sendPoll() Method()");
    }

    private final void initPollTicket() {
        if (!this.isRunning()) {
            return;
        }
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
        this.pollTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getPollInterval(), (Action)poll, null);
    }

    private final void cancelPollTicket() {
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
    }

    protected boolean isChildSubscribed() {
        Class clazz = class$com$tridium$ak255$components$BStatusComponent;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BStatusComponent = BStatusPollableComponent.class("[Lcom.tridium.ak255.components.BStatusComponent;", false);
        }
        BStatusComponent[] bStatusComponentArray = (BStatusComponent[])this.getChildren(clazz);
        int n = 0;
        while (n < bStatusComponentArray.length) {
            if (bStatusComponentArray[n].isSubscribed()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void subscribed() {
        if (this.isRunning()) {
            this.poll();
        }
        super.subscribed();
    }

    public boolean decodeReplyError(XElem xElem) {
        int n = xElem.geti("error", 0);
        if (n != 0) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(xElem.content(0).toString());
            return true;
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pollTicket = null;
    }

    public BStatusPollableComponent() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BStatusPollableComponent;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BStatusPollableComponent = BStatusPollableComponent.class("[Lcom.tridium.ak255.components.BStatusPollableComponent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

