/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.BAk255Network;
import com.tridium.ak255.comm.req.BAk255ReadSuctionGroupRequest;
import com.tridium.ak255.comm.req.BAk255WriteSuctionGroupRequest;
import com.tridium.ak255.comm.rsp.ParseUtil;
import com.tridium.ak255.components.BAk255AlarmLimit;
import com.tridium.ak255.components.BAk255SuctionCircuit;
import com.tridium.ak255.components.BAk255SuctionControl;
import com.tridium.ak255.components.BIAlarmLimitParent;
import com.tridium.ak255.components.BStatusPollableComponent;
import com.tridium.ak255.enums.BCondenserAlmActionEnum;
import com.tridium.ak255.enums.BCondenserAlmDurEnum;
import com.tridium.ak255.enums.BUnitsTypeEnum;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255SuctionGroup
extends BStatusPollableComponent
implements BIAlarmLimitParent {
    public static final Property writeStatus = BAk255SuctionGroup.newProperty((int)3, (String)"", null);
    public static final Property rackId = BAk255SuctionGroup.newProperty((int)1, (int)0, null);
    public static final Property suctionId = BAk255SuctionGroup.newProperty((int)1, (int)0, null);
    public static final Property groupName = BAk255SuctionGroup.newProperty((int)1, (String)"", null);
    public static final Property numCircuits = BAk255SuctionGroup.newProperty((int)1, (int)0, null);
    public static final Property suctionPressure = BAk255SuctionGroup.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property units = BAk255SuctionGroup.newProperty((int)5, (BValue)BUnit.NULL, null);
    public static final Property suctionTarget = BAk255SuctionGroup.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property suctionTargetUnits = BAk255SuctionGroup.newProperty((int)5, (BValue)BUnit.NULL, null);
    public static final Property suctionCutout = BAk255SuctionGroup.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property suctionCutoutUnits = BAk255SuctionGroup.newProperty((int)5, (BValue)BUnit.NULL, null);
    public static final Property suctionControl = BAk255SuctionGroup.newProperty((int)1, (BValue)new BAk255SuctionControl(), null);
    public static final Property alarmHiLimit = BAk255SuctionGroup.newProperty((int)1, (BValue)new BAk255AlarmLimit(), null);
    public static final Property alarmLoLimit = BAk255SuctionGroup.newProperty((int)1, (BValue)new BAk255AlarmLimit(), null);
    public static final Property defrostAutoSchedule = BAk255SuctionGroup.newProperty((int)1, (boolean)false, null);
    public static final Action modifySuctionTarget = BAk255SuctionGroup.newAction((int)16, (BValue)BFloat.make((float)0.0f), null);
    public static final Action modifySuctionCutout = BAk255SuctionGroup.newAction((int)16, (BValue)BFloat.make((float)0.0f), null);
    public static final Action modifyDefrostAutoSchedule = BAk255SuctionGroup.newAction((int)16, (BValue)BBoolean.make((boolean)false), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255SuctionGroup;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255SuctionCircuit;

    public String getWriteStatus() {
        return this.getString(writeStatus);
    }

    public void setWriteStatus(String string) {
        this.setString(writeStatus, string, null);
    }

    public int getRackId() {
        return this.getInt(rackId);
    }

    public void setRackId(int n) {
        this.setInt(rackId, n, null);
    }

    public int getSuctionId() {
        return this.getInt(suctionId);
    }

    public void setSuctionId(int n) {
        this.setInt(suctionId, n, null);
    }

    public String getGroupName() {
        return this.getString(groupName);
    }

    public void setGroupName(String string) {
        this.setString(groupName, string, null);
    }

    public int getNumCircuits() {
        return this.getInt(numCircuits);
    }

    public void setNumCircuits(int n) {
        this.setInt(numCircuits, n, null);
    }

    public BStatusNumeric getSuctionPressure() {
        return (BStatusNumeric)this.get(suctionPressure);
    }

    public void setSuctionPressure(BStatusNumeric bStatusNumeric) {
        this.set(suctionPressure, (BValue)bStatusNumeric, null);
    }

    public BUnit getUnits() {
        return (BUnit)this.get(units);
    }

    public void setUnits(BUnit bUnit) {
        this.set(units, (BValue)bUnit, null);
    }

    public BStatusNumeric getSuctionTarget() {
        return (BStatusNumeric)this.get(suctionTarget);
    }

    public void setSuctionTarget(BStatusNumeric bStatusNumeric) {
        this.set(suctionTarget, (BValue)bStatusNumeric, null);
    }

    public BUnit getSuctionTargetUnits() {
        return (BUnit)this.get(suctionTargetUnits);
    }

    public void setSuctionTargetUnits(BUnit bUnit) {
        this.set(suctionTargetUnits, (BValue)bUnit, null);
    }

    public BStatusNumeric getSuctionCutout() {
        return (BStatusNumeric)this.get(suctionCutout);
    }

    public void setSuctionCutout(BStatusNumeric bStatusNumeric) {
        this.set(suctionCutout, (BValue)bStatusNumeric, null);
    }

    public BUnit getSuctionCutoutUnits() {
        return (BUnit)this.get(suctionCutoutUnits);
    }

    public void setSuctionCutoutUnits(BUnit bUnit) {
        this.set(suctionCutoutUnits, (BValue)bUnit, null);
    }

    public BAk255SuctionControl getSuctionControl() {
        return (BAk255SuctionControl)this.get(suctionControl);
    }

    public void setSuctionControl(BAk255SuctionControl bAk255SuctionControl) {
        this.set(suctionControl, (BValue)bAk255SuctionControl, null);
    }

    public BAk255AlarmLimit getAlarmHiLimit() {
        return (BAk255AlarmLimit)this.get(alarmHiLimit);
    }

    public void setAlarmHiLimit(BAk255AlarmLimit bAk255AlarmLimit) {
        this.set(alarmHiLimit, (BValue)bAk255AlarmLimit, null);
    }

    public BAk255AlarmLimit getAlarmLoLimit() {
        return (BAk255AlarmLimit)this.get(alarmLoLimit);
    }

    public void setAlarmLoLimit(BAk255AlarmLimit bAk255AlarmLimit) {
        this.set(alarmLoLimit, (BValue)bAk255AlarmLimit, null);
    }

    public boolean getDefrostAutoSchedule() {
        return this.getBoolean(defrostAutoSchedule);
    }

    public void setDefrostAutoSchedule(boolean bl) {
        this.setBoolean(defrostAutoSchedule, bl, null);
    }

    public void modifySuctionTarget(BFloat bFloat) {
        this.invoke(modifySuctionTarget, (BValue)bFloat, null);
    }

    public void modifySuctionCutout(BFloat bFloat) {
        this.invoke(modifySuctionCutout, (BValue)bFloat, null);
    }

    public void modifyDefrostAutoSchedule(BBoolean bBoolean) {
        this.invoke(modifyDefrostAutoSchedule, (BValue)bBoolean, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)suctionPressure)) {
            return BFacets.makeNumeric((BUnit)this.getUnits(), (int)2);
        }
        if (slot.equals((Object)suctionTarget)) {
            return BFacets.makeNumeric((BUnit)this.getSuctionTargetUnits(), (int)2);
        }
        if (slot.equals((Object)suctionCutout)) {
            return BFacets.makeNumeric((BUnit)this.getSuctionCutoutUnits(), (int)2);
        }
        return super.getSlotFacets(slot);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals((Object)numCircuits)) {
            int n;
            BAk255SuctionCircuit[] bAk255SuctionCircuitArray;
            int n2 = 1;
            while (n2 <= this.getNumCircuits()) {
                BAk255SuctionCircuit bAk255SuctionCircuit = null;
                String string = "curcuit" + n2;
                try {
                    bAk255SuctionCircuit = (BAk255SuctionCircuit)this.get(string);
                }
                catch (Exception exception) {}
                if (bAk255SuctionCircuit == null) {
                    System.out.println("adding circuit: " + n2);
                    Property property2 = this.add(string, (BValue)new BAk255SuctionCircuit(n2));
                    bAk255SuctionCircuit = (BAk255SuctionCircuit)this.get(property2);
                }
                bAk255SuctionCircuit.setSuctionId(this.getSuctionId());
                bAk255SuctionCircuit.setRackId(this.getRackId());
                bAk255SuctionCircuit.read();
                ++n2;
            }
            Class clazz = class$com$tridium$ak255$components$BAk255SuctionCircuit;
            if (clazz == null) {
                clazz = class$com$tridium$ak255$components$BAk255SuctionCircuit = BAk255SuctionGroup.class("[Lcom.tridium.ak255.components.BAk255SuctionCircuit;", false);
            }
            if ((bAk255SuctionCircuitArray = (BAk255SuctionCircuit[])this.getChildren(clazz)).length > (n = this.getNumCircuits())) {
                int n3 = n;
                while (n3 < bAk255SuctionCircuitArray.length) {
                    this.remove((BComplex)bAk255SuctionCircuitArray[n3]);
                    ++n3;
                }
            }
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)modifySuctionTarget)) {
            return BFloat.make((float)((float)this.getSuctionTarget().getValue()));
        }
        if (action.equals((Object)modifySuctionCutout)) {
            return BFloat.make((float)((float)this.getSuctionCutout().getValue()));
        }
        if (action.equals((Object)modifyDefrostAutoSchedule)) {
            return BBoolean.make((boolean)this.getDefrostAutoSchedule());
        }
        return super.getActionParameterDefault(action);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BAk255Network bAk255Network = this.getNetwork();
        if (bAk255Network != null && (action.equals((Object)modifySuctionTarget) || action.equals((Object)modifySuctionCutout) || action.equals((Object)modifyDefrostAutoSchedule))) {
            return bAk255Network.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doModifySuctionTarget(BFloat bFloat) {
        this.doModifySuction("suction_target", (BValue)bFloat);
    }

    public void doModifySuctionCutout(BFloat bFloat) {
        this.doModifySuction("suction_cutout", (BValue)bFloat);
    }

    public void doModifySuction(String string, BValue bValue) {
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null) {
            BAk255Network bAk255Network = (BAk255Network)bAk255Device.getNetwork();
            if (bAk255Network != null) {
                BAk255WriteSuctionGroupRequest bAk255WriteSuctionGroupRequest = new BAk255WriteSuctionGroupRequest(bAk255Device, this, string, bValue);
                DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteSuctionGroupRequest);
            }
            this.doPoll();
        }
    }

    public void doModifyAlarmLimit(Slot slot, Action action, BValue bValue) {
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null) {
            String string = null;
            if (slot.equals((Object)alarmHiLimit)) {
                if (action.equals((Object)BAk255AlarmLimit.modifyLimit)) {
                    string = "almhi_limit";
                } else if (action.equals((Object)BAk255AlarmLimit.modifyDuration)) {
                    string = "almhi_dur";
                }
            } else if (slot.equals((Object)alarmLoLimit)) {
                if (action.equals((Object)BAk255AlarmLimit.modifyLimit)) {
                    string = "almlo_limit";
                } else if (action.equals((Object)BAk255AlarmLimit.modifyDuration)) {
                    string = "almlo_dur";
                }
            }
            BAk255Network bAk255Network = (BAk255Network)bAk255Device.getNetwork();
            if (bAk255Network != null) {
                BAk255WriteSuctionGroupRequest bAk255WriteSuctionGroupRequest = new BAk255WriteSuctionGroupRequest(bAk255Device, this, string, bValue);
                DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteSuctionGroupRequest);
            }
            this.doPoll();
        }
    }

    public void doModifyDefrostAutoSchedule(BBoolean bBoolean) {
        int n = 0;
        if (bBoolean.getBoolean()) {
            n = 1;
        }
        this.doModifySuction("auto_schedule", (BValue)BInteger.make((int)n));
    }

    public void doPoll() {
        BAk255Network bAk255Network;
        BAk255ReadSuctionGroupRequest bAk255ReadSuctionGroupRequest = new BAk255ReadSuctionGroupRequest(this);
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null && (bAk255Network = (BAk255Network)bAk255Device.getNetwork()) != null) {
            DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255ReadSuctionGroupRequest);
        }
    }

    public void decodeXElem(XElem xElem) {
        this.decodeReplyError(xElem);
        this.setLastUpdate(BAbsTime.now());
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            if (xElemArray[n].name().equals("name")) {
                this.setGroupName(xElemArray[n].content(0).toString());
            } else if (xElemArray[n].name().equals("num_circuits")) {
                this.setNumCircuits(Integer.parseInt(xElemArray[n].content(0).toString()));
            } else if (xElemArray[n].name().equals("value")) {
                this.getSuctionPressure().setValue(Double.parseDouble(xElemArray[n].text(0).toString()));
                this.setUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("suction_target")) {
                this.getSuctionTarget().setValue(Double.parseDouble(xElemArray[n].text(0).toString()));
                this.setSuctionTargetUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("suction_cutout")) {
                this.getSuctionCutout().setValue(Double.parseDouble(xElemArray[n].text(0).toString()));
                this.setSuctionCutoutUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("suction_control")) {
                this.getSuctionControl().parseXelem(xElemArray[n]);
            } else if (xElemArray[n].name().equals("auto_schedule")) {
                int n2 = ParseUtil.getXlmIntContent(xElemArray[n], 0);
                boolean bl = false;
                if (n2 == 1) {
                    bl = true;
                }
                this.setDefrostAutoSchedule(bl);
            } else if (xElemArray[n].name().equals("almhi_limit")) {
                this.getAlarmHiLimit().setAction(BCondenserAlmActionEnum.make(xElemArray[n].geti("action_index", 1)));
                this.getAlarmHiLimit().setRoutingAction(xElemArray[n].geti("routingAction", 0));
                this.getAlarmHiLimit().setValue(Float.parseFloat(xElemArray[n].text(0).toString()));
                this.getAlarmHiLimit().setUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("almhi_dur")) {
                this.getAlarmHiLimit().setDuration(Integer.parseInt(xElemArray[n].text(0).toString()));
                this.getAlarmHiLimit().setDurationUnits(BCondenserAlmDurEnum.make(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("almlo_limit")) {
                this.getAlarmLoLimit().setAction(BCondenserAlmActionEnum.make(xElemArray[n].geti("action_index", 1)));
                this.getAlarmLoLimit().setRoutingAction(xElemArray[n].geti("routingAction", 0));
                this.getAlarmLoLimit().setValue(Float.parseFloat(xElemArray[n].text(0).toString()));
                this.getAlarmLoLimit().setUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("almlo_dur")) {
                this.getAlarmLoLimit().setDuration(Integer.parseInt(xElemArray[n].text(0).toString()));
                this.getAlarmLoLimit().setDurationUnits(BCondenserAlmDurEnum.make(xElemArray[n].geti("units_index", 0)));
            }
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAk255SuctionGroup() {
    }

    public BAk255SuctionGroup(int n) {
        this.setSuctionId(n);
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BAk255SuctionGroup;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255SuctionGroup = BAk255SuctionGroup.class("[Lcom.tridium.ak255.components.BAk255SuctionGroup;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

