/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.BAk255Network;
import com.tridium.ak255.comm.req.BAk255ReadDeviceRequest;
import com.tridium.ak255.comm.rsp.ParseUtil;
import com.tridium.ak255.components.BAk255SuctionGroup;
import com.tridium.ak255.components.BStatusPollableComponent;
import com.tridium.ak255.enums.BNodeTypeEnum;
import com.tridium.ak255.enums.BUnitsTypeEnum;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255SubDevice
extends BStatusPollableComponent {
    public static final Property deviceName = BAk255SubDevice.newProperty((int)1, (String)"", null);
    public static final Property deviceId = BAk255SubDevice.newProperty((int)1, (String)"", null);
    public static final Property rackId = BAk255SubDevice.newProperty((int)5, (int)0, null);
    public static final Property numSuctionGroups = BAk255SubDevice.newProperty((int)5, (int)0, null);
    public static final Property deviceType = BAk255SubDevice.newProperty((int)1, (String)"", null);
    public static final Property nodeType = BAk255SubDevice.newProperty((int)1, (int)0, null);
    public static final Property nodeTypeEnum = BAk255SubDevice.newProperty((int)1, (BValue)BNodeTypeEnum.emptyNode, null);
    public static final Property deviceAddr = BAk255SubDevice.newProperty((int)1, (String)"", null);
    public static final Property deviceNode = BAk255SubDevice.newProperty((int)1, (int)0, null);
    public static final Property deviceModule = BAk255SubDevice.newProperty((int)1, (int)0, null);
    public static final Property devicePoint = BAk255SubDevice.newProperty((int)1, (int)0, null);
    public static final Property deviceMulti = BAk255SubDevice.newProperty((int)1, (int)0, null);
    public static final Property deviceSection = BAk255SubDevice.newProperty((int)1, (int)0, null);
    public static final Property fileName = BAk255SubDevice.newProperty((int)1, (String)"", null);
    public static final Property model = BAk255SubDevice.newProperty((int)1, (String)"", null);
    public static final Property booleanValue = BAk255SubDevice.newProperty((int)1, (BValue)new BStatusBoolean(), null);
    public static final Property numericValue = BAk255SubDevice.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property numericValueUnits = BAk255SubDevice.newProperty((int)5, (BValue)BUnit.NULL, null);
    public static final Property deviceStatus = BAk255SubDevice.newProperty((int)1, (String)"", null);
    public static final Property hasCondenser = BAk255SubDevice.newProperty((int)5, (boolean)false, null);
    public static final Property hasAlarm = BAk255SubDevice.newProperty((int)1, (boolean)false, null);
    public static final Property hasMainSwitch = BAk255SubDevice.newProperty((int)1, (boolean)false, null);
    public static final Property hasLights = BAk255SubDevice.newProperty((int)1, (boolean)false, null);
    public static final Property hasNight = BAk255SubDevice.newProperty((int)1, (boolean)false, null);
    public static final Property hasDefrost = BAk255SubDevice.newProperty((int)1, (boolean)false, null);
    public static final Property hasCleaning = BAk255SubDevice.newProperty((int)1, (boolean)false, null);
    public static final Property hasShutDown = BAk255SubDevice.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255SubDevice;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255SuctionGroup;

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String string) {
        this.setString(deviceName, string, null);
    }

    public String getDeviceId() {
        return this.getString(deviceId);
    }

    public void setDeviceId(String string) {
        this.setString(deviceId, string, null);
    }

    public int getRackId() {
        return this.getInt(rackId);
    }

    public void setRackId(int n) {
        this.setInt(rackId, n, null);
    }

    public int getNumSuctionGroups() {
        return this.getInt(numSuctionGroups);
    }

    public void setNumSuctionGroups(int n) {
        this.setInt(numSuctionGroups, n, null);
    }

    public String getDeviceType() {
        return this.getString(deviceType);
    }

    public void setDeviceType(String string) {
        this.setString(deviceType, string, null);
    }

    public int getNodeType() {
        return this.getInt(nodeType);
    }

    public void setNodeType(int n) {
        this.setInt(nodeType, n, null);
    }

    public BNodeTypeEnum getNodeTypeEnum() {
        return (BNodeTypeEnum)this.get(nodeTypeEnum);
    }

    public void setNodeTypeEnum(BNodeTypeEnum bNodeTypeEnum) {
        this.set(nodeTypeEnum, (BValue)bNodeTypeEnum, null);
    }

    public String getDeviceAddr() {
        return this.getString(deviceAddr);
    }

    public void setDeviceAddr(String string) {
        this.setString(deviceAddr, string, null);
    }

    public int getDeviceNode() {
        return this.getInt(deviceNode);
    }

    public void setDeviceNode(int n) {
        this.setInt(deviceNode, n, null);
    }

    public int getDeviceModule() {
        return this.getInt(deviceModule);
    }

    public void setDeviceModule(int n) {
        this.setInt(deviceModule, n, null);
    }

    public int getDevicePoint() {
        return this.getInt(devicePoint);
    }

    public void setDevicePoint(int n) {
        this.setInt(devicePoint, n, null);
    }

    public int getDeviceMulti() {
        return this.getInt(deviceMulti);
    }

    public void setDeviceMulti(int n) {
        this.setInt(deviceMulti, n, null);
    }

    public int getDeviceSection() {
        return this.getInt(deviceSection);
    }

    public void setDeviceSection(int n) {
        this.setInt(deviceSection, n, null);
    }

    public String getFileName() {
        return this.getString(fileName);
    }

    public void setFileName(String string) {
        this.setString(fileName, string, null);
    }

    public String getModel() {
        return this.getString(model);
    }

    public void setModel(String string) {
        this.setString(model, string, null);
    }

    public BStatusBoolean getBooleanValue() {
        return (BStatusBoolean)this.get(booleanValue);
    }

    public void setBooleanValue(BStatusBoolean bStatusBoolean) {
        this.set(booleanValue, (BValue)bStatusBoolean, null);
    }

    public BStatusNumeric getNumericValue() {
        return (BStatusNumeric)this.get(numericValue);
    }

    public void setNumericValue(BStatusNumeric bStatusNumeric) {
        this.set(numericValue, (BValue)bStatusNumeric, null);
    }

    public BUnit getNumericValueUnits() {
        return (BUnit)this.get(numericValueUnits);
    }

    public void setNumericValueUnits(BUnit bUnit) {
        this.set(numericValueUnits, (BValue)bUnit, null);
    }

    public String getDeviceStatus() {
        return this.getString(deviceStatus);
    }

    public void setDeviceStatus(String string) {
        this.setString(deviceStatus, string, null);
    }

    public boolean getHasCondenser() {
        return this.getBoolean(hasCondenser);
    }

    public void setHasCondenser(boolean bl) {
        this.setBoolean(hasCondenser, bl, null);
    }

    public boolean getHasAlarm() {
        return this.getBoolean(hasAlarm);
    }

    public void setHasAlarm(boolean bl) {
        this.setBoolean(hasAlarm, bl, null);
    }

    public boolean getHasMainSwitch() {
        return this.getBoolean(hasMainSwitch);
    }

    public void setHasMainSwitch(boolean bl) {
        this.setBoolean(hasMainSwitch, bl, null);
    }

    public boolean getHasLights() {
        return this.getBoolean(hasLights);
    }

    public void setHasLights(boolean bl) {
        this.setBoolean(hasLights, bl, null);
    }

    public boolean getHasNight() {
        return this.getBoolean(hasNight);
    }

    public void setHasNight(boolean bl) {
        this.setBoolean(hasNight, bl, null);
    }

    public boolean getHasDefrost() {
        return this.getBoolean(hasDefrost);
    }

    public void setHasDefrost(boolean bl) {
        this.setBoolean(hasDefrost, bl, null);
    }

    public boolean getHasCleaning() {
        return this.getBoolean(hasCleaning);
    }

    public void setHasCleaning(boolean bl) {
        this.setBoolean(hasCleaning, bl, null);
    }

    public boolean getHasShutDown() {
        return this.getBoolean(hasShutDown);
    }

    public void setHasShutDown(boolean bl) {
        this.setBoolean(hasShutDown, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.checkAddSuctionGroups();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals((Object)numSuctionGroups)) {
            this.checkAddSuctionGroups();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)numericValue)) {
            return BFacets.makeNumeric((BUnit)this.getNumericValueUnits(), (int)2);
        }
        return super.getSlotFacets(slot);
    }

    public void checkAddSuctionGroups() {
        int n = 1;
        while (n <= this.getNumSuctionGroups()) {
            BAk255SuctionGroup bAk255SuctionGroup = null;
            try {
                bAk255SuctionGroup = (BAk255SuctionGroup)this.get("suction" + n);
            }
            catch (Exception exception) {}
            if (bAk255SuctionGroup == null) {
                System.out.println("adding suctionGroup: " + n);
                Property property = this.add("suction" + n, (BValue)new BAk255SuctionGroup(n));
                bAk255SuctionGroup = (BAk255SuctionGroup)this.get(property);
            }
            bAk255SuctionGroup.setRackId(this.getRackId());
            bAk255SuctionGroup.read();
            ++n;
        }
        Class clazz = class$com$tridium$ak255$components$BAk255SuctionGroup;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255SuctionGroup = BAk255SubDevice.class("[Lcom.tridium.ak255.components.BAk255SuctionGroup;", false);
        }
        BAk255SuctionGroup[] bAk255SuctionGroupArray = (BAk255SuctionGroup[])this.getChildren(clazz);
        int n2 = this.getNumSuctionGroups();
        if (n2 > 0 && bAk255SuctionGroupArray.length > n2) {
            int n3 = n2;
            while (n3 < bAk255SuctionGroupArray.length) {
                this.remove((BComplex)bAk255SuctionGroupArray[n3]);
                ++n3;
            }
        }
    }

    public void doPoll() {
        BAk255Network bAk255Network;
        BAk255ReadDeviceRequest bAk255ReadDeviceRequest = new BAk255ReadDeviceRequest(this);
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null && (bAk255Network = (BAk255Network)bAk255Device.getNetwork()) != null) {
            DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255ReadDeviceRequest);
        }
    }

    public BAk255Device getDevice() {
        return (BAk255Device)this.getParent().getParent();
    }

    public void decodeXElem(XElem xElem) {
        this.decodeReplyError(xElem);
        this.setLastUpdate(BAbsTime.now());
        this.setDeviceName(ParseUtil.getElemHideProperty(xElem, "name", (BComplex)this, deviceName, ""));
        this.setDeviceType(ParseUtil.getElemHideProperty(xElem, "type", (BComplex)this, deviceType, ""));
        this.setFileName(ParseUtil.getElemHideProperty(xElem, "filename", (BComplex)this, fileName, ""));
        this.setModel(ParseUtil.getElemHideProperty(xElem, "model", (BComplex)this, model, ""));
        this.setDeviceStatus(ParseUtil.getElemHideProperty(xElem, "stat", (BComplex)this, deviceStatus, ""));
        this.setHasAlarm(ParseUtil.getbElemHideProperty(xElem, "alarm", (BComplex)this, hasAlarm, "0"));
        this.setHasMainSwitch(ParseUtil.getbElemHideProperty(xElem, "mainswitch", (BComplex)this, hasMainSwitch, "0"));
        this.setHasLights(ParseUtil.getbElemHideProperty(xElem, "lights", (BComplex)this, hasLights, "0"));
        this.setHasNight(ParseUtil.getbElemHideProperty(xElem, "night", (BComplex)this, hasNight, "0"));
        this.setHasDefrost(ParseUtil.getbElemHideProperty(xElem, "defrost", (BComplex)this, hasDefrost, "0"));
        this.setHasCleaning(ParseUtil.getbElemHideProperty(xElem, "cleaning", (BComplex)this, hasCleaning, "0"));
        this.setHasShutDown(ParseUtil.getbElemHideProperty(xElem, "shutdown", (BComplex)this, hasShutDown, "0"));
        XElem xElem2 = xElem.elem("val");
        if (xElem2 != null) {
            String string = xElem2.content(0).toString();
            if (this.getDeviceType().equals("PACK")) {
                this.setBooleanValue(ParseUtil.parseBoolean(string));
                this.setFlags((Slot)booleanValue, this.getFlags((Slot)booleanValue) & 0xFFFFFFFB);
                this.setFlags((Slot)numericValue, this.getFlags((Slot)numericValue) | 4);
            } else {
                this.setNumericValue(ParseUtil.parseNumeric(string));
                this.setNumericValueUnits(BUnitsTypeEnum.getNigaraUnit(xElem2.geti("units_index", 0)));
                this.setFlags((Slot)booleanValue, this.getFlags((Slot)booleanValue) | 4);
                this.setFlags((Slot)numericValue, this.getFlags((Slot)numericValue) & 0xFFFFFFFB);
            }
        } else {
            this.setFlags((Slot)booleanValue, this.getFlags((Slot)booleanValue) | 4);
            this.setFlags((Slot)numericValue, this.getFlags((Slot)numericValue) | 4);
        }
    }

    public String toString(Context context) {
        if (this.getDeviceName().length() == 0) {
            return super.toString(context);
        }
        return this.getDeviceName();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BAk255SubDevice;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255SubDevice = BAk255SubDevice.class("[Lcom.tridium.ak255.components.BAk255SubDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

