/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.comm.rsp.ParseUtil;
import com.tridium.ak255.components.BAk255Meters;
import com.tridium.ak255.components.BStatusComponent;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255Meter
extends BStatusComponent {
    public static final Property consumptionFacets = BAk255Meter.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"kilowatt hour"), (int)2), null);
    public static final Property rateFacets = BAk255Meter.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"kilowatt"), (int)2), null);
    public static final Property meterName = BAk255Meter.newProperty((int)1, (String)"", null);
    public static final Property nodeType = BAk255Meter.newProperty((int)1, (int)0, null);
    public static final Property node = BAk255Meter.newProperty((int)1, (int)0, null);
    public static final Property consumption = BAk255Meter.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property currentRate = BAk255Meter.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property hourlyAccumulation = BAk255Meter.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property dailyAccumulation = BAk255Meter.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property peak = BAk255Meter.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property peakTime = BAk255Meter.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property lastPeakReset = BAk255Meter.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property lastConsumptionReset = BAk255Meter.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255Meter;

    public BFacets getConsumptionFacets() {
        return (BFacets)this.get(consumptionFacets);
    }

    public void setConsumptionFacets(BFacets bFacets) {
        this.set(consumptionFacets, (BValue)bFacets, null);
    }

    public BFacets getRateFacets() {
        return (BFacets)this.get(rateFacets);
    }

    public void setRateFacets(BFacets bFacets) {
        this.set(rateFacets, (BValue)bFacets, null);
    }

    public String getMeterName() {
        return this.getString(meterName);
    }

    public void setMeterName(String string) {
        this.setString(meterName, string, null);
    }

    public int getNodeType() {
        return this.getInt(nodeType);
    }

    public void setNodeType(int n) {
        this.setInt(nodeType, n, null);
    }

    public int getNode() {
        return this.getInt(node);
    }

    public void setNode(int n) {
        this.setInt(node, n, null);
    }

    public BStatusNumeric getConsumption() {
        return (BStatusNumeric)this.get(consumption);
    }

    public void setConsumption(BStatusNumeric bStatusNumeric) {
        this.set(consumption, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentRate() {
        return (BStatusNumeric)this.get(currentRate);
    }

    public void setCurrentRate(BStatusNumeric bStatusNumeric) {
        this.set(currentRate, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getHourlyAccumulation() {
        return (BStatusNumeric)this.get(hourlyAccumulation);
    }

    public void setHourlyAccumulation(BStatusNumeric bStatusNumeric) {
        this.set(hourlyAccumulation, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getDailyAccumulation() {
        return (BStatusNumeric)this.get(dailyAccumulation);
    }

    public void setDailyAccumulation(BStatusNumeric bStatusNumeric) {
        this.set(dailyAccumulation, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getPeak() {
        return (BStatusNumeric)this.get(peak);
    }

    public void setPeak(BStatusNumeric bStatusNumeric) {
        this.set(peak, (BValue)bStatusNumeric, null);
    }

    public BAbsTime getPeakTime() {
        return (BAbsTime)this.get(peakTime);
    }

    public void setPeakTime(BAbsTime bAbsTime) {
        this.set(peakTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastPeakReset() {
        return (BAbsTime)this.get(lastPeakReset);
    }

    public void setLastPeakReset(BAbsTime bAbsTime) {
        this.set(lastPeakReset, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastConsumptionReset() {
        return (BAbsTime)this.get(lastConsumptionReset);
    }

    public void setLastConsumptionReset(BAbsTime bAbsTime) {
        this.set(lastConsumptionReset, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAk255Device getDevice() {
        return (BAk255Device)this.getParent().getParent();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)consumption) || slot.equals((Object)hourlyAccumulation) || slot.equals((Object)dailyAccumulation)) {
            return this.getConsumptionFacets();
        }
        if (slot.equals((Object)currentRate) || slot.equals((Object)peak)) {
            return this.getRateFacets();
        }
        return super.getSlotFacets(slot);
    }

    public static void parseMeter(BAk255Meters bAk255Meters, XElem xElem) {
        Object object;
        XElem[] xElemArray = xElem.elems();
        BAk255Meter bAk255Meter = new BAk255Meter();
        int n = 0;
        while (n < xElemArray.length) {
            block26: {
                object = "";
                try {
                    object = xElemArray[n].content(0).toString();
                }
                catch (Exception exception) {
                    break block26;
                }
                if (xElemArray[n].name().equals("name")) {
                    bAk255Meter.setMeterName((String)object);
                } else if (xElemArray[n].name().equals("nodetype")) {
                    bAk255Meter.setNodeType(ParseUtil.parseInteger(object));
                } else if (xElemArray[n].name().equals("node")) {
                    bAk255Meter.setNode(ParseUtil.parseInteger(object));
                } else if (xElemArray[n].name().equals("kwh")) {
                    bAk255Meter.setConsumption(ParseUtil.parseNumeric(object));
                } else if (xElemArray[n].name().equals("kw")) {
                    bAk255Meter.setCurrentRate(ParseUtil.parseNumeric(object));
                } else if (xElemArray[n].name().equals("pk")) {
                    bAk255Meter.setPeak(ParseUtil.parseNumeric(object));
                } else if (xElemArray[n].name().equals("acc_kwh_hourly")) {
                    bAk255Meter.setHourlyAccumulation(ParseUtil.parseNumeric(object));
                } else if (xElemArray[n].name().equals("acc_kwh_daily")) {
                    bAk255Meter.setDailyAccumulation(ParseUtil.parseNumeric(object));
                } else if (xElemArray[n].name().equals("pk_epoch")) {
                    bAk255Meter.setPeakTime(ParseUtil.parseEpochSeconds(object));
                } else if (xElemArray[n].name().equals("pk_reset_epoch")) {
                    bAk255Meter.setLastPeakReset(ParseUtil.parseEpochSeconds(object));
                } else if (xElemArray[n].name().equals("kwh_reset_epoch")) {
                    bAk255Meter.setLastConsumptionReset(ParseUtil.parseEpochSeconds(object));
                }
            }
            ++n;
        }
        String string = "meter_" + bAk255Meter.getNode();
        object = (BAk255Meter)bAk255Meters.get(string);
        if (object == null) {
            bAk255Meters.add(string, (BValue)bAk255Meter);
        } else {
            object.copyFrom((BComplex)bAk255Meter);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BAk255Meter;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255Meter = BAk255Meter.class("[Lcom.tridium.ak255.components.BAk255Meter;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

