/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.BAk255AlarmDeviceExt;
import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.BAk255Network;
import com.tridium.ak255.comm.req.BAk255ReadAlarmDetailRequest;
import com.tridium.ak255.comm.req.BAk255WriteAlarmAckRequest;
import com.tridium.ak255.comm.rsp.ParseUtil;
import com.tridium.ak255.enums.BNodeTypeEnum;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255AlarmDetail
extends BComponent {
    public static final Property ref = BAk255AlarmDetail.newProperty((int)1, (int)0, null);
    public static final Property status = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property occurTime = BAk255AlarmDetail.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showTimeZone", (boolean)true));
    public static final Property ackTime = BAk255AlarmDetail.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showTimeZone", (boolean)true));
    public static final Property normalTime = BAk255AlarmDetail.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showTimeZone", (boolean)true));
    public static final Property alarmName = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property tripValue = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property currentValue = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property storeName = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property unitNumber = BAk255AlarmDetail.newProperty((int)1, (int)0, null);
    public static final Property unitName = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property deviceName = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property deviceModel = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property nodeType = BAk255AlarmDetail.newProperty((int)1, (BValue)BNodeTypeEnum.emptyNode, null);
    public static final Property addr = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property alarmClass = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property action = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property clearable = BAk255AlarmDetail.newProperty((int)1, (boolean)false, null);
    public static final Property setting = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property acknowledgement = BAk255AlarmDetail.newProperty((int)1, (String)"", null);
    public static final Property isOrphaned = BAk255AlarmDetail.newProperty((int)5, (boolean)false, null);
    public static final Action readDetail = BAk255AlarmDetail.newAction((int)16, null);
    public static final Action ackAlarm = BAk255AlarmDetail.newAction((int)16, null);
    public static final Action clearAlarm = BAk255AlarmDetail.newAction((int)16, null);
    public static final Type TYPE;
    private static boolean ACK;
    private static boolean CLEAR;
    private static BIcon yellowAlarmIcon;
    private static BIcon redAlarmIcon;
    private static BIcon greenAlarmIcon;
    private static BIcon orangeAlarmIcon;
    private static BIcon whiteAlarmIcon;
    private static final BIcon ackedIcon;
    private static final BIcon almIcon;
    private static final BIcon icon;
    Clock.Ticket readBackTicket;
    private BAk255AlarmDeviceExt alarmDeviceExt;
    private BAk255Device device;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255AlarmDetail;

    public long getRef() {
        return this.getLong(ref);
    }

    public void setRef(long l) {
        this.setLong(ref, l, null);
    }

    public String getStatus() {
        return this.getString(status);
    }

    public void setStatus(String string) {
        this.setString(status, string, null);
    }

    public BAbsTime getOccurTime() {
        return (BAbsTime)this.get(occurTime);
    }

    public void setOccurTime(BAbsTime bAbsTime) {
        this.set(occurTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getAckTime() {
        return (BAbsTime)this.get(ackTime);
    }

    public void setAckTime(BAbsTime bAbsTime) {
        this.set(ackTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getNormalTime() {
        return (BAbsTime)this.get(normalTime);
    }

    public void setNormalTime(BAbsTime bAbsTime) {
        this.set(normalTime, (BValue)bAbsTime, null);
    }

    public String getAlarmName() {
        return this.getString(alarmName);
    }

    public void setAlarmName(String string) {
        this.setString(alarmName, string, null);
    }

    public String getTripValue() {
        return this.getString(tripValue);
    }

    public void setTripValue(String string) {
        this.setString(tripValue, string, null);
    }

    public String getCurrentValue() {
        return this.getString(currentValue);
    }

    public void setCurrentValue(String string) {
        this.setString(currentValue, string, null);
    }

    public String getStoreName() {
        return this.getString(storeName);
    }

    public void setStoreName(String string) {
        this.setString(storeName, string, null);
    }

    public int getUnitNumber() {
        return this.getInt(unitNumber);
    }

    public void setUnitNumber(int n) {
        this.setInt(unitNumber, n, null);
    }

    public String getUnitName() {
        return this.getString(unitName);
    }

    public void setUnitName(String string) {
        this.setString(unitName, string, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String string) {
        this.setString(deviceName, string, null);
    }

    public String getDeviceModel() {
        return this.getString(deviceModel);
    }

    public void setDeviceModel(String string) {
        this.setString(deviceModel, string, null);
    }

    public BNodeTypeEnum getNodeType() {
        return (BNodeTypeEnum)this.get(nodeType);
    }

    public void setNodeType(BNodeTypeEnum bNodeTypeEnum) {
        this.set(nodeType, (BValue)bNodeTypeEnum, null);
    }

    public String getAddr() {
        return this.getString(addr);
    }

    public void setAddr(String string) {
        this.setString(addr, string, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public String getAction() {
        return this.getString(action);
    }

    public void setAction(String string) {
        this.setString(action, string, null);
    }

    public boolean getClearable() {
        return this.getBoolean(clearable);
    }

    public void setClearable(boolean bl) {
        this.setBoolean(clearable, bl, null);
    }

    public String getSetting() {
        return this.getString(setting);
    }

    public void setSetting(String string) {
        this.setString(setting, string, null);
    }

    public String getAcknowledgement() {
        return this.getString(acknowledgement);
    }

    public void setAcknowledgement(String string) {
        this.setString(acknowledgement, string, null);
    }

    public boolean getIsOrphaned() {
        return this.getBoolean(isOrphaned);
    }

    public void setIsOrphaned(boolean bl) {
        this.setBoolean(isOrphaned, bl, null);
    }

    public void readDetail() {
        this.invoke(readDetail, null, null);
    }

    public void ackAlarm() {
        this.invoke(ackAlarm, null, null);
    }

    public void clearAlarm() {
        this.invoke(clearAlarm, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)readDetail) || action.equals((Object)ackAlarm) || action.equals((Object)clearAlarm)) {
            this.alarmDeviceExt = (BAk255AlarmDeviceExt)this.getParent();
            this.device = this.alarmDeviceExt.getAk255Device();
            BStatus bStatus = this.device.getStatus();
            if (this.isRunning() && !bStatus.isDisabled() && !bStatus.isDown()) {
                return this.device.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    public void doAckAlarm() {
        BAk255Network bAk255Network;
        BAk255AlarmDeviceExt.alarmLog.trace("ack alarm ref: " + this.getRef());
        BAk255WriteAlarmAckRequest bAk255WriteAlarmAckRequest = new BAk255WriteAlarmAckRequest(this.alarmDeviceExt, ACK, this.getRef());
        if (this.device != null && (bAk255Network = (BAk255Network)this.device.getNetwork()) != null) {
            this.setAcknowledgement("ackPending");
            DdfRequestUtil.communicateSync((BIDdfCommunicator)this.device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteAlarmAckRequest);
        }
        this.initReadBackTicket();
    }

    public void doClearAlarm() {
        BAk255AlarmDeviceExt.alarmLog.trace("clear alarm ref: " + this.getRef());
        BAk255WriteAlarmAckRequest bAk255WriteAlarmAckRequest = new BAk255WriteAlarmAckRequest(this.alarmDeviceExt, CLEAR, this.getRef());
        if (this.device != null && this.device.getNetwork() != null) {
            this.setAcknowledgement("clearPending");
            DdfRequestUtil.communicateSync((BIDdfCommunicator)this.device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteAlarmAckRequest);
        }
        this.initReadBackTicket();
    }

    public void doReadDetail() {
        this.setAcknowledgement("");
        BAk255ReadAlarmDetailRequest bAk255ReadAlarmDetailRequest = new BAk255ReadAlarmDetailRequest(this.alarmDeviceExt, "any", this.getRef());
        if (this.device != null && this.device.getNetwork() != null) {
            DdfRequestUtil.communicateSync((BIDdfCommunicator)this.device.getDdfCommunicator(), (BIDdfRequest)bAk255ReadAlarmDetailRequest);
        }
    }

    public boolean isActive() {
        return this.getStatus().equals("active");
    }

    public boolean isNowNormal() {
        return this.getNormalTime().isNull() ^ true;
    }

    public boolean isCleared() {
        return this.getStatus().equals("cleared");
    }

    public boolean isAcked() {
        return this.getAckTime().isNull() ^ true;
    }

    public boolean isClearPending() {
        return this.getAcknowledgement().equals("clearPending");
    }

    public boolean isAckPending() {
        return this.getAcknowledgement().equals("ackPending");
    }

    public void decodeAlarm(XElem xElem, BAk255AlarmDeviceExt bAk255AlarmDeviceExt) {
        this.alarmDeviceExt = bAk255AlarmDeviceExt;
        this.device = this.alarmDeviceExt.getAk255Device();
        int n = this.device.getTimeZoneOffset();
        boolean bl = this.device.getIsDaylightSavings();
        this.setIsOrphaned(false);
        this.setRef(ParseUtil.getLongElemValue(xElem, "ref", -1));
        this.setStoreName(ParseUtil.getStringElemValue(xElem, "storeName", ""));
        this.setUnitNumber(ParseUtil.getIntElemValue(xElem, "unitNumber", -1));
        this.setUnitName(ParseUtil.getStringElemValue(xElem, "unitName", ""));
        this.setDeviceName(ParseUtil.getStringElemValue(xElem, "deviceName", ""));
        this.setDeviceModel(ParseUtil.getStringElemValue(xElem, "deviceModel", ""));
        this.setAddr(ParseUtil.getStringElemValue(xElem, "addr", ""));
        this.setAlarmClass(ParseUtil.getStringElemValue(xElem, "class", ""));
        this.setAlarmName(ParseUtil.getStringElemValue(xElem, "name", ""));
        this.setStatus(ParseUtil.getStringElemValue(xElem, "status", ""));
        this.setAction(ParseUtil.getStringElemValue(xElem, "action", ""));
        this.setClearable(ParseUtil.getBooleanElemValue(xElem, "clearable", false));
        this.setTripValue(ParseUtil.getStringElemValue(xElem, "value", ""));
        this.setCurrentValue(ParseUtil.getStringElemValue(xElem, "current_value", ""));
        this.setSetting(ParseUtil.getStringElemValue(xElem, "setting", ""));
        this.setAcknowledgement(ParseUtil.getStringElemValue(xElem, "acknowledgement", ""));
        this.setOccurTime(ParseUtil.getEpochElemValue(xElem, "epoch", BAbsTime.NULL, n, bl));
        this.setNormalTime(ParseUtil.getEpochElemValue(xElem, "epoch_cleared", this.getNormalTime(), n, bl));
        this.setAckTime(ParseUtil.getEpochElemValue(xElem, "epoch_acked", BAbsTime.NULL, n, bl));
        int n2 = ParseUtil.getIntElemValue(xElem, "nodetype", -1);
        this.setNodeType(BNodeTypeEnum.make(n2));
    }

    private final void initReadBackTicket() {
        if (this.readBackTicket != null) {
            this.readBackTicket.cancel();
        }
        this.readBackTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)15), (Action)readDetail, null);
    }

    public BIcon getIcon() {
        if (this.isCleared()) {
            return whiteAlarmIcon;
        }
        if (!this.isAcked()) {
            return redAlarmIcon;
        }
        return yellowAlarmIcon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BAk255AlarmDetail;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255AlarmDetail = BAk255AlarmDetail.class("[Lcom.tridium.ak255.components.BAk255AlarmDetail;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ACK = true;
        CLEAR = false;
        yellowAlarmIcon = BIcon.make((String)"module://icons/x16/alarm.png");
        redAlarmIcon = BIcon.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
        greenAlarmIcon = BIcon.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
        orangeAlarmIcon = BIcon.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
        whiteAlarmIcon = BIcon.make((String)"module://alarm/com/tridium/alarm/icons/alarmWhite.png");
        ackedIcon = BIcon.std((String)"alarm/alarmAck.png");
        almIcon = BIcon.std((String)"alarm/alarm.png");
        icon = BIcon.std((String)"alarm/alarmClassExtension.png");
    }
}

