/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.comm.rsp;

import com.tridium.ak255.components.BHolidayBits;
import com.tridium.ak255.enums.BScheduleUsageEnum;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.TextUtil;
import javax.baja.xml.XElem;

public class ParseUtil {
    public static String getStringElemValue(XElem xElem, String string, String string2) {
        XElem xElem2 = xElem.elem(string);
        if (xElem2 == null) {
            return string2;
        }
        try {
            return xElem2.content(0).toString();
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static long getLongElemValue(XElem xElem, String string, long l) {
        XElem xElem2 = xElem.elem(string);
        if (xElem2 == null) {
            return l;
        }
        try {
            return Long.parseLong(xElem2.content(0).toString());
        }
        catch (Exception exception) {
            return l;
        }
    }

    public static int getIntElemValue(XElem xElem, String string, int n) {
        XElem xElem2 = xElem.elem(string);
        if (xElem2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(xElem2.content(0).toString());
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static boolean getBooleanElemValue(XElem xElem, String string, boolean bl) {
        XElem xElem2 = xElem.elem(string);
        if (xElem2 == null) {
            return bl;
        }
        try {
            boolean bl2 = false;
            if (Integer.parseInt(xElem2.content(0).toString()) != 0) {
                bl2 = true;
            }
            return bl2;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public static BAbsTime getAbsTimeElemValue(XElem xElem, String string, String string2, BAbsTime bAbsTime) {
        XElem xElem2 = xElem.elem(string);
        XElem xElem3 = xElem.elem(string2);
        if (xElem2 == null || xElem3 == null) {
            return bAbsTime;
        }
        try {
            String[] stringArray = TextUtil.splitAndTrim((String)xElem2.content(0).toString(), (char)'/');
            String[] stringArray2 = TextUtil.splitAndTrim((String)xElem3.content(0).toString(), (char)':');
            int n = 2000 + Integer.parseInt(stringArray[2]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[0]);
            int n4 = Integer.parseInt(stringArray2[0]);
            int n5 = Integer.parseInt(stringArray2[1]);
            return BAbsTime.make((int)n, (BMonth)BMonth.make((int)(n3 - 1)), (int)n2, (int)n4, (int)n5);
        }
        catch (Exception exception) {
            return bAbsTime;
        }
    }

    public static BAbsTime getEpochElemValue(XElem xElem, String string, BAbsTime bAbsTime, int n, boolean bl) {
        XElem xElem2 = xElem.elem(string);
        if (xElem2 == null) {
            return bAbsTime;
        }
        return ParseUtil.parseEpochSeconds(xElem2.content(0).toString(), bAbsTime, n, bl);
    }

    public static int getiElemHideProperty(XElem xElem, String string, BComplex bComplex, Property property, String string2) {
        int n = 0;
        try {
            n = Integer.parseInt(ParseUtil.getElemHideProperty(xElem, string, bComplex, property, string2));
        }
        catch (Exception exception) {}
        return n;
    }

    public static boolean getbElemHideProperty(XElem xElem, String string, BComplex bComplex, Property property, String string2) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            if (Integer.parseInt(ParseUtil.getElemHideProperty(xElem, string, bComplex, property, string2)) != 0) {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception exception) {}
        return bl;
    }

    public static String getElemHideProperty(XElem xElem, String string, BComplex bComplex, Property property, String string2) {
        String string3 = string2;
        XElem xElem2 = xElem.elem(string);
        int n = bComplex.getFlags((Slot)property);
        if (xElem2 == null) {
            bComplex.setFlags((Slot)property, n | 4);
            return string3;
        }
        try {
            string3 = xElem2.content(0).toString();
        }
        catch (Exception exception) {
            bComplex.setFlags((Slot)property, n | 4);
            return string3;
        }
        bComplex.setFlags((Slot)property, n & 0xFFFFFFFB);
        return string3;
    }

    public static BStatusBoolean parseBoolean(String string) {
        BStatusBoolean bStatusBoolean = new BStatusBoolean();
        if (string.startsWith("*")) {
            bStatusBoolean.setStatusDown(true);
        } else if (string.equalsIgnoreCase("On")) {
            bStatusBoolean.setValue(true);
        } else {
            try {
                boolean bl = false;
                if (Integer.parseInt(string) == 1) {
                    bl = true;
                }
                bStatusBoolean.setValue(bl);
            }
            catch (Exception exception) {
                bStatusBoolean.setStatusFault(true);
            }
        }
        return bStatusBoolean;
    }

    public static BStatusNumeric parseNumeric(String string) {
        BStatusNumeric bStatusNumeric = new BStatusNumeric(0.0);
        if (string.startsWith("*")) {
            bStatusNumeric.setStatusDown(true);
        } else {
            String[] stringArray = TextUtil.splitAndTrim((String)string.trim(), (char)' ');
            try {
                bStatusNumeric.setValue(Double.parseDouble(stringArray[0]));
            }
            catch (Exception exception) {
                bStatusNumeric.setStatusFault(true);
            }
        }
        return bStatusNumeric;
    }

    public static int parseInteger(String string) {
        String[] stringArray = TextUtil.splitAndTrim((String)string.trim(), (char)' ');
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {}
        return n;
    }

    public static String getXlmStringContent(XElem xElem, String string) {
        try {
            return xElem.text(0).toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static int getXlmIntContent(XElem xElem, int n) {
        try {
            return Integer.parseInt(xElem.text(0).toString());
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static void replaceBytes(byte[] byArray, byte by, byte by2) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == by) {
                byArray[n] = by2;
            }
            ++n;
        }
    }

    public static BMonth parseMonth(String string) {
        BMonth bMonth = BMonth.january;
        if (string.equals("Jan")) {
            bMonth = BMonth.january;
        } else if (string.equals("Feb")) {
            bMonth = BMonth.february;
        } else if (string.equals("Mar")) {
            bMonth = BMonth.march;
        } else if (string.equals("Apr")) {
            bMonth = BMonth.april;
        } else if (string.equals("May")) {
            bMonth = BMonth.may;
        } else if (string.equals("Jun")) {
            bMonth = BMonth.june;
        } else if (string.equals("Jul")) {
            bMonth = BMonth.july;
        } else if (string.equals("Aug")) {
            bMonth = BMonth.august;
        } else if (string.equals("Sep")) {
            bMonth = BMonth.september;
        } else if (string.equals("Oct")) {
            bMonth = BMonth.october;
        } else if (string.equals("Nov")) {
            bMonth = BMonth.november;
        } else if (string.equals("Dec")) {
            bMonth = BMonth.december;
        }
        return bMonth;
    }

    public static int parseWeek(String string) {
        if (string.equals("First")) {
            return 1;
        }
        if (string.equals("Second")) {
            return 2;
        }
        if (string.equals("Third")) {
            return 3;
        }
        if (string.equals("Fourth")) {
            return 4;
        }
        if (string.equals("Last")) {
            return 5;
        }
        return 2;
    }

    public static BWeekday parseDay(String string) {
        if (string.equals("Sun")) {
            return BWeekday.sunday;
        }
        if (string.equals("Mon")) {
            return BWeekday.monday;
        }
        if (string.equals("Tue")) {
            return BWeekday.tuesday;
        }
        if (string.equals("Wed")) {
            return BWeekday.wednesday;
        }
        if (string.equals("Thu")) {
            return BWeekday.thursday;
        }
        if (string.equals("Fri")) {
            return BWeekday.friday;
        }
        if (string.equals("Sat")) {
            return BWeekday.saturday;
        }
        return BWeekday.sunday;
    }

    public static BRelTime parseRelTime(String string) {
        String string2 = string;
        try {
            boolean bl = true;
            if (string.charAt(0) == '+' || string.charAt(0) == '-') {
                if (string.charAt(0) == '-') {
                    bl = false;
                }
                string = string.substring(1).trim();
            }
            String[] stringArray = TextUtil.splitAndTrim((String)string, (char)':');
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = n * 60 + n2;
            if (!bl) {
                n3 = -n3;
            }
            BRelTime bRelTime = BRelTime.makeMinutes((int)n3);
            return bRelTime;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return BRelTime.DEFAULT;
        }
    }

    public static BTime parseTime(String string) {
        String string2 = string;
        try {
            int n = string.indexOf("AM");
            if (n > 0) {
                if (string.charAt(n - 1) != ' ') {
                    string2 = TextUtil.replace((String)string2, (String)"AM", (String)" AM");
                }
            } else {
                n = string.indexOf("PM");
                if (n > 0 && string.charAt(n - 1) != ' ') {
                    string2 = TextUtil.replace((String)string2, (String)"PM", (String)" PM");
                }
            }
            String[] stringArray = TextUtil.splitAndTrim((String)string2.trim(), (char)' ');
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray.length > 1) {
                bl = true;
                bl2 = stringArray[1].equals("PM");
            }
            stringArray = TextUtil.splitAndTrim((String)stringArray[0], (char)':');
            int n2 = Integer.parseInt(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            if (bl && bl2 && n2 < 12) {
                n2 += 12;
            } else if (bl && !bl2 && n2 == 12) {
                n2 -= 12;
            }
            return BTime.make((int)n2, (int)n3, (int)0);
        }
        catch (Exception exception) {
            return BTime.MIDNIGHT;
        }
    }

    public static BAbsTime parseDateTime(String string) {
        if (string == null || string.length() < 14) {
            return BAbsTime.NULL;
        }
        try {
            String[] stringArray = TextUtil.splitAndTrim((String)string, (char)' ');
            String[] stringArray2 = TextUtil.splitAndTrim((String)stringArray[0], (char)'/');
            String[] stringArray3 = TextUtil.splitAndTrim((String)stringArray[1], (char)':');
            int n = 2000 + Integer.parseInt(stringArray2[2]);
            int n2 = Integer.parseInt(stringArray2[1]);
            int n3 = Integer.parseInt(stringArray2[0]);
            int n4 = Integer.parseInt(stringArray3[0]);
            int n5 = Integer.parseInt(stringArray3[1]);
            return BAbsTime.make((int)n, (BMonth)BMonth.make((int)(n3 - 1)), (int)n2, (int)n4, (int)n5);
        }
        catch (Exception exception) {
            return BAbsTime.NULL;
        }
    }

    public static BAbsTime parseEpochSeconds(String string) {
        return ParseUtil.parseEpochSeconds(string, BAbsTime.NULL, 0, false);
    }

    public static BAbsTime parseEpochSeconds(String string, BAbsTime bAbsTime, int n, boolean bl) {
        try {
            long l = Long.parseLong(string) * 1000L;
            if (l <= 0L) {
                return BAbsTime.NULL;
            }
            l -= (long)n * 60000L;
            if (bl) {
                l -= 3600000L;
            }
            if (l <= 0L) {
                return BAbsTime.NULL;
            }
            BAbsTime bAbsTime2 = BAbsTime.make((long)l, (BTimeZone)BTimeZone.UTC);
            return bAbsTime2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bAbsTime;
        }
    }

    public static int parseHolidayMonth(String string) {
        try {
            String[] stringArray = TextUtil.splitAndTrim((String)string.trim(), (char)'/');
            return Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int parseHolidayDay(String string) {
        try {
            String[] stringArray = TextUtil.splitAndTrim((String)string.trim(), (char)'/');
            return Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static BAbsTime parseHoliday(String string) {
        try {
            String[] stringArray = TextUtil.splitAndTrim((String)string.trim(), (char)'/');
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            return BAbsTime.make((int)BAbsTime.now().getYear(), (BMonth)BMonth.make((int)(n - 1)), (int)n2);
        }
        catch (Exception exception) {
            return BAbsTime.NULL;
        }
    }

    public static String encodeDaysOfWeek(BDaysOfWeekBits bDaysOfWeekBits) {
        int n = bDaysOfWeekBits.getBits();
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append('S');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 2) != 0) {
            stringBuffer.append('M');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 4) != 0) {
            stringBuffer.append('T');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 8) != 0) {
            stringBuffer.append('W');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append('R');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append('F');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append('A');
        } else {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static BDaysOfWeekBits parseDaysOfWeek(String string) {
        int n = 0;
        if (string.indexOf("S") >= 0) {
            ++n;
        }
        if (string.indexOf("M") >= 0) {
            n += 2;
        }
        if (string.indexOf("T") >= 0) {
            n += 4;
        }
        if (string.indexOf("W") >= 0) {
            n += 8;
        }
        if (string.indexOf("R") >= 0) {
            n += 16;
        }
        if (string.indexOf("F") >= 0) {
            n += 32;
        }
        if (string.indexOf("A") >= 0) {
            n += 64;
        }
        return BDaysOfWeekBits.make((int)n);
    }

    public static String encodeHolidays(BHolidayBits bHolidayBits) {
        int n = bHolidayBits.getBits();
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append('1');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 2) != 0) {
            stringBuffer.append('2');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 4) != 0) {
            stringBuffer.append('3');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 8) != 0) {
            stringBuffer.append('4');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append('5');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append('6');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append('7');
        } else {
            stringBuffer.append(' ');
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append('8');
        } else {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static BHolidayBits parseHolidayBits(String string) {
        int n = 0;
        if (string.indexOf("1") >= 0) {
            ++n;
        }
        if (string.indexOf("2") >= 0) {
            n += 2;
        }
        if (string.indexOf("3") >= 0) {
            n += 4;
        }
        if (string.indexOf("4") >= 0) {
            n += 8;
        }
        if (string.indexOf("5") >= 0) {
            n += 16;
        }
        if (string.indexOf("6") >= 0) {
            n += 32;
        }
        if (string.indexOf("7") >= 0) {
            n += 64;
        }
        if (string.indexOf("8") >= 0) {
            n += 128;
        }
        return BHolidayBits.make(n);
    }

    public static BScheduleUsageEnum parseScheduleUsage(String string) {
        if (string.equals("Misc")) {
            return BScheduleUsageEnum.misc;
        }
        if (string.equals("Case Lighting")) {
            return BScheduleUsageEnum.caseLighting;
        }
        if (string.equals("Night Setback")) {
            return BScheduleUsageEnum.nightSetback;
        }
        if (string.equals("Shutdown")) {
            return BScheduleUsageEnum.shutDown;
        }
        if (string.equals("Defrost")) {
            return BScheduleUsageEnum.defrost;
        }
        if (string.equals("Coord Defrost")) {
            return BScheduleUsageEnum.coordDefrost;
        }
        return BScheduleUsageEnum.misc;
    }
}

