/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.util;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveOutputStream;
import com.tridium.zwave.util.BUserInfo;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveUserDeviceExt
extends BDeviceExt
implements ZWaveMessageConst,
BIDeviceFolder {
    public static final Property numberUsers = BZWaveUserDeviceExt.newProperty((int)1, (int)0, null);
    public static final Action read = BZWaveUserDeviceExt.newAction((int)16, null);
    public static final Action readUsers = BZWaveUserDeviceExt.newAction((int)16, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$zwave$util$BZWaveUserDeviceExt;

    public int getNumberUsers() {
        return this.getInt(numberUsers);
    }

    public void setNumberUsers(int n) {
        this.setInt(numberUsers, n, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public void readUsers() {
        this.invoke(readUsers, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BZWaveDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return null;
    }

    public final BZWaveUserDeviceExt getDeviceExt() {
        return this;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BValue bValue = this.get(property);
        if (bValue.getType().is(BUserInfo.TYPE) && context != null) {
            this.doWriteUserData((BUserInfo)bValue);
        }
    }

    public void doWriteUserData(BUserInfo bUserInfo) {
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDevice();
        SerialSendData serialSendData = null;
        try {
            String string = bUserInfo.getUserCode();
            if (string.length() < 4) {
                string = "0000" + string;
                string = string.substring(string.length() - 4);
            } else if (string.length() > 20) {
                string = string.substring(string.length() - 20);
            }
            ZWaveOutputStream zWaveOutputStream = new ZWaveOutputStream();
            zWaveOutputStream.write(99);
            zWaveOutputStream.write(1);
            zWaveOutputStream.write(bUserInfo.getUserId());
            zWaveOutputStream.write(bUserInfo.getUserIdStatus());
            zWaveOutputStream.write(string.getBytes());
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), zWaveOutputStream.toByteArray(), 5, false);
            bZWaveNetwork.sendDataReq(serialSendData);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {}
    }

    public void doRead() {
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDevice();
        byte[] byArray = new byte[]{99, 4};
        SerialSendData serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5, false);
        bZWaveNetwork.sendDataReq(serialSendData);
    }

    public void doReadUsers() {
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDevice();
        SerialSendData serialSendData = null;
        int n = this.getNumberUsers();
        if (n < 1) {
            return;
        }
        byte[] byArray = new byte[3];
        byArray[0] = 99;
        byArray[1] = 2;
        try {
            int n2 = 1;
            while (n2 < n) {
                byArray[2] = (byte)n2;
                serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5);
                bZWaveNetwork.sendDataReq(serialSendData);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public void readUserData(int n, ZWaveInputStream zWaveInputStream) {
        block5: {
            if (n == 3) {
                int n2 = zWaveInputStream.readByte();
                int n3 = zWaveInputStream.readByte();
                String string = zWaveInputStream.readString(zWaveInputStream.available());
                BUserInfo bUserInfo = new BUserInfo(n2, n3, string);
                try {
                    Property property = this.getProperty("user" + n2);
                    if (property == null) {
                        property = this.add("user" + n2, (BValue)bUserInfo);
                        break block5;
                    }
                    this.set(property, (BValue)bUserInfo);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.setNumberUsers(zWaveInputStream.readByte());
                this.readUsers();
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$util$BZWaveUserDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$util$BZWaveUserDeviceExt = BZWaveUserDeviceExt.class("[Lcom.tridium.zwave.util.BZWaveUserDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"layers.png");
    }
}

