/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.scene;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.enums.BDurationUnits;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import javax.baja.driver.BDeviceExt;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveSceneActuatorConf
extends BComponent
implements ZWaveMessageConst {
    public static final Property sceneId = BZWaveSceneActuatorConf.newProperty((int)1, (int)0, null);
    public static final Property dimmingDuration = BZWaveSceneActuatorConf.newProperty((int)1, (int)0, null);
    public static final Property durationUnits = BZWaveSceneActuatorConf.newProperty((int)1, (BValue)BDurationUnits.second, null);
    public static final Property override = BZWaveSceneActuatorConf.newProperty((int)1, (boolean)false, null);
    public static final Property level = BZWaveSceneActuatorConf.newProperty((int)1, (int)0, null);
    public static final Action read = BZWaveSceneActuatorConf.newAction((int)16, null);
    public static final Action write = BZWaveSceneActuatorConf.newAction((int)16, null);
    public static final Action activate = BZWaveSceneActuatorConf.newAction((int)16, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$zwave$scene$BZWaveSceneActuatorConf;

    public int getSceneId() {
        return this.getInt(sceneId);
    }

    public void setSceneId(int n) {
        this.setInt(sceneId, n, null);
    }

    public int getDimmingDuration() {
        return this.getInt(dimmingDuration);
    }

    public void setDimmingDuration(int n) {
        this.setInt(dimmingDuration, n, null);
    }

    public BDurationUnits getDurationUnits() {
        return (BDurationUnits)this.get(durationUnits);
    }

    public void setDurationUnits(BDurationUnits bDurationUnits) {
        this.set(durationUnits, (BValue)bDurationUnits, null);
    }

    public boolean getOverride() {
        return this.getBoolean(override);
    }

    public void setOverride(boolean bl) {
        this.setBoolean(override, bl, null);
    }

    public int getLevel() {
        return this.getInt(level);
    }

    public void setLevel(int n) {
        this.setInt(level, n, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public void write() {
        this.invoke(write, null, null);
    }

    public void activate() {
        this.invoke(activate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDeviceExt getDeviceExt() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BDeviceExt) {
                return (BDeviceExt)bComplex;
            }
            bComplex = this.getParent();
        }
        return null;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveNetwork bZWaveNetwork;
        if ((action.equals((Object)activate) || action.equals((Object)read) || action.equals((Object)write)) && (bZWaveNetwork = (BZWaveNetwork)this.getDeviceExt().getDevice().getNetwork()) != null) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doRead() {
        SerialSendData serialSendData = null;
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        byte[] byArray = null;
        byArray = new byte[]{44, 2, (byte)this.getSceneId()};
        try {
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5);
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork();
            bZWaveNetwork.sendDataReq(serialSendData);
        }
        catch (Exception exception) {}
    }

    public void doWrite() {
        SerialSendData serialSendData = null;
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        byte[] byArray = null;
        byArray = new byte[]{44, 1, (byte)this.getSceneId(), (byte)this.getDimmingDurationInt(), (byte)this.getOverrideInt(), this.getLevel() == 100 ? (byte)99 : (byte)this.getLevel()};
        try {
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5, false);
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork();
            bZWaveNetwork.sendDataReq(serialSendData);
        }
        catch (Exception exception) {}
    }

    public void doActivate() {
        SerialSendData serialSendData = null;
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        byte[] byArray = null;
        byArray = new byte[]{43, 1, (byte)this.getSceneId(), (byte)this.getDimmingDurationInt()};
        try {
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5, false);
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork();
            bZWaveNetwork.sendDataReq(serialSendData);
        }
        catch (Exception exception) {}
    }

    int getDimmingDurationInt() {
        if (this.getDurationUnits().equals((Object)BDurationUnits.second)) {
            return this.getDimmingDuration();
        }
        return 128 + this.getDimmingDuration();
    }

    int getOverrideInt() {
        if (this.getOverride()) {
            return 128;
        }
        return 0;
    }

    public void readData(ZWaveInputStream zWaveInputStream) {
        this.setSceneId(zWaveInputStream.readByte());
        this.setLevel(zWaveInputStream.readByte());
        int n = zWaveInputStream.readByte();
        this.setDimmingDuration(n & 0x7F);
        if (n >= 128) {
            this.setDurationUnits(BDurationUnits.minute);
        } else {
            this.setDurationUnits(BDurationUnits.second);
        }
    }

    public void setDimmingDuration(BRelTime bRelTime) {
        int n = bRelTime.getSeconds();
        this.setDurationUnits(BDurationUnits.second);
        if (n > 127) {
            this.setDurationUnits(BDurationUnits.minute);
            n = bRelTime.getMinutes();
        }
        if (n > 127) {
            n = 127;
        }
        this.setDimmingDuration(n);
    }

    public boolean isDimmingDurationDefault() {
        boolean bl = false;
        if (this.getDimmingDurationInt() == 240) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$scene$BZWaveSceneActuatorConf;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$scene$BZWaveSceneActuatorConf = BZWaveSceneActuatorConf.class("[Lcom.tridium.zwave.scene.BZWaveSceneActuatorConf;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

