/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.scene;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.enums.BDurationUnits;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.scene.BZWaveNetworkScene;
import com.tridium.zwave.scene.BZWaveSceneActuatorConf;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveNetworkSceneConfig
extends BComponent
implements BIStatus,
ZWaveMessageConst {
    public static final Property status = BZWaveNetworkSceneConfig.newProperty((int)1, (BValue)BStatus.ok, null);
    public static final Property faultCause = BZWaveNetworkSceneConfig.newProperty((int)3, (String)"", null);
    public static final Property sceneId = BZWaveNetworkSceneConfig.newProperty((int)1, (int)0, null);
    public static final Property nodeId = BZWaveNetworkSceneConfig.newProperty((int)65, (int)-1, null);
    public static final Property dimmingDuration = BZWaveNetworkSceneConfig.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String[])ZWaveMessageConst.durationKeys, (BIDataValue[])ZWaveMessageConst.durationValues));
    public static final Property override = BZWaveNetworkSceneConfig.newProperty((int)4, (boolean)false, null);
    public static final Property level = BZWaveNetworkSceneConfig.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)100));
    public static final Property currentValue = BZWaveNetworkSceneConfig.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Type TYPE;
    private BLink subscribedLink;
    static /* synthetic */ Class class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public int getSceneId() {
        return this.getInt(sceneId);
    }

    public void setSceneId(int n) {
        this.setInt(sceneId, n, null);
    }

    public int getNodeId() {
        return this.getInt(nodeId);
    }

    public void setNodeId(int n) {
        this.setInt(nodeId, n, null);
    }

    public BRelTime getDimmingDuration() {
        return (BRelTime)this.get(dimmingDuration);
    }

    public void setDimmingDuration(BRelTime bRelTime) {
        this.set(dimmingDuration, (BValue)bRelTime, null);
    }

    public boolean getOverride() {
        return this.getBoolean(override);
    }

    public void setOverride(boolean bl) {
        this.setBoolean(override, bl, null);
    }

    public int getLevel() {
        return this.getInt(level);
    }

    public void setLevel(int n) {
        this.setInt(level, n, null);
    }

    public BStatusValue getCurrentValue() {
        return (BStatusValue)this.get(currentValue);
    }

    public void setCurrentValue(BStatusValue bStatusValue) {
        this.set(currentValue, (BValue)bStatusValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        Type type = bComponent.getType();
        return type.is(BZWaveNetworkScene.TYPE);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BComplex bComplex = this.getParent();
        if (bComplex == null || !(bComplex instanceof BZWaveNetworkScene)) {
            return;
        }
        if (property.equals((Object)currentValue)) {
            return;
        }
        ((BZWaveNetworkScene)bComplex).updateDevices();
    }

    public void started() throws Exception {
        BZWaveDevice bZWaveDevice;
        BZWaveNetworkScene bZWaveNetworkScene = this.getParentScene();
        if (bZWaveNetworkScene == null) {
            return;
        }
        if (this.getSceneId() != bZWaveNetworkScene.getSceneId()) {
            this.setSceneId(bZWaveNetworkScene.getSceneId());
        }
        if ((bZWaveDevice = bZWaveNetworkScene.getNetwork().getDevice(this.getNodeId())) != null && bZWaveDevice.isRunning()) {
            Type type = bZWaveDevice.getNodeInfo().getDefaultCmdClassPointType();
            if (type.is(BEnumPoint.TYPE)) {
                this.set(currentValue, (BValue)new BStatusEnum((BEnum)BDynamicEnum.DEFAULT, BStatus.nullStatus));
            } else if (type.is(BBooleanPoint.TYPE)) {
                this.set(currentValue, (BValue)new BStatusBoolean(false, BStatus.nullStatus));
            } else if (type.is(BNumericPoint.TYPE)) {
                this.set(currentValue, (BValue)new BStatusNumeric(Double.NaN, BStatus.nullStatus));
            } else if (type.is(BStringPoint.TYPE)) {
                this.set(currentValue, (BValue)new BStatusString("", BStatus.nullStatus));
            }
        }
    }

    private final void checkCurrentValueType(BControlPoint bControlPoint) {
        Type type = bControlPoint.getType();
        if (type.is(BEnumPoint.TYPE)) {
            this.set(currentValue, (BValue)new BStatusEnum((BEnum)BDynamicEnum.DEFAULT, BStatus.nullStatus));
        } else if (type.is(BBooleanPoint.TYPE)) {
            this.set(currentValue, (BValue)new BStatusBoolean(false, BStatus.nullStatus));
        } else if (type.is(BNumericPoint.TYPE)) {
            this.set(currentValue, (BValue)new BStatusNumeric(Double.NaN, BStatus.nullStatus));
        } else if (type.is(BStringPoint.TYPE)) {
            this.set(currentValue, (BValue)new BStatusString("", BStatus.nullStatus));
        }
    }

    public void subscribed() {
        BZWaveNetworkScene bZWaveNetworkScene = this.getParentScene();
        if (bZWaveNetworkScene == null) {
            return;
        }
        BZWaveDevice bZWaveDevice = bZWaveNetworkScene.getNetwork().getDevice(this.getNodeId());
        if (bZWaveDevice == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Z-Wave device is not in station");
        } else if (bZWaveDevice.get("scenes") == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Z-Wave device does not support scenes");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        BControlPoint bControlPoint = bZWaveDevice.getBasicPoint();
        if (bControlPoint != null) {
            this.checkCurrentValueType(bControlPoint);
            this.subscribedLink = this.linkTo((BComponent)bControlPoint, (Slot)bControlPoint.getOutProperty(), (Slot)currentValue);
        }
    }

    public void unsubscribed() {
        if (this.subscribedLink != null) {
            this.remove((BComplex)this.subscribedLink);
        }
        this.subscribedLink = null;
    }

    public BZWaveNetworkScene getParentScene() {
        BComplex bComplex = this.getParent();
        if (bComplex != null && bComplex instanceof BZWaveNetworkScene) {
            return (BZWaveNetworkScene)bComplex;
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.subscribedLink = null;
    }

    public BZWaveNetworkSceneConfig() {
        this.this();
    }

    public BZWaveNetworkSceneConfig(int n, int n2, BZWaveSceneActuatorConf bZWaveSceneActuatorConf) {
        this.this();
        this.setSceneId(n);
        this.setNodeId(n2);
        this.setLevel(bZWaveSceneActuatorConf.getLevel());
        if (bZWaveSceneActuatorConf.getDurationUnits().equals((Object)BDurationUnits.second)) {
            this.setDimmingDuration(BRelTime.makeSeconds((int)bZWaveSceneActuatorConf.getDimmingDuration()));
        } else {
            this.setDimmingDuration(BRelTime.makeMinutes((int)bZWaveSceneActuatorConf.getDimmingDuration()));
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig = BZWaveNetworkSceneConfig.class("[Lcom.tridium.zwave.scene.BZWaveNetworkSceneConfig;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

