/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveReceivedMessage;
import com.tridium.zwave.messages.ZWaveSerialApiRequest;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class ZWaveSerialFrame
extends Message
implements ZWaveMessageConst {
    public ZWaveSerialApiRequest request;
    int length;
    byte[] data;
    int cksum;

    public Message toResponse(ReceivedMessage receivedMessage) {
        ZWaveSerialFrame zWaveSerialFrame = new ZWaveSerialFrame();
        zWaveSerialFrame.data = ((ZWaveReceivedMessage)receivedMessage).getBytes();
        zWaveSerialFrame.length = ((ZWaveReceivedMessage)receivedMessage).getLength();
        return zWaveSerialFrame;
    }

    public void write(OutputStream outputStream) {
        try {
            outputStream.write(1);
            outputStream.write(this.length);
            if (this.data != null && this.data.length > 0) {
                outputStream.write(this.data);
            }
            outputStream.write(this.cksum);
        }
        catch (Exception exception) {}
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("l=");
        stringBuffer.append(this.length);
        stringBuffer.append(", d=");
        stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.data));
        stringBuffer.append(", ck=");
        stringBuffer.append(this.cksum);
        return stringBuffer.toString();
    }

    public void calcCksum() {
        this.cksum = 255;
        this.cksum ^= this.length;
        int n = 0;
        while (n < this.data.length) {
            this.cksum ^= this.data[n] & 0xFF;
            ++n;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public ZWaveSerialFrame() {
    }

    public ZWaveSerialFrame(ZWaveSerialApiRequest zWaveSerialApiRequest) {
        this.request = zWaveSerialApiRequest;
        this.data = zWaveSerialApiRequest.getByteArray();
        this.length = this.data.length + 1;
        this.calcCksum();
        this.setResponseExpected(false);
    }

    public ZWaveSerialFrame(ZWaveSerialApiRequest zWaveSerialApiRequest, boolean bl) {
        this.request = zWaveSerialApiRequest;
        this.data = zWaveSerialApiRequest.getByteArray();
        this.length = this.data.length + 1;
        this.calcCksum();
        this.setResponseExpected(bl);
        if (bl) {
            this.setTag(zWaveSerialApiRequest.getTag());
        }
    }
}

