/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.messages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZWaveInputStream
extends ByteArrayInputStream {
    public int readByte() {
        return this.read() & 0xFF;
    }

    public int readWord() {
        return (this.readByte() << 8) + this.readByte();
    }

    public long readU32() {
        long l = this.readByte();
        l = (l << 8) + (long)this.readByte();
        l = (l << 8) + (long)this.readByte();
        l = (l << 8) + (long)this.readByte();
        return l;
    }

    public String readString(int n) {
        try {
            return ZWaveInputStream.readString(this, n);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public String readString() {
        try {
            return ZWaveInputStream.readString(this);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String readString(InputStream inputStream, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        if (n > inputStream.available()) {
            n2 = inputStream.available();
        }
        int n3 = 0;
        boolean bl = false;
        while (n3++ < n2) {
            char c = (char)inputStream.read();
            if (bl) continue;
            if (c == '\u0000') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String readString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        int n2 = inputStream.available();
        while (n++ < n2 && !bl) {
            char c = (char)inputStream.read();
            if (bl) continue;
            if (c == '\u0000') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        int n2 = inputStream.available();
        while (n++ < n2 && !bl) {
            char c = (char)inputStream.read();
            if (bl) continue;
            if (c == '\r') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public ZWaveInputStream(byte[] byArray) {
        super(byArray);
    }

    public ZWaveInputStream(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }
}

