/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.learn;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.learn.BNetworkSceneEntry;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.scene.BZWaveNetworkScene;
import com.tridium.zwave.scene.BZWaveNetworkSceneConfig;
import com.tridium.zwave.scene.BZWaveSceneActuatorConf;
import com.tridium.zwave.scene.BZWaveSceneDeviceExt;
import java.util.ArrayList;
import javax.baja.driver.BDevice;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveLearnNetworkScenesJob
extends BSimpleJob
implements ZWaveMessageConst {
    public static final Property learnedScenes = BZWaveLearnNetworkScenesJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE;
    BZWaveNetworkScene scene;
    BZWaveNetwork network;
    boolean isDeep;
    static /* synthetic */ Class class$com$tridium$zwave$learn$BZWaveLearnNetworkScenesJob;

    public BFolder getLearnedScenes() {
        return (BFolder)this.get(learnedScenes);
    }

    public void setLearnedScenes(BFolder bFolder) {
        this.set(learnedScenes, (BValue)bFolder, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doCancel(Context context) {
        super.doCancel(context);
        throw new JobCancelException();
    }

    public void run(Context context) throws Exception {
        try {
            this.getLearnedScenes().removeAll();
            BZWaveDevice[] bZWaveDeviceArray = this.getSceneDevices();
            int n = 0;
            while (n < bZWaveDeviceArray.length) {
                this.getLearnedScenes().add(bZWaveDeviceArray[n].getName(), (BValue)new BNetworkSceneEntry(bZWaveDeviceArray[n].getDisplayName(null), bZWaveDeviceArray[n].getNodeId()));
                ++n;
            }
            n = this.scene.getSceneId();
            if (this.isDeep) {
                this.readNodeScenes(n);
            }
            BZWaveSceneActuatorConf[] bZWaveSceneActuatorConfArray = this.getDeviceScenes();
            int n2 = 0;
            while (n2 < bZWaveSceneActuatorConfArray.length) {
                if (bZWaveSceneActuatorConfArray[n2].getSceneId() == n) {
                    BZWaveDevice bZWaveDevice = (BZWaveDevice)bZWaveSceneActuatorConfArray[n2].getDeviceExt().getDevice();
                    String string = bZWaveDevice.getName();
                    int n3 = bZWaveDevice.getNodeId();
                    if (this.scene.get(string) == null) {
                        this.scene.add(string, (BValue)new BZWaveNetworkSceneConfig(n, n3, bZWaveSceneActuatorConfArray[n2]));
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public void readNodeScenes(int n) {
        BDevice[] bDeviceArray = this.network.getDevices();
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            try {
                BZWaveSceneDeviceExt bZWaveSceneDeviceExt = (BZWaveSceneDeviceExt)bDeviceArray[n2].get("scenes");
                if (bZWaveSceneDeviceExt != null) {
                    bZWaveSceneDeviceExt.readScenes(BInteger.make((int)n));
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
    }

    public BZWaveDevice[] getSceneDevices() {
        ArrayList<BDevice> arrayList = new ArrayList<BDevice>();
        BDevice[] bDeviceArray = this.network.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            try {
                if (bDeviceArray[n].get("scenes") != null) {
                    arrayList.add(bDeviceArray[n]);
                }
            }
            catch (Exception exception) {}
            ++n;
        }
        return arrayList.toArray(new BZWaveDevice[arrayList.size()]);
    }

    public BZWaveSceneActuatorConf[] getDeviceScenes() {
        ArrayList arrayList = new ArrayList();
        this.getDeviceScenes((BComponent)this.network, BZWaveSceneActuatorConf.TYPE, arrayList);
        return arrayList.toArray(new BZWaveSceneActuatorConf[arrayList.size()]);
    }

    private final void getDeviceScenes(BComponent bComponent, Type type, ArrayList arrayList) {
        SlotCursor slotCursor = bComponent.loadSlots().getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = slotCursor.get().asComponent();
            if (bComponent2.getType().is(type)) {
                arrayList.add(bComponent2);
                continue;
            }
            this.getDeviceScenes(bComponent2, type, arrayList);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isDeep = false;
    }

    public BZWaveLearnNetworkScenesJob() {
        this.this();
        this.network = null;
        this.scene = null;
    }

    public BZWaveLearnNetworkScenesJob(BZWaveNetworkScene bZWaveNetworkScene) {
        this.this();
        this.scene = bZWaveNetworkScene;
        this.network = bZWaveNetworkScene.getNetwork();
    }

    public BZWaveLearnNetworkScenesJob(BZWaveNetworkScene bZWaveNetworkScene, boolean bl) {
        this.this();
        this.scene = bZWaveNetworkScene;
        this.network = bZWaveNetworkScene.getNetwork();
        this.isDeep = bl;
    }

    static {
        Class clazz = class$com$tridium$zwave$learn$BZWaveLearnNetworkScenesJob;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$learn$BZWaveLearnNetworkScenesJob = BZWaveLearnNetworkScenesJob.class("[Lcom.tridium.zwave.learn.BZWaveLearnNetworkScenesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

