/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.comm.serial;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialComm;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.comm.BSerialApiCapabilities;
import com.tridium.zwave.comm.ZWaveComm;
import com.tridium.zwave.comm.ZWaveCommTransmitter;
import com.tridium.zwave.comm.serial.ZWaveSerialCommReceiver;
import com.tridium.zwave.util.BZWaveApiParam;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveSerialPlugIn
extends BSerialComm {
    public static final Property interMessageDelay = BZWaveSerialPlugIn.newProperty((int)0, (BValue)BRelTime.make((long)300L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property zwAckTimeout = BZWaveSerialPlugIn.newProperty((int)0, (int)200, null);
    public static final Property zwByteTimeout = BZWaveSerialPlugIn.newProperty((int)0, (int)2, null);
    public static final Property zwVersion = BZWaveSerialPlugIn.newProperty((int)3, (String)"-", null);
    public static final Property zwCapabilities = BZWaveSerialPlugIn.newProperty((int)3, (BValue)new BSerialApiCapabilities(), null);
    public static final Action resetCard = BZWaveSerialPlugIn.newAction((int)16, null);
    public static final Action upgradeFirmware = BZWaveSerialPlugIn.newAction((int)148, null);
    public static final Type TYPE;
    private static final long MIN_SLEEP_TIME = 10L;
    public static Log optCardLog;
    private long lastRecvMessageTicks;
    static /* synthetic */ Class class$com$tridium$zwave$comm$serial$BZWaveSerialPlugIn;

    public int getZwAckTimeout() {
        return this.getInt(zwAckTimeout);
    }

    public void setZwAckTimeout(int n) {
        this.setInt(zwAckTimeout, n, null);
    }

    public int getZwByteTimeout() {
        return this.getInt(zwByteTimeout);
    }

    public void setZwByteTimeout(int n) {
        this.setInt(zwByteTimeout, n, null);
    }

    public String getZwVersion() {
        return this.getString(zwVersion);
    }

    public void setZwVersion(String string) {
        this.setString(zwVersion, string, null);
    }

    public BSerialApiCapabilities getZwCapabilities() {
        return (BSerialApiCapabilities)this.get(zwCapabilities);
    }

    public void setZwCapabilities(BSerialApiCapabilities bSerialApiCapabilities) {
        this.set(zwCapabilities, (BValue)bSerialApiCapabilities, null);
    }

    public void resetCard() {
        this.invoke(resetCard, null, null);
    }

    public void upgradeFirmware() {
        this.invoke(upgradeFirmware, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        String string = "zflash.hex";
        BModule bModule = BZWaveNetwork.TYPE.getModule();
        BIFile bIFile = bModule.findFile(new FilePath("/com/tridium/zwave/firmware"));
        BIFile[] bIFileArray = bModule.getChildren(bIFile);
        BIFile bIFile2 = null;
        int n = 0;
        while (n < bIFileArray.length) {
            String string2 = bIFileArray[n].getFileName();
            if (string2.startsWith("zflash")) {
                bIFile2 = bIFileArray[n];
                try {
                    String string3 = string2.substring(7, string2.indexOf(46));
                    int n2 = string3.indexOf(95);
                    String string4 = string3.substring(0, n2);
                    String string5 = string3.substring(n2 + 1);
                    this.getZwCapabilities().setAvailiableVersion(string4 + '.' + string5);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            ++n;
        }
        if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx)) {
            this.setFlags((Slot)resetCard, this.getFlags((Slot)resetCard) & 0xFFFFFFFB);
            this.setFlags((Slot)upgradeFirmware, this.getFlags((Slot)upgradeFirmware) & 0xFFFFFFFB);
        } else {
            this.setFlags((Slot)resetCard, this.getFlags((Slot)resetCard) | 4);
            this.setFlags((Slot)upgradeFirmware, this.getFlags((Slot)upgradeFirmware) | 4);
        }
    }

    public boolean commStarted() throws Exception {
        try {
            boolean bl = super.commStarted();
            if (this.getSerialPortConfig().getStatus().equals((Object)BStatus.ok)) {
                this.getNetwork().configOk();
            } else {
                this.getNetwork().configFail("Serial port invalid or not specified");
                bl = false;
            }
            return bl;
        }
        catch (Exception exception) {
            this.getNetwork().configFail("Serial port invalid or not specified");
            throw exception;
        }
    }

    public boolean isFunctionSupported(int n) {
        String string = this.getZwCapabilities().getFuncIdList();
        String string2 = "0x" + Integer.toHexString(n);
        boolean bl = false;
        if (string.indexOf(string2) >= 0) {
            bl = true;
        }
        return bl;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)resetCard) || action.equals((Object)upgradeFirmware)) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public Comm makeComm() {
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        return new ZWaveComm(bZWaveNetwork, new ZWaveSerialCommReceiver(bZWaveNetwork), new ZWaveCommTransmitter(bZWaveNetwork));
    }

    public Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        if (message == null) {
            return null;
        }
        if (!message.getResponseExpected()) {
            this.transmitNoResponse(message);
            return null;
        }
        this.performInterMessageDelay();
        return this.getComm().transmit(message, bRelTime, n);
    }

    public void transmitNoResponse(Message message) throws BasicException {
        if (message == null) {
            return;
        }
        if (!this.getComm().isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        this.performInterMessageDelay();
        this.getComm().transmitNoResponse(message);
    }

    protected void performInterMessageDelay() {
        long l = ((BSerialNetwork)this.getNetwork()).getInterMessageDelay().getMillis();
        if (l <= 0L) {
            return;
        }
        long l2 = Clock.ticks() - this.lastRecvMessageTicks;
        if (l2 >= l) {
            return;
        }
        long l3 = Math.max(l - l2, 10L);
        try {
            Thread.sleep(l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doResetCard() {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cat /tmp/zwave_opt");
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            optCardLog.trace("zwaveOpt = " + string);
            process = runtime.exec("/proc/boot/zwave -b " + string);
            inputStream = process.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                optCardLog.trace("reset card results = " + string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doUpgradeFirmware() {
        optCardLog.trace("start zwave option card flash upgrade");
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cat /tmp/zwave_reg");
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            boolean bl = false;
            if (string != null) {
                bl = string.equalsIgnoreCase("0e");
                optCardLog.trace("  Option Card type = " + string + " isEuFrequency = " + bl);
            } else {
                optCardLog.trace("  zwave_reg file does not exist defaulting to US frequency");
            }
            String string2 = "zflash";
            if (bl) {
                string2 = "zflashEu";
            }
            BModule bModule = BZWaveNetwork.TYPE.getModule();
            BIFile bIFile = bModule.findFile(new FilePath("/com/tridium/zwave/firmware"));
            BIFile[] bIFileArray = bModule.getChildren(bIFile);
            BIFile bIFile2 = null;
            int n = 0;
            while (n < bIFileArray.length) {
                if (bIFileArray[n].getFileName().startsWith(string2)) {
                    bIFile2 = bIFileArray[n];
                    break;
                }
                ++n;
            }
            if (bIFile2 == null) {
                optCardLog.error(string2 + ".hex does not exist in zwave jar file");
                return;
            }
            string2 = bIFile2.getFileName();
            InputStream inputStream2 = bIFile2.getInputStream();
            BIFile bIFile3 = BFileSystem.INSTANCE.findFile(new FilePath("/tmp/" + string2));
            if (bIFile3 == null) {
                bIFile3 = BFileSystem.INSTANCE.makeFile(new FilePath("/tmp/" + string2));
            } else {
                bIFile3.delete();
                bIFile3 = BFileSystem.INSTANCE.makeFile(new FilePath("/tmp/" + string2));
            }
            optCardLog.trace("Copying hex file " + string2);
            OutputStream outputStream = bIFile3.getOutputStream();
            boolean bl2 = false;
            while (!bl2) {
                int n2 = inputStream2.read();
                if (n2 < 0) {
                    bl2 = true;
                    continue;
                }
                outputStream.write(n2);
            }
            inputStream2.close();
            outputStream.flush();
            outputStream.close();
            optCardLog.trace("Copy file complete");
            runtime = Runtime.getRuntime();
            process = runtime.exec("cat /tmp/zwave_opt");
            inputStream = process.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = bufferedReader.readLine();
            optCardLog.trace("upgrading flash in zwave option card");
            process = runtime.exec("/proc/boot/zwave -f/tmp/" + string2 + " -w -v " + string3);
            inputStream = process.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                optCardLog.trace("upgrade results = " + string4);
                string4 = bufferedReader.readLine();
            }
            optCardLog.trace("zwave option card flash upgrade complete");
            ((BZWaveNetwork)this.getNetwork()).doSendSerialApiRequest(new BZWaveApiParam(8));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString(Context context) {
        return super.toString(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastRecvMessageTicks = 0L;
    }

    public BZWaveSerialPlugIn() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$comm$serial$BZWaveSerialPlugIn;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$comm$serial$BZWaveSerialPlugIn = BZWaveSerialPlugIn.class("[Lcom.tridium.zwave.comm.serial.BZWaveSerialPlugIn;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        optCardLog = Log.getLog((String)"zwave.optionCard");
    }
}

