/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.comm;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BBasicUnsolicitedReceive;
import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.comm.ZWaveCommTransmitter;
import com.tridium.zwave.comm.serial.BZWaveSerialPlugIn;
import com.tridium.zwave.enums.BSerialApiFunctIds;
import com.tridium.zwave.learn.BZWaveOptimizeNetworkJob;
import com.tridium.zwave.learn.BZWaveTransferPrimaryJob;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveReceivedMessage;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveUnsolicitedReceive
extends BBasicUnsolicitedReceive
implements ZWaveMessageConst {
    public static final Type TYPE;
    public static Log usLog;
    private BZWaveDevice nodeInfoUpdateDevice;
    private BZWaveOptimizeNetworkJob neighborUpdateJob;
    private BZWaveTransferPrimaryJob transferPrimaryJob;
    public Object serialSend;
    static /* synthetic */ Class class$com$tridium$zwave$comm$BZWaveUnsolicitedReceive;
    static /* synthetic */ Class class$com$tridium$zwave$BZWaveDevice;

    public Type getType() {
        return TYPE;
    }

    BZWaveNetwork getNetwork() {
        return (BZWaveNetwork)this.getParent();
    }

    protected void processUnsolicitedMessage(ReceivedMessage receivedMessage) {
        ZWaveReceivedMessage zWaveReceivedMessage = (ZWaveReceivedMessage)receivedMessage;
        usLog.trace(ByteArrayUtil.toHexString((byte[])zWaveReceivedMessage.getBytes(), (int)0, (int)zWaveReceivedMessage.getLength()));
        ZWaveInputStream zWaveInputStream = new ZWaveInputStream(zWaveReceivedMessage.getBytes(), 0, zWaveReceivedMessage.getLength());
        zWaveInputStream.read();
        zWaveInputStream.read();
        int n = zWaveInputStream.read() & 0xFF;
        usLog.trace((Object)((Object)BSerialApiFunctIds.getTag(n)) + " (0x" + Integer.toHexString(n) + ')');
        switch (n) {
            case 21: {
                ((BZWaveSerialPlugIn)this.getNetwork().getCommPlugIn()).setZwVersion(zWaveInputStream.readString());
                break;
            }
            case 7: {
                ((BZWaveSerialPlugIn)this.getNetwork().getCommPlugIn()).getZwCapabilities().readData(zWaveInputStream);
                break;
            }
            case 5: {
                this.getNetwork().getInterfaceCapabilites().readData(zWaveInputStream);
                break;
            }
            case 73: {
                int n2 = zWaveInputStream.readByte();
                int n3 = zWaveInputStream.readByte();
                if (n2 == 64) {
                    usLog.trace("Node " + n3 + " added.");
                    this.getNetwork().notifyNodeAdded(n3, zWaveInputStream);
                    break;
                }
                if (n2 == 32) {
                    usLog.trace("Node " + n3 + " deleted.");
                    if (!this.getNetwork().getRemoveExcludedDevices()) break;
                    BZWaveNetwork bZWaveNetwork = this.getNetwork();
                    Class clazz = class$com$tridium$zwave$BZWaveDevice;
                    if (clazz == null) {
                        clazz = class$com$tridium$zwave$BZWaveDevice = BZWaveUnsolicitedReceive.class("[Lcom.tridium.zwave.BZWaveDevice;", false);
                    }
                    Object[] objectArray = bZWaveNetwork.getChildren(clazz);
                    int n4 = 0;
                    while (objectArray != null && n4 < objectArray.length) {
                        BZWaveDevice bZWaveDevice = (BZWaveDevice)objectArray[n4];
                        if (bZWaveDevice.getNodeId() == n3) {
                            usLog.trace("Removing device \"" + bZWaveDevice.getDisplayName(null) + "\" - node id " + n3);
                            String string = bZWaveDevice.getName();
                            if (string == null) {
                                usLog.trace("Could not delete failed to get device location");
                            } else {
                                this.getNetwork().remove(string);
                            }
                            objectArray = null;
                        }
                        ++n4;
                    }
                    break;
                }
                if (n2 == 16) {
                    usLog.trace("The SUC node Id was updated.");
                    break;
                }
                if (n2 == 129) {
                    usLog.trace("node did not acknowledge a ZW_RequestNodeInfo call: " + n3);
                    break;
                }
                if (n2 == 132) {
                    usLog.trace("nodeInfo update: nodeId = 0x" + Integer.toHexString(n3));
                    zWaveInputStream.readByte();
                    BZWaveDevice bZWaveDevice = this.getNetwork().getDevice(n3);
                    if (bZWaveDevice == null) break;
                    bZWaveDevice.getNodeInfo().readData(zWaveInputStream);
                    bZWaveDevice.setStatus(BStatus.makeFault((BStatus)bZWaveDevice.getStatus(), (boolean)false));
                    bZWaveDevice.setFaultCause("");
                    bZWaveDevice.pingOk();
                    if (this.nodeInfoUpdateDevice != null) {
                        this.nodeInfoUpdateDevice.notifyNodeInfoUpdate(n2);
                        this.nodeInfoUpdateDevice = null;
                        break;
                    }
                    if (!bZWaveDevice.isNodeListening()) {
                        bZWaveDevice.readDeviceData();
                        break;
                    }
                    if (Clock.ticks() <= bZWaveDevice.getMinTicksForNodeInfoPoll()) break;
                    bZWaveDevice.readNonBasicPointData();
                    break;
                }
                usLog.trace("unknown ApplicationControllerUpdate bStatus received: " + n2);
                break;
            }
            case 4: {
                int n5 = zWaveInputStream.readByte();
                int n6 = zWaveInputStream.readByte();
                usLog.trace("nodeId = 0x" + Integer.toHexString(n6) + ", rxStatus = 0x" + Integer.toHexString(n5));
                this.getNetwork().messageComplete(0);
                BZWaveDevice bZWaveDevice = this.getNetwork().getDevice(n6);
                if (bZWaveDevice != null) {
                    bZWaveDevice.pingOk();
                    bZWaveDevice.processApplicationCommand(zWaveInputStream);
                    break;
                }
                usLog.trace("message received from undefined device: " + n6);
                this.getNetwork().processApplicationCommand(zWaveInputStream);
                break;
            }
            case 19: 
            case 20: 
            case 69: {
                int n7 = zWaveInputStream.readByte();
                if (n7 == 153) {
                    int n8 = zWaveInputStream.readByte();
                    usLog.trace("txStatus = 0x" + n8);
                    break;
                }
                if (n7 != 0) break;
                ZWaveCommTransmitter.txLog.trace("transmit queue overflow");
                this.getNetwork().messageComplete(128);
                break;
            }
            case 80: {
                zWaveInputStream.readByte();
                int n9 = zWaveInputStream.readByte();
                if (n9 == 1) {
                    usLog.trace("Learn Mode Started");
                    break;
                }
                if (n9 == 6) {
                    usLog.trace("Learn Mode Done");
                    this.getNetwork().setAddNodeDone(true);
                    break;
                }
                usLog.trace("unknown learn mode status: " + n9);
                break;
            }
            case 72: {
                zWaveInputStream.readByte();
                int n10 = zWaveInputStream.readByte();
                if (this.neighborUpdateJob == null) break;
                this.neighborUpdateJob.nodeNeighborUpdate(n10);
                break;
            }
            case 70: {
                if (this.neighborUpdateJob == null) break;
                zWaveInputStream.readByte();
                int n11 = zWaveInputStream.readByte();
                this.neighborUpdateJob.notifyAssignReturnRoute(n11);
                break;
            }
            case 71: {
                if (this.neighborUpdateJob == null) break;
                zWaveInputStream.readByte();
                int n12 = zWaveInputStream.readByte();
                this.neighborUpdateJob.notifyDeleteReturnRoute(n12);
                break;
            }
            case 77: {
                zWaveInputStream.readByte();
                int n13 = zWaveInputStream.readByte();
                if (this.transferPrimaryJob == null) break;
                this.transferPrimaryJob.controllerChangeUpdate(n13);
                break;
            }
            case 32: {
                long l = zWaveInputStream.readU32();
                int n14 = zWaveInputStream.readByte();
                this.getNetwork().setHomeId(l);
                this.getNetwork().setInterfaceNodeId(n14);
                break;
            }
            default: {
                usLog.trace("unsupported cmdId = 0x" + Integer.toHexString(n));
            }
        }
    }

    public void setNodeInfoUpdate(BZWaveDevice bZWaveDevice) {
        this.nodeInfoUpdateDevice = bZWaveDevice;
    }

    public void setNeighborUpdateJob(BZWaveOptimizeNetworkJob bZWaveOptimizeNetworkJob) {
        this.neighborUpdateJob = bZWaveOptimizeNetworkJob;
    }

    public BZWaveOptimizeNetworkJob getNeighborUpdateJob() {
        return this.neighborUpdateJob;
    }

    public void setTransferPrimaryJob(BZWaveTransferPrimaryJob bZWaveTransferPrimaryJob) {
        this.transferPrimaryJob = bZWaveTransferPrimaryJob;
    }

    public BZWaveTransferPrimaryJob getTransferPrimaryJob() {
        return this.transferPrimaryJob;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.nodeInfoUpdateDevice = null;
        this.neighborUpdateJob = null;
        this.transferPrimaryJob = null;
        this.serialSend = new Object();
    }

    public BZWaveUnsolicitedReceive() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$comm$BZWaveUnsolicitedReceive;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$comm$BZWaveUnsolicitedReceive = BZWaveUnsolicitedReceive.class("[Lcom.tridium.zwave.comm.BZWaveUnsolicitedReceive;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        usLog = Log.getLog((String)"zwave.unsolicited");
    }
}

