/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.cmdclass.BNodeInformation;
import com.tridium.zwave.learn.BZWaveLearnDevicesJob;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.util.BCmdClassInfo;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveVersion
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property libraryType = BZWaveVersion.newProperty((int)1, (int)0, null);
    public static final Property protocolVersion = BZWaveVersion.newProperty((int)1, (String)".", null);
    public static final Property applicationVersion = BZWaveVersion.newProperty((int)1, (String)".", null);
    public static final Action readCmdClassVersions = BZWaveVersion.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BZWaveVersion;

    public int getLibraryType() {
        return this.getInt(libraryType);
    }

    public void setLibraryType(int n) {
        this.setInt(libraryType, n, null);
    }

    public String getProtocolVersion() {
        return this.getString(protocolVersion);
    }

    public void setProtocolVersion(String string) {
        this.setString(protocolVersion, string, null);
    }

    public String getApplicationVersion() {
        return this.getString(applicationVersion);
    }

    public void setApplicationVersion(String string) {
        this.setString(applicationVersion, string, null);
    }

    public void readCmdClassVersions() {
        this.invoke(readCmdClassVersions, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 134;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (n > 0) {
            return;
        }
        BZWaveVersion bZWaveVersion = (BZWaveVersion)bZWaveDevice.get(ADD_NAME);
        if (bZWaveVersion == null) {
            bZWaveVersion = (BZWaveVersion)bZWaveDevice.add(ADD_NAME, (BValue)this);
        }
        bZWaveDevice.setFlags((Slot)BZWaveDevice.readVersion, bZWaveDevice.getFlags((Slot)BZWaveDevice.readVersion) & 0xFFFFFFFB);
        if (Thread.currentThread().getName().startsWith("BscClscWkr")) {
            bZWaveDevice.doReadVersion();
            bZWaveVersion.doReadCmdClassVersions();
        } else {
            bZWaveDevice.readVersion();
            bZWaveVersion.readCmdClassVersions();
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 18 && n != 20) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ":  CommandClassVersion: 0x" + Integer.toHexString(n));
            return;
        }
        try {
            if (n == 18) {
                BZWaveVersion bZWaveVersion = (BZWaveVersion)bZWaveDevice.get(ADD_NAME);
                bZWaveVersion.readData(zWaveInputStream);
            } else {
                int n2 = zWaveInputStream.readByte();
                int n3 = zWaveInputStream.readByte();
                BNodeInformation.setCmdClassVersion(bZWaveDevice, n2, n3);
                if (bZWaveDevice.getReadVersionInfoJob() != null && bZWaveDevice.getVersionInfoUpdateLastCmdClass() == n2) {
                    BZWaveLearnDevicesJob.ldLog.trace("   notifyVersionInfoUpdate()");
                    try {
                        bZWaveDevice.getReadVersionInfoJob().notifyVersionInfoUpdate();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("!!!!!!! version object does not exist !!!!!!!!!");
        }
    }

    public void readData(ZWaveInputStream zWaveInputStream) {
        this.setLibraryType(zWaveInputStream.readByte());
        this.setProtocolVersion("" + zWaveInputStream.readByte() + '.' + zWaveInputStream.readByte());
        this.setApplicationVersion("" + zWaveInputStream.readByte() + '.' + zWaveInputStream.readByte());
    }

    public void doReadCmdClassVersions() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            BCmdClassInfo[] bCmdClassInfoArray = bZWaveDevice.getNodeInfo().getSupportedClasses();
            int n = 0;
            while (n < bCmdClassInfoArray.length) {
                int n2 = bCmdClassInfoArray[n].getCmdClassType().getOrdinal();
                byte[] byArray = new byte[]{(byte)this.getCommandClass(), 19, (byte)n2};
                this.sendCmd(bZWaveDevice.getNodeId(), byArray);
                if (n2 == 239) break;
                ++n;
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
    }

    public String toString(Context context) {
        return "lib:" + this.getLibraryType() + ", pv:" + this.getProtocolVersion() + ", av:" + this.getApplicationVersion();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BZWaveVersion;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BZWaveVersion = BZWaveVersion.class("[Lcom.tridium.zwave.cmdclass.BZWaveVersion;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "version";
    }
}

