/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveOutputStream;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveNames
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property nodeName = BZWaveNames.newProperty((int)1, (String)new String(), null);
    public static final Property nodeLocation = BZWaveNames.newProperty((int)1, (String)new String(), null);
    public static final Action assignNodeName = BZWaveNames.newAction((int)16, (BValue)BString.make((String)""), null);
    public static final Action assignNodeLocation = BZWaveNames.newAction((int)16, (BValue)BString.make((String)""), null);
    public static final Action readNodeName = BZWaveNames.newAction((int)16, null);
    public static final Action readNodeLocation = BZWaveNames.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BZWaveNames;

    public String getNodeName() {
        return this.getString(nodeName);
    }

    public void setNodeName(String string) {
        this.setString(nodeName, string, null);
    }

    public String getNodeLocation() {
        return this.getString(nodeLocation);
    }

    public void setNodeLocation(String string) {
        this.setString(nodeLocation, string, null);
    }

    public void assignNodeName(BString bString) {
        this.invoke(assignNodeName, (BValue)bString, null);
    }

    public void assignNodeLocation(BString bString) {
        this.invoke(assignNodeLocation, (BValue)bString, null);
    }

    public void readNodeName() {
        this.invoke(readNodeName, null, null);
    }

    public void readNodeLocation() {
        this.invoke(readNodeLocation, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 119;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        bZWaveDevice.setFlags((Slot)BZWaveDevice.naming, bZWaveDevice.getFlags((Slot)BZWaveDevice.naming) & 0xFFFFFFFB);
        bZWaveDevice.setFlags((Slot)BZWaveDevice.nameLocation, bZWaveDevice.getFlags((Slot)BZWaveDevice.nameLocation) & 0xFFFFFFFB);
        bZWaveDevice.setFlags((Slot)BZWaveDevice.assignNodeName, bZWaveDevice.getFlags((Slot)BZWaveDevice.assignNodeName) & 0xFFFFFFFB);
        bZWaveDevice.setFlags((Slot)BZWaveDevice.assignNodeLocation, bZWaveDevice.getFlags((Slot)BZWaveDevice.assignNodeLocation) & 0xFFFFFFFB);
        bZWaveDevice.readNodeName();
        bZWaveDevice.readNodeLocation();
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n == 3) {
            try {
                BZWaveNames bZWaveNames = bZWaveDevice.getNaming();
                int n2 = zWaveInputStream.read() & 7;
                byte[] byArray = new byte[zWaveInputStream.available()];
                zWaveInputStream.read(byArray);
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while (n3 < byArray.length) {
                    if (byArray[n3] == 0) break;
                    stringBuffer.append((char)byArray[n3]);
                    ++n3;
                }
                bZWaveNames.setNodeName(new String(stringBuffer.toString().trim()));
                bZWaveDevice.setNameLocation(bZWaveNames.toString(null));
            }
            catch (Exception exception) {
                System.out.println("!!!!!!! unable to decode/set node name !!!!!!!!!");
            }
        } else if (n == 6) {
            try {
                BZWaveNames bZWaveNames = bZWaveDevice.getNaming();
                int n4 = zWaveInputStream.read() & 7;
                byte[] byArray = new byte[zWaveInputStream.available()];
                zWaveInputStream.read(byArray);
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = 0;
                while (n5 < byArray.length) {
                    if (byArray[n5] == 0) break;
                    stringBuffer.append((char)byArray[n5]);
                    ++n5;
                }
                bZWaveNames.setNodeLocation(new String(stringBuffer.toString().trim()));
                bZWaveDevice.setNameLocation(bZWaveNames.toString(null));
            }
            catch (Exception exception) {
                System.out.println("!!!!!!! unable to decode/set node name !!!!!!!!!");
            }
        } else {
            return;
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveNetwork bZWaveNetwork;
        if ((action.equals((Object)assignNodeName) || action.equals((Object)assignNodeLocation)) && (bZWaveNetwork = this.getNetwork()) != null) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doAssignNodeName(BString bString) {
        byte[] byArray = this.formatString(119, 1, bString.getString());
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            byte[] byArray2 = new byte[]{119, 2};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray2);
        }
    }

    public void doReadNodeName() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{119, 2};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void doAssignNodeLocation(BString bString) {
        byte[] byArray = this.formatString(119, 4, bString.getString());
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            byte[] byArray2 = new byte[]{119, 5};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray2);
        }
    }

    public void doReadNodeLocation() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{119, 5};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    private final byte[] formatString(int n, int n2, String string) {
        byte[] byArray = string.getBytes();
        ZWaveOutputStream zWaveOutputStream = new ZWaveOutputStream();
        zWaveOutputStream.write(n);
        zWaveOutputStream.write(n2);
        zWaveOutputStream.write(0);
        int n3 = 0;
        while (n3 < byArray.length) {
            zWaveOutputStream.write(byArray[n3]);
            ++n3;
        }
        n3 = 16 - byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            zWaveOutputStream.write(32);
            ++n4;
        }
        return zWaveOutputStream.toByteArray();
    }

    public String toString(Context context) {
        String string = this.getNodeLocation();
        String string2 = this.getNodeName();
        boolean bl = string.equals("") ^ true;
        boolean bl2 = string2.equals("") ^ true;
        if (bl && bl2) {
            return string + '_' + string2;
        }
        if (!bl && !bl2) {
            return "null";
        }
        if (bl) {
            return string;
        }
        return string2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BZWaveNames;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BZWaveNames = BZWaveNames.class("[Lcom.tridium.zwave.cmdclass.BZWaveNames;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "nodeInfo";
    }
}

