/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveManufacturerSpecific
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property manufacturerId = BZWaveManufacturerSpecific.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"radix", (BIDataValue)BInteger.make((int)16)));
    public static final Property productTypeId = BZWaveManufacturerSpecific.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"radix", (BIDataValue)BInteger.make((int)16)));
    public static final Property productId = BZWaveManufacturerSpecific.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"radix", (BIDataValue)BInteger.make((int)16)));
    public static final Type TYPE;
    public static String ADD_NAME;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BZWaveManufacturerSpecific;

    public int getManufacturerId() {
        return this.getInt(manufacturerId);
    }

    public void setManufacturerId(int n) {
        this.setInt(manufacturerId, n, null);
    }

    public int getProductTypeId() {
        return this.getInt(productTypeId);
    }

    public void setProductTypeId(int n) {
        this.setInt(productTypeId, n, null);
    }

    public int getProductId() {
        return this.getInt(productId);
    }

    public void setProductId(int n) {
        this.setInt(productId, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 114;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (bZWaveDevice.get(ADD_NAME) == null) {
            bZWaveDevice.add(ADD_NAME, (BValue)this);
        }
        bZWaveDevice.readManufacturerSpecific();
    }

    public void changed(Property property, Context context) {
        BZWaveDevice bZWaveDevice;
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if ((property.equals((Object)manufacturerId) || property.equals((Object)productId) || property.equals((Object)productTypeId)) && (bZWaveDevice = this.getDevice()) != null) {
            bZWaveDevice.loadDeviceProfile();
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 5) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassManufacturerSpecific: 0x" + Integer.toHexString(n));
            return;
        }
        try {
            BZWaveManufacturerSpecific bZWaveManufacturerSpecific = (BZWaveManufacturerSpecific)bZWaveDevice.get(ADD_NAME);
            if (bZWaveManufacturerSpecific == null) {
                Property property = bZWaveDevice.add(ADD_NAME, (BValue)this);
                bZWaveManufacturerSpecific = (BZWaveManufacturerSpecific)bZWaveDevice.get(property);
                bZWaveManufacturerSpecific.readData(zWaveInputStream);
                bZWaveDevice.doLoadDeviceProfile();
            } else {
                bZWaveManufacturerSpecific.readData(zWaveInputStream);
            }
        }
        catch (Exception exception) {
            System.out.println("!!!!!!! manufacturerSpecific object does not exist !!!!!!!!!");
        }
    }

    public void readData(ZWaveInputStream zWaveInputStream) {
        this.setManufacturerId(zWaveInputStream.readWord());
        this.setProductTypeId(zWaveInputStream.readWord());
        this.setProductId(zWaveInputStream.readWord());
    }

    public String getInfoFileName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('x');
        stringBuffer.append(Integer.toHexString(this.getManufacturerId()));
        stringBuffer.append("_x");
        stringBuffer.append(Integer.toHexString(this.getProductTypeId()));
        stringBuffer.append("_x");
        stringBuffer.append(Integer.toHexString(this.getProductId()));
        stringBuffer.append(".info");
        return stringBuffer.toString();
    }

    public static BZWaveManufacturerSpecific getCmdClassComponent(BZWaveDevice bZWaveDevice) {
        BValue bValue = bZWaveDevice.get(ADD_NAME);
        if (bValue != null && bValue.getType().is(TYPE)) {
            return (BZWaveManufacturerSpecific)bValue;
        }
        return null;
    }

    public String toString(Context context) {
        return "mId:" + this.getManufacturerId() + ", ptId:" + this.getProductTypeId() + ", pId:" + this.getProductId();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BZWaveManufacturerSpecific;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BZWaveManufacturerSpecific = BZWaveManufacturerSpecific.class("[Lcom.tridium.zwave.cmdclass.BZWaveManufacturerSpecific;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "manufacturerSpecific";
    }
}

